﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/appsync/AppSyncRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/appsync/model/SourceApiAssociationConfig.h>
#include <utility>

namespace Aws
{
namespace AppSync
{
namespace Model
{

  /**
   */
  class AssociateSourceGraphqlApiRequest : public AppSyncRequest
  {
  public:
    AWS_APPSYNC_API AssociateSourceGraphqlApiRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "AssociateSourceGraphqlApi"; }

    AWS_APPSYNC_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline const Aws::String& GetMergedApiIdentifier() const{ return m_mergedApiIdentifier; }
    inline bool MergedApiIdentifierHasBeenSet() const { return m_mergedApiIdentifierHasBeenSet; }
    inline void SetMergedApiIdentifier(const Aws::String& value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier = value; }
    inline void SetMergedApiIdentifier(Aws::String&& value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier = std::move(value); }
    inline void SetMergedApiIdentifier(const char* value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier.assign(value); }
    inline AssociateSourceGraphqlApiRequest& WithMergedApiIdentifier(const Aws::String& value) { SetMergedApiIdentifier(value); return *this;}
    inline AssociateSourceGraphqlApiRequest& WithMergedApiIdentifier(Aws::String&& value) { SetMergedApiIdentifier(std::move(value)); return *this;}
    inline AssociateSourceGraphqlApiRequest& WithMergedApiIdentifier(const char* value) { SetMergedApiIdentifier(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The identifier of the AppSync Source API. This is generated by the AppSync
     * service. In most cases, source APIs (especially in your account) only require
     * the API ID value or ARN of the source API. However, source APIs from other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * source API.</p>
     */
    inline const Aws::String& GetSourceApiIdentifier() const{ return m_sourceApiIdentifier; }
    inline bool SourceApiIdentifierHasBeenSet() const { return m_sourceApiIdentifierHasBeenSet; }
    inline void SetSourceApiIdentifier(const Aws::String& value) { m_sourceApiIdentifierHasBeenSet = true; m_sourceApiIdentifier = value; }
    inline void SetSourceApiIdentifier(Aws::String&& value) { m_sourceApiIdentifierHasBeenSet = true; m_sourceApiIdentifier = std::move(value); }
    inline void SetSourceApiIdentifier(const char* value) { m_sourceApiIdentifierHasBeenSet = true; m_sourceApiIdentifier.assign(value); }
    inline AssociateSourceGraphqlApiRequest& WithSourceApiIdentifier(const Aws::String& value) { SetSourceApiIdentifier(value); return *this;}
    inline AssociateSourceGraphqlApiRequest& WithSourceApiIdentifier(Aws::String&& value) { SetSourceApiIdentifier(std::move(value)); return *this;}
    inline AssociateSourceGraphqlApiRequest& WithSourceApiIdentifier(const char* value) { SetSourceApiIdentifier(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The description field.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }
    inline AssociateSourceGraphqlApiRequest& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}
    inline AssociateSourceGraphqlApiRequest& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}
    inline AssociateSourceGraphqlApiRequest& WithDescription(const char* value) { SetDescription(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline const SourceApiAssociationConfig& GetSourceApiAssociationConfig() const{ return m_sourceApiAssociationConfig; }
    inline bool SourceApiAssociationConfigHasBeenSet() const { return m_sourceApiAssociationConfigHasBeenSet; }
    inline void SetSourceApiAssociationConfig(const SourceApiAssociationConfig& value) { m_sourceApiAssociationConfigHasBeenSet = true; m_sourceApiAssociationConfig = value; }
    inline void SetSourceApiAssociationConfig(SourceApiAssociationConfig&& value) { m_sourceApiAssociationConfigHasBeenSet = true; m_sourceApiAssociationConfig = std::move(value); }
    inline AssociateSourceGraphqlApiRequest& WithSourceApiAssociationConfig(const SourceApiAssociationConfig& value) { SetSourceApiAssociationConfig(value); return *this;}
    inline AssociateSourceGraphqlApiRequest& WithSourceApiAssociationConfig(SourceApiAssociationConfig&& value) { SetSourceApiAssociationConfig(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_mergedApiIdentifier;
    bool m_mergedApiIdentifierHasBeenSet = false;

    Aws::String m_sourceApiIdentifier;
    bool m_sourceApiIdentifierHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    SourceApiAssociationConfig m_sourceApiAssociationConfig;
    bool m_sourceApiAssociationConfigHasBeenSet = false;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
