﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/appsync/AppSyncRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/appsync/model/TypeDefinitionFormat.h>
#include <utility>

namespace Aws
{
namespace Http
{
    class URI;
} //namespace Http
namespace AppSync
{
namespace Model
{

  /**
   */
  class ListTypesByAssociationRequest : public AppSyncRequest
  {
  public:
    AWS_APPSYNC_API ListTypesByAssociationRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "ListTypesByAssociation"; }

    AWS_APPSYNC_API Aws::String SerializePayload() const override;

    AWS_APPSYNC_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;


    ///@{
    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline const Aws::String& GetMergedApiIdentifier() const{ return m_mergedApiIdentifier; }
    inline bool MergedApiIdentifierHasBeenSet() const { return m_mergedApiIdentifierHasBeenSet; }
    inline void SetMergedApiIdentifier(const Aws::String& value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier = value; }
    inline void SetMergedApiIdentifier(Aws::String&& value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier = std::move(value); }
    inline void SetMergedApiIdentifier(const char* value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier.assign(value); }
    inline ListTypesByAssociationRequest& WithMergedApiIdentifier(const Aws::String& value) { SetMergedApiIdentifier(value); return *this;}
    inline ListTypesByAssociationRequest& WithMergedApiIdentifier(Aws::String&& value) { SetMergedApiIdentifier(std::move(value)); return *this;}
    inline ListTypesByAssociationRequest& WithMergedApiIdentifier(const char* value) { SetMergedApiIdentifier(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline const Aws::String& GetAssociationId() const{ return m_associationId; }
    inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }
    inline void SetAssociationId(const Aws::String& value) { m_associationIdHasBeenSet = true; m_associationId = value; }
    inline void SetAssociationId(Aws::String&& value) { m_associationIdHasBeenSet = true; m_associationId = std::move(value); }
    inline void SetAssociationId(const char* value) { m_associationIdHasBeenSet = true; m_associationId.assign(value); }
    inline ListTypesByAssociationRequest& WithAssociationId(const Aws::String& value) { SetAssociationId(value); return *this;}
    inline ListTypesByAssociationRequest& WithAssociationId(Aws::String&& value) { SetAssociationId(std::move(value)); return *this;}
    inline ListTypesByAssociationRequest& WithAssociationId(const char* value) { SetAssociationId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The format type.</p>
     */
    inline const TypeDefinitionFormat& GetFormat() const{ return m_format; }
    inline bool FormatHasBeenSet() const { return m_formatHasBeenSet; }
    inline void SetFormat(const TypeDefinitionFormat& value) { m_formatHasBeenSet = true; m_format = value; }
    inline void SetFormat(TypeDefinitionFormat&& value) { m_formatHasBeenSet = true; m_format = std::move(value); }
    inline ListTypesByAssociationRequest& WithFormat(const TypeDefinitionFormat& value) { SetFormat(value); return *this;}
    inline ListTypesByAssociationRequest& WithFormat(TypeDefinitionFormat&& value) { SetFormat(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>An identifier that was returned from the previous call to this operation,
     * which you can use to return the next set of items in the list.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
    inline void SetNextToken(const Aws::String& value) { m_nextTokenHasBeenSet = true; m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextTokenHasBeenSet = true; m_nextToken.assign(value); }
    inline ListTypesByAssociationRequest& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListTypesByAssociationRequest& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListTypesByAssociationRequest& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The maximum number of results that you want the request to return.</p>
     */
    inline int GetMaxResults() const{ return m_maxResults; }
    inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
    inline void SetMaxResults(int value) { m_maxResultsHasBeenSet = true; m_maxResults = value; }
    inline ListTypesByAssociationRequest& WithMaxResults(int value) { SetMaxResults(value); return *this;}
    ///@}
  private:

    Aws::String m_mergedApiIdentifier;
    bool m_mergedApiIdentifierHasBeenSet = false;

    Aws::String m_associationId;
    bool m_associationIdHasBeenSet = false;

    TypeDefinitionFormat m_format;
    bool m_formatHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    int m_maxResults;
    bool m_maxResultsHasBeenSet = false;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
