﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace BedrockAgentRuntime
{
namespace Model
{

  /**
   * <p>Contains the JSON-formatted string returned by the API invoked by the code
   * interpreter.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/CodeInterpreterInvocationOutput">AWS
   * API Reference</a></p>
   */
  class CodeInterpreterInvocationOutput
  {
  public:
    AWS_BEDROCKAGENTRUNTIME_API CodeInterpreterInvocationOutput();
    AWS_BEDROCKAGENTRUNTIME_API CodeInterpreterInvocationOutput(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKAGENTRUNTIME_API CodeInterpreterInvocationOutput& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKAGENTRUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Contains the error returned from code execution.</p>
     */
    inline const Aws::String& GetExecutionError() const{ return m_executionError; }
    inline bool ExecutionErrorHasBeenSet() const { return m_executionErrorHasBeenSet; }
    inline void SetExecutionError(const Aws::String& value) { m_executionErrorHasBeenSet = true; m_executionError = value; }
    inline void SetExecutionError(Aws::String&& value) { m_executionErrorHasBeenSet = true; m_executionError = std::move(value); }
    inline void SetExecutionError(const char* value) { m_executionErrorHasBeenSet = true; m_executionError.assign(value); }
    inline CodeInterpreterInvocationOutput& WithExecutionError(const Aws::String& value) { SetExecutionError(value); return *this;}
    inline CodeInterpreterInvocationOutput& WithExecutionError(Aws::String&& value) { SetExecutionError(std::move(value)); return *this;}
    inline CodeInterpreterInvocationOutput& WithExecutionError(const char* value) { SetExecutionError(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains the successful output returned from code execution</p>
     */
    inline const Aws::String& GetExecutionOutput() const{ return m_executionOutput; }
    inline bool ExecutionOutputHasBeenSet() const { return m_executionOutputHasBeenSet; }
    inline void SetExecutionOutput(const Aws::String& value) { m_executionOutputHasBeenSet = true; m_executionOutput = value; }
    inline void SetExecutionOutput(Aws::String&& value) { m_executionOutputHasBeenSet = true; m_executionOutput = std::move(value); }
    inline void SetExecutionOutput(const char* value) { m_executionOutputHasBeenSet = true; m_executionOutput.assign(value); }
    inline CodeInterpreterInvocationOutput& WithExecutionOutput(const Aws::String& value) { SetExecutionOutput(value); return *this;}
    inline CodeInterpreterInvocationOutput& WithExecutionOutput(Aws::String&& value) { SetExecutionOutput(std::move(value)); return *this;}
    inline CodeInterpreterInvocationOutput& WithExecutionOutput(const char* value) { SetExecutionOutput(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates if the execution of the code timed out.</p>
     */
    inline bool GetExecutionTimeout() const{ return m_executionTimeout; }
    inline bool ExecutionTimeoutHasBeenSet() const { return m_executionTimeoutHasBeenSet; }
    inline void SetExecutionTimeout(bool value) { m_executionTimeoutHasBeenSet = true; m_executionTimeout = value; }
    inline CodeInterpreterInvocationOutput& WithExecutionTimeout(bool value) { SetExecutionTimeout(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains output files, if generated by code execution.</p>
     */
    inline const Aws::Vector<Aws::String>& GetFiles() const{ return m_files; }
    inline bool FilesHasBeenSet() const { return m_filesHasBeenSet; }
    inline void SetFiles(const Aws::Vector<Aws::String>& value) { m_filesHasBeenSet = true; m_files = value; }
    inline void SetFiles(Aws::Vector<Aws::String>&& value) { m_filesHasBeenSet = true; m_files = std::move(value); }
    inline CodeInterpreterInvocationOutput& WithFiles(const Aws::Vector<Aws::String>& value) { SetFiles(value); return *this;}
    inline CodeInterpreterInvocationOutput& WithFiles(Aws::Vector<Aws::String>&& value) { SetFiles(std::move(value)); return *this;}
    inline CodeInterpreterInvocationOutput& AddFiles(const Aws::String& value) { m_filesHasBeenSet = true; m_files.push_back(value); return *this; }
    inline CodeInterpreterInvocationOutput& AddFiles(Aws::String&& value) { m_filesHasBeenSet = true; m_files.push_back(std::move(value)); return *this; }
    inline CodeInterpreterInvocationOutput& AddFiles(const char* value) { m_filesHasBeenSet = true; m_files.push_back(value); return *this; }
    ///@}
  private:

    Aws::String m_executionError;
    bool m_executionErrorHasBeenSet = false;

    Aws::String m_executionOutput;
    bool m_executionOutputHasBeenSet = false;

    bool m_executionTimeout;
    bool m_executionTimeoutHasBeenSet = false;

    Aws::Vector<Aws::String> m_files;
    bool m_filesHasBeenSet = false;
  };

} // namespace Model
} // namespace BedrockAgentRuntime
} // namespace Aws
