﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codecommit/CodeCommit_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/codecommit/model/BatchDisassociateApprovalRuleTemplateFromRepositoriesError.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CodeCommit
{
namespace Model
{
  class BatchDisassociateApprovalRuleTemplateFromRepositoriesResult
  {
  public:
    AWS_CODECOMMIT_API BatchDisassociateApprovalRuleTemplateFromRepositoriesResult();
    AWS_CODECOMMIT_API BatchDisassociateApprovalRuleTemplateFromRepositoriesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CODECOMMIT_API BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of repository names that have had their association with the template
     * removed.</p>
     */
    inline const Aws::Vector<Aws::String>& GetDisassociatedRepositoryNames() const{ return m_disassociatedRepositoryNames; }
    inline void SetDisassociatedRepositoryNames(const Aws::Vector<Aws::String>& value) { m_disassociatedRepositoryNames = value; }
    inline void SetDisassociatedRepositoryNames(Aws::Vector<Aws::String>&& value) { m_disassociatedRepositoryNames = std::move(value); }
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& WithDisassociatedRepositoryNames(const Aws::Vector<Aws::String>& value) { SetDisassociatedRepositoryNames(value); return *this;}
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& WithDisassociatedRepositoryNames(Aws::Vector<Aws::String>&& value) { SetDisassociatedRepositoryNames(std::move(value)); return *this;}
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& AddDisassociatedRepositoryNames(const Aws::String& value) { m_disassociatedRepositoryNames.push_back(value); return *this; }
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& AddDisassociatedRepositoryNames(Aws::String&& value) { m_disassociatedRepositoryNames.push_back(std::move(value)); return *this; }
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& AddDisassociatedRepositoryNames(const char* value) { m_disassociatedRepositoryNames.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>A list of any errors that might have occurred while attempting to remove the
     * association between the template and the repositories.</p>
     */
    inline const Aws::Vector<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>& GetErrors() const{ return m_errors; }
    inline void SetErrors(const Aws::Vector<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>& value) { m_errors = value; }
    inline void SetErrors(Aws::Vector<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>&& value) { m_errors = std::move(value); }
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& WithErrors(const Aws::Vector<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>& value) { SetErrors(value); return *this;}
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& WithErrors(Aws::Vector<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>&& value) { SetErrors(std::move(value)); return *this;}
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& AddErrors(const BatchDisassociateApprovalRuleTemplateFromRepositoriesError& value) { m_errors.push_back(value); return *this; }
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& AddErrors(BatchDisassociateApprovalRuleTemplateFromRepositoriesError&& value) { m_errors.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline BatchDisassociateApprovalRuleTemplateFromRepositoriesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<Aws::String> m_disassociatedRepositoryNames;

    Aws::Vector<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> m_errors;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace CodeCommit
} // namespace Aws
