﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/SnapshotTierStatus.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Xml
{
  class XmlDocument;
} // namespace Xml
} // namespace Utils
namespace EC2
{
namespace Model
{
  class DescribeSnapshotTierStatusResponse
  {
  public:
    AWS_EC2_API DescribeSnapshotTierStatusResponse();
    AWS_EC2_API DescribeSnapshotTierStatusResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
    AWS_EC2_API DescribeSnapshotTierStatusResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);


    ///@{
    /**
     * <p>Information about the snapshot's storage tier.</p>
     */
    inline const Aws::Vector<SnapshotTierStatus>& GetSnapshotTierStatuses() const{ return m_snapshotTierStatuses; }
    inline void SetSnapshotTierStatuses(const Aws::Vector<SnapshotTierStatus>& value) { m_snapshotTierStatuses = value; }
    inline void SetSnapshotTierStatuses(Aws::Vector<SnapshotTierStatus>&& value) { m_snapshotTierStatuses = std::move(value); }
    inline DescribeSnapshotTierStatusResponse& WithSnapshotTierStatuses(const Aws::Vector<SnapshotTierStatus>& value) { SetSnapshotTierStatuses(value); return *this;}
    inline DescribeSnapshotTierStatusResponse& WithSnapshotTierStatuses(Aws::Vector<SnapshotTierStatus>&& value) { SetSnapshotTierStatuses(std::move(value)); return *this;}
    inline DescribeSnapshotTierStatusResponse& AddSnapshotTierStatuses(const SnapshotTierStatus& value) { m_snapshotTierStatuses.push_back(value); return *this; }
    inline DescribeSnapshotTierStatusResponse& AddSnapshotTierStatuses(SnapshotTierStatus&& value) { m_snapshotTierStatuses.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token to include in another request to get the next page of items. This
     * value is <code>null</code> when there are no more items to return.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline DescribeSnapshotTierStatusResponse& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline DescribeSnapshotTierStatusResponse& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline DescribeSnapshotTierStatusResponse& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const ResponseMetadata& GetResponseMetadata() const{ return m_responseMetadata; }
    inline void SetResponseMetadata(const ResponseMetadata& value) { m_responseMetadata = value; }
    inline void SetResponseMetadata(ResponseMetadata&& value) { m_responseMetadata = std::move(value); }
    inline DescribeSnapshotTierStatusResponse& WithResponseMetadata(const ResponseMetadata& value) { SetResponseMetadata(value); return *this;}
    inline DescribeSnapshotTierStatusResponse& WithResponseMetadata(ResponseMetadata&& value) { SetResponseMetadata(std::move(value)); return *this;}
    ///@}
  private:

    Aws::Vector<SnapshotTierStatus> m_snapshotTierStatuses;

    Aws::String m_nextToken;

    ResponseMetadata m_responseMetadata;
  };

} // namespace Model
} // namespace EC2
} // namespace Aws
