﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/fis/FIS_EXPORTS.h>
#include <aws/fis/model/ReportConfigurationS3OutputInput.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace FIS
{
namespace Model
{

  /**
   * <p>Specifies the outputs for the experiment templates.</p><p><h3>See Also:</h3> 
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ExperimentTemplateReportConfigurationOutputsInput">AWS
   * API Reference</a></p>
   */
  class ExperimentTemplateReportConfigurationOutputsInput
  {
  public:
    AWS_FIS_API ExperimentTemplateReportConfigurationOutputsInput();
    AWS_FIS_API ExperimentTemplateReportConfigurationOutputsInput(Aws::Utils::Json::JsonView jsonValue);
    AWS_FIS_API ExperimentTemplateReportConfigurationOutputsInput& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_FIS_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The S3 destination for the experiment report.</p>
     */
    inline const ReportConfigurationS3OutputInput& GetS3Configuration() const{ return m_s3Configuration; }
    inline bool S3ConfigurationHasBeenSet() const { return m_s3ConfigurationHasBeenSet; }
    inline void SetS3Configuration(const ReportConfigurationS3OutputInput& value) { m_s3ConfigurationHasBeenSet = true; m_s3Configuration = value; }
    inline void SetS3Configuration(ReportConfigurationS3OutputInput&& value) { m_s3ConfigurationHasBeenSet = true; m_s3Configuration = std::move(value); }
    inline ExperimentTemplateReportConfigurationOutputsInput& WithS3Configuration(const ReportConfigurationS3OutputInput& value) { SetS3Configuration(value); return *this;}
    inline ExperimentTemplateReportConfigurationOutputsInput& WithS3Configuration(ReportConfigurationS3OutputInput&& value) { SetS3Configuration(std::move(value)); return *this;}
    ///@}
  private:

    ReportConfigurationS3OutputInput m_s3Configuration;
    bool m_s3ConfigurationHasBeenSet = false;
  };

} // namespace Model
} // namespace FIS
} // namespace Aws
