﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Glue
{
namespace Model
{
  class DeleteMLTransformResult
  {
  public:
    AWS_GLUE_API DeleteMLTransformResult();
    AWS_GLUE_API DeleteMLTransformResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_GLUE_API DeleteMLTransformResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The unique identifier of the transform that was deleted.</p>
     */
    inline const Aws::String& GetTransformId() const{ return m_transformId; }
    inline void SetTransformId(const Aws::String& value) { m_transformId = value; }
    inline void SetTransformId(Aws::String&& value) { m_transformId = std::move(value); }
    inline void SetTransformId(const char* value) { m_transformId.assign(value); }
    inline DeleteMLTransformResult& WithTransformId(const Aws::String& value) { SetTransformId(value); return *this;}
    inline DeleteMLTransformResult& WithTransformId(Aws::String&& value) { SetTransformId(std::move(value)); return *this;}
    inline DeleteMLTransformResult& WithTransformId(const char* value) { SetTransformId(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DeleteMLTransformResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DeleteMLTransformResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DeleteMLTransformResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_transformId;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Glue
} // namespace Aws
