﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/model/Connection.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Glue
{
namespace Model
{
  class GetConnectionsResult
  {
  public:
    AWS_GLUE_API GetConnectionsResult();
    AWS_GLUE_API GetConnectionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_GLUE_API GetConnectionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of requested connection definitions.</p>
     */
    inline const Aws::Vector<Connection>& GetConnectionList() const{ return m_connectionList; }
    inline void SetConnectionList(const Aws::Vector<Connection>& value) { m_connectionList = value; }
    inline void SetConnectionList(Aws::Vector<Connection>&& value) { m_connectionList = std::move(value); }
    inline GetConnectionsResult& WithConnectionList(const Aws::Vector<Connection>& value) { SetConnectionList(value); return *this;}
    inline GetConnectionsResult& WithConnectionList(Aws::Vector<Connection>&& value) { SetConnectionList(std::move(value)); return *this;}
    inline GetConnectionsResult& AddConnectionList(const Connection& value) { m_connectionList.push_back(value); return *this; }
    inline GetConnectionsResult& AddConnectionList(Connection&& value) { m_connectionList.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A continuation token, if the list of connections returned does not include
     * the last of the filtered connections.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline GetConnectionsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline GetConnectionsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline GetConnectionsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline GetConnectionsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline GetConnectionsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline GetConnectionsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<Connection> m_connectionList;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Glue
} // namespace Aws
