﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Glue
{
namespace Model
{

  /**
   * <p>A structure used as a protocol between query engines and Lake Formation or
   * Glue. Contains both a Lake Formation generated authorization identifier and
   * information from the request's authorization context.</p><p><h3>See Also:</h3>  
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/QuerySessionContext">AWS
   * API Reference</a></p>
   */
  class QuerySessionContext
  {
  public:
    AWS_GLUE_API QuerySessionContext();
    AWS_GLUE_API QuerySessionContext(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUE_API QuerySessionContext& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>A unique identifier generated by the query engine for the query.</p>
     */
    inline const Aws::String& GetQueryId() const{ return m_queryId; }
    inline bool QueryIdHasBeenSet() const { return m_queryIdHasBeenSet; }
    inline void SetQueryId(const Aws::String& value) { m_queryIdHasBeenSet = true; m_queryId = value; }
    inline void SetQueryId(Aws::String&& value) { m_queryIdHasBeenSet = true; m_queryId = std::move(value); }
    inline void SetQueryId(const char* value) { m_queryIdHasBeenSet = true; m_queryId.assign(value); }
    inline QuerySessionContext& WithQueryId(const Aws::String& value) { SetQueryId(value); return *this;}
    inline QuerySessionContext& WithQueryId(Aws::String&& value) { SetQueryId(std::move(value)); return *this;}
    inline QuerySessionContext& WithQueryId(const char* value) { SetQueryId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A timestamp provided by the query engine for when the query started.</p>
     */
    inline const Aws::Utils::DateTime& GetQueryStartTime() const{ return m_queryStartTime; }
    inline bool QueryStartTimeHasBeenSet() const { return m_queryStartTimeHasBeenSet; }
    inline void SetQueryStartTime(const Aws::Utils::DateTime& value) { m_queryStartTimeHasBeenSet = true; m_queryStartTime = value; }
    inline void SetQueryStartTime(Aws::Utils::DateTime&& value) { m_queryStartTimeHasBeenSet = true; m_queryStartTime = std::move(value); }
    inline QuerySessionContext& WithQueryStartTime(const Aws::Utils::DateTime& value) { SetQueryStartTime(value); return *this;}
    inline QuerySessionContext& WithQueryStartTime(Aws::Utils::DateTime&& value) { SetQueryStartTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>An identifier string for the consumer cluster.</p>
     */
    inline const Aws::String& GetClusterId() const{ return m_clusterId; }
    inline bool ClusterIdHasBeenSet() const { return m_clusterIdHasBeenSet; }
    inline void SetClusterId(const Aws::String& value) { m_clusterIdHasBeenSet = true; m_clusterId = value; }
    inline void SetClusterId(Aws::String&& value) { m_clusterIdHasBeenSet = true; m_clusterId = std::move(value); }
    inline void SetClusterId(const char* value) { m_clusterIdHasBeenSet = true; m_clusterId.assign(value); }
    inline QuerySessionContext& WithClusterId(const Aws::String& value) { SetClusterId(value); return *this;}
    inline QuerySessionContext& WithClusterId(Aws::String&& value) { SetClusterId(std::move(value)); return *this;}
    inline QuerySessionContext& WithClusterId(const char* value) { SetClusterId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A cryptographically generated query identifier generated by Glue or Lake
     * Formation.</p>
     */
    inline const Aws::String& GetQueryAuthorizationId() const{ return m_queryAuthorizationId; }
    inline bool QueryAuthorizationIdHasBeenSet() const { return m_queryAuthorizationIdHasBeenSet; }
    inline void SetQueryAuthorizationId(const Aws::String& value) { m_queryAuthorizationIdHasBeenSet = true; m_queryAuthorizationId = value; }
    inline void SetQueryAuthorizationId(Aws::String&& value) { m_queryAuthorizationIdHasBeenSet = true; m_queryAuthorizationId = std::move(value); }
    inline void SetQueryAuthorizationId(const char* value) { m_queryAuthorizationIdHasBeenSet = true; m_queryAuthorizationId.assign(value); }
    inline QuerySessionContext& WithQueryAuthorizationId(const Aws::String& value) { SetQueryAuthorizationId(value); return *this;}
    inline QuerySessionContext& WithQueryAuthorizationId(Aws::String&& value) { SetQueryAuthorizationId(std::move(value)); return *this;}
    inline QuerySessionContext& WithQueryAuthorizationId(const char* value) { SetQueryAuthorizationId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>An opaque string-string map passed by the query engine.</p>
     */
    inline const Aws::Map<Aws::String, Aws::String>& GetAdditionalContext() const{ return m_additionalContext; }
    inline bool AdditionalContextHasBeenSet() const { return m_additionalContextHasBeenSet; }
    inline void SetAdditionalContext(const Aws::Map<Aws::String, Aws::String>& value) { m_additionalContextHasBeenSet = true; m_additionalContext = value; }
    inline void SetAdditionalContext(Aws::Map<Aws::String, Aws::String>&& value) { m_additionalContextHasBeenSet = true; m_additionalContext = std::move(value); }
    inline QuerySessionContext& WithAdditionalContext(const Aws::Map<Aws::String, Aws::String>& value) { SetAdditionalContext(value); return *this;}
    inline QuerySessionContext& WithAdditionalContext(Aws::Map<Aws::String, Aws::String>&& value) { SetAdditionalContext(std::move(value)); return *this;}
    inline QuerySessionContext& AddAdditionalContext(const Aws::String& key, const Aws::String& value) { m_additionalContextHasBeenSet = true; m_additionalContext.emplace(key, value); return *this; }
    inline QuerySessionContext& AddAdditionalContext(Aws::String&& key, const Aws::String& value) { m_additionalContextHasBeenSet = true; m_additionalContext.emplace(std::move(key), value); return *this; }
    inline QuerySessionContext& AddAdditionalContext(const Aws::String& key, Aws::String&& value) { m_additionalContextHasBeenSet = true; m_additionalContext.emplace(key, std::move(value)); return *this; }
    inline QuerySessionContext& AddAdditionalContext(Aws::String&& key, Aws::String&& value) { m_additionalContextHasBeenSet = true; m_additionalContext.emplace(std::move(key), std::move(value)); return *this; }
    inline QuerySessionContext& AddAdditionalContext(const char* key, Aws::String&& value) { m_additionalContextHasBeenSet = true; m_additionalContext.emplace(key, std::move(value)); return *this; }
    inline QuerySessionContext& AddAdditionalContext(Aws::String&& key, const char* value) { m_additionalContextHasBeenSet = true; m_additionalContext.emplace(std::move(key), value); return *this; }
    inline QuerySessionContext& AddAdditionalContext(const char* key, const char* value) { m_additionalContextHasBeenSet = true; m_additionalContext.emplace(key, value); return *this; }
    ///@}
  private:

    Aws::String m_queryId;
    bool m_queryIdHasBeenSet = false;

    Aws::Utils::DateTime m_queryStartTime;
    bool m_queryStartTimeHasBeenSet = false;

    Aws::String m_clusterId;
    bool m_clusterIdHasBeenSet = false;

    Aws::String m_queryAuthorizationId;
    bool m_queryAuthorizationIdHasBeenSet = false;

    Aws::Map<Aws::String, Aws::String> m_additionalContext;
    bool m_additionalContextHasBeenSet = false;
  };

} // namespace Model
} // namespace Glue
} // namespace Aws
