﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/healthlake/HealthLake_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/healthlake/model/DatastoreProperties.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace HealthLake
{
namespace Model
{
  class ListFHIRDatastoresResult
  {
  public:
    AWS_HEALTHLAKE_API ListFHIRDatastoresResult();
    AWS_HEALTHLAKE_API ListFHIRDatastoresResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_HEALTHLAKE_API ListFHIRDatastoresResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>All properties associated with the listed data stores.</p>
     */
    inline const Aws::Vector<DatastoreProperties>& GetDatastorePropertiesList() const{ return m_datastorePropertiesList; }
    inline void SetDatastorePropertiesList(const Aws::Vector<DatastoreProperties>& value) { m_datastorePropertiesList = value; }
    inline void SetDatastorePropertiesList(Aws::Vector<DatastoreProperties>&& value) { m_datastorePropertiesList = std::move(value); }
    inline ListFHIRDatastoresResult& WithDatastorePropertiesList(const Aws::Vector<DatastoreProperties>& value) { SetDatastorePropertiesList(value); return *this;}
    inline ListFHIRDatastoresResult& WithDatastorePropertiesList(Aws::Vector<DatastoreProperties>&& value) { SetDatastorePropertiesList(std::move(value)); return *this;}
    inline ListFHIRDatastoresResult& AddDatastorePropertiesList(const DatastoreProperties& value) { m_datastorePropertiesList.push_back(value); return *this; }
    inline ListFHIRDatastoresResult& AddDatastorePropertiesList(DatastoreProperties&& value) { m_datastorePropertiesList.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Pagination token that can be used to retrieve the next page of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListFHIRDatastoresResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListFHIRDatastoresResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListFHIRDatastoresResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListFHIRDatastoresResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListFHIRDatastoresResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListFHIRDatastoresResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<DatastoreProperties> m_datastorePropertiesList;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace HealthLake
} // namespace Aws
