﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/model/SecurityProfileIdentifier.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace IoT
{
namespace Model
{
  class ListSecurityProfilesResult
  {
  public:
    AWS_IOT_API ListSecurityProfilesResult();
    AWS_IOT_API ListSecurityProfilesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_IOT_API ListSecurityProfilesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of security profile identifiers (names and ARNs).</p>
     */
    inline const Aws::Vector<SecurityProfileIdentifier>& GetSecurityProfileIdentifiers() const{ return m_securityProfileIdentifiers; }
    inline void SetSecurityProfileIdentifiers(const Aws::Vector<SecurityProfileIdentifier>& value) { m_securityProfileIdentifiers = value; }
    inline void SetSecurityProfileIdentifiers(Aws::Vector<SecurityProfileIdentifier>&& value) { m_securityProfileIdentifiers = std::move(value); }
    inline ListSecurityProfilesResult& WithSecurityProfileIdentifiers(const Aws::Vector<SecurityProfileIdentifier>& value) { SetSecurityProfileIdentifiers(value); return *this;}
    inline ListSecurityProfilesResult& WithSecurityProfileIdentifiers(Aws::Vector<SecurityProfileIdentifier>&& value) { SetSecurityProfileIdentifiers(std::move(value)); return *this;}
    inline ListSecurityProfilesResult& AddSecurityProfileIdentifiers(const SecurityProfileIdentifier& value) { m_securityProfileIdentifiers.push_back(value); return *this; }
    inline ListSecurityProfilesResult& AddSecurityProfileIdentifiers(SecurityProfileIdentifier&& value) { m_securityProfileIdentifiers.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A token that can be used to retrieve the next set of results, or
     * <code>null</code> if there are no additional results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListSecurityProfilesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListSecurityProfilesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListSecurityProfilesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListSecurityProfilesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListSecurityProfilesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListSecurityProfilesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<SecurityProfileIdentifier> m_securityProfileIdentifiers;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace IoT
} // namespace Aws
