﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/license-manager/LicenseManager_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/license-manager/model/License.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace LicenseManager
{
namespace Model
{
  class ListLicenseVersionsResult
  {
  public:
    AWS_LICENSEMANAGER_API ListLicenseVersionsResult();
    AWS_LICENSEMANAGER_API ListLicenseVersionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_LICENSEMANAGER_API ListLicenseVersionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>License details.</p>
     */
    inline const Aws::Vector<License>& GetLicenses() const{ return m_licenses; }
    inline void SetLicenses(const Aws::Vector<License>& value) { m_licenses = value; }
    inline void SetLicenses(Aws::Vector<License>&& value) { m_licenses = std::move(value); }
    inline ListLicenseVersionsResult& WithLicenses(const Aws::Vector<License>& value) { SetLicenses(value); return *this;}
    inline ListLicenseVersionsResult& WithLicenses(Aws::Vector<License>&& value) { SetLicenses(std::move(value)); return *this;}
    inline ListLicenseVersionsResult& AddLicenses(const License& value) { m_licenses.push_back(value); return *this; }
    inline ListLicenseVersionsResult& AddLicenses(License&& value) { m_licenses.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>Token for the next set of results.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListLicenseVersionsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListLicenseVersionsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListLicenseVersionsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListLicenseVersionsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListLicenseVersionsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListLicenseVersionsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::Vector<License> m_licenses;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace LicenseManager
} // namespace Aws
