﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lookoutequipment/LookoutEquipment_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lookoutequipment/model/InferenceEventSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace LookoutEquipment
{
namespace Model
{
  class ListInferenceEventsResult
  {
  public:
    AWS_LOOKOUTEQUIPMENT_API ListInferenceEventsResult();
    AWS_LOOKOUTEQUIPMENT_API ListInferenceEventsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_LOOKOUTEQUIPMENT_API ListInferenceEventsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>An opaque pagination token indicating where to continue the listing of
     * inference executions. </p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListInferenceEventsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListInferenceEventsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListInferenceEventsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Provides an array of information about the individual inference events
     * returned from the <code>ListInferenceEvents</code> operation, including
     * scheduler used, event start time, event end time, diagnostics, and so on. </p>
     */
    inline const Aws::Vector<InferenceEventSummary>& GetInferenceEventSummaries() const{ return m_inferenceEventSummaries; }
    inline void SetInferenceEventSummaries(const Aws::Vector<InferenceEventSummary>& value) { m_inferenceEventSummaries = value; }
    inline void SetInferenceEventSummaries(Aws::Vector<InferenceEventSummary>&& value) { m_inferenceEventSummaries = std::move(value); }
    inline ListInferenceEventsResult& WithInferenceEventSummaries(const Aws::Vector<InferenceEventSummary>& value) { SetInferenceEventSummaries(value); return *this;}
    inline ListInferenceEventsResult& WithInferenceEventSummaries(Aws::Vector<InferenceEventSummary>&& value) { SetInferenceEventSummaries(std::move(value)); return *this;}
    inline ListInferenceEventsResult& AddInferenceEventSummaries(const InferenceEventSummary& value) { m_inferenceEventSummaries.push_back(value); return *this; }
    inline ListInferenceEventsResult& AddInferenceEventSummaries(InferenceEventSummary&& value) { m_inferenceEventSummaries.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListInferenceEventsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListInferenceEventsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListInferenceEventsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;

    Aws::Vector<InferenceEventSummary> m_inferenceEventSummaries;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace LookoutEquipment
} // namespace Aws
