﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/managedblockchain/ManagedBlockchain_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace ManagedBlockchain
{
namespace Model
{

  /**
   * <p>Configuration properties for Hyperledger Fabric for a member in a Managed
   * Blockchain network that is using the Hyperledger Fabric framework.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/MemberFabricConfiguration">AWS
   * API Reference</a></p>
   */
  class MemberFabricConfiguration
  {
  public:
    AWS_MANAGEDBLOCKCHAIN_API MemberFabricConfiguration();
    AWS_MANAGEDBLOCKCHAIN_API MemberFabricConfiguration(Aws::Utils::Json::JsonView jsonValue);
    AWS_MANAGEDBLOCKCHAIN_API MemberFabricConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_MANAGEDBLOCKCHAIN_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The user name for the member's initial administrative user.</p>
     */
    inline const Aws::String& GetAdminUsername() const{ return m_adminUsername; }
    inline bool AdminUsernameHasBeenSet() const { return m_adminUsernameHasBeenSet; }
    inline void SetAdminUsername(const Aws::String& value) { m_adminUsernameHasBeenSet = true; m_adminUsername = value; }
    inline void SetAdminUsername(Aws::String&& value) { m_adminUsernameHasBeenSet = true; m_adminUsername = std::move(value); }
    inline void SetAdminUsername(const char* value) { m_adminUsernameHasBeenSet = true; m_adminUsername.assign(value); }
    inline MemberFabricConfiguration& WithAdminUsername(const Aws::String& value) { SetAdminUsername(value); return *this;}
    inline MemberFabricConfiguration& WithAdminUsername(Aws::String&& value) { SetAdminUsername(std::move(value)); return *this;}
    inline MemberFabricConfiguration& WithAdminUsername(const char* value) { SetAdminUsername(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The password for the member's initial administrative user. The
     * <code>AdminPassword</code> must be at least 8 characters long and no more than
     * 32 characters. It must contain at least one uppercase letter, one lowercase
     * letter, and one digit. It cannot have a single quotation mark (‘), a double
     * quotation marks (“), a forward slash(/), a backward slash(\), @, or a space.</p>
     */
    inline const Aws::String& GetAdminPassword() const{ return m_adminPassword; }
    inline bool AdminPasswordHasBeenSet() const { return m_adminPasswordHasBeenSet; }
    inline void SetAdminPassword(const Aws::String& value) { m_adminPasswordHasBeenSet = true; m_adminPassword = value; }
    inline void SetAdminPassword(Aws::String&& value) { m_adminPasswordHasBeenSet = true; m_adminPassword = std::move(value); }
    inline void SetAdminPassword(const char* value) { m_adminPasswordHasBeenSet = true; m_adminPassword.assign(value); }
    inline MemberFabricConfiguration& WithAdminPassword(const Aws::String& value) { SetAdminPassword(value); return *this;}
    inline MemberFabricConfiguration& WithAdminPassword(Aws::String&& value) { SetAdminPassword(std::move(value)); return *this;}
    inline MemberFabricConfiguration& WithAdminPassword(const char* value) { SetAdminPassword(value); return *this;}
    ///@}
  private:

    Aws::String m_adminUsername;
    bool m_adminUsernameHasBeenSet = false;

    Aws::String m_adminPassword;
    bool m_adminPasswordHasBeenSet = false;
  };

} // namespace Model
} // namespace ManagedBlockchain
} // namespace Aws
