﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/medialive/MediaLive_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace MediaLive
{
namespace Model
{
  enum class HlsScte35SourceType
  {
    NOT_SET,
    MANIFEST,
    SEGMENTS
  };

namespace HlsScte35SourceTypeMapper
{
AWS_MEDIALIVE_API HlsScte35SourceType GetHlsScte35SourceTypeForName(const Aws::String& name);

AWS_MEDIALIVE_API Aws::String GetNameForHlsScte35SourceType(HlsScte35SourceType value);
} // namespace HlsScte35SourceTypeMapper
} // namespace Model
} // namespace MediaLive
} // namespace Aws
