﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/neptunedata/Neptunedata_EXPORTS.h>
#include <aws/neptunedata/NeptunedataRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace neptunedata
{
namespace Model
{

  /**
   */
  class CreateMLEndpointRequest : public NeptunedataRequest
  {
  public:
    AWS_NEPTUNEDATA_API CreateMLEndpointRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CreateMLEndpoint"; }

    AWS_NEPTUNEDATA_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>A unique identifier for the new inference endpoint. The default is an
     * autogenerated timestamped name.</p>
     */
    inline const Aws::String& GetId() const{ return m_id; }
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }
    inline CreateMLEndpointRequest& WithId(const Aws::String& value) { SetId(value); return *this;}
    inline CreateMLEndpointRequest& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}
    inline CreateMLEndpointRequest& WithId(const char* value) { SetId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job Id of the completed model-training job that has created the model
     * that the inference endpoint will point to. You must supply either the
     * <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.</p>
     */
    inline const Aws::String& GetMlModelTrainingJobId() const{ return m_mlModelTrainingJobId; }
    inline bool MlModelTrainingJobIdHasBeenSet() const { return m_mlModelTrainingJobIdHasBeenSet; }
    inline void SetMlModelTrainingJobId(const Aws::String& value) { m_mlModelTrainingJobIdHasBeenSet = true; m_mlModelTrainingJobId = value; }
    inline void SetMlModelTrainingJobId(Aws::String&& value) { m_mlModelTrainingJobIdHasBeenSet = true; m_mlModelTrainingJobId = std::move(value); }
    inline void SetMlModelTrainingJobId(const char* value) { m_mlModelTrainingJobIdHasBeenSet = true; m_mlModelTrainingJobId.assign(value); }
    inline CreateMLEndpointRequest& WithMlModelTrainingJobId(const Aws::String& value) { SetMlModelTrainingJobId(value); return *this;}
    inline CreateMLEndpointRequest& WithMlModelTrainingJobId(Aws::String&& value) { SetMlModelTrainingJobId(std::move(value)); return *this;}
    inline CreateMLEndpointRequest& WithMlModelTrainingJobId(const char* value) { SetMlModelTrainingJobId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The job Id of the completed model-transform job. You must supply either the
     * <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.</p>
     */
    inline const Aws::String& GetMlModelTransformJobId() const{ return m_mlModelTransformJobId; }
    inline bool MlModelTransformJobIdHasBeenSet() const { return m_mlModelTransformJobIdHasBeenSet; }
    inline void SetMlModelTransformJobId(const Aws::String& value) { m_mlModelTransformJobIdHasBeenSet = true; m_mlModelTransformJobId = value; }
    inline void SetMlModelTransformJobId(Aws::String&& value) { m_mlModelTransformJobIdHasBeenSet = true; m_mlModelTransformJobId = std::move(value); }
    inline void SetMlModelTransformJobId(const char* value) { m_mlModelTransformJobIdHasBeenSet = true; m_mlModelTransformJobId.assign(value); }
    inline CreateMLEndpointRequest& WithMlModelTransformJobId(const Aws::String& value) { SetMlModelTransformJobId(value); return *this;}
    inline CreateMLEndpointRequest& WithMlModelTransformJobId(Aws::String&& value) { SetMlModelTransformJobId(std::move(value)); return *this;}
    inline CreateMLEndpointRequest& WithMlModelTransformJobId(const char* value) { SetMlModelTransformJobId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>If set to <code>true</code>, <code>update</code> indicates that this is an
     * update request. The default is <code>false</code>. You must supply either the
     * <code>mlModelTrainingJobId</code> or the <code>mlModelTransformJobId</code>.</p>
     */
    inline bool GetUpdate() const{ return m_update; }
    inline bool UpdateHasBeenSet() const { return m_updateHasBeenSet; }
    inline void SetUpdate(bool value) { m_updateHasBeenSet = true; m_update = value; }
    inline CreateMLEndpointRequest& WithUpdate(bool value) { SetUpdate(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ARN of an IAM role providing Neptune access to SageMaker and Amazon S3
     * resources. This must be listed in your DB cluster parameter group or an error
     * will be thrown.</p>
     */
    inline const Aws::String& GetNeptuneIamRoleArn() const{ return m_neptuneIamRoleArn; }
    inline bool NeptuneIamRoleArnHasBeenSet() const { return m_neptuneIamRoleArnHasBeenSet; }
    inline void SetNeptuneIamRoleArn(const Aws::String& value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn = value; }
    inline void SetNeptuneIamRoleArn(Aws::String&& value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn = std::move(value); }
    inline void SetNeptuneIamRoleArn(const char* value) { m_neptuneIamRoleArnHasBeenSet = true; m_neptuneIamRoleArn.assign(value); }
    inline CreateMLEndpointRequest& WithNeptuneIamRoleArn(const Aws::String& value) { SetNeptuneIamRoleArn(value); return *this;}
    inline CreateMLEndpointRequest& WithNeptuneIamRoleArn(Aws::String&& value) { SetNeptuneIamRoleArn(std::move(value)); return *this;}
    inline CreateMLEndpointRequest& WithNeptuneIamRoleArn(const char* value) { SetNeptuneIamRoleArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Model type for training. By default the Neptune ML model is automatically
     * based on the <code>modelType</code> used in data processing, but you can specify
     * a different model type here. The default is <code>rgcn</code> for heterogeneous
     * graphs and <code>kge</code> for knowledge graphs. The only valid value for
     * heterogeneous graphs is <code>rgcn</code>. Valid values for knowledge graphs
     * are: <code>kge</code>, <code>transe</code>, <code>distmult</code>, and
     * <code>rotate</code>.</p>
     */
    inline const Aws::String& GetModelName() const{ return m_modelName; }
    inline bool ModelNameHasBeenSet() const { return m_modelNameHasBeenSet; }
    inline void SetModelName(const Aws::String& value) { m_modelNameHasBeenSet = true; m_modelName = value; }
    inline void SetModelName(Aws::String&& value) { m_modelNameHasBeenSet = true; m_modelName = std::move(value); }
    inline void SetModelName(const char* value) { m_modelNameHasBeenSet = true; m_modelName.assign(value); }
    inline CreateMLEndpointRequest& WithModelName(const Aws::String& value) { SetModelName(value); return *this;}
    inline CreateMLEndpointRequest& WithModelName(Aws::String&& value) { SetModelName(std::move(value)); return *this;}
    inline CreateMLEndpointRequest& WithModelName(const char* value) { SetModelName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The type of Neptune ML instance to use for online servicing. The default is
     * <code>ml.m5.xlarge</code>. Choosing the ML instance for an inference endpoint
     * depends on the task type, the graph size, and your budget.</p>
     */
    inline const Aws::String& GetInstanceType() const{ return m_instanceType; }
    inline bool InstanceTypeHasBeenSet() const { return m_instanceTypeHasBeenSet; }
    inline void SetInstanceType(const Aws::String& value) { m_instanceTypeHasBeenSet = true; m_instanceType = value; }
    inline void SetInstanceType(Aws::String&& value) { m_instanceTypeHasBeenSet = true; m_instanceType = std::move(value); }
    inline void SetInstanceType(const char* value) { m_instanceTypeHasBeenSet = true; m_instanceType.assign(value); }
    inline CreateMLEndpointRequest& WithInstanceType(const Aws::String& value) { SetInstanceType(value); return *this;}
    inline CreateMLEndpointRequest& WithInstanceType(Aws::String&& value) { SetInstanceType(std::move(value)); return *this;}
    inline CreateMLEndpointRequest& WithInstanceType(const char* value) { SetInstanceType(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The minimum number of Amazon EC2 instances to deploy to an endpoint for
     * prediction. The default is 1</p>
     */
    inline int GetInstanceCount() const{ return m_instanceCount; }
    inline bool InstanceCountHasBeenSet() const { return m_instanceCountHasBeenSet; }
    inline void SetInstanceCount(int value) { m_instanceCountHasBeenSet = true; m_instanceCount = value; }
    inline CreateMLEndpointRequest& WithInstanceCount(int value) { SetInstanceCount(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Key Management Service (Amazon KMS) key that SageMaker uses to
     * encrypt data on the storage volume attached to the ML compute instances that run
     * the training job. The default is None.</p>
     */
    inline const Aws::String& GetVolumeEncryptionKMSKey() const{ return m_volumeEncryptionKMSKey; }
    inline bool VolumeEncryptionKMSKeyHasBeenSet() const { return m_volumeEncryptionKMSKeyHasBeenSet; }
    inline void SetVolumeEncryptionKMSKey(const Aws::String& value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey = value; }
    inline void SetVolumeEncryptionKMSKey(Aws::String&& value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey = std::move(value); }
    inline void SetVolumeEncryptionKMSKey(const char* value) { m_volumeEncryptionKMSKeyHasBeenSet = true; m_volumeEncryptionKMSKey.assign(value); }
    inline CreateMLEndpointRequest& WithVolumeEncryptionKMSKey(const Aws::String& value) { SetVolumeEncryptionKMSKey(value); return *this;}
    inline CreateMLEndpointRequest& WithVolumeEncryptionKMSKey(Aws::String&& value) { SetVolumeEncryptionKMSKey(std::move(value)); return *this;}
    inline CreateMLEndpointRequest& WithVolumeEncryptionKMSKey(const char* value) { SetVolumeEncryptionKMSKey(value); return *this;}
    ///@}
  private:

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::String m_mlModelTrainingJobId;
    bool m_mlModelTrainingJobIdHasBeenSet = false;

    Aws::String m_mlModelTransformJobId;
    bool m_mlModelTransformJobIdHasBeenSet = false;

    bool m_update;
    bool m_updateHasBeenSet = false;

    Aws::String m_neptuneIamRoleArn;
    bool m_neptuneIamRoleArnHasBeenSet = false;

    Aws::String m_modelName;
    bool m_modelNameHasBeenSet = false;

    Aws::String m_instanceType;
    bool m_instanceTypeHasBeenSet = false;

    int m_instanceCount;
    bool m_instanceCountHasBeenSet = false;

    Aws::String m_volumeEncryptionKMSKey;
    bool m_volumeEncryptionKMSKeyHasBeenSet = false;
  };

} // namespace Model
} // namespace neptunedata
} // namespace Aws
