﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/neptunedata/Neptunedata_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/neptunedata/model/GremlinQueryStatus.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace neptunedata
{
namespace Model
{
  class ListOpenCypherQueriesResult
  {
  public:
    AWS_NEPTUNEDATA_API ListOpenCypherQueriesResult();
    AWS_NEPTUNEDATA_API ListOpenCypherQueriesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_NEPTUNEDATA_API ListOpenCypherQueriesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The number of queries that have been accepted but not yet completed,
     * including queries in the queue.</p>
     */
    inline int GetAcceptedQueryCount() const{ return m_acceptedQueryCount; }
    inline void SetAcceptedQueryCount(int value) { m_acceptedQueryCount = value; }
    inline ListOpenCypherQueriesResult& WithAcceptedQueryCount(int value) { SetAcceptedQueryCount(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The number of currently running openCypher queries.</p>
     */
    inline int GetRunningQueryCount() const{ return m_runningQueryCount; }
    inline void SetRunningQueryCount(int value) { m_runningQueryCount = value; }
    inline ListOpenCypherQueriesResult& WithRunningQueryCount(int value) { SetRunningQueryCount(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A list of current openCypher queries.</p>
     */
    inline const Aws::Vector<GremlinQueryStatus>& GetQueries() const{ return m_queries; }
    inline void SetQueries(const Aws::Vector<GremlinQueryStatus>& value) { m_queries = value; }
    inline void SetQueries(Aws::Vector<GremlinQueryStatus>&& value) { m_queries = std::move(value); }
    inline ListOpenCypherQueriesResult& WithQueries(const Aws::Vector<GremlinQueryStatus>& value) { SetQueries(value); return *this;}
    inline ListOpenCypherQueriesResult& WithQueries(Aws::Vector<GremlinQueryStatus>&& value) { SetQueries(std::move(value)); return *this;}
    inline ListOpenCypherQueriesResult& AddQueries(const GremlinQueryStatus& value) { m_queries.push_back(value); return *this; }
    inline ListOpenCypherQueriesResult& AddQueries(GremlinQueryStatus&& value) { m_queries.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListOpenCypherQueriesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListOpenCypherQueriesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListOpenCypherQueriesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    int m_acceptedQueryCount;

    int m_runningQueryCount;

    Aws::Vector<GremlinQueryStatus> m_queries;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace neptunedata
} // namespace Aws
