﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/panorama/Panorama_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/panorama/model/PackageObject.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Panorama
{
namespace Model
{
  class ListApplicationInstanceDependenciesResult
  {
  public:
    AWS_PANORAMA_API ListApplicationInstanceDependenciesResult();
    AWS_PANORAMA_API ListApplicationInstanceDependenciesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_PANORAMA_API ListApplicationInstanceDependenciesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A pagination token that's included if more results are available.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListApplicationInstanceDependenciesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListApplicationInstanceDependenciesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListApplicationInstanceDependenciesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A list of package objects.</p>
     */
    inline const Aws::Vector<PackageObject>& GetPackageObjects() const{ return m_packageObjects; }
    inline void SetPackageObjects(const Aws::Vector<PackageObject>& value) { m_packageObjects = value; }
    inline void SetPackageObjects(Aws::Vector<PackageObject>&& value) { m_packageObjects = std::move(value); }
    inline ListApplicationInstanceDependenciesResult& WithPackageObjects(const Aws::Vector<PackageObject>& value) { SetPackageObjects(value); return *this;}
    inline ListApplicationInstanceDependenciesResult& WithPackageObjects(Aws::Vector<PackageObject>&& value) { SetPackageObjects(std::move(value)); return *this;}
    inline ListApplicationInstanceDependenciesResult& AddPackageObjects(const PackageObject& value) { m_packageObjects.push_back(value); return *this; }
    inline ListApplicationInstanceDependenciesResult& AddPackageObjects(PackageObject&& value) { m_packageObjects.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListApplicationInstanceDependenciesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListApplicationInstanceDependenciesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListApplicationInstanceDependenciesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;

    Aws::Vector<PackageObject> m_packageObjects;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Panorama
} // namespace Aws
