﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/panorama/Panorama_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/panorama/model/NodeInstance.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Panorama
{
namespace Model
{
  class ListApplicationInstanceNodeInstancesResult
  {
  public:
    AWS_PANORAMA_API ListApplicationInstanceNodeInstancesResult();
    AWS_PANORAMA_API ListApplicationInstanceNodeInstancesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_PANORAMA_API ListApplicationInstanceNodeInstancesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A pagination token that's included if more results are available.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }
    inline ListApplicationInstanceNodeInstancesResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline ListApplicationInstanceNodeInstancesResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline ListApplicationInstanceNodeInstancesResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A list of node instances.</p>
     */
    inline const Aws::Vector<NodeInstance>& GetNodeInstances() const{ return m_nodeInstances; }
    inline void SetNodeInstances(const Aws::Vector<NodeInstance>& value) { m_nodeInstances = value; }
    inline void SetNodeInstances(Aws::Vector<NodeInstance>&& value) { m_nodeInstances = std::move(value); }
    inline ListApplicationInstanceNodeInstancesResult& WithNodeInstances(const Aws::Vector<NodeInstance>& value) { SetNodeInstances(value); return *this;}
    inline ListApplicationInstanceNodeInstancesResult& WithNodeInstances(Aws::Vector<NodeInstance>&& value) { SetNodeInstances(std::move(value)); return *this;}
    inline ListApplicationInstanceNodeInstancesResult& AddNodeInstances(const NodeInstance& value) { m_nodeInstances.push_back(value); return *this; }
    inline ListApplicationInstanceNodeInstancesResult& AddNodeInstances(NodeInstance&& value) { m_nodeInstances.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline ListApplicationInstanceNodeInstancesResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline ListApplicationInstanceNodeInstancesResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline ListApplicationInstanceNodeInstancesResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_nextToken;

    Aws::Vector<NodeInstance> m_nodeInstances;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Panorama
} // namespace Aws
