﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/pipes/Pipes_EXPORTS.h>
#include <aws/pipes/model/FilterCriteria.h>
#include <aws/pipes/model/UpdatePipeSourceKinesisStreamParameters.h>
#include <aws/pipes/model/UpdatePipeSourceDynamoDBStreamParameters.h>
#include <aws/pipes/model/UpdatePipeSourceSqsQueueParameters.h>
#include <aws/pipes/model/UpdatePipeSourceActiveMQBrokerParameters.h>
#include <aws/pipes/model/UpdatePipeSourceRabbitMQBrokerParameters.h>
#include <aws/pipes/model/UpdatePipeSourceManagedStreamingKafkaParameters.h>
#include <aws/pipes/model/UpdatePipeSourceSelfManagedKafkaParameters.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Pipes
{
namespace Model
{

  /**
   * <p>The parameters required to set up a source for your pipe.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/UpdatePipeSourceParameters">AWS
   * API Reference</a></p>
   */
  class UpdatePipeSourceParameters
  {
  public:
    AWS_PIPES_API UpdatePipeSourceParameters();
    AWS_PIPES_API UpdatePipeSourceParameters(Aws::Utils::Json::JsonView jsonValue);
    AWS_PIPES_API UpdatePipeSourceParameters& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_PIPES_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The collection of event patterns used to filter events.</p> <p>To remove a
     * filter, specify a <code>FilterCriteria</code> object with an empty array of
     * <code>Filter</code> objects.</p> <p>For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events
     * and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
     */
    inline const FilterCriteria& GetFilterCriteria() const{ return m_filterCriteria; }
    inline bool FilterCriteriaHasBeenSet() const { return m_filterCriteriaHasBeenSet; }
    inline void SetFilterCriteria(const FilterCriteria& value) { m_filterCriteriaHasBeenSet = true; m_filterCriteria = value; }
    inline void SetFilterCriteria(FilterCriteria&& value) { m_filterCriteriaHasBeenSet = true; m_filterCriteria = std::move(value); }
    inline UpdatePipeSourceParameters& WithFilterCriteria(const FilterCriteria& value) { SetFilterCriteria(value); return *this;}
    inline UpdatePipeSourceParameters& WithFilterCriteria(FilterCriteria&& value) { SetFilterCriteria(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The parameters for using a Kinesis stream as a source.</p>
     */
    inline const UpdatePipeSourceKinesisStreamParameters& GetKinesisStreamParameters() const{ return m_kinesisStreamParameters; }
    inline bool KinesisStreamParametersHasBeenSet() const { return m_kinesisStreamParametersHasBeenSet; }
    inline void SetKinesisStreamParameters(const UpdatePipeSourceKinesisStreamParameters& value) { m_kinesisStreamParametersHasBeenSet = true; m_kinesisStreamParameters = value; }
    inline void SetKinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters&& value) { m_kinesisStreamParametersHasBeenSet = true; m_kinesisStreamParameters = std::move(value); }
    inline UpdatePipeSourceParameters& WithKinesisStreamParameters(const UpdatePipeSourceKinesisStreamParameters& value) { SetKinesisStreamParameters(value); return *this;}
    inline UpdatePipeSourceParameters& WithKinesisStreamParameters(UpdatePipeSourceKinesisStreamParameters&& value) { SetKinesisStreamParameters(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The parameters for using a DynamoDB stream as a source.</p>
     */
    inline const UpdatePipeSourceDynamoDBStreamParameters& GetDynamoDBStreamParameters() const{ return m_dynamoDBStreamParameters; }
    inline bool DynamoDBStreamParametersHasBeenSet() const { return m_dynamoDBStreamParametersHasBeenSet; }
    inline void SetDynamoDBStreamParameters(const UpdatePipeSourceDynamoDBStreamParameters& value) { m_dynamoDBStreamParametersHasBeenSet = true; m_dynamoDBStreamParameters = value; }
    inline void SetDynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters&& value) { m_dynamoDBStreamParametersHasBeenSet = true; m_dynamoDBStreamParameters = std::move(value); }
    inline UpdatePipeSourceParameters& WithDynamoDBStreamParameters(const UpdatePipeSourceDynamoDBStreamParameters& value) { SetDynamoDBStreamParameters(value); return *this;}
    inline UpdatePipeSourceParameters& WithDynamoDBStreamParameters(UpdatePipeSourceDynamoDBStreamParameters&& value) { SetDynamoDBStreamParameters(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The parameters for using a Amazon SQS stream as a source.</p>
     */
    inline const UpdatePipeSourceSqsQueueParameters& GetSqsQueueParameters() const{ return m_sqsQueueParameters; }
    inline bool SqsQueueParametersHasBeenSet() const { return m_sqsQueueParametersHasBeenSet; }
    inline void SetSqsQueueParameters(const UpdatePipeSourceSqsQueueParameters& value) { m_sqsQueueParametersHasBeenSet = true; m_sqsQueueParameters = value; }
    inline void SetSqsQueueParameters(UpdatePipeSourceSqsQueueParameters&& value) { m_sqsQueueParametersHasBeenSet = true; m_sqsQueueParameters = std::move(value); }
    inline UpdatePipeSourceParameters& WithSqsQueueParameters(const UpdatePipeSourceSqsQueueParameters& value) { SetSqsQueueParameters(value); return *this;}
    inline UpdatePipeSourceParameters& WithSqsQueueParameters(UpdatePipeSourceSqsQueueParameters&& value) { SetSqsQueueParameters(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The parameters for using an Active MQ broker as a source.</p>
     */
    inline const UpdatePipeSourceActiveMQBrokerParameters& GetActiveMQBrokerParameters() const{ return m_activeMQBrokerParameters; }
    inline bool ActiveMQBrokerParametersHasBeenSet() const { return m_activeMQBrokerParametersHasBeenSet; }
    inline void SetActiveMQBrokerParameters(const UpdatePipeSourceActiveMQBrokerParameters& value) { m_activeMQBrokerParametersHasBeenSet = true; m_activeMQBrokerParameters = value; }
    inline void SetActiveMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters&& value) { m_activeMQBrokerParametersHasBeenSet = true; m_activeMQBrokerParameters = std::move(value); }
    inline UpdatePipeSourceParameters& WithActiveMQBrokerParameters(const UpdatePipeSourceActiveMQBrokerParameters& value) { SetActiveMQBrokerParameters(value); return *this;}
    inline UpdatePipeSourceParameters& WithActiveMQBrokerParameters(UpdatePipeSourceActiveMQBrokerParameters&& value) { SetActiveMQBrokerParameters(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The parameters for using a Rabbit MQ broker as a source.</p>
     */
    inline const UpdatePipeSourceRabbitMQBrokerParameters& GetRabbitMQBrokerParameters() const{ return m_rabbitMQBrokerParameters; }
    inline bool RabbitMQBrokerParametersHasBeenSet() const { return m_rabbitMQBrokerParametersHasBeenSet; }
    inline void SetRabbitMQBrokerParameters(const UpdatePipeSourceRabbitMQBrokerParameters& value) { m_rabbitMQBrokerParametersHasBeenSet = true; m_rabbitMQBrokerParameters = value; }
    inline void SetRabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters&& value) { m_rabbitMQBrokerParametersHasBeenSet = true; m_rabbitMQBrokerParameters = std::move(value); }
    inline UpdatePipeSourceParameters& WithRabbitMQBrokerParameters(const UpdatePipeSourceRabbitMQBrokerParameters& value) { SetRabbitMQBrokerParameters(value); return *this;}
    inline UpdatePipeSourceParameters& WithRabbitMQBrokerParameters(UpdatePipeSourceRabbitMQBrokerParameters&& value) { SetRabbitMQBrokerParameters(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The parameters for using an MSK stream as a source.</p>
     */
    inline const UpdatePipeSourceManagedStreamingKafkaParameters& GetManagedStreamingKafkaParameters() const{ return m_managedStreamingKafkaParameters; }
    inline bool ManagedStreamingKafkaParametersHasBeenSet() const { return m_managedStreamingKafkaParametersHasBeenSet; }
    inline void SetManagedStreamingKafkaParameters(const UpdatePipeSourceManagedStreamingKafkaParameters& value) { m_managedStreamingKafkaParametersHasBeenSet = true; m_managedStreamingKafkaParameters = value; }
    inline void SetManagedStreamingKafkaParameters(UpdatePipeSourceManagedStreamingKafkaParameters&& value) { m_managedStreamingKafkaParametersHasBeenSet = true; m_managedStreamingKafkaParameters = std::move(value); }
    inline UpdatePipeSourceParameters& WithManagedStreamingKafkaParameters(const UpdatePipeSourceManagedStreamingKafkaParameters& value) { SetManagedStreamingKafkaParameters(value); return *this;}
    inline UpdatePipeSourceParameters& WithManagedStreamingKafkaParameters(UpdatePipeSourceManagedStreamingKafkaParameters&& value) { SetManagedStreamingKafkaParameters(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The parameters for using a self-managed Apache Kafka stream as a source.</p>
     * <p>A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted
     * by Amazon Web Services. This includes both clusters you manage yourself, as well
     * as those hosted by a third-party provider, such as <a
     * href="https://www.confluent.io/">Confluent Cloud</a>, <a
     * href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a
     * href="https://redpanda.com/">Redpanda</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache
     * Kafka streams as a source</a> in the <i>Amazon EventBridge User Guide</i>.</p>
     */
    inline const UpdatePipeSourceSelfManagedKafkaParameters& GetSelfManagedKafkaParameters() const{ return m_selfManagedKafkaParameters; }
    inline bool SelfManagedKafkaParametersHasBeenSet() const { return m_selfManagedKafkaParametersHasBeenSet; }
    inline void SetSelfManagedKafkaParameters(const UpdatePipeSourceSelfManagedKafkaParameters& value) { m_selfManagedKafkaParametersHasBeenSet = true; m_selfManagedKafkaParameters = value; }
    inline void SetSelfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters&& value) { m_selfManagedKafkaParametersHasBeenSet = true; m_selfManagedKafkaParameters = std::move(value); }
    inline UpdatePipeSourceParameters& WithSelfManagedKafkaParameters(const UpdatePipeSourceSelfManagedKafkaParameters& value) { SetSelfManagedKafkaParameters(value); return *this;}
    inline UpdatePipeSourceParameters& WithSelfManagedKafkaParameters(UpdatePipeSourceSelfManagedKafkaParameters&& value) { SetSelfManagedKafkaParameters(std::move(value)); return *this;}
    ///@}
  private:

    FilterCriteria m_filterCriteria;
    bool m_filterCriteriaHasBeenSet = false;

    UpdatePipeSourceKinesisStreamParameters m_kinesisStreamParameters;
    bool m_kinesisStreamParametersHasBeenSet = false;

    UpdatePipeSourceDynamoDBStreamParameters m_dynamoDBStreamParameters;
    bool m_dynamoDBStreamParametersHasBeenSet = false;

    UpdatePipeSourceSqsQueueParameters m_sqsQueueParameters;
    bool m_sqsQueueParametersHasBeenSet = false;

    UpdatePipeSourceActiveMQBrokerParameters m_activeMQBrokerParameters;
    bool m_activeMQBrokerParametersHasBeenSet = false;

    UpdatePipeSourceRabbitMQBrokerParameters m_rabbitMQBrokerParameters;
    bool m_rabbitMQBrokerParametersHasBeenSet = false;

    UpdatePipeSourceManagedStreamingKafkaParameters m_managedStreamingKafkaParameters;
    bool m_managedStreamingKafkaParametersHasBeenSet = false;

    UpdatePipeSourceSelfManagedKafkaParameters m_selfManagedKafkaParameters;
    bool m_selfManagedKafkaParametersHasBeenSet = false;
  };

} // namespace Model
} // namespace Pipes
} // namespace Aws
