﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace QuickSight
{
namespace Model
{
  enum class QSearchStatus
  {
    NOT_SET,
    ENABLED,
    DISABLED
  };

namespace QSearchStatusMapper
{
AWS_QUICKSIGHT_API QSearchStatus GetQSearchStatusForName(const Aws::String& name);

AWS_QUICKSIGHT_API Aws::String GetNameForQSearchStatus(QSearchStatus value);
} // namespace QSearchStatusMapper
} // namespace Model
} // namespace QuickSight
} // namespace Aws
