﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/rekognition/Rekognition_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/rekognition/model/Instance.h>
#include <aws/rekognition/model/Parent.h>
#include <aws/rekognition/model/LabelAlias.h>
#include <aws/rekognition/model/LabelCategory.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Rekognition
{
namespace Model
{

  /**
   * <p>Structure containing details about the detected label, including the name,
   * detected instances, parent labels, and level of confidence.</p> <p>
   * </p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/rekognition-2016-06-27/Label">AWS
   * API Reference</a></p>
   */
  class Label
  {
  public:
    AWS_REKOGNITION_API Label();
    AWS_REKOGNITION_API Label(Aws::Utils::Json::JsonView jsonValue);
    AWS_REKOGNITION_API Label& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_REKOGNITION_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The name (label) of the object or scene.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }
    inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
    inline void SetName(const Aws::String& value) { m_nameHasBeenSet = true; m_name = value; }
    inline void SetName(Aws::String&& value) { m_nameHasBeenSet = true; m_name = std::move(value); }
    inline void SetName(const char* value) { m_nameHasBeenSet = true; m_name.assign(value); }
    inline Label& WithName(const Aws::String& value) { SetName(value); return *this;}
    inline Label& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}
    inline Label& WithName(const char* value) { SetName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Level of confidence.</p>
     */
    inline double GetConfidence() const{ return m_confidence; }
    inline bool ConfidenceHasBeenSet() const { return m_confidenceHasBeenSet; }
    inline void SetConfidence(double value) { m_confidenceHasBeenSet = true; m_confidence = value; }
    inline Label& WithConfidence(double value) { SetConfidence(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>If <code>Label</code> represents an object, <code>Instances</code> contains
     * the bounding boxes for each instance of the detected object. Bounding boxes are
     * returned for common object labels such as people, cars, furniture, apparel or
     * pets.</p>
     */
    inline const Aws::Vector<Instance>& GetInstances() const{ return m_instances; }
    inline bool InstancesHasBeenSet() const { return m_instancesHasBeenSet; }
    inline void SetInstances(const Aws::Vector<Instance>& value) { m_instancesHasBeenSet = true; m_instances = value; }
    inline void SetInstances(Aws::Vector<Instance>&& value) { m_instancesHasBeenSet = true; m_instances = std::move(value); }
    inline Label& WithInstances(const Aws::Vector<Instance>& value) { SetInstances(value); return *this;}
    inline Label& WithInstances(Aws::Vector<Instance>&& value) { SetInstances(std::move(value)); return *this;}
    inline Label& AddInstances(const Instance& value) { m_instancesHasBeenSet = true; m_instances.push_back(value); return *this; }
    inline Label& AddInstances(Instance&& value) { m_instancesHasBeenSet = true; m_instances.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The parent labels for a label. The response includes all ancestor labels.</p>
     */
    inline const Aws::Vector<Parent>& GetParents() const{ return m_parents; }
    inline bool ParentsHasBeenSet() const { return m_parentsHasBeenSet; }
    inline void SetParents(const Aws::Vector<Parent>& value) { m_parentsHasBeenSet = true; m_parents = value; }
    inline void SetParents(Aws::Vector<Parent>&& value) { m_parentsHasBeenSet = true; m_parents = std::move(value); }
    inline Label& WithParents(const Aws::Vector<Parent>& value) { SetParents(value); return *this;}
    inline Label& WithParents(Aws::Vector<Parent>&& value) { SetParents(std::move(value)); return *this;}
    inline Label& AddParents(const Parent& value) { m_parentsHasBeenSet = true; m_parents.push_back(value); return *this; }
    inline Label& AddParents(Parent&& value) { m_parentsHasBeenSet = true; m_parents.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A list of potential aliases for a given label.</p>
     */
    inline const Aws::Vector<LabelAlias>& GetAliases() const{ return m_aliases; }
    inline bool AliasesHasBeenSet() const { return m_aliasesHasBeenSet; }
    inline void SetAliases(const Aws::Vector<LabelAlias>& value) { m_aliasesHasBeenSet = true; m_aliases = value; }
    inline void SetAliases(Aws::Vector<LabelAlias>&& value) { m_aliasesHasBeenSet = true; m_aliases = std::move(value); }
    inline Label& WithAliases(const Aws::Vector<LabelAlias>& value) { SetAliases(value); return *this;}
    inline Label& WithAliases(Aws::Vector<LabelAlias>&& value) { SetAliases(std::move(value)); return *this;}
    inline Label& AddAliases(const LabelAlias& value) { m_aliasesHasBeenSet = true; m_aliases.push_back(value); return *this; }
    inline Label& AddAliases(LabelAlias&& value) { m_aliasesHasBeenSet = true; m_aliases.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A list of the categories associated with a given label.</p>
     */
    inline const Aws::Vector<LabelCategory>& GetCategories() const{ return m_categories; }
    inline bool CategoriesHasBeenSet() const { return m_categoriesHasBeenSet; }
    inline void SetCategories(const Aws::Vector<LabelCategory>& value) { m_categoriesHasBeenSet = true; m_categories = value; }
    inline void SetCategories(Aws::Vector<LabelCategory>&& value) { m_categoriesHasBeenSet = true; m_categories = std::move(value); }
    inline Label& WithCategories(const Aws::Vector<LabelCategory>& value) { SetCategories(value); return *this;}
    inline Label& WithCategories(Aws::Vector<LabelCategory>&& value) { SetCategories(std::move(value)); return *this;}
    inline Label& AddCategories(const LabelCategory& value) { m_categoriesHasBeenSet = true; m_categories.push_back(value); return *this; }
    inline Label& AddCategories(LabelCategory&& value) { m_categoriesHasBeenSet = true; m_categories.push_back(std::move(value)); return *this; }
    ///@}
  private:

    Aws::String m_name;
    bool m_nameHasBeenSet = false;

    double m_confidence;
    bool m_confidenceHasBeenSet = false;

    Aws::Vector<Instance> m_instances;
    bool m_instancesHasBeenSet = false;

    Aws::Vector<Parent> m_parents;
    bool m_parentsHasBeenSet = false;

    Aws::Vector<LabelAlias> m_aliases;
    bool m_aliasesHasBeenSet = false;

    Aws::Vector<LabelCategory> m_categories;
    bool m_categoriesHasBeenSet = false;
  };

} // namespace Model
} // namespace Rekognition
} // namespace Aws
