﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/resiliencehub/ResilienceHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace ResilienceHub
{
namespace Model
{

  /**
   * <p>Indicates a specific risk identified in the Resilience Hub assessment and the
   * corresponding recommendation provided to address that risk.</p>  <p>The
   * assessment summary generated by large language models (LLMs) on Amazon Bedrock
   * are only suggestions. The current level of generative AI technology is not
   * perfect and LLMs are not infallible. Bias and incorrect answers, although rare,
   * should be expected. Review each recommendation in the assessment summary before
   * you use the output from an LLM. </p>   <p>This property is
   * available only in the US East (N. Virginia) Region.</p> <p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/resiliencehub-2020-04-30/AssessmentRiskRecommendation">AWS
   * API Reference</a></p>
   */
  class AssessmentRiskRecommendation
  {
  public:
    AWS_RESILIENCEHUB_API AssessmentRiskRecommendation();
    AWS_RESILIENCEHUB_API AssessmentRiskRecommendation(Aws::Utils::Json::JsonView jsonValue);
    AWS_RESILIENCEHUB_API AssessmentRiskRecommendation& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_RESILIENCEHUB_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Indicates the Application Components (AppComponents) that were assessed as
     * part of the assessment and are associated with the identified risk and
     * recommendation.</p>  <p>This property is available only in the US East (N.
     * Virginia) Region.</p> 
     */
    inline const Aws::Vector<Aws::String>& GetAppComponents() const{ return m_appComponents; }
    inline bool AppComponentsHasBeenSet() const { return m_appComponentsHasBeenSet; }
    inline void SetAppComponents(const Aws::Vector<Aws::String>& value) { m_appComponentsHasBeenSet = true; m_appComponents = value; }
    inline void SetAppComponents(Aws::Vector<Aws::String>&& value) { m_appComponentsHasBeenSet = true; m_appComponents = std::move(value); }
    inline AssessmentRiskRecommendation& WithAppComponents(const Aws::Vector<Aws::String>& value) { SetAppComponents(value); return *this;}
    inline AssessmentRiskRecommendation& WithAppComponents(Aws::Vector<Aws::String>&& value) { SetAppComponents(std::move(value)); return *this;}
    inline AssessmentRiskRecommendation& AddAppComponents(const Aws::String& value) { m_appComponentsHasBeenSet = true; m_appComponents.push_back(value); return *this; }
    inline AssessmentRiskRecommendation& AddAppComponents(Aws::String&& value) { m_appComponentsHasBeenSet = true; m_appComponents.push_back(std::move(value)); return *this; }
    inline AssessmentRiskRecommendation& AddAppComponents(const char* value) { m_appComponentsHasBeenSet = true; m_appComponents.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>Indicates the recommendation provided by the Resilience Hub to address the
     * identified risks in the application.</p>  <p>This property is available
     * only in the US East (N. Virginia) Region.</p> 
     */
    inline const Aws::String& GetRecommendation() const{ return m_recommendation; }
    inline bool RecommendationHasBeenSet() const { return m_recommendationHasBeenSet; }
    inline void SetRecommendation(const Aws::String& value) { m_recommendationHasBeenSet = true; m_recommendation = value; }
    inline void SetRecommendation(Aws::String&& value) { m_recommendationHasBeenSet = true; m_recommendation = std::move(value); }
    inline void SetRecommendation(const char* value) { m_recommendationHasBeenSet = true; m_recommendation.assign(value); }
    inline AssessmentRiskRecommendation& WithRecommendation(const Aws::String& value) { SetRecommendation(value); return *this;}
    inline AssessmentRiskRecommendation& WithRecommendation(Aws::String&& value) { SetRecommendation(std::move(value)); return *this;}
    inline AssessmentRiskRecommendation& WithRecommendation(const char* value) { SetRecommendation(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Indicates the description of the potential risk identified in the application
     * as part of the Resilience Hub assessment.</p>  <p>This property is
     * available only in the US East (N. Virginia) Region.</p> 
     */
    inline const Aws::String& GetRisk() const{ return m_risk; }
    inline bool RiskHasBeenSet() const { return m_riskHasBeenSet; }
    inline void SetRisk(const Aws::String& value) { m_riskHasBeenSet = true; m_risk = value; }
    inline void SetRisk(Aws::String&& value) { m_riskHasBeenSet = true; m_risk = std::move(value); }
    inline void SetRisk(const char* value) { m_riskHasBeenSet = true; m_risk.assign(value); }
    inline AssessmentRiskRecommendation& WithRisk(const Aws::String& value) { SetRisk(value); return *this;}
    inline AssessmentRiskRecommendation& WithRisk(Aws::String&& value) { SetRisk(std::move(value)); return *this;}
    inline AssessmentRiskRecommendation& WithRisk(const char* value) { SetRisk(value); return *this;}
    ///@}
  private:

    Aws::Vector<Aws::String> m_appComponents;
    bool m_appComponentsHasBeenSet = false;

    Aws::String m_recommendation;
    bool m_recommendationHasBeenSet = false;

    Aws::String m_risk;
    bool m_riskHasBeenSet = false;
  };

} // namespace Model
} // namespace ResilienceHub
} // namespace Aws
