﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/resiliencehub/ResilienceHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/resiliencehub/model/AssessmentStatus.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace ResilienceHub
{
namespace Model
{
  class DeleteAppAssessmentResult
  {
  public:
    AWS_RESILIENCEHUB_API DeleteAppAssessmentResult();
    AWS_RESILIENCEHUB_API DeleteAppAssessmentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_RESILIENCEHUB_API DeleteAppAssessmentResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
     * arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>.
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General
     * Reference</i> guide.</p>
     */
    inline const Aws::String& GetAssessmentArn() const{ return m_assessmentArn; }
    inline void SetAssessmentArn(const Aws::String& value) { m_assessmentArn = value; }
    inline void SetAssessmentArn(Aws::String&& value) { m_assessmentArn = std::move(value); }
    inline void SetAssessmentArn(const char* value) { m_assessmentArn.assign(value); }
    inline DeleteAppAssessmentResult& WithAssessmentArn(const Aws::String& value) { SetAssessmentArn(value); return *this;}
    inline DeleteAppAssessmentResult& WithAssessmentArn(Aws::String&& value) { SetAssessmentArn(std::move(value)); return *this;}
    inline DeleteAppAssessmentResult& WithAssessmentArn(const char* value) { SetAssessmentArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The current status of the assessment for the resiliency policy.</p>
     */
    inline const AssessmentStatus& GetAssessmentStatus() const{ return m_assessmentStatus; }
    inline void SetAssessmentStatus(const AssessmentStatus& value) { m_assessmentStatus = value; }
    inline void SetAssessmentStatus(AssessmentStatus&& value) { m_assessmentStatus = std::move(value); }
    inline DeleteAppAssessmentResult& WithAssessmentStatus(const AssessmentStatus& value) { SetAssessmentStatus(value); return *this;}
    inline DeleteAppAssessmentResult& WithAssessmentStatus(AssessmentStatus&& value) { SetAssessmentStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DeleteAppAssessmentResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DeleteAppAssessmentResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DeleteAppAssessmentResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_assessmentArn;

    AssessmentStatus m_assessmentStatus;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace ResilienceHub
} // namespace Aws
