﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SageMaker
{
namespace Model
{

  /**
   * <p>Metadata properties of the tracking entity, trial, or trial
   * component.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/MetadataProperties">AWS
   * API Reference</a></p>
   */
  class MetadataProperties
  {
  public:
    AWS_SAGEMAKER_API MetadataProperties();
    AWS_SAGEMAKER_API MetadataProperties(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKER_API MetadataProperties& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The commit ID.</p>
     */
    inline const Aws::String& GetCommitId() const{ return m_commitId; }
    inline bool CommitIdHasBeenSet() const { return m_commitIdHasBeenSet; }
    inline void SetCommitId(const Aws::String& value) { m_commitIdHasBeenSet = true; m_commitId = value; }
    inline void SetCommitId(Aws::String&& value) { m_commitIdHasBeenSet = true; m_commitId = std::move(value); }
    inline void SetCommitId(const char* value) { m_commitIdHasBeenSet = true; m_commitId.assign(value); }
    inline MetadataProperties& WithCommitId(const Aws::String& value) { SetCommitId(value); return *this;}
    inline MetadataProperties& WithCommitId(Aws::String&& value) { SetCommitId(std::move(value)); return *this;}
    inline MetadataProperties& WithCommitId(const char* value) { SetCommitId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The repository.</p>
     */
    inline const Aws::String& GetRepository() const{ return m_repository; }
    inline bool RepositoryHasBeenSet() const { return m_repositoryHasBeenSet; }
    inline void SetRepository(const Aws::String& value) { m_repositoryHasBeenSet = true; m_repository = value; }
    inline void SetRepository(Aws::String&& value) { m_repositoryHasBeenSet = true; m_repository = std::move(value); }
    inline void SetRepository(const char* value) { m_repositoryHasBeenSet = true; m_repository.assign(value); }
    inline MetadataProperties& WithRepository(const Aws::String& value) { SetRepository(value); return *this;}
    inline MetadataProperties& WithRepository(Aws::String&& value) { SetRepository(std::move(value)); return *this;}
    inline MetadataProperties& WithRepository(const char* value) { SetRepository(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The entity this entity was generated by.</p>
     */
    inline const Aws::String& GetGeneratedBy() const{ return m_generatedBy; }
    inline bool GeneratedByHasBeenSet() const { return m_generatedByHasBeenSet; }
    inline void SetGeneratedBy(const Aws::String& value) { m_generatedByHasBeenSet = true; m_generatedBy = value; }
    inline void SetGeneratedBy(Aws::String&& value) { m_generatedByHasBeenSet = true; m_generatedBy = std::move(value); }
    inline void SetGeneratedBy(const char* value) { m_generatedByHasBeenSet = true; m_generatedBy.assign(value); }
    inline MetadataProperties& WithGeneratedBy(const Aws::String& value) { SetGeneratedBy(value); return *this;}
    inline MetadataProperties& WithGeneratedBy(Aws::String&& value) { SetGeneratedBy(std::move(value)); return *this;}
    inline MetadataProperties& WithGeneratedBy(const char* value) { SetGeneratedBy(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The project ID.</p>
     */
    inline const Aws::String& GetProjectId() const{ return m_projectId; }
    inline bool ProjectIdHasBeenSet() const { return m_projectIdHasBeenSet; }
    inline void SetProjectId(const Aws::String& value) { m_projectIdHasBeenSet = true; m_projectId = value; }
    inline void SetProjectId(Aws::String&& value) { m_projectIdHasBeenSet = true; m_projectId = std::move(value); }
    inline void SetProjectId(const char* value) { m_projectIdHasBeenSet = true; m_projectId.assign(value); }
    inline MetadataProperties& WithProjectId(const Aws::String& value) { SetProjectId(value); return *this;}
    inline MetadataProperties& WithProjectId(Aws::String&& value) { SetProjectId(std::move(value)); return *this;}
    inline MetadataProperties& WithProjectId(const char* value) { SetProjectId(value); return *this;}
    ///@}
  private:

    Aws::String m_commitId;
    bool m_commitIdHasBeenSet = false;

    Aws::String m_repository;
    bool m_repositoryHasBeenSet = false;

    Aws::String m_generatedBy;
    bool m_generatedByHasBeenSet = false;

    Aws::String m_projectId;
    bool m_projectIdHasBeenSet = false;
  };

} // namespace Model
} // namespace SageMaker
} // namespace Aws
