﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/model/VulnerabilityVendor.h>
#include <aws/securityhub/model/VulnerabilityFixAvailable.h>
#include <aws/securityhub/model/VulnerabilityExploitAvailable.h>
#include <aws/securityhub/model/SoftwarePackage.h>
#include <aws/securityhub/model/Cvss.h>
#include <aws/securityhub/model/VulnerabilityCodeVulnerabilities.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>A vulnerability associated with a finding.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Vulnerability">AWS
   * API Reference</a></p>
   */
  class Vulnerability
  {
  public:
    AWS_SECURITYHUB_API Vulnerability();
    AWS_SECURITYHUB_API Vulnerability(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API Vulnerability& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The identifier of the vulnerability.</p>
     */
    inline const Aws::String& GetId() const{ return m_id; }
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
    inline void SetId(const Aws::String& value) { m_idHasBeenSet = true; m_id = value; }
    inline void SetId(Aws::String&& value) { m_idHasBeenSet = true; m_id = std::move(value); }
    inline void SetId(const char* value) { m_idHasBeenSet = true; m_id.assign(value); }
    inline Vulnerability& WithId(const Aws::String& value) { SetId(value); return *this;}
    inline Vulnerability& WithId(Aws::String&& value) { SetId(std::move(value)); return *this;}
    inline Vulnerability& WithId(const char* value) { SetId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>List of software packages that have the vulnerability.</p>
     */
    inline const Aws::Vector<SoftwarePackage>& GetVulnerablePackages() const{ return m_vulnerablePackages; }
    inline bool VulnerablePackagesHasBeenSet() const { return m_vulnerablePackagesHasBeenSet; }
    inline void SetVulnerablePackages(const Aws::Vector<SoftwarePackage>& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages = value; }
    inline void SetVulnerablePackages(Aws::Vector<SoftwarePackage>&& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages = std::move(value); }
    inline Vulnerability& WithVulnerablePackages(const Aws::Vector<SoftwarePackage>& value) { SetVulnerablePackages(value); return *this;}
    inline Vulnerability& WithVulnerablePackages(Aws::Vector<SoftwarePackage>&& value) { SetVulnerablePackages(std::move(value)); return *this;}
    inline Vulnerability& AddVulnerablePackages(const SoftwarePackage& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages.push_back(value); return *this; }
    inline Vulnerability& AddVulnerablePackages(SoftwarePackage&& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>CVSS scores from the advisory related to the vulnerability.</p>
     */
    inline const Aws::Vector<Cvss>& GetCvss() const{ return m_cvss; }
    inline bool CvssHasBeenSet() const { return m_cvssHasBeenSet; }
    inline void SetCvss(const Aws::Vector<Cvss>& value) { m_cvssHasBeenSet = true; m_cvss = value; }
    inline void SetCvss(Aws::Vector<Cvss>&& value) { m_cvssHasBeenSet = true; m_cvss = std::move(value); }
    inline Vulnerability& WithCvss(const Aws::Vector<Cvss>& value) { SetCvss(value); return *this;}
    inline Vulnerability& WithCvss(Aws::Vector<Cvss>&& value) { SetCvss(std::move(value)); return *this;}
    inline Vulnerability& AddCvss(const Cvss& value) { m_cvssHasBeenSet = true; m_cvss.push_back(value); return *this; }
    inline Vulnerability& AddCvss(Cvss&& value) { m_cvssHasBeenSet = true; m_cvss.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>List of vulnerabilities that are related to this vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetRelatedVulnerabilities() const{ return m_relatedVulnerabilities; }
    inline bool RelatedVulnerabilitiesHasBeenSet() const { return m_relatedVulnerabilitiesHasBeenSet; }
    inline void SetRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = value; }
    inline void SetRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = std::move(value); }
    inline Vulnerability& WithRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { SetRelatedVulnerabilities(value); return *this;}
    inline Vulnerability& WithRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { SetRelatedVulnerabilities(std::move(value)); return *this;}
    inline Vulnerability& AddRelatedVulnerabilities(const Aws::String& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }
    inline Vulnerability& AddRelatedVulnerabilities(Aws::String&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(std::move(value)); return *this; }
    inline Vulnerability& AddRelatedVulnerabilities(const char* value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>Information about the vendor that generates the vulnerability report.</p>
     */
    inline const VulnerabilityVendor& GetVendor() const{ return m_vendor; }
    inline bool VendorHasBeenSet() const { return m_vendorHasBeenSet; }
    inline void SetVendor(const VulnerabilityVendor& value) { m_vendorHasBeenSet = true; m_vendor = value; }
    inline void SetVendor(VulnerabilityVendor&& value) { m_vendorHasBeenSet = true; m_vendor = std::move(value); }
    inline Vulnerability& WithVendor(const VulnerabilityVendor& value) { SetVendor(value); return *this;}
    inline Vulnerability& WithVendor(VulnerabilityVendor&& value) { SetVendor(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A list of URLs that provide additional information about the
     * vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const{ return m_referenceUrls; }
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }
    inline void SetReferenceUrls(const Aws::Vector<Aws::String>& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = value; }
    inline void SetReferenceUrls(Aws::Vector<Aws::String>&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::move(value); }
    inline Vulnerability& WithReferenceUrls(const Aws::Vector<Aws::String>& value) { SetReferenceUrls(value); return *this;}
    inline Vulnerability& WithReferenceUrls(Aws::Vector<Aws::String>&& value) { SetReferenceUrls(std::move(value)); return *this;}
    inline Vulnerability& AddReferenceUrls(const Aws::String& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }
    inline Vulnerability& AddReferenceUrls(Aws::String&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(std::move(value)); return *this; }
    inline Vulnerability& AddReferenceUrls(const char* value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>Specifies if all vulnerable packages in a finding have a value for
     * <code>FixedInVersion</code> and <code>Remediation</code>. This field is
     * evaluated for each vulnerability <code>Id</code> based on the number of
     * vulnerable packages that have a value for both <code>FixedInVersion</code> and
     * <code>Remediation</code>. Valid values are as follows:</p> <ul> <li> <p>
     * <code>YES</code> if all vulnerable packages have a value for both
     * <code>FixedInVersion</code> and <code>Remediation</code> </p> </li> <li> <p>
     * <code>NO</code> if no vulnerable packages have a value for
     * <code>FixedInVersion</code> and <code>Remediation</code> </p> </li> <li> <p>
     * <code>PARTIAL</code> otherwise</p> </li> </ul>
     */
    inline const VulnerabilityFixAvailable& GetFixAvailable() const{ return m_fixAvailable; }
    inline bool FixAvailableHasBeenSet() const { return m_fixAvailableHasBeenSet; }
    inline void SetFixAvailable(const VulnerabilityFixAvailable& value) { m_fixAvailableHasBeenSet = true; m_fixAvailable = value; }
    inline void SetFixAvailable(VulnerabilityFixAvailable&& value) { m_fixAvailableHasBeenSet = true; m_fixAvailable = std::move(value); }
    inline Vulnerability& WithFixAvailable(const VulnerabilityFixAvailable& value) { SetFixAvailable(value); return *this;}
    inline Vulnerability& WithFixAvailable(VulnerabilityFixAvailable&& value) { SetFixAvailable(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Exploit Prediction Scoring System (EPSS) score for a finding. </p>
     */
    inline double GetEpssScore() const{ return m_epssScore; }
    inline bool EpssScoreHasBeenSet() const { return m_epssScoreHasBeenSet; }
    inline void SetEpssScore(double value) { m_epssScoreHasBeenSet = true; m_epssScore = value; }
    inline Vulnerability& WithEpssScore(double value) { SetEpssScore(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Whether an exploit is available for a finding. </p>
     */
    inline const VulnerabilityExploitAvailable& GetExploitAvailable() const{ return m_exploitAvailable; }
    inline bool ExploitAvailableHasBeenSet() const { return m_exploitAvailableHasBeenSet; }
    inline void SetExploitAvailable(const VulnerabilityExploitAvailable& value) { m_exploitAvailableHasBeenSet = true; m_exploitAvailable = value; }
    inline void SetExploitAvailable(VulnerabilityExploitAvailable&& value) { m_exploitAvailableHasBeenSet = true; m_exploitAvailable = std::move(value); }
    inline Vulnerability& WithExploitAvailable(const VulnerabilityExploitAvailable& value) { SetExploitAvailable(value); return *this;}
    inline Vulnerability& WithExploitAvailable(VulnerabilityExploitAvailable&& value) { SetExploitAvailable(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p> The date and time of the last exploit associated with a finding discovered
     * in your environment. </p>
     */
    inline const Aws::String& GetLastKnownExploitAt() const{ return m_lastKnownExploitAt; }
    inline bool LastKnownExploitAtHasBeenSet() const { return m_lastKnownExploitAtHasBeenSet; }
    inline void SetLastKnownExploitAt(const Aws::String& value) { m_lastKnownExploitAtHasBeenSet = true; m_lastKnownExploitAt = value; }
    inline void SetLastKnownExploitAt(Aws::String&& value) { m_lastKnownExploitAtHasBeenSet = true; m_lastKnownExploitAt = std::move(value); }
    inline void SetLastKnownExploitAt(const char* value) { m_lastKnownExploitAtHasBeenSet = true; m_lastKnownExploitAt.assign(value); }
    inline Vulnerability& WithLastKnownExploitAt(const Aws::String& value) { SetLastKnownExploitAt(value); return *this;}
    inline Vulnerability& WithLastKnownExploitAt(Aws::String&& value) { SetLastKnownExploitAt(std::move(value)); return *this;}
    inline Vulnerability& WithLastKnownExploitAt(const char* value) { SetLastKnownExploitAt(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The vulnerabilities found in your Lambda function code. This field pertains
     * to findings that Security Hub receives from Amazon Inspector. </p>
     */
    inline const Aws::Vector<VulnerabilityCodeVulnerabilities>& GetCodeVulnerabilities() const{ return m_codeVulnerabilities; }
    inline bool CodeVulnerabilitiesHasBeenSet() const { return m_codeVulnerabilitiesHasBeenSet; }
    inline void SetCodeVulnerabilities(const Aws::Vector<VulnerabilityCodeVulnerabilities>& value) { m_codeVulnerabilitiesHasBeenSet = true; m_codeVulnerabilities = value; }
    inline void SetCodeVulnerabilities(Aws::Vector<VulnerabilityCodeVulnerabilities>&& value) { m_codeVulnerabilitiesHasBeenSet = true; m_codeVulnerabilities = std::move(value); }
    inline Vulnerability& WithCodeVulnerabilities(const Aws::Vector<VulnerabilityCodeVulnerabilities>& value) { SetCodeVulnerabilities(value); return *this;}
    inline Vulnerability& WithCodeVulnerabilities(Aws::Vector<VulnerabilityCodeVulnerabilities>&& value) { SetCodeVulnerabilities(std::move(value)); return *this;}
    inline Vulnerability& AddCodeVulnerabilities(const VulnerabilityCodeVulnerabilities& value) { m_codeVulnerabilitiesHasBeenSet = true; m_codeVulnerabilities.push_back(value); return *this; }
    inline Vulnerability& AddCodeVulnerabilities(VulnerabilityCodeVulnerabilities&& value) { m_codeVulnerabilitiesHasBeenSet = true; m_codeVulnerabilities.push_back(std::move(value)); return *this; }
    ///@}
  private:

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::Vector<SoftwarePackage> m_vulnerablePackages;
    bool m_vulnerablePackagesHasBeenSet = false;

    Aws::Vector<Cvss> m_cvss;
    bool m_cvssHasBeenSet = false;

    Aws::Vector<Aws::String> m_relatedVulnerabilities;
    bool m_relatedVulnerabilitiesHasBeenSet = false;

    VulnerabilityVendor m_vendor;
    bool m_vendorHasBeenSet = false;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet = false;

    VulnerabilityFixAvailable m_fixAvailable;
    bool m_fixAvailableHasBeenSet = false;

    double m_epssScore;
    bool m_epssScoreHasBeenSet = false;

    VulnerabilityExploitAvailable m_exploitAvailable;
    bool m_exploitAvailableHasBeenSet = false;

    Aws::String m_lastKnownExploitAt;
    bool m_lastKnownExploitAtHasBeenSet = false;

    Aws::Vector<VulnerabilityCodeVulnerabilities> m_codeVulnerabilities;
    bool m_codeVulnerabilitiesHasBeenSet = false;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
