﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/model/CodeVulnerabilitiesFilePath.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>Provides details about the vulnerabilities found in your Lambda function
   * code. This field pertains to findings that Security Hub receives from Amazon
   * Inspector. </p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/VulnerabilityCodeVulnerabilities">AWS
   * API Reference</a></p>
   */
  class VulnerabilityCodeVulnerabilities
  {
  public:
    AWS_SECURITYHUB_API VulnerabilityCodeVulnerabilities();
    AWS_SECURITYHUB_API VulnerabilityCodeVulnerabilities(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API VulnerabilityCodeVulnerabilities& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p> The Common Weakness Enumeration (CWE) item associated with the detected code
     * vulnerability. </p>
     */
    inline const Aws::Vector<Aws::String>& GetCwes() const{ return m_cwes; }
    inline bool CwesHasBeenSet() const { return m_cwesHasBeenSet; }
    inline void SetCwes(const Aws::Vector<Aws::String>& value) { m_cwesHasBeenSet = true; m_cwes = value; }
    inline void SetCwes(Aws::Vector<Aws::String>&& value) { m_cwesHasBeenSet = true; m_cwes = std::move(value); }
    inline VulnerabilityCodeVulnerabilities& WithCwes(const Aws::Vector<Aws::String>& value) { SetCwes(value); return *this;}
    inline VulnerabilityCodeVulnerabilities& WithCwes(Aws::Vector<Aws::String>&& value) { SetCwes(std::move(value)); return *this;}
    inline VulnerabilityCodeVulnerabilities& AddCwes(const Aws::String& value) { m_cwesHasBeenSet = true; m_cwes.push_back(value); return *this; }
    inline VulnerabilityCodeVulnerabilities& AddCwes(Aws::String&& value) { m_cwesHasBeenSet = true; m_cwes.push_back(std::move(value)); return *this; }
    inline VulnerabilityCodeVulnerabilities& AddCwes(const char* value) { m_cwesHasBeenSet = true; m_cwes.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p> Provides details about where a code vulnerability is located in your Lambda
     * function. </p>
     */
    inline const CodeVulnerabilitiesFilePath& GetFilePath() const{ return m_filePath; }
    inline bool FilePathHasBeenSet() const { return m_filePathHasBeenSet; }
    inline void SetFilePath(const CodeVulnerabilitiesFilePath& value) { m_filePathHasBeenSet = true; m_filePath = value; }
    inline void SetFilePath(CodeVulnerabilitiesFilePath&& value) { m_filePathHasBeenSet = true; m_filePath = std::move(value); }
    inline VulnerabilityCodeVulnerabilities& WithFilePath(const CodeVulnerabilitiesFilePath& value) { SetFilePath(value); return *this;}
    inline VulnerabilityCodeVulnerabilities& WithFilePath(CodeVulnerabilitiesFilePath&& value) { SetFilePath(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p> The Amazon Resource Name (ARN) of the Lambda layer in which the code
     * vulnerability is located. </p>
     */
    inline const Aws::String& GetSourceArn() const{ return m_sourceArn; }
    inline bool SourceArnHasBeenSet() const { return m_sourceArnHasBeenSet; }
    inline void SetSourceArn(const Aws::String& value) { m_sourceArnHasBeenSet = true; m_sourceArn = value; }
    inline void SetSourceArn(Aws::String&& value) { m_sourceArnHasBeenSet = true; m_sourceArn = std::move(value); }
    inline void SetSourceArn(const char* value) { m_sourceArnHasBeenSet = true; m_sourceArn.assign(value); }
    inline VulnerabilityCodeVulnerabilities& WithSourceArn(const Aws::String& value) { SetSourceArn(value); return *this;}
    inline VulnerabilityCodeVulnerabilities& WithSourceArn(Aws::String&& value) { SetSourceArn(std::move(value)); return *this;}
    inline VulnerabilityCodeVulnerabilities& WithSourceArn(const char* value) { SetSourceArn(value); return *this;}
    ///@}
  private:

    Aws::Vector<Aws::String> m_cwes;
    bool m_cwesHasBeenSet = false;

    CodeVulnerabilitiesFilePath m_filePath;
    bool m_filePathHasBeenSet = false;

    Aws::String m_sourceArn;
    bool m_sourceArnHasBeenSet = false;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
