﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/sso-admin/SSOAdmin_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SSOAdmin
{
namespace Model
{

  /**
   * <p>A structure that describes a trusted token issuer and associates it with a
   * set of authorized audiences.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AuthorizedTokenIssuer">AWS
   * API Reference</a></p>
   */
  class AuthorizedTokenIssuer
  {
  public:
    AWS_SSOADMIN_API AuthorizedTokenIssuer();
    AWS_SSOADMIN_API AuthorizedTokenIssuer(Aws::Utils::Json::JsonView jsonValue);
    AWS_SSOADMIN_API AuthorizedTokenIssuer& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SSOADMIN_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>An array list of authorized audiences, or applications, that can consume the
     * tokens generated by the associated trusted token issuer.</p>
     */
    inline const Aws::Vector<Aws::String>& GetAuthorizedAudiences() const{ return m_authorizedAudiences; }
    inline bool AuthorizedAudiencesHasBeenSet() const { return m_authorizedAudiencesHasBeenSet; }
    inline void SetAuthorizedAudiences(const Aws::Vector<Aws::String>& value) { m_authorizedAudiencesHasBeenSet = true; m_authorizedAudiences = value; }
    inline void SetAuthorizedAudiences(Aws::Vector<Aws::String>&& value) { m_authorizedAudiencesHasBeenSet = true; m_authorizedAudiences = std::move(value); }
    inline AuthorizedTokenIssuer& WithAuthorizedAudiences(const Aws::Vector<Aws::String>& value) { SetAuthorizedAudiences(value); return *this;}
    inline AuthorizedTokenIssuer& WithAuthorizedAudiences(Aws::Vector<Aws::String>&& value) { SetAuthorizedAudiences(std::move(value)); return *this;}
    inline AuthorizedTokenIssuer& AddAuthorizedAudiences(const Aws::String& value) { m_authorizedAudiencesHasBeenSet = true; m_authorizedAudiences.push_back(value); return *this; }
    inline AuthorizedTokenIssuer& AddAuthorizedAudiences(Aws::String&& value) { m_authorizedAudiencesHasBeenSet = true; m_authorizedAudiences.push_back(std::move(value)); return *this; }
    inline AuthorizedTokenIssuer& AddAuthorizedAudiences(const char* value) { m_authorizedAudiencesHasBeenSet = true; m_authorizedAudiences.push_back(value); return *this; }
    ///@}

    ///@{
    /**
     * <p>The ARN of the trusted token issuer.</p>
     */
    inline const Aws::String& GetTrustedTokenIssuerArn() const{ return m_trustedTokenIssuerArn; }
    inline bool TrustedTokenIssuerArnHasBeenSet() const { return m_trustedTokenIssuerArnHasBeenSet; }
    inline void SetTrustedTokenIssuerArn(const Aws::String& value) { m_trustedTokenIssuerArnHasBeenSet = true; m_trustedTokenIssuerArn = value; }
    inline void SetTrustedTokenIssuerArn(Aws::String&& value) { m_trustedTokenIssuerArnHasBeenSet = true; m_trustedTokenIssuerArn = std::move(value); }
    inline void SetTrustedTokenIssuerArn(const char* value) { m_trustedTokenIssuerArnHasBeenSet = true; m_trustedTokenIssuerArn.assign(value); }
    inline AuthorizedTokenIssuer& WithTrustedTokenIssuerArn(const Aws::String& value) { SetTrustedTokenIssuerArn(value); return *this;}
    inline AuthorizedTokenIssuer& WithTrustedTokenIssuerArn(Aws::String&& value) { SetTrustedTokenIssuerArn(std::move(value)); return *this;}
    inline AuthorizedTokenIssuer& WithTrustedTokenIssuerArn(const char* value) { SetTrustedTokenIssuerArn(value); return *this;}
    ///@}
  private:

    Aws::Vector<Aws::String> m_authorizedAudiences;
    bool m_authorizedAudiencesHasBeenSet = false;

    Aws::String m_trustedTokenIssuerArn;
    bool m_trustedTokenIssuerArnHasBeenSet = false;
  };

} // namespace Model
} // namespace SSOAdmin
} // namespace Aws
