/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class SuperInvocationMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private boolean invokesSuperMethods;

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -73) {
            this.invokesSuperMethods = false;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            if (this.invokesSuperMethods) {
                SuperInvocationMarker.setInvokesSuperMethods(method);
            }
        }
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        this.invokesSuperMethods = !clazz.equals(refConstant.referencedClass) && !refConstant.getName(clazz).equals("<init>");
    }

    private static void setInvokesSuperMethods(Method method) {
        ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).setInvokesSuperMethods();
    }

    public static boolean invokesSuperMethods(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).invokesSuperMethods();
    }
}

