
# 13 "plugins/ltac/g_rewrite.mlg"
 

open Names
open Locus
open Constrexpr
open Glob_term
open Genintern
open Geninterp
open Extraargs
open Rewrite
open ComRewrite
open Stdarg
open Tactypes
open Pcoq.Prim
open Pcoq.Constr
open Pvernac.Vernac_
open Pltac
open Vernacextend



let _ = Mltop.add_known_module "coq-core.plugins.ltac"

# 36 "plugins/ltac/g_rewrite.mlg"
 

type constr_expr_with_bindings = constr_expr with_bindings
type glob_constr_with_bindings = glob_constr_and_expr with_bindings
type glob_constr_with_bindings_sign = interp_sign * glob_constr_and_expr with_bindings

let pr_glob_constr_with_bindings_sign env sigma _ _ _ (ge : glob_constr_with_bindings_sign) =
  Printer.pr_glob_constr_env env sigma (fst (fst (snd ge)))
let pr_glob_constr_with_bindings env sigma _ _ _ (ge : glob_constr_with_bindings) =
  Printer.pr_glob_constr_env env sigma (fst (fst ge))
let pr_constr_expr_with_bindings env sigma prc _ _ (ge : constr_expr_with_bindings) = prc env sigma (fst ge)
let interp_glob_constr_with_bindings ist _ _ c = (ist, c)
let glob_glob_constr_with_bindings ist l = Tacintern.intern_constr_with_bindings ist l
let subst_glob_constr_with_bindings s c =
  Tacsubst.subst_glob_with_bindings s c



let (wit_glob_constr_with_bindings, glob_constr_with_bindings) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ltac" ~name:"glob_constr_with_bindings" 
                                                                 {
                                                                 Tacentries.arg_parsing = 
                                                                 Vernacextend.Arg_alias (constr_with_bindings);
                                                                 Tacentries.arg_tag = 
                                                                 None;
                                                                 Tacentries.arg_intern = 
                                                                 Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                                 
# 58 "plugins/ltac/g_rewrite.mlg"
                    glob_glob_constr_with_bindings 
                                                                 ));
                                                                 Tacentries.arg_subst = 
                                                                 Tacentries.ArgSubstFun (
                                                                 
# 59 "plugins/ltac/g_rewrite.mlg"
                     subst_glob_constr_with_bindings 
                                                                 );
                                                                 Tacentries.arg_interp = 
                                                                 Tacentries.ArgInterpSimple (
                                                                 
# 57 "plugins/ltac/g_rewrite.mlg"
                     interp_glob_constr_with_bindings 
                                                                 );
                                                                 Tacentries.arg_printer = 
                                                                 ((fun env sigma -> 
                                                                 
# 61 "plugins/ltac/g_rewrite.mlg"
                     pr_constr_expr_with_bindings env sigma 
                                                                 ), (fun env sigma -> 
                                                                 
# 62 "plugins/ltac/g_rewrite.mlg"
                      pr_glob_constr_with_bindings env sigma 
                                                                 ), (fun env sigma -> 
                                                                 
# 55 "plugins/ltac/g_rewrite.mlg"
                 pr_glob_constr_with_bindings_sign env sigma 
                                                                 ));
                                                                 }
let _ = (wit_glob_constr_with_bindings, glob_constr_with_bindings)


# 67 "plugins/ltac/g_rewrite.mlg"
 

let subst_strategy sub = map_strategy
    (Tacsubst.subst_glob_constr_and_expr sub)
    (Tacsubst.subst_glob_red_expr sub)
    (fun x -> x)

let pr_strategy _ _ _ (s : strategy) = Pp.str "<strategy>"
let pr_raw_strategy env sigma prc prlc _ (s : Tacexpr.raw_strategy) =
  let prr = Pptactic.pr_red_expr env sigma (prc, prlc, Pputils.pr_or_by_notation Libnames.pr_qualid, prc,Pputils.pr_or_var Pp.int) in
  Rewrite.pr_strategy (prc env sigma) prr Pputils.pr_lident s
let pr_glob_strategy env sigma prc prlc _ (s : Tacexpr.glob_strategy) =
  let prcst = Pputils.pr_or_var Pptactic.(pr_and_short_name (pr_evaluable_reference_env env)) in
  let prr = Pptactic.pr_red_expr env sigma (prc, prlc, prcst, prc, Pputils.pr_or_var Pp.int) in
  Rewrite.pr_strategy (prc env sigma) prr Id.print s



let (wit_rewstrategy, rewstrategy) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ltac" ~name:"rewstrategy" 
                                     {
                                     Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                              []);
                                     Tacentries.arg_tag = None;
                                     Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                             
# 89 "plugins/ltac/g_rewrite.mlg"
                    Tacintern.intern_strategy 
                                                             ));
                                     Tacentries.arg_subst = Tacentries.ArgSubstFun (
                                                            
# 90 "plugins/ltac/g_rewrite.mlg"
                     subst_strategy 
                                                            );
                                     Tacentries.arg_interp = Tacentries.ArgInterpSimple (
                                                             
# 88 "plugins/ltac/g_rewrite.mlg"
                     Tacinterp.interp_strategy 
                                                             );
                                     Tacentries.arg_printer = ((fun env sigma -> 
                                                              
# 92 "plugins/ltac/g_rewrite.mlg"
                     pr_raw_strategy env sigma 
                                                              ), (fun env sigma -> 
                                                              
# 93 "plugins/ltac/g_rewrite.mlg"
                      pr_glob_strategy env sigma 
                                                              ), (fun env sigma -> 
                                                              
# 86 "plugins/ltac/g_rewrite.mlg"
                 pr_strategy 
                                                              ));
                                     }
let _ = (wit_rewstrategy, rewstrategy)

let _ = let ne_rewstrategy1_list_sep_semicolon =
          Pcoq.Entry.make "ne_rewstrategy1_list_sep_semicolon"
        and rewstrategy1 = Pcoq.Entry.make "rewstrategy1"
        and rewstrategy0 = Pcoq.Entry.make "rewstrategy0"
        in
        let () = assert (Pcoq.Entry.is_empty rewstrategy) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac", "g_rewrite.mlg:0")
        rewstrategy
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, Some (Gramlib.Gramext.NonA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ne_rewstrategy1_list_sep_semicolon)))
                                  (fun h loc -> 
# 101 "plugins/ltac/g_rewrite.mlg"
                                                    h 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("fix"))))))
                                                                 ((Pcoq.Symbol.nterm identref)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                 ((Pcoq.Symbol.nterm rewstrategy1)))
                                 (fun s _ id _ loc -> 
# 100 "plugins/ltac/g_rewrite.mlg"
                                                                StratFix (id, s) 
                                                      )])]))
        in let () =
        assert (Pcoq.Entry.is_empty ne_rewstrategy1_list_sep_semicolon)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac", "g_rewrite.mlg:1")
        ne_rewstrategy1_list_sep_semicolon
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, Some (Gramlib.Gramext.LeftA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm rewstrategy1)))
                                  (fun h loc -> 
# 106 "plugins/ltac/g_rewrite.mlg"
                              h 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 (Pcoq.Symbol.self))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                 ((Pcoq.Symbol.nterm rewstrategy1)))
                                 (fun h' _ h loc -> 
# 105 "plugins/ltac/g_rewrite.mlg"
                                              StratBinary (Compose, h, h') 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty rewstrategy1) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac", "g_rewrite.mlg:2")
        rewstrategy1
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, Some (Gramlib.Gramext.RightA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm rewstrategy0)))
                                  (fun h loc -> 
# 127 "plugins/ltac/g_rewrite.mlg"
                              h 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("fold"))))))
                                                 ((Pcoq.Symbol.nterm constr)))
                                 (fun c _ loc -> 
# 126 "plugins/ltac/g_rewrite.mlg"
                                      StratFold c 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("eval"))))))
                                                 ((Pcoq.Symbol.nterm red_expr)))
                                 (fun r _ loc -> 
# 125 "plugins/ltac/g_rewrite.mlg"
                                        StratEval r 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("terms"))))))
                                                 ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm constr))))
                                 (fun h _ loc -> 
# 124 "plugins/ltac/g_rewrite.mlg"
                                             StratTerms h 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("hints"))))))
                                                 ((Pcoq.Symbol.nterm preident)))
                                 (fun h _ loc -> 
# 123 "plugins/ltac/g_rewrite.mlg"
                                         StratHints (false, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("old_hints"))))))
                                                 ((Pcoq.Symbol.nterm preident)))
                                 (fun h _ loc -> 
# 122 "plugins/ltac/g_rewrite.mlg"
                                             StratHints (true, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("choice"))))))
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm rewstrategy0)))))
                                 (fun h _ loc -> 
# 121 "plugins/ltac/g_rewrite.mlg"
                                                    StratNAry (Choice, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("repeat"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 120 "plugins/ltac/g_rewrite.mlg"
                                      StratUnary (Repeat, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("any"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 119 "plugins/ltac/g_rewrite.mlg"
                                   StratUnary (Any, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("try"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 118 "plugins/ltac/g_rewrite.mlg"
                                   StratUnary (Try, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("progress"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 117 "plugins/ltac/g_rewrite.mlg"
                                        StratUnary (Progress, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("topdown"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 116 "plugins/ltac/g_rewrite.mlg"
                                       StratUnary(Topdown, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("bottomup"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 115 "plugins/ltac/g_rewrite.mlg"
                                        StratUnary(Bottomup, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("outermost"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 114 "plugins/ltac/g_rewrite.mlg"
                                         StratUnary(Outermost, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("innermost"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 113 "plugins/ltac/g_rewrite.mlg"
                                         StratUnary(Innermost, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("subterm"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 112 "plugins/ltac/g_rewrite.mlg"
                                       StratUnary (Subterm, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("subterms"))))))
                                                 (Pcoq.Symbol.self))
                                 (fun h _ loc -> 
# 111 "plugins/ltac/g_rewrite.mlg"
                                        StratUnary (Subterms, h) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("<-")))))
                                                 ((Pcoq.Symbol.nterm constr)))
                                 (fun c _ loc -> 
# 110 "plugins/ltac/g_rewrite.mlg"
                              StratConstr (c, false) 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty rewstrategy0) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac", "g_rewrite.mlg:3")
        rewstrategy0
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, Some (Gramlib.Gramext.NonA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.nterm rewstrategy)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ h _ loc -> 
# 135 "plugins/ltac/g_rewrite.mlg"
                                       h 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("refl"))))))
                                 (fun _ loc -> 
# 134 "plugins/ltac/g_rewrite.mlg"
                          StratRefl 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("fail"))))))
                                 (fun _ loc -> 
# 133 "plugins/ltac/g_rewrite.mlg"
                          StratFail 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("id"))))))
                                 (fun _ loc -> 
# 132 "plugins/ltac/g_rewrite.mlg"
                        StratId 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm constr)))
                                 (fun c loc -> 
# 131 "plugins/ltac/g_rewrite.mlg"
                        StratConstr (c, true) 
                                               )])]))
        in ()


# 141 "plugins/ltac/g_rewrite.mlg"
 

let db_strat db = StratUnary (Topdown, StratHints (false, db))
let cl_rewrite_clause_db ist db = cl_rewrite_clause_strat (strategy_of_ast (db_strat db))

let cl_rewrite_clause (ist, c) b occ cl =
  let c env sigma = Tacinterp.interp_open_constr_with_bindings ist env sigma c in
  cl_rewrite_clause c b occ cl



let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "rewrite_strat" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("rewrite_strat", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_rewstrategy), 
                                                                 Tacentries.TyIdent ("in", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                 Tacentries.TyNil)))), 
           (fun s id ist -> 
# 153 "plugins/ltac/g_rewrite.mlg"
                                                       cl_rewrite_clause_strat s (Some id) 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("rewrite_strat", Tacentries.TyArg (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_rewstrategy), 
                                                                Tacentries.TyNil)), 
          (fun s ist -> 
# 154 "plugins/ltac/g_rewrite.mlg"
                                          cl_rewrite_clause_strat s None 
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("rewrite_db", Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_preident), 
                                                             Tacentries.TyIdent ("in", 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                             Tacentries.TyNil)))), 
          (fun db id ist -> 
# 155 "plugins/ltac/g_rewrite.mlg"
                                                  cl_rewrite_clause_db ist db (Some id) 
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("rewrite_db", Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_preident), 
                                                             Tacentries.TyNil)), 
          (fun db ist -> 
# 156 "plugins/ltac/g_rewrite.mlg"
                                     cl_rewrite_clause_db ist db None 
          )))]


# 159 "plugins/ltac/g_rewrite.mlg"
 

let clsubstitute o c =
  Proofview.Goal.enter begin fun gl ->
  let is_tac id = match DAst.get (fst (fst (snd c))) with GVar id' when Id.equal id' id -> true | _ -> false in
  let hyps = Tacmach.pf_ids_of_hyps gl in
    Tacticals.tclMAP
      (fun cl ->
        match cl with
          | Some id when is_tac id -> Tacticals.tclIDTAC
          | _ -> cl_rewrite_clause c o AllOccurrences cl)
      (None :: List.map (fun id -> Some id) hyps)
  end



let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "substitute" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("substitute", Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                              Tacentries.TyNil))), 
           (fun o c ist -> 
# 176 "plugins/ltac/g_rewrite.mlg"
                                                               clsubstitute o c 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "setoid_rewrite" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                  Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                  Tacentries.TyNil))), 
           (fun o c ist -> 
# 184 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o AllOccurrences None 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                 Tacentries.TyIdent ("in", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                 Tacentries.TyNil))))), 
          (fun o c id ist -> 
# 186 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o AllOccurrences (Some id) 
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                 Tacentries.TyIdent ("at", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_occurrences), 
                                                                 Tacentries.TyNil))))), 
          (fun o c occ ist -> 
# 188 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o (occurrences_of occ) None 
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                 Tacentries.TyIdent ("at", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_occurrences), 
                                                                 Tacentries.TyIdent ("in", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                 Tacentries.TyNil))))))), 
          (fun o c occ id ist -> 
# 190 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o (occurrences_of occ) (Some id) 
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_rewrite", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_orient), 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_glob_constr_with_bindings), 
                                                                 Tacentries.TyIdent ("in", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                 Tacentries.TyIdent ("at", 
                                                                 Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_occurrences), 
                                                                 Tacentries.TyNil))))))), 
          (fun o c id occ ist -> 
# 192 "plugins/ltac/g_rewrite.mlg"
        cl_rewrite_clause c o (occurrences_of occ) (Some id) 
          )))]


# 195 "plugins/ltac/g_rewrite.mlg"
 

let declare_relation atts a ?binders aeq n refl symm trans =
  declare_relation atts a ?binders aeq n.CAst.v refl symm trans



let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac") ~command:"AddRelation" ~classifier:(fun _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", 
                                     Vernacextend.TyTerminal ("Relation", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                     Vernacextend.TyTerminal ("reflexivity", 
                                     Vernacextend.TyTerminal ("proved", 
                                     Vernacextend.TyTerminal ("by", Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("symmetry", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))))))))))), 
         (let coqpp_body a aeq lemma1 lemma2 n
         atts = Vernactypes.vtdefault (fun () -> 
# 205 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n (Some lemma1) (Some lemma2) None 
                ) in fun a
         aeq lemma1 lemma2 n ?loc ~atts () -> coqpp_body a aeq lemma1 lemma2
         n (Attributes.parse 
# 203 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("reflexivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))))))), 
         (let coqpp_body a aeq lemma1 n
         atts = Vernactypes.vtdefault (fun () -> 
# 209 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n (Some lemma1) None None 
                ) in fun a
         aeq lemma1 n ?loc ~atts () -> coqpp_body a aeq lemma1 n
         (Attributes.parse 
# 207 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))), 
         (let coqpp_body a aeq n
         atts = Vernactypes.vtdefault (fun () -> 
# 211 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n None None None 
                ) in fun a
         aeq n ?loc ~atts () -> coqpp_body a aeq n (Attributes.parse 
         
# 210 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac") ~command:"AddRelation2" ~classifier:(fun _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", 
                                     Vernacextend.TyTerminal ("Relation", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                     Vernacextend.TyTerminal ("symmetry", 
                                     Vernacextend.TyTerminal ("proved", 
                                     Vernacextend.TyTerminal ("by", Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))))))), 
         (let coqpp_body a aeq lemma2 n
         atts = Vernactypes.vtdefault (fun () -> 
# 217 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n None (Some lemma2) None 
                ) in fun a
         aeq lemma2 n ?loc ~atts () -> coqpp_body a aeq lemma2 n
         (Attributes.parse 
# 215 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("symmetry", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("transitivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))))))))))), 
         (let coqpp_body a aeq lemma2 lemma3 n
         atts = Vernactypes.vtdefault (fun () -> 
# 219 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n None (Some lemma2) (Some lemma3) 
                ) in fun a
         aeq lemma2 lemma3 n ?loc ~atts () -> coqpp_body a aeq lemma2 lemma3
         n (Attributes.parse 
# 218 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac") ~command:"AddRelation3" ~classifier:(fun _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", 
                                     Vernacextend.TyTerminal ("Relation", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                     Vernacextend.TyTerminal ("reflexivity", 
                                     Vernacextend.TyTerminal ("proved", 
                                     Vernacextend.TyTerminal ("by", Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("transitivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))))))))))), 
         (let coqpp_body a aeq lemma1 lemma3 n
         atts = Vernactypes.vtdefault (fun () -> 
# 225 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n (Some lemma1) None (Some lemma3) 
                ) in fun a
         aeq lemma1 lemma3 n ?loc ~atts () -> coqpp_body a aeq lemma1 lemma3
         n (Attributes.parse 
# 223 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("reflexivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("symmetry", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("transitivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))))))))))))))), 
         (let coqpp_body a aeq lemma1 lemma2 lemma3 n
         atts = Vernactypes.vtdefault (fun () -> 
# 229 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n (Some lemma1) (Some lemma2) (Some lemma3) 
                ) in fun a
         aeq lemma1 lemma2 lemma3 n ?loc ~atts () -> coqpp_body a aeq lemma1
         lemma2 lemma3 n (Attributes.parse 
# 226 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("transitivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))))))), 
         (let coqpp_body a aeq lemma3 n
         atts = Vernactypes.vtdefault (fun () -> 
# 232 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts a aeq n None None (Some lemma3) 
                ) in fun a
         aeq lemma3 n ?loc ~atts () -> coqpp_body a aeq lemma3 n
         (Attributes.parse 
# 230 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None))]


# 235 "plugins/ltac/g_rewrite.mlg"
 

type binders_argtype = local_binder_expr list

let wit_binders =
 (Genarg.create_arg "binders" : binders_argtype Genarg.uniform_genarg_type)

let binders = Pcoq.create_generic_entry2 "binders" (Genarg.rawwit wit_binders)

let () =
  let raw_printer env sigma _ _ _ l = Pp.pr_non_empty_arg (Ppconstr.pr_binders env sigma) l in
  Pptactic.declare_extra_vernac_genarg_pprule wit_binders raw_printer



let _ = let () = assert (Pcoq.Entry.is_empty binders) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac", "g_rewrite.mlg:4")
        binders
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Pcoq.Constr.binders)))
                                  (fun b loc -> 
# 253 "plugins/ltac/g_rewrite.mlg"
                                     b 
                                                )])]))
        in ()

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac") ~command:"AddParametricRelation" ~classifier:(fun _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", 
                                     Vernacextend.TyTerminal ("Parametric", 
                                     Vernacextend.TyTerminal ("Relation", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                     Vernacextend.TyTerminal (":", Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyTerminal ("reflexivity", 
                                                                   Vernacextend.TyTerminal ("proved", 
                                                                   Vernacextend.TyTerminal ("by", 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyTerminal ("symmetry", 
                                                                   Vernacextend.TyTerminal ("proved", 
                                                                   Vernacextend.TyTerminal ("by", 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyTerminal ("as", 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                   Vernacextend.TyNil))))))))))))))))), 
         (let coqpp_body b a aeq lemma1 lemma2 n
         atts = Vernactypes.vtdefault (fun () -> 
# 260 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n (Some lemma1) (Some lemma2) None 
                ) in fun b
         a aeq lemma1 lemma2 n ?loc ~atts () -> coqpp_body b a aeq lemma1
         lemma2 n (Attributes.parse 
# 257 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Parametric", 
                                                                    Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                                                    Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("reflexivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil))))))))))))), 
         (let coqpp_body b a aeq lemma1 n
         atts = Vernactypes.vtdefault (fun () -> 
# 264 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n (Some lemma1) None None 
                ) in fun b
         a aeq lemma1 n ?loc ~atts () -> coqpp_body b a aeq lemma1 n
         (Attributes.parse 
# 261 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Parametric", 
                                                                    Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                                                    Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil))))))))), 
         (let coqpp_body b a aeq n
         atts = Vernactypes.vtdefault (fun () -> 
# 266 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n None None None 
                ) in fun b
         a aeq n ?loc ~atts () -> coqpp_body b a aeq n
         (Attributes.parse 
# 265 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac") ~command:"AddParametricRelation2" ~classifier:(fun _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", 
                                     Vernacextend.TyTerminal ("Parametric", 
                                     Vernacextend.TyTerminal ("Relation", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                     Vernacextend.TyTerminal (":", Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyTerminal ("symmetry", 
                                                                   Vernacextend.TyTerminal ("proved", 
                                                                   Vernacextend.TyTerminal ("by", 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyTerminal ("as", 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                   Vernacextend.TyNil))))))))))))), 
         (let coqpp_body b a aeq lemma2 n
         atts = Vernactypes.vtdefault (fun () -> 
# 272 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n None (Some lemma2) None 
                ) in fun b
         a aeq lemma2 n ?loc ~atts () -> coqpp_body b a aeq lemma2 n
         (Attributes.parse 
# 270 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Parametric", 
                                                                    Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                                                    Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("symmetry", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("transitivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil))))))))))))))))), 
         (let coqpp_body b a aeq lemma2 lemma3 n
         atts = Vernactypes.vtdefault (fun () -> 
# 274 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n None (Some lemma2) (Some lemma3) 
                ) in fun b
         a aeq lemma2 lemma3 n ?loc ~atts () -> coqpp_body b a aeq lemma2
         lemma3 n (Attributes.parse 
# 273 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac") ~command:"AddParametricRelation3" ~classifier:(fun _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", 
                                     Vernacextend.TyTerminal ("Parametric", 
                                     Vernacextend.TyTerminal ("Relation", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                     Vernacextend.TyTerminal (":", Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyTerminal ("reflexivity", 
                                                                   Vernacextend.TyTerminal ("proved", 
                                                                   Vernacextend.TyTerminal ("by", 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyTerminal ("transitivity", 
                                                                   Vernacextend.TyTerminal ("proved", 
                                                                   Vernacextend.TyTerminal ("by", 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                   Vernacextend.TyTerminal ("as", 
                                                                   Vernacextend.TyNonTerminal (
                                                                   Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                   Vernacextend.TyNil))))))))))))))))), 
         (let coqpp_body b a aeq lemma1 lemma3 n
         atts = Vernactypes.vtdefault (fun () -> 
# 280 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n (Some lemma1) None (Some lemma3) 
                ) in fun b
         a aeq lemma1 lemma3 n ?loc ~atts () -> coqpp_body b a aeq lemma1
         lemma3 n (Attributes.parse 
# 278 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Parametric", 
                                                                    Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                                                    Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("reflexivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("symmetry", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("transitivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil))))))))))))))))))))), 
         (let coqpp_body b a aeq lemma1 lemma2 lemma3 n
         atts = Vernactypes.vtdefault (fun () -> 
# 284 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n (Some lemma1) (Some lemma2) (Some lemma3) 
                ) in fun b
         a aeq lemma1 lemma2 lemma3 n ?loc ~atts () -> coqpp_body b a aeq
         lemma1 lemma2 lemma3 n (Attributes.parse 
# 281 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Parametric", 
                                                                    Vernacextend.TyTerminal ("Relation", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                                                    Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("transitivity", 
                                                                    Vernacextend.TyTerminal ("proved", 
                                                                    Vernacextend.TyTerminal ("by", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil))))))))))))), 
         (let coqpp_body b a aeq lemma3 n
         atts = Vernactypes.vtdefault (fun () -> 
# 287 "plugins/ltac/g_rewrite.mlg"
        declare_relation atts ~binders:b a aeq n None None (Some lemma3) 
                ) in fun b
         a aeq lemma3 n ?loc ~atts () -> coqpp_body b a aeq lemma3 n
         (Attributes.parse 
# 285 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None))]


# 290 "plugins/ltac/g_rewrite.mlg"
 

let add_setoid atts binders a aeq t n =
  add_setoid atts binders a aeq t n.CAst.v

let morphism_tactic =
  let open Tacexpr in
  let name = "Coq.Classes.SetoidTactics.add_morphism_tactic" in
  let tacqid = Libnames.qualid_of_string name in
  let tac = CAst.make @@ TacArg (TacCall (CAst.make (tacqid, []))) in
  Tacinterp.interp tac



let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac") ~command:"AddSetoid1" ~classifier:(fun _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", 
                                     Vernacextend.TyTerminal ("Setoid", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                     Vernacextend.TyTerminal ("as", Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil))))))), 
         (let coqpp_body a aeq t n
         atts = Vernactypes.vtdefault (fun () -> 
# 306 "plugins/ltac/g_rewrite.mlg"
      
         add_setoid atts [] a aeq t n
     
                ) in fun a
         aeq t n ?loc ~atts () -> coqpp_body a aeq t n
         (Attributes.parse 
# 305 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Parametric", 
                                                                    Vernacextend.TyTerminal ("Setoid", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                                                    Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))))))), 
         (let coqpp_body binders a aeq t n
         atts = Vernactypes.vtdefault (fun () -> 
# 310 "plugins/ltac/g_rewrite.mlg"
      
         add_setoid atts binders a aeq t n
     
                ) in fun binders
         a aeq t n ?loc ~atts () -> coqpp_body binders a aeq t n
         (Attributes.parse 
# 309 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Morphism", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil))))), 
         (let coqpp_body m n
         atts = Vernactypes.vtopenproof (fun () -> (
# 315 "plugins/ltac/g_rewrite.mlg"
         if Lib.is_modtype () then
           CErrors.user_err Pp.(str "Add Morphism cannot be used in a module type. Use Parameter Morphism instead.");
         add_morphism_interactive atts ~tactic:morphism_tactic m n.CAst.v 
                )) in fun m
         n ?loc ~atts () -> coqpp_body m n (Attributes.parse 
# 313 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), Some (fun m n -> 
# 314 "plugins/ltac/g_rewrite.mlg"
         VtStartProof(GuaranteesOpacity, [n.CAst.v]) 
                       )));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Declare", 
                                    Vernacextend.TyTerminal ("Morphism", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                    Vernacextend.TyTerminal (":", Vernacextend.TyNonTerminal (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                  Vernacextend.TyNil))))), 
         (let coqpp_body m n
         atts = Vernactypes.vtdefault (fun () -> 
# 320 "plugins/ltac/g_rewrite.mlg"
         add_morphism_as_parameter atts m n.CAst.v 
                ) in fun m
         n ?loc ~atts () -> coqpp_body m n (Attributes.parse 
# 318 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), Some (fun m n -> 
# 319 "plugins/ltac/g_rewrite.mlg"
         VtSideff([n.CAst.v], VtLater) 
                       )));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Morphism", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("with", 
                                                                    Vernacextend.TyTerminal ("signature", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_lconstr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil)))))))), 
         (let coqpp_body m s n
         atts = Vernactypes.vtopenproof (fun () -> (
# 323 "plugins/ltac/g_rewrite.mlg"
         add_morphism atts ~tactic:morphism_tactic [] m s n.CAst.v 
                )) in fun m
         s n ?loc ~atts () -> coqpp_body m s n (Attributes.parse 
# 321 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), Some (fun m s n -> 
# 322 "plugins/ltac/g_rewrite.mlg"
         VtStartProof(GuaranteesOpacity,[n.CAst.v]) 
                       )));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Add", Vernacextend.TyTerminal ("Parametric", 
                                                                    Vernacextend.TyTerminal ("Morphism", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_binders), 
                                                                    Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Vernacextend.TyTerminal ("with", 
                                                                    Vernacextend.TyTerminal ("signature", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_lconstr), 
                                                                    Vernacextend.TyTerminal ("as", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_identref), 
                                                                    Vernacextend.TyNil))))))))))), 
         (let coqpp_body binders m s n
         atts = Vernactypes.vtopenproof (fun () -> (
# 327 "plugins/ltac/g_rewrite.mlg"
         add_morphism atts ~tactic:morphism_tactic binders m s n.CAst.v 
                )) in fun binders
         m s n ?loc ~atts () -> coqpp_body binders m s n
         (Attributes.parse 
# 324 "plugins/ltac/g_rewrite.mlg"
               rewrite_attributes
          atts)), Some (fun binders m s n -> 
# 326 "plugins/ltac/g_rewrite.mlg"
         VtStartProof(GuaranteesOpacity,[n.CAst.v]) 
                       )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "setoid_symmetry" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("setoid_symmetry", Tacentries.TyNil), 
           (fun ist -> 
# 331 "plugins/ltac/g_rewrite.mlg"
                              setoid_symmetry 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_symmetry", Tacentries.TyIdent ("in", 
                                                                  Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                  Tacentries.TyNil))), 
          (fun n ist -> 
# 332 "plugins/ltac/g_rewrite.mlg"
                                          setoid_symmetry_in n 
          )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "setoid_reflexivity" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("setoid_reflexivity", 
                            Tacentries.TyNil), (fun ist -> 
# 336 "plugins/ltac/g_rewrite.mlg"
                                setoid_reflexivity 
                                               )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ltac" "setoid_transitivity" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("setoid_transitivity", 
                            Tacentries.TyArg (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                            Tacentries.TyNil)), (fun t ist -> 
# 340 "plugins/ltac/g_rewrite.mlg"
                                           setoid_transitivity (Some t) 
                                                )));
         (Tacentries.TyML (Tacentries.TyIdent ("setoid_etransitivity", 
                           Tacentries.TyNil), (fun ist -> 
# 341 "plugins/ltac/g_rewrite.mlg"
                                  setoid_transitivity None 
                                              )))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac") ~command:"PrintRewriteHintDb" ~classifier:(fun _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Print", 
                                     Vernacextend.TyTerminal ("Rewrite", 
                                     Vernacextend.TyTerminal ("HintDb", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_preident), 
                                     Vernacextend.TyNil)))), (let coqpp_body s
                                                             () = Vernactypes.vtdefault (fun () -> 
                                                                  
# 346 "plugins/ltac/g_rewrite.mlg"
    Feedback.msg_notice (Autorewrite.print_rewrite_hintdb s) 
                                                                  ) in fun s
                                                             ?loc ~atts ()
                                                             -> coqpp_body s
                                                             (Attributes.unsupported_attributes atts)), None))]

