
# 13 "vernac/g_proofs.mlg"
 

open Constrexpr
open Vernacexpr
open Hints

module C = Constr

open Pcoq
open Pcoq.Prim
open Pcoq.Constr
open Pvernac.Vernac_

let thm_token = G_vernac.thm_token

let hint = Entry.make "hint"

let warn_deprecated_focus =
  CWarnings.create ~name:"deprecated-focus" ~category:Deprecation.Version.v8_8
    Pp.(function
      | None ->
        strbrk "The Focus command is deprecated; use bullets or focusing brackets instead."
      | Some n ->
        str "The Focus command is deprecated;" ++ spc ()
        ++ str "use '" ++ int n ++ str ": {' instead.")

let warn_deprecated_focus_n ?loc n = warn_deprecated_focus ?loc (Some n)

let warn_deprecated_focus ?loc () = warn_deprecated_focus ?loc None

let warn_deprecated_unfocus =
  CWarnings.create ~name:"deprecated-unfocus" ~category:Deprecation.Version.v8_8
         (fun () -> Pp.strbrk "The Unfocus command is deprecated")



let _ = let opt_hintbases = Pcoq.Entry.make "opt_hintbases"
        and reference_or_constr = Pcoq.Entry.make "reference_or_constr"
        and constr_body = Pcoq.Entry.make "constr_body"
        and mode = Pcoq.Entry.make "mode"
        in
        let () = assert (Pcoq.Entry.is_empty opt_hintbases) in
        let () =
        Pcoq.grammar_extend opt_hintbases
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.rules 
                                                  [Pcoq.Rules.make (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.stop)
                                                                   ((Pcoq.Symbol.token (Tok.PIDENT (None)))))
                                                                   (fun id
                                                                   loc -> 
                                                                   
# 55 "vernac/g_proofs.mlg"
                                      id 
                                                                   )])))))
                                  (fun l _ loc -> 
# 55 "vernac/g_proofs.mlg"
                                                  l 
                                                  );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 54 "vernac/g_proofs.mlg"
           [] 
                                             )])]))
        in let () =
        Pcoq.grammar_extend command
        (Pcoq.Reuse (None, [Pcoq.Production.make
                            (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                            (Pcoq.Rule.stop)
                                                            ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                            ("Hint"))))))
                                                            ((Pcoq.Symbol.nterm hint)))
                                            ((Pcoq.Symbol.nterm opt_hintbases)))
                            (fun dbnames h _ loc -> 
# 107 "vernac/g_proofs.mlg"
            VernacSynPure (VernacHints (dbnames, h)) 
                                                    );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                           (Pcoq.Rule.next 
                                                           (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Remove"))))))
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Hints"))))))
                                                           ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm global)))))
                                           ((Pcoq.Symbol.nterm opt_hintbases)))
                           (fun dbnames ids _ _ loc -> 
# 105 "vernac/g_proofs.mlg"
            VernacSynPure (VernacRemoveHints (dbnames, ids)) 
                                                       );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                           (Pcoq.Rule.next 
                                                           (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Create"))))))
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("HintDb"))))))
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (None)))))
                                           ((Pcoq.Symbol.rules [Pcoq.Rules.make 
                                                               (Pcoq.Rule.stop)
                                                               (fun loc -> 
                                                               
# 102 "vernac/g_proofs.mlg"
                                                                      false 
                                                               );
                                                               Pcoq.Rules.make 
                                                               (Pcoq.Rule.next_norec 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                               ("discriminated"))))))
                                                               (fun _ loc ->
                                                               
# 102 "vernac/g_proofs.mlg"
                                                        true 
                                                               )])))
                           (fun b id _ _ loc -> 
# 103 "vernac/g_proofs.mlg"
              VernacSynPure (VernacCreateHintDb (id, b)) 
                                                );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Validate"))))))
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Proof"))))))
                           (fun _ _ loc -> 
# 99 "vernac/g_proofs.mlg"
                                             VernacSynPure VernacValidateProof 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Guarded"))))))
                           (fun _ loc -> 
# 98 "vernac/g_proofs.mlg"
                             VernacSynPure VernacCheckGuard 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                           (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Show"))))))
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Match"))))))
                                           ((Pcoq.Symbol.nterm reference)))
                           (fun id _ _ loc -> 
# 97 "vernac/g_proofs.mlg"
                                                         VernacSynPure (VernacShow (ShowMatch id)) 
                                              );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Show"))))))
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Intros"))))))
                           (fun _ _ loc -> 
# 96 "vernac/g_proofs.mlg"
                                          VernacSynPure (VernacShow (ShowIntros true)) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Show"))))))
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Intro"))))))
                           (fun _ _ loc -> 
# 95 "vernac/g_proofs.mlg"
                                         VernacSynPure (VernacShow (ShowIntros false)) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Show"))))))
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Proof"))))))
                           (fun _ _ loc -> 
# 94 "vernac/g_proofs.mlg"
                                         VernacSynPure (VernacShow ShowProof) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Show"))))))
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Conjectures"))))))
                           (fun _ _ loc -> 
# 93 "vernac/g_proofs.mlg"
                                               VernacSynPure (VernacShow ShowProofNames) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Show"))))))
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Universes"))))))
                           (fun _ _ loc -> 
# 92 "vernac/g_proofs.mlg"
                                             VernacSynPure (VernacShow ShowUniverses) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Show"))))))
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Existentials"))))))
                           (fun _ _ loc -> 
# 91 "vernac/g_proofs.mlg"
                                                VernacSynPure (VernacShow ShowExistentials) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Show"))))))
                                           ((Pcoq.Symbol.nterm ident)))
                           (fun id _ loc -> 
# 90 "vernac/g_proofs.mlg"
                                      VernacSynPure (VernacShow (ShowGoal (GoalId id))) 
                                            );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Show"))))))
                                           ((Pcoq.Symbol.nterm natural)))
                           (fun n _ loc -> 
# 89 "vernac/g_proofs.mlg"
                                       VernacSynPure (VernacShow (ShowGoal (NthGoal n))) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Show"))))))
                           (fun _ loc -> 
# 88 "vernac/g_proofs.mlg"
                          VernacSynPure (VernacShow (ShowGoal OpenSubgoals)) 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Unfocused"))))))
                           (fun _ loc -> 
# 87 "vernac/g_proofs.mlg"
                               VernacSynPure VernacUnfocused 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Unfocus"))))))
                           (fun _ loc -> 
# 85 "vernac/g_proofs.mlg"
           warn_deprecated_unfocus ~loc ();
         VernacSynPure VernacUnfocus 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Focus"))))))
                                           ((Pcoq.Symbol.nterm natural)))
                           (fun n _ loc -> 
# 82 "vernac/g_proofs.mlg"
           warn_deprecated_focus_n n ~loc;
         VernacSynPure (VernacFocus (Some n)) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Focus"))))))
                           (fun _ loc -> 
# 79 "vernac/g_proofs.mlg"
           warn_deprecated_focus ~loc ();
         VernacSynPure (VernacFocus None) 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                           (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Undo"))))))
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("To"))))))
                                           ((Pcoq.Symbol.nterm natural)))
                           (fun n _ _ loc -> 
# 77 "vernac/g_proofs.mlg"
                                                   VernacSynPure (VernacUndoTo n) 
                                             );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Undo"))))))
                                           ((Pcoq.Symbol.nterm natural)))
                           (fun n _ loc -> 
# 76 "vernac/g_proofs.mlg"
                                       VernacSynPure (VernacUndo n) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Undo"))))))
                           (fun _ loc -> 
# 75 "vernac/g_proofs.mlg"
                          VernacSynPure (VernacUndo 1) 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Restart"))))))
                           (fun _ loc -> 
# 74 "vernac/g_proofs.mlg"
                             VernacSynPure VernacRestart 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Defined"))))))
                                           ((Pcoq.Symbol.nterm identref)))
                           (fun id _ loc -> 
# 73 "vernac/g_proofs.mlg"
            VernacSynPure (VernacEndProof (Proved (Transparent,Some id))) 
                                            );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Defined"))))))
                           (fun _ loc -> 
# 71 "vernac/g_proofs.mlg"
                             VernacSynPure (VernacEndProof (Proved (Transparent,None))) 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Save"))))))
                                           ((Pcoq.Symbol.nterm identref)))
                           (fun id _ loc -> 
# 70 "vernac/g_proofs.mlg"
            VernacSynPure (VernacEndProof (Proved (Opaque, Some id))) 
                                            );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Qed"))))))
                           (fun _ loc -> 
# 68 "vernac/g_proofs.mlg"
                         VernacSynPure (VernacEndProof (Proved (Opaque,None))) 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Admitted"))))))
                           (fun _ loc -> 
# 67 "vernac/g_proofs.mlg"
                              VernacSynPure (VernacEndProof Admitted) 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Abort"))))))
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("All"))))))
                           (fun _ _ loc -> 
# 66 "vernac/g_proofs.mlg"
                                        VernacSynPure VernacAbortAll 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Abort"))))))
                           (fun _ loc -> 
# 65 "vernac/g_proofs.mlg"
                           VernacSynPure VernacAbort 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Proof"))))))
                                           ((Pcoq.Symbol.nterm lconstr)))
                           (fun c _ loc -> 
# 64 "vernac/g_proofs.mlg"
                                        VernacSynPure (VernacExactProof c) 
                                           );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                           (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Proof"))))))
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Mode"))))))
                                           ((Pcoq.Symbol.nterm string)))
                           (fun mn _ _ loc -> 
# 63 "vernac/g_proofs.mlg"
                                                        VernacSynterp (VernacProofMode mn) 
                                              );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                           (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Proof"))))))
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("using"))))))
                                           ((Pcoq.Symbol.nterm G_vernac.section_subset_expr)))
                           (fun l _ _ loc -> 
# 62 "vernac/g_proofs.mlg"
            VernacSynPure (VernacProof (None,Some l)) 
                                             );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.stop)
                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                           ("Proof"))))))
                           (fun _ loc -> 
# 60 "vernac/g_proofs.mlg"
                           VernacSynPure (VernacProof (None,None)) 
                                         );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                           ("Goal"))))))
                                           ((Pcoq.Symbol.nterm lconstr)))
                           (fun c _ loc -> 
# 59 "vernac/g_proofs.mlg"
          VernacSynPure (VernacDefinition (Decls.(NoDischarge, Definition), ((CAst.make ~loc Names.Anonymous), None), ProveBody ([], c))) 
                                           )]))
        in let () = assert (Pcoq.Entry.is_empty reference_or_constr)
        in
        let () =
        Pcoq.grammar_extend reference_or_constr
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm constr)))
                                  (fun c loc -> 
# 111 "vernac/g_proofs.mlg"
                       HintsConstr c 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm global)))
                                 (fun r loc -> 
# 110 "vernac/g_proofs.mlg"
                       HintsReference r 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty hint) in
        let () =
        Pcoq.grammar_extend hint
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("Constructors"))))))
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm global)))))
                                  (fun lc _ loc -> 
# 131 "vernac/g_proofs.mlg"
                                                     HintsConstructors lc 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Unfold"))))))
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm global)))))
                                 (fun lqid _ loc -> 
# 130 "vernac/g_proofs.mlg"
                                                 HintsUnfold lqid 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Mode"))))))
                                                                 ((Pcoq.Symbol.nterm global)))
                                                 ((Pcoq.Symbol.nterm mode)))
                                 (fun m l _ loc -> 
# 129 "vernac/g_proofs.mlg"
                                                HintsMode (l, m) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Opaque"))))))
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm global)))))
                                 (fun lc _ loc -> 
# 128 "vernac/g_proofs.mlg"
                                               HintsTransparency (HintsReferences lc, false) 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Transparent"))))))
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm global)))))
                                 (fun lc _ loc -> 
# 127 "vernac/g_proofs.mlg"
                                                    HintsTransparency (HintsReferences lc, true) 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Projections"))))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("Opaque"))))))
                                 (fun _ _ loc -> 
# 126 "vernac/g_proofs.mlg"
                                                 HintsTransparency (HintsProjections, false) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Projections"))))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("Transparent"))))))
                                 (fun _ _ loc -> 
# 125 "vernac/g_proofs.mlg"
                                                      HintsTransparency (HintsProjections, true) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Constants"))))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("Opaque"))))))
                                 (fun _ _ loc -> 
# 124 "vernac/g_proofs.mlg"
                                               HintsTransparency (HintsConstants, false) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Constants"))))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("Transparent"))))))
                                 (fun _ _ loc -> 
# 123 "vernac/g_proofs.mlg"
                                                    HintsTransparency (HintsConstants, true) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Variables"))))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("Opaque"))))))
                                 (fun _ _ loc -> 
# 122 "vernac/g_proofs.mlg"
                                               HintsTransparency (HintsVariables, false) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Variables"))))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("Transparent"))))))
                                 (fun _ _ loc -> 
# 121 "vernac/g_proofs.mlg"
                                                    HintsTransparency (HintsVariables, true) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Immediate"))))))
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm reference_or_constr)))))
                                 (fun lc _ loc -> 
# 120 "vernac/g_proofs.mlg"
                                                               HintsImmediate lc 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Resolve"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("<-")))))
                                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm global)))))
                                                 ((Pcoq.Symbol.opt (Pcoq.Symbol.nterm natural))))
                                 (fun n lc _ _ loc -> 
# 119 "vernac/g_proofs.mlg"
            HintsResolveIFF (false, lc, n) 
                                                      );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Resolve"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("->")))))
                                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm global)))))
                                                 ((Pcoq.Symbol.opt (Pcoq.Symbol.nterm natural))))
                                 (fun n lc _ _ loc -> 
# 117 "vernac/g_proofs.mlg"
            HintsResolveIFF (true, lc, n) 
                                                      );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Resolve"))))))
                                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm reference_or_constr)))))
                                                 ((Pcoq.Symbol.nterm hint_info)))
                                 (fun info lc _ loc -> 
# 115 "vernac/g_proofs.mlg"
            HintsResolve (List.map (fun x -> (info, true, x)) lc) 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty constr_body) in
        let () =
        Pcoq.grammar_extend constr_body
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                  ((Pcoq.Symbol.nterm lconstr)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm lconstr)))
                                  (fun c _ t _ loc -> 
# 135 "vernac/g_proofs.mlg"
                                                 CAst.make ~loc @@ CCast(c,Some C.DEFAULTcast, t) 
                                                      );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                 ((Pcoq.Symbol.nterm lconstr)))
                                 (fun c _ loc -> 
# 134 "vernac/g_proofs.mlg"
                               c 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty mode) in
        let () =
        Pcoq.grammar_extend mode
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.rules 
                                                  [Pcoq.Rules.make (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.stop)
                                                                   ((Pcoq.Symbol.token (Tok.PKEYWORD ("-")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 140 "vernac/g_proofs.mlg"
                             ModeOutput 
                                                                   );
                                                  Pcoq.Rules.make (Pcoq.Rule.next_norec 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("!")))))
                                                                  (fun _
                                                                  loc -> 
                                                                  
# 139 "vernac/g_proofs.mlg"
                             ModeNoHeadEvar 
                                                                  );
                                                  Pcoq.Rules.make (Pcoq.Rule.next_norec 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("+")))))
                                                                  (fun _
                                                                  loc -> 
                                                                  
# 138 "vernac/g_proofs.mlg"
                             ModeInput 
                                                                  )])))))
                                  (fun l loc -> 
# 140 "vernac/g_proofs.mlg"
                                                 l 
                                                )])]))
        in ()

