#include "keybindings.h"

using namespace std;

bimap<InterfaceKey,std::string> bindingNames;
bimap<InterfaceKey,std::string> displayNames;
bimap<SDL_Keycode,std::string> sdlNames;
bimap<SDL_Keycode, int> sdlUnicode;
set<int> unicodeCapitals;

void keybinding_init() {
	bindingNames = bimap<InterfaceKey, std::string>{
	//********************* MAIN KEY LOSS
	{INTERFACEKEY_NONE, "NONE"},
	{INTERFACEKEY_SELECT, "SELECT"},
	/*
	{INTERFACEKEY_SEC_SELECT, "SEC_SELECT"},
	{INTERFACEKEY_DESELECT, "DESELECT"},
	*/
	{INTERFACEKEY_SELECT_ALL, "SELECT_ALL"},
	/*
	{INTERFACEKEY_DESELECT_ALL, "DESELECT_ALL"},
	*/
	{INTERFACEKEY_LEAVESCREEN, "LEAVESCREEN"},
	//{INTERFACEKEY_LEAVESCREEN_ALL, "LEAVESCREEN_ALL"},
	{INTERFACEKEY_CLOSE_MEGA_ANNOUNCEMENT, "CLOSE_MEGA_ANNOUNCEMENT"},
	{INTERFACEKEY_TOGGLE_FULLSCREEN, "TOGGLE_FULLSCREEN"},
	/*
	{INTERFACEKEY_WORLD_PARAM_ADD, "WORLD_PARAM_ADD"},
	{INTERFACEKEY_WORLD_PARAM_COPY, "WORLD_PARAM_COPY"},
	{INTERFACEKEY_WORLD_PARAM_DELETE, "WORLD_PARAM_DELETE"},
	{INTERFACEKEY_WORLD_PARAM_TITLE, "WORLD_PARAM_TITLE"},
	{INTERFACEKEY_WORLD_PARAM_NAME_RANDOM, "WORLD_PARAM_NAME_RANDOM"},
	{INTERFACEKEY_WORLD_PARAM_NAME_ENTER, "WORLD_PARAM_NAME_ENTER"},
	{INTERFACEKEY_WORLD_PARAM_SEED_RANDOM, "WORLD_PARAM_SEED_RANDOM"},
	{INTERFACEKEY_WORLD_PARAM_SEED_ENTER, "WORLD_PARAM_SEED_ENTER"},
	{INTERFACEKEY_WORLD_PARAM_LOAD, "WORLD_PARAM_LOAD"},
	{INTERFACEKEY_WORLD_PARAM_SAVE, "WORLD_PARAM_SAVE"},
	{INTERFACEKEY_WORLD_PARAM_DIM_X_UP, "WORLD_PARAM_DIM_X_UP"},
	{INTERFACEKEY_WORLD_PARAM_DIM_X_DOWN, "WORLD_PARAM_DIM_X_DOWN"},
	{INTERFACEKEY_WORLD_PARAM_DIM_Y_UP, "WORLD_PARAM_DIM_Y_UP"},
	{INTERFACEKEY_WORLD_PARAM_DIM_Y_DOWN, "WORLD_PARAM_DIM_Y_DOWN"},
	{INTERFACEKEY_WORLD_PARAM_SET, "WORLD_PARAM_SET"},
	{INTERFACEKEY_WORLD_PARAM_INCREASE, "WORLD_PARAM_INCREASE"},
	{INTERFACEKEY_WORLD_PARAM_DECREASE, "WORLD_PARAM_DECREASE"},
	{INTERFACEKEY_WORLD_PARAM_ENTER_VALUE, "WORLD_PARAM_ENTER_VALUE"},
	{INTERFACEKEY_WORLD_PARAM_NULLIFY, "WORLD_PARAM_NULLIFY"},
	{INTERFACEKEY_WORLD_PARAM_PRESET, "WORLD_PARAM_PRESET"},
	{INTERFACEKEY_WORLD_PARAM_REJECT_CONTINUE, "WORLD_PARAM_REJECT_CONTINUE"},
	{INTERFACEKEY_WORLD_PARAM_REJECT_ABORT, "WORLD_PARAM_REJECT_ABORT"},
	{INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_THIS, "WORLD_PARAM_REJECT_ALLOW_THIS"},
	{INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_ALL, "WORLD_PARAM_REJECT_ALLOW_ALL"},
	{INTERFACEKEY_WORLD_GEN_CONTINUE, "WORLD_GEN_CONTINUE"},
	{INTERFACEKEY_WORLD_GEN_USE, "WORLD_GEN_USE"},
	{INTERFACEKEY_WORLD_GEN_ABORT, "WORLD_GEN_ABORT"},
	{INTERFACEKEY_SETUP_EMBARK, "SETUP_EMBARK"},
	{INTERFACEKEY_SETUP_NAME_FORT, "SETUP_NAME_FORT"},
	{INTERFACEKEY_SETUP_NAME_GROUP, "SETUP_NAME_GROUP"},
	{INTERFACEKEY_SETUP_SYMBOL, "SETUP_SYMBOL"},
	{INTERFACEKEY_SETUP_RECLAIM, "SETUP_RECLAIM"},
	{INTERFACEKEY_SETUP_FIND, "SETUP_FIND"},
	{INTERFACEKEY_SETUP_NOTES, "SETUP_NOTES"},
	{INTERFACEKEY_SETUP_NOTES_TAKE_NOTES, "SETUP_NOTES_TAKE_NOTES"},
	{INTERFACEKEY_SETUP_NOTES_DELETE_NOTE, "SETUP_NOTES_DELETE_NOTE"},
	{INTERFACEKEY_SETUP_NOTES_CHANGE_SYMBOL_SELECTION, "SETUP_NOTES_CHANGE_SYMBOL_SELECTION"},
	{INTERFACEKEY_SETUP_NOTES_ADOPT_SYMBOL, "SETUP_NOTES_ADOPT_SYMBOL"},
	{INTERFACEKEY_SETUP_LOCAL_Y_UP, "SETUP_LOCAL_Y_UP"},
	{INTERFACEKEY_SETUP_LOCAL_Y_DOWN, "SETUP_LOCAL_Y_DOWN"},
	{INTERFACEKEY_SETUP_LOCAL_X_UP, "SETUP_LOCAL_X_UP"},
	{INTERFACEKEY_SETUP_LOCAL_X_DOWN, "SETUP_LOCAL_X_DOWN"},
	{INTERFACEKEY_SETUP_LOCAL_Y_MUP, "SETUP_LOCAL_Y_MUP"},
	{INTERFACEKEY_SETUP_LOCAL_Y_MDOWN, "SETUP_LOCAL_Y_MDOWN"},
	{INTERFACEKEY_SETUP_LOCAL_X_MUP, "SETUP_LOCAL_X_MUP"},
	{INTERFACEKEY_SETUP_LOCAL_X_MDOWN, "SETUP_LOCAL_X_MDOWN"},
	{INTERFACEKEY_SETUP_BIOME_1, "SETUP_BIOME_1"},
	{INTERFACEKEY_SETUP_BIOME_2, "SETUP_BIOME_2"},
	{INTERFACEKEY_SETUP_BIOME_3, "SETUP_BIOME_3"},
	{INTERFACEKEY_SETUP_BIOME_4, "SETUP_BIOME_4"},
	{INTERFACEKEY_SETUP_BIOME_5, "SETUP_BIOME_5"},
	{INTERFACEKEY_SETUP_BIOME_6, "SETUP_BIOME_6"},
	{INTERFACEKEY_SETUP_BIOME_7, "SETUP_BIOME_7"},
	{INTERFACEKEY_SETUP_BIOME_8, "SETUP_BIOME_8"},
	{INTERFACEKEY_SETUP_BIOME_9, "SETUP_BIOME_9"},
	{INTERFACEKEY_CHOOSE_NAME_RANDOM, "CHOOSE_NAME_RANDOM"},
	{INTERFACEKEY_CHOOSE_NAME_CLEAR, "CHOOSE_NAME_CLEAR"},
	{INTERFACEKEY_CHOOSE_NAME_TYPE, "CHOOSE_NAME_TYPE"},
	{INTERFACEKEY_CHOOSE_NAME_FIRST, "CHOOSE_NAME_FIRST"},
	{INTERFACEKEY_ITEM_DESCRIPTION, "ITEM_DESCRIPTION"},
	{INTERFACEKEY_ITEM_FORBID, "ITEM_FORBID"},
	{INTERFACEKEY_ITEM_MELT, "ITEM_MELT"},
	{INTERFACEKEY_ITEM_DUMP, "ITEM_DUMP"},
	{INTERFACEKEY_ITEM_HIDE, "ITEM_HIDE"},
	{INTERFACEKEY_HELP, "HELP"},
	{INTERFACEKEY_MOVIES, "MOVIES"},
	*/
	{INTERFACEKEY_OPTIONS, "OPTIONS"},
	/*
	{INTERFACEKEY_OPTION_EXPORT, "OPTION_EXPORT"},
	*/
	{INTERFACEKEY_CHANGETAB, "CHANGETAB"},
	{INTERFACEKEY_SEC_CHANGETAB, "SEC_CHANGETAB"},
	{INTERFACEKEY_STANDARDSCROLL_LEFT, "STANDARDSCROLL_LEFT"},
	{INTERFACEKEY_STANDARDSCROLL_RIGHT, "STANDARDSCROLL_RIGHT"},
	{INTERFACEKEY_STANDARDSCROLL_UP, "STANDARDSCROLL_UP"},
	{INTERFACEKEY_STANDARDSCROLL_DOWN, "STANDARDSCROLL_DOWN"},
	{INTERFACEKEY_STANDARDSCROLL_PAGEUP, "STANDARDSCROLL_PAGEUP"},
	{INTERFACEKEY_STANDARDSCROLL_PAGEDOWN, "STANDARDSCROLL_PAGEDOWN"},
	{INTERFACEKEY_CONTEXT_SCROLL_UP, "CONTEXT_SCROLL_UP"},
	{INTERFACEKEY_CONTEXT_SCROLL_DOWN, "CONTEXT_SCROLL_DOWN"},
	{INTERFACEKEY_CONTEXT_SCROLL_PAGEUP, "CONTEXT_SCROLL_PAGEUP"},
	{INTERFACEKEY_CONTEXT_SCROLL_PAGEDOWN, "CONTEXT_SCROLL_PAGEDOWN"},
	/*
	{INTERFACEKEY_SECONDSCROLL_UP, "SECONDSCROLL_UP"},
	{INTERFACEKEY_SECONDSCROLL_DOWN, "SECONDSCROLL_DOWN"},
	{INTERFACEKEY_SECONDSCROLL_PAGEUP, "SECONDSCROLL_PAGEUP"},
	{INTERFACEKEY_SECONDSCROLL_PAGEDOWN, "SECONDSCROLL_PAGEDOWN"},
	*/
	{INTERFACEKEY_CURSOR_UP, "CURSOR_UP"},
	{INTERFACEKEY_CURSOR_DOWN, "CURSOR_DOWN"},
	{INTERFACEKEY_CURSOR_LEFT, "CURSOR_LEFT"},
	{INTERFACEKEY_CURSOR_RIGHT, "CURSOR_RIGHT"},
	{INTERFACEKEY_CURSOR_UPLEFT, "CURSOR_UPLEFT"},
	{INTERFACEKEY_CURSOR_UPRIGHT, "CURSOR_UPRIGHT"},
	{INTERFACEKEY_CURSOR_DOWNLEFT, "CURSOR_DOWNLEFT"},
	{INTERFACEKEY_CURSOR_DOWNRIGHT, "CURSOR_DOWNRIGHT"},
	{INTERFACEKEY_CURSOR_UP_FAST, "CURSOR_UP_FAST"},
	{INTERFACEKEY_CURSOR_DOWN_FAST, "CURSOR_DOWN_FAST"},
	{INTERFACEKEY_CURSOR_LEFT_FAST, "CURSOR_LEFT_FAST"},
	{INTERFACEKEY_CURSOR_RIGHT_FAST, "CURSOR_RIGHT_FAST"},
	{INTERFACEKEY_CURSOR_UPLEFT_FAST, "CURSOR_UPLEFT_FAST"},
	{INTERFACEKEY_CURSOR_UPRIGHT_FAST, "CURSOR_UPRIGHT_FAST"},
	{INTERFACEKEY_CURSOR_DOWNLEFT_FAST, "CURSOR_DOWNLEFT_FAST"},
	{INTERFACEKEY_CURSOR_DOWNRIGHT_FAST, "CURSOR_DOWNRIGHT_FAST"},
	{INTERFACEKEY_CURSOR_UP_Z, "CURSOR_UP_Z"},
	{INTERFACEKEY_CURSOR_DOWN_Z, "CURSOR_DOWN_Z"},
	{INTERFACEKEY_CURSOR_UP_Z_AUX, "CURSOR_UP_Z_AUX"},
	{INTERFACEKEY_CURSOR_DOWN_Z_AUX, "CURSOR_DOWN_Z_AUX"},
	{INTERFACEKEY_CURSOR_UP_Z_FAST, "CURSOR_UP_Z_FAST"},
	{INTERFACEKEY_CURSOR_DOWN_Z_FAST, "CURSOR_DOWN_Z_FAST"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UP, "KEYBOARD_CURSOR_UP"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWN, "KEYBOARD_CURSOR_DOWN"},
	{INTERFACEKEY_KEYBOARD_CURSOR_LEFT, "KEYBOARD_CURSOR_LEFT"},
	{INTERFACEKEY_KEYBOARD_CURSOR_RIGHT, "KEYBOARD_CURSOR_RIGHT"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UPLEFT, "KEYBOARD_CURSOR_UPLEFT"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UPRIGHT, "KEYBOARD_CURSOR_UPRIGHT"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWNLEFT, "KEYBOARD_CURSOR_DOWNLEFT"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWNRIGHT, "KEYBOARD_CURSOR_DOWNRIGHT"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UP_FAST, "KEYBOARD_CURSOR_UP_FAST"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWN_FAST, "KEYBOARD_CURSOR_DOWN_FAST"},
	{INTERFACEKEY_KEYBOARD_CURSOR_LEFT_FAST, "KEYBOARD_CURSOR_LEFT_FAST"},
	{INTERFACEKEY_KEYBOARD_CURSOR_RIGHT_FAST, "KEYBOARD_CURSOR_RIGHT_FAST"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UPLEFT_FAST, "KEYBOARD_CURSOR_UPLEFT_FAST"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UPRIGHT_FAST, "KEYBOARD_CURSOR_UPRIGHT_FAST"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWNLEFT_FAST, "KEYBOARD_CURSOR_DOWNLEFT_FAST"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWNRIGHT_FAST, "KEYBOARD_CURSOR_DOWNRIGHT_FAST"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UP_Z, "KEYBOARD_CURSOR_UP_Z"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWN_Z, "KEYBOARD_CURSOR_DOWN_Z"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UP_Z_AUX, "KEYBOARD_CURSOR_UP_Z_AUX"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWN_Z_AUX, "KEYBOARD_CURSOR_DOWN_Z_AUX"},
	/*
	{INTERFACEKEY_A_RETURN_TO_ARENA, "A_RETURN_TO_ARENA"},
	{INTERFACEKEY_A_MOVE_N, "A_MOVE_N"},
	{INTERFACEKEY_A_MOVE_S, "A_MOVE_S"},
	{INTERFACEKEY_A_MOVE_E, "A_MOVE_E"},
	{INTERFACEKEY_A_MOVE_W, "A_MOVE_W"},
	{INTERFACEKEY_A_MOVE_NW, "A_MOVE_NW"},
	{INTERFACEKEY_A_MOVE_NE, "A_MOVE_NE"},
	{INTERFACEKEY_A_MOVE_SW, "A_MOVE_SW"},
	{INTERFACEKEY_A_MOVE_SE, "A_MOVE_SE"},
	{INTERFACEKEY_A_MOVE_SAME_SQUARE, "A_MOVE_SAME_SQUARE"},
	{INTERFACEKEY_A_CARE_MOVE_N, "A_CARE_MOVE_N"},
	{INTERFACEKEY_A_CARE_MOVE_S, "A_CARE_MOVE_S"},
	{INTERFACEKEY_A_CARE_MOVE_E, "A_CARE_MOVE_E"},
	{INTERFACEKEY_A_CARE_MOVE_W, "A_CARE_MOVE_W"},
	{INTERFACEKEY_A_CARE_MOVE_NW, "A_CARE_MOVE_NW"},
	{INTERFACEKEY_A_CARE_MOVE_NE, "A_CARE_MOVE_NE"},
	{INTERFACEKEY_A_CARE_MOVE_SW, "A_CARE_MOVE_SW"},
	{INTERFACEKEY_A_CARE_MOVE_SE, "A_CARE_MOVE_SE"},
	{INTERFACEKEY_A_CARE_MOVE_UPDOWN, "A_CARE_MOVE_UPDOWN"},
	{INTERFACEKEY_A_MOVE_N_UP, "A_MOVE_N_UP"},
	{INTERFACEKEY_A_MOVE_S_UP, "A_MOVE_S_UP"},
	{INTERFACEKEY_A_MOVE_E_UP, "A_MOVE_E_UP"},
	{INTERFACEKEY_A_MOVE_W_UP, "A_MOVE_W_UP"},
	{INTERFACEKEY_A_MOVE_NW_UP, "A_MOVE_NW_UP"},
	{INTERFACEKEY_A_MOVE_NE_UP, "A_MOVE_NE_UP"},
	{INTERFACEKEY_A_MOVE_SW_UP, "A_MOVE_SW_UP"},
	{INTERFACEKEY_A_MOVE_SE_UP, "A_MOVE_SE_UP"},
	{INTERFACEKEY_A_MOVE_UP, "A_MOVE_UP"},
	{INTERFACEKEY_A_MOVE_N_DOWN, "A_MOVE_N_DOWN"},
	{INTERFACEKEY_A_MOVE_S_DOWN, "A_MOVE_S_DOWN"},
	{INTERFACEKEY_A_MOVE_E_DOWN, "A_MOVE_E_DOWN"},
	{INTERFACEKEY_A_MOVE_W_DOWN, "A_MOVE_W_DOWN"},
	{INTERFACEKEY_A_MOVE_NW_DOWN, "A_MOVE_NW_DOWN"},
	{INTERFACEKEY_A_MOVE_NE_DOWN, "A_MOVE_NE_DOWN"},
	{INTERFACEKEY_A_MOVE_SW_DOWN, "A_MOVE_SW_DOWN"},
	{INTERFACEKEY_A_MOVE_SE_DOWN, "A_MOVE_SE_DOWN"},
	{INTERFACEKEY_A_MOVE_DOWN, "A_MOVE_DOWN"},
	{INTERFACEKEY_A_MOVE_UP_AUX, "A_MOVE_UP_AUX"},
	{INTERFACEKEY_A_MOVE_DOWN_AUX, "A_MOVE_DOWN_AUX"},
	{INTERFACEKEY_WORLDGEN_EXPORT_MAP, "WORLDGEN_EXPORT_MAP"},
	{INTERFACEKEY_LEGENDS_EXPORT_MAP, "LEGENDS_EXPORT_MAP"},
	{INTERFACEKEY_LEGENDS_EXPORT_XML, "LEGENDS_EXPORT_XML"},
	{INTERFACEKEY_LEGENDS_EXPORT_DETAILED_MAP, "LEGENDS_EXPORT_DETAILED_MAP"},
	{INTERFACEKEY_LEGENDS_TOGGLE_CIVSITE, "LEGENDS_TOGGLE_CIVSITE"},
	{INTERFACEKEY_LEGENDS_STRING_FILTER, "LEGENDS_STRING_FILTER"},
	{INTERFACEKEY_A_COMBAT_ATTACK, "A_COMBAT_ATTACK"},
	{INTERFACEKEY_A_COMBAT_DODGE, "A_COMBAT_DODGE"},
	{INTERFACEKEY_A_COMBAT_CHARGEDEF, "A_COMBAT_CHARGEDEF"},
	{INTERFACEKEY_A_STATUS, "A_STATUS"},
	{INTERFACEKEY_A_STATUS_WRESTLE, "A_STATUS_WRESTLE"},
	{INTERFACEKEY_A_STATUS_CUSTOMIZE, "A_STATUS_CUSTOMIZE"},
	{INTERFACEKEY_A_STATUS_KILLS, "A_STATUS_KILLS"},
	{INTERFACEKEY_A_STATUS_HEALTH, "A_STATUS_HEALTH"},
	{INTERFACEKEY_A_STATUS_ATT_SKILL, "A_STATUS_ATT_SKILL"},
	{INTERFACEKEY_A_STATUS_DESC, "A_STATUS_DESC"},
	{INTERFACEKEY_UNITVIEW_CUSTOMIZE, "UNITVIEW_CUSTOMIZE"},
	{INTERFACEKEY_UNITVIEW_HEALTH, "UNITVIEW_HEALTH"},
	{INTERFACEKEY_UNITVIEW_RELATIONSHIPS, "UNITVIEW_RELATIONSHIPS"},
	{INTERFACEKEY_UNITVIEW_RELATIONSHIPS_ZOOM, "UNITVIEW_RELATIONSHIPS_ZOOM"},
	{INTERFACEKEY_UNITVIEW_RELATIONSHIPS_VIEW, "UNITVIEW_RELATIONSHIPS_VIEW"},
	{INTERFACEKEY_UNITVIEW_KILLS, "UNITVIEW_KILLS"},
	{INTERFACEKEY_CUSTOMIZE_UNIT_NICKNAME, "CUSTOMIZE_UNIT_NICKNAME"},
	{INTERFACEKEY_CUSTOMIZE_UNIT_PROFNAME, "CUSTOMIZE_UNIT_PROFNAME"},
	{INTERFACEKEY_IMAGE_CREATOR_FILTER, "IMAGE_CREATOR_FILTER"},
	{INTERFACEKEY_IMAGE_CREATOR_NAME, "IMAGE_CREATOR_NAME"},
	{INTERFACEKEY_IMAGE_CREATOR_DONE, "IMAGE_CREATOR_DONE"},
	{INTERFACEKEY_CIV_RAID, "CIV_RAID"},
	{INTERFACEKEY_CIV_CENTER_ON_FORT, "CIV_CENTER_ON_FORT"},
	{INTERFACEKEY_CIV_HOLDINGS, "CIV_HOLDINGS"},
	{INTERFACEKEY_CIV_MAP_LEGEND, "CIV_MAP_LEGEND"},
	{INTERFACEKEY_CIV_REMOVE_MISSION, "CIV_REMOVE_MISSION"},
	{INTERFACEKEY_CIV_RESCUE, "CIV_RESCUE"},
	{INTERFACEKEY_CIV_RECOVER, "CIV_RECOVER"},
	{INTERFACEKEY_CIV_WORLD, "CIV_WORLD"},
	{INTERFACEKEY_CIV_MISSIONS, "CIV_MISSIONS"},
	{INTERFACEKEY_CIV_MISSION_DETAILS, "CIV_MISSION_DETAILS"},
	{INTERFACEKEY_CIV_MISSION_FREE_CAPTIVES, "CIV_MISSION_FREE_CAPTIVES"},
	{INTERFACEKEY_CIV_MISSION_RELEASE_OTHERS, "CIV_MISSION_RELEASE_OTHERS"},
	{INTERFACEKEY_CIV_MISSION_TAKE_ARTIFACTS, "CIV_MISSION_TAKE_ARTIFACTS"},
	{INTERFACEKEY_CIV_MISSION_TAKE_ITEMS, "CIV_MISSION_TAKE_ITEMS"},
	{INTERFACEKEY_CIV_MISSION_TAKE_LIVESTOCK, "CIV_MISSION_TAKE_LIVESTOCK"},
	{INTERFACEKEY_CIV_MISSION_RAID, "CIV_MISSION_RAID"},
	{INTERFACEKEY_CIV_MISSION_PILLAGE, "CIV_MISSION_PILLAGE"},
	{INTERFACEKEY_CIV_MISSION_RAZE, "CIV_MISSION_RAZE"},
	{INTERFACEKEY_CIV_MISSION_TRIBUTE_ONE_TIME, "CIV_MISSION_TRIBUTE_ONE_TIME"},
	{INTERFACEKEY_CIV_MISSION_TRIBUTE_ONGOING, "CIV_MISSION_TRIBUTE_ONGOING"},
	{INTERFACEKEY_CIV_MISSION_CONQUER, "CIV_MISSION_CONQUER"},
	{INTERFACEKEY_CIV_MISSION_DEMAND_SURRENDER, "CIV_MISSION_DEMAND_SURRENDER"},
	{INTERFACEKEY_CIV_NEWS, "CIV_NEWS"},
	{INTERFACEKEY_CIV_PEOPLE, "CIV_PEOPLE"},
	{INTERFACEKEY_CIV_ARTIFACTS, "CIV_ARTIFACTS"},
	{INTERFACEKEY_CIV_CIVS, "CIV_CIVS"},
	{INTERFACEKEY_A_CLEAR_ANNOUNCEMENTS, "A_CLEAR_ANNOUNCEMENTS"},
	{INTERFACEKEY_A_SLEEP, "A_SLEEP"},
	{INTERFACEKEY_A_SLEEP_SLEEP, "A_SLEEP_SLEEP"},
	{INTERFACEKEY_A_SLEEP_WAIT, "A_SLEEP_WAIT"},
	{INTERFACEKEY_A_SLEEP_DAWN, "A_SLEEP_DAWN"},
	{INTERFACEKEY_A_WAIT, "A_WAIT"},
	{INTERFACEKEY_A_SHORT_WAIT, "A_SHORT_WAIT"},
	{INTERFACEKEY_A_ATTACK, "A_ATTACK"},
	{INTERFACEKEY_A_ATTACK_CONFIRM, "A_ATTACK_CONFIRM"},
	{INTERFACEKEY_QUICK_ATTACK, "QUICK_ATTACK"},
	{INTERFACEKEY_HEAVY_ATTACK, "HEAVY_ATTACK"},
	{INTERFACEKEY_WILD_ATTACK, "WILD_ATTACK"},
	{INTERFACEKEY_PRECISE_ATTACK, "PRECISE_ATTACK"},
	{INTERFACEKEY_CHARGE_ATTACK, "CHARGE_ATTACK"},
	{INTERFACEKEY_MULTI_ATTACK, "MULTI_ATTACK"},
	{INTERFACEKEY_A_LOOK, "A_LOOK"},
	{INTERFACEKEY_A_SEARCH, "A_SEARCH"},
	{INTERFACEKEY_A_ODOR, A_ODOR},
	{INTERFACEKEY_A_DISPLAY_ODOR, A_DISPLAY_ODOR},
	{INTERFACEKEY_A_YIELD, A_YIELD},
	{INTERFACEKEY_A_DISPLAY_TRACKS, A_DISPLAY_TRACKS},
	{INTERFACEKEY_A_FRESHEST_TRACK, A_FRESHEST_TRACK},
	{INTERFACEKEY_A_INV_DRAW_WEAPON, A_INV_DRAW_WEAPON},
	{INTERFACEKEY_A_JUMP, A_JUMP},
	{INTERFACEKEY_A_HOLD, A_HOLD},
	{INTERFACEKEY_A_TALK, "A_TALK"},
	{INTERFACEKEY_A_CONV_PERSUADE, "A_CONV_PERSUADE"},
	{INTERFACEKEY_A_CONV_INTIMIDATE, "A_CONV_INTIMIDATE"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_NEW, "A_ASSUME_IDENTITY_NEW"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_NONE, "A_ASSUME_IDENTITY_NONE"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_NAME, "A_ASSUME_IDENTITY_NAME"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_ORIGIN, "A_ASSUME_IDENTITY_ORIGIN"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_PROFESSION, "A_ASSUME_IDENTITY_PROFESSION"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_WORSHIP, "A_ASSUME_IDENTITY_WORSHIP"},
	{INTERFACEKEY_A_INTERACT, "A_INTERACT"},
	{INTERFACEKEY_A_ACTION, "A_ACTION"},
	{INTERFACEKEY_A_ACTION_CREATE, "A_ACTION_CREATE"},
	{INTERFACEKEY_A_ACTION_BUTCHER, "A_ACTION_BUTCHER"},
	{INTERFACEKEY_A_ACTION_ABILITY, "A_ACTION_ABILITY"},
	{INTERFACEKEY_A_ACTION_POWER, "A_ACTION_POWER"},
	{INTERFACEKEY_A_ACTION_COMPOSE, "A_ACTION_COMPOSE"},
	{INTERFACEKEY_A_ACTION_WRITE, "A_ACTION_WRITE"},
	{INTERFACEKEY_A_CONSTRUCTION, "A_CONSTRUCTION"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_NEW, "ADV_CONSTRUCTION_ZONE_NEW"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_EDIT, "ADV_CONSTRUCTION_ZONE_EDIT"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_ASSIGN, "ADV_CONSTRUCTION_ZONE_ASSIGN"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_DELETE, "ADV_CONSTRUCTION_ZONE_DELETE"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_RECT, "ADV_CONSTRUCTION_ZONE_RECT"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_FLOW, "ADV_CONSTRUCTION_ZONE_FLOW"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_REMOVE_RECT, "ADV_CONSTRUCTION_ZONE_REMOVE_RECT"},
	{INTERFACEKEY_ADV_CONSTRUCTION_STAIR_UPDOWN, "ADV_CONSTRUCTION_STAIR_UPDOWN"},
	{INTERFACEKEY_ADV_CONSTRUCTION_REMOVE_PLANS, "ADV_CONSTRUCTION_REMOVE_PLANS"},
	{INTERFACEKEY_ADV_CONSTRUCTION_REMOVE_EXISTING, "ADV_CONSTRUCTION_REMOVE_EXISTING"},
	{INTERFACEKEY_ADV_CONSTRUCTION_MATERIAL, "ADV_CONSTRUCTION_MATERIAL"},
	{INTERFACEKEY_ADV_CONSTRUCTION_CONSTRUCTION, "ADV_CONSTRUCTION_CONSTRUCTION"},
	{INTERFACEKEY_ADV_CONSTRUCTION_BUILDING, "ADV_CONSTRUCTION_BUILDING"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE, "ADV_CONSTRUCTION_ZONE"},
	{INTERFACEKEY_ADV_CONSTRUCTION_WORK_MENU, "ADV_CONSTRUCTION_WORK_MENU"},
	{INTERFACEKEY_ADV_CONSTRUCTION_NAME_SITE, "ADV_CONSTRUCTION_NAME_SITE"},
	{INTERFACEKEY_ADV_CONSTRUCTION_YOU_WORK, "ADV_CONSTRUCTION_YOU_WORK"},
	{INTERFACEKEY_ADV_CONSTRUCTION_START, "ADV_CONSTRUCTION_START"},
	{INTERFACEKEY_A_COMPOSE_FILTER, "A_COMPOSE_FILTER"},
	{INTERFACEKEY_A_INV_LOOK, "A_INV_LOOK"},
	{INTERFACEKEY_A_INV_REMOVE, "A_INV_REMOVE"},
	{INTERFACEKEY_A_INV_WEAR, "A_INV_WEAR"},
	{INTERFACEKEY_A_INV_EATDRINK, "A_INV_EATDRINK"},
	{INTERFACEKEY_A_INV_PUTIN, "A_INV_PUTIN"},
	{INTERFACEKEY_A_INV_DROP, "A_INV_DROP"},
	{INTERFACEKEY_A_GROUND, "A_GROUND"},
	{INTERFACEKEY_A_THROW, "A_THROW"},
	{INTERFACEKEY_A_SHOOT, "A_SHOOT"},
	{INTERFACEKEY_A_ANNOUNCEMENTS, "A_ANNOUNCEMENTS"},
	{INTERFACEKEY_A_COMBAT, "A_COMBAT"},
	{INTERFACEKEY_A_TACTICAL_SETTINGS, "A_TACTICAL_SETTINGS"},
	{INTERFACEKEY_A_MOVEMENT, "A_MOVEMENT"},
	{INTERFACEKEY_A_MOVEMENT_SWIM, "A_MOVEMENT_SWIM"},
	{INTERFACEKEY_A_SNEAK, "A_SNEAK"},
	{INTERFACEKEY_A_SPEED_SNEAK, "A_SPEED_SNEAK"},
	{INTERFACEKEY_A_CENTER, "A_CENTER"},
	{INTERFACEKEY_A_COMPANIONS, "A_COMPANIONS"},
	{INTERFACEKEY_A_BUILDING, "A_BUILDING"},
	{INTERFACEKEY_A_TRAVEL, "A_TRAVEL"},
	{INTERFACEKEY_A_TRAVEL_SLEEP, "A_TRAVEL_SLEEP"},
	{INTERFACEKEY_A_TRAVEL_MAP, "A_TRAVEL_MAP"},
	{INTERFACEKEY_A_TRAVEL_HIDE_INSTRUCTIONS, "A_TRAVEL_HIDE_INSTRUCTIONS"},
	{INTERFACEKEY_A_DATE, "A_DATE"},
	{INTERFACEKEY_A_WEATHER, "A_WEATHER"},
	{INTERFACEKEY_A_TEMPERATURE, "A_TEMPERATURE"},
	{INTERFACEKEY_A_STANCE, "A_STANCE"},
	{INTERFACEKEY_OPTION1, "OPTION1"},
	{INTERFACEKEY_OPTION2, "OPTION2"},
	{INTERFACEKEY_OPTION3, "OPTION3"},
	{INTERFACEKEY_OPTION4, "OPTION4"},
	{INTERFACEKEY_OPTION5, "OPTION5"},
	{INTERFACEKEY_OPTION6, "OPTION6"},
	{INTERFACEKEY_OPTION7, "OPTION7"},
	{INTERFACEKEY_OPTION8, "OPTION8"},
	{INTERFACEKEY_OPTION9, "OPTION9"},
	{INTERFACEKEY_OPTION10, "OPTION10"},
	{INTERFACEKEY_OPTION11, "OPTION11"},
	{INTERFACEKEY_OPTION12, "OPTION12"},
	{INTERFACEKEY_OPTION13, "OPTION13"},
	{INTERFACEKEY_OPTION14, "OPTION14"},
	{INTERFACEKEY_OPTION15, "OPTION15"},
	{INTERFACEKEY_OPTION16, "OPTION16"},
	{INTERFACEKEY_OPTION17, "OPTION17"},
	{INTERFACEKEY_OPTION18, "OPTION18"},
	{INTERFACEKEY_OPTION19, "OPTION19"},
	{INTERFACEKEY_OPTION20, "OPTION20"},
	{INTERFACEKEY_SEC_OPTION1, "SEC_OPTION1"},
	{INTERFACEKEY_SEC_OPTION2, "SEC_OPTION2"},
	{INTERFACEKEY_SEC_OPTION3, "SEC_OPTION3"},
	{INTERFACEKEY_SEC_OPTION4, "SEC_OPTION4"},
	{INTERFACEKEY_SEC_OPTION5, "SEC_OPTION5"},
	{INTERFACEKEY_SEC_OPTION6, "SEC_OPTION6"},
	{INTERFACEKEY_SEC_OPTION7, "SEC_OPTION7"},
	{INTERFACEKEY_SEC_OPTION8, "SEC_OPTION8"},
	{INTERFACEKEY_SEC_OPTION9, "SEC_OPTION9"},
	{INTERFACEKEY_SEC_OPTION10, "SEC_OPTION10"},
	{INTERFACEKEY_SEC_OPTION11, "SEC_OPTION11"},
	{INTERFACEKEY_SEC_OPTION12, "SEC_OPTION12"},
	{INTERFACEKEY_SEC_OPTION13, "SEC_OPTION13"},
	{INTERFACEKEY_SEC_OPTION14, "SEC_OPTION14"},
	{INTERFACEKEY_SEC_OPTION15, "SEC_OPTION15"},
	{INTERFACEKEY_SEC_OPTION16, "SEC_OPTION16"},
	{INTERFACEKEY_SEC_OPTION17, "SEC_OPTION17"},
	{INTERFACEKEY_SEC_OPTION18, "SEC_OPTION18"},
	{INTERFACEKEY_SEC_OPTION19, "SEC_OPTION19"},
	{INTERFACEKEY_SEC_OPTION20, "SEC_OPTION20"},
	{INTERFACEKEY_HOTKEY_MAKE_ASH, "HOTKEY_MAKE_ASH"},
	{INTERFACEKEY_HOTKEY_MAKE_CHARCOAL, "HOTKEY_MAKE_CHARCOAL"},
	{INTERFACEKEY_HOTKEY_MELT_OBJECT, "HOTKEY_MELT_OBJECT"},
	{INTERFACEKEY_HOTKEY_GLASS_GREEN, "HOTKEY_GLASS_GREEN"},
	{INTERFACEKEY_HOTKEY_GLASS_CLEAR, "HOTKEY_GLASS_CLEAR"},
	{INTERFACEKEY_HOTKEY_GLASS_CRYSTAL, "HOTKEY_GLASS_CRYSTAL"},
	{INTERFACEKEY_HOTKEY_COLLECT_SAND, "HOTKEY_COLLECT_SAND"},
	{INTERFACEKEY_HOTKEY_COLLECT_CLAY, "HOTKEY_COLLECT_CLAY"},
	{INTERFACEKEY_HOTKEY_GLASS_ROUGH, "HOTKEY_GLASS_ROUGH"},
	{INTERFACEKEY_HOTKEY_GLASS_ARMORSTAND, "HOTKEY_GLASS_ARMORSTAND"},
	{INTERFACEKEY_HOTKEY_GLASS_BOX, "HOTKEY_GLASS_BOX"},
	{INTERFACEKEY_HOTKEY_GLASS_CABINET, "HOTKEY_GLASS_CABINET"},
	{INTERFACEKEY_HOTKEY_GLASS_COFFIN, "HOTKEY_GLASS_COFFIN"},
	{INTERFACEKEY_HOTKEY_GLASS_FLOODGATE, "HOTKEY_GLASS_FLOODGATE"},
	{INTERFACEKEY_HOTKEY_GLASS_HATCH_COVER, "HOTKEY_GLASS_HATCH_COVER"},
	{INTERFACEKEY_HOTKEY_GLASS_GRATE, "HOTKEY_GLASS_GRATE"},
	{INTERFACEKEY_HOTKEY_GLASS_GOBLET, "HOTKEY_GLASS_GOBLET"},
	{INTERFACEKEY_HOTKEY_GLASS_TOY, "HOTKEY_GLASS_TOY"},
	{INTERFACEKEY_HOTKEY_GLASS_DOOR, "HOTKEY_GLASS_DOOR"},
	{INTERFACEKEY_HOTKEY_GLASS_STATUE, "HOTKEY_GLASS_STATUE"},
	{INTERFACEKEY_HOTKEY_GLASS_TABLE, "HOTKEY_GLASS_TABLE"},
	{INTERFACEKEY_HOTKEY_GLASS_CAGE, "HOTKEY_GLASS_CAGE"},
	{INTERFACEKEY_HOTKEY_GLASS_CHAIR, "HOTKEY_GLASS_CHAIR"},
	{INTERFACEKEY_HOTKEY_GLASS_BLOCKS, "HOTKEY_GLASS_BLOCKS"},
	{INTERFACEKEY_HOTKEY_GLASS_FLASK, "HOTKEY_GLASS_FLASK"},
	{INTERFACEKEY_HOTKEY_GLASS_WEAPONRACK, "HOTKEY_GLASS_WEAPONRACK"},
	{INTERFACEKEY_HOTKEY_GLASS_WINDOW, "HOTKEY_GLASS_WINDOW"},
	{INTERFACEKEY_HOTKEY_ASHERY_LYE, "HOTKEY_ASHERY_LYE"},
	{INTERFACEKEY_HOTKEY_ASHERY_POTASH, "HOTKEY_ASHERY_POTASH"},
	{INTERFACEKEY_HOTKEY_ASHERY_POTASH_DIRECT, "HOTKEY_ASHERY_POTASH_DIRECT"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BARREL, "HOTKEY_CARPENTER_BARREL"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BLOCKS, "HOTKEY_CARPENTER_BLOCKS"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BUCKET, "HOTKEY_CARPENTER_BUCKET"},
	{INTERFACEKEY_HOTKEY_CARPENTER_TRAP_ANIMAL, "HOTKEY_CARPENTER_TRAP_ANIMAL"},
	{INTERFACEKEY_HOTKEY_CARPENTER_CAGE, "HOTKEY_CARPENTER_CAGE"},
	{INTERFACEKEY_HOTKEY_CARPENTER_ARMORSTAND, "HOTKEY_CARPENTER_ARMORSTAND"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BED, "HOTKEY_CARPENTER_BED"},
	{INTERFACEKEY_HOTKEY_CARPENTER_CHAIR, "HOTKEY_CARPENTER_CHAIR"},
	{INTERFACEKEY_HOTKEY_CARPENTER_COFFIN, "HOTKEY_CARPENTER_COFFIN"},
	{INTERFACEKEY_HOTKEY_CARPENTER_DOOR, "HOTKEY_CARPENTER_DOOR"},
	{INTERFACEKEY_HOTKEY_CARPENTER_FLOODGATE, "HOTKEY_CARPENTER_FLOODGATE"},
	{INTERFACEKEY_HOTKEY_CARPENTER_HATCH_COVER, "HOTKEY_CARPENTER_HATCH_COVER"},
	{INTERFACEKEY_HOTKEY_CARPENTER_GRATE, "HOTKEY_CARPENTER_GRATE"},
	{INTERFACEKEY_HOTKEY_CARPENTER_CABINET, "HOTKEY_CARPENTER_CABINET"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BIN, "HOTKEY_CARPENTER_BIN"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BOX, "HOTKEY_CARPENTER_BOX"},
	{INTERFACEKEY_HOTKEY_CARPENTER_WEAPONRACK, "HOTKEY_CARPENTER_WEAPONRACK"},
	{INTERFACEKEY_HOTKEY_CARPENTER_TABLE, "HOTKEY_CARPENTER_TABLE"},
	{INTERFACEKEY_HOTKEY_SIEGE_BALLISTA, "HOTKEY_SIEGE_BALLISTA"},
	{INTERFACEKEY_HOTKEY_SIEGE_CATAPULT, "HOTKEY_SIEGE_CATAPULT"},
	{INTERFACEKEY_HOTKEY_LEATHER_BOX, "HOTKEY_LEATHER_BOX"},
	{INTERFACEKEY_HOTKEY_LEATHER_FLASK, "HOTKEY_LEATHER_FLASK"},
	{INTERFACEKEY_HOTKEY_LEATHER_SHIRT, "HOTKEY_LEATHER_SHIRT"},
	{INTERFACEKEY_HOTKEY_LEATHER_CLOAK, "HOTKEY_LEATHER_CLOAK"},
	{INTERFACEKEY_HOTKEY_LEATHER_BACKPACK, "HOTKEY_LEATHER_BACKPACK"},
	{INTERFACEKEY_HOTKEY_LEATHER_QUIVER, "HOTKEY_LEATHER_QUIVER"},
	{INTERFACEKEY_HOTKEY_LEATHER_IMAGE, "HOTKEY_LEATHER_IMAGE"},
	{INTERFACEKEY_HOTKEY_CLOTHES_MAT_PLANT, "HOTKEY_CLOTHES_MAT_PLANT"},
	{INTERFACEKEY_HOTKEY_CLOTHES_MAT_SILK, "HOTKEY_CLOTHES_MAT_SILK"},
	{INTERFACEKEY_HOTKEY_CLOTHES_MAT_YARN, "HOTKEY_CLOTHES_MAT_YARN"},
	{INTERFACEKEY_HOTKEY_CLOTHES_SHIRT, "HOTKEY_CLOTHES_SHIRT"},
	{INTERFACEKEY_HOTKEY_CLOTHES_CLOAK, "HOTKEY_CLOTHES_CLOAK"},
	{INTERFACEKEY_HOTKEY_CLOTHES_BOX, "HOTKEY_CLOTHES_BOX"},
	{INTERFACEKEY_HOTKEY_CLOTHES_CHAIN, "HOTKEY_CLOTHES_CHAIN"},
	{INTERFACEKEY_HOTKEY_CLOTHES_IMAGE, "HOTKEY_CLOTHES_IMAGE"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_STONE, "HOTKEY_CRAFTS_MAT_STONE"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_WOOD, "HOTKEY_CRAFTS_MAT_WOOD"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_BONE, "HOTKEY_CRAFTS_DEC_BONE"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_SHELL, "HOTKEY_CRAFTS_DEC_SHELL"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_TOOTH, "HOTKEY_CRAFTS_DEC_TOOTH"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_HORN, "HOTKEY_CRAFTS_DEC_HORN"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_PEARL, "HOTKEY_CRAFTS_DEC_PEARL"},
	{INTERFACEKEY_HOTKEY_CRAFTS_TOTEM, "HOTKEY_CRAFTS_TOTEM"},
	{INTERFACEKEY_HOTKEY_CRAFTS_CLOTH, "HOTKEY_CRAFTS_CLOTH"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SILK, "HOTKEY_CRAFTS_SILK"},
	{INTERFACEKEY_HOTKEY_CRAFTS_YARN, "HOTKEY_CRAFTS_YARN"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SEL_WOOD, "HOTKEY_CRAFTS_SEL_WOOD"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SEL_BONE, "HOTKEY_CRAFTS_SEL_BONE"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SEL_SHELL, "HOTKEY_CRAFTS_SEL_SHELL"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SHELL, "HOTKEY_CRAFTS_SHELL"},
	{INTERFACEKEY_HOTKEY_CRAFTS_TOOTH, "HOTKEY_CRAFTS_TOOTH"},
	{INTERFACEKEY_HOTKEY_CRAFTS_HORN, "HOTKEY_CRAFTS_HORN"},
	{INTERFACEKEY_HOTKEY_CRAFTS_PEARL, "HOTKEY_CRAFTS_PEARL"},
	{INTERFACEKEY_HOTKEY_CRAFTS_BONE, "HOTKEY_CRAFTS_BONE"},
	{INTERFACEKEY_HOTKEY_CRAFTS_LEATHER, "HOTKEY_CRAFTS_LEATHER"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SLAB, "HOTKEY_CRAFTS_SLAB"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_CRAFTS, "HOTKEY_CRAFTS_MAT_CRAFTS"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_GOBLET, "HOTKEY_CRAFTS_MAT_GOBLET"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_TOY, "HOTKEY_CRAFTS_MAT_TOY"},
	{INTERFACEKEY_HOTKEY_SMITH_WEAPON, "HOTKEY_SMITH_WEAPON"},
	{INTERFACEKEY_HOTKEY_SMITH_ARMOR, "HOTKEY_SMITH_ARMOR"},
	{INTERFACEKEY_HOTKEY_SMITH_FURNITURE, "HOTKEY_SMITH_FURNITURE"},
	{INTERFACEKEY_HOTKEY_SMITH_SIEGE, "HOTKEY_SMITH_SIEGE"},
	{INTERFACEKEY_HOTKEY_SMITH_TRAP, "HOTKEY_SMITH_TRAP"},
	{INTERFACEKEY_HOTKEY_SMITH_OTHER, "HOTKEY_SMITH_OTHER"},
	{INTERFACEKEY_HOTKEY_SMITH_METAL, "HOTKEY_SMITH_METAL"},
	*/
	{INTERFACEKEY_HOTKEY_BUILDING_ARMORSTAND, "HOTKEY_BUILDING_ARMORSTAND"},
	{INTERFACEKEY_HOTKEY_BUILDING_BED, "HOTKEY_BUILDING_BED"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRACTION_BENCH, "HOTKEY_BUILDING_TRACTION_BENCH"},
	{INTERFACEKEY_HOTKEY_BUILDING_SLAB, "HOTKEY_BUILDING_SLAB"},
	{INTERFACEKEY_HOTKEY_BUILDING_NEST_BOX, "HOTKEY_BUILDING_NEST_BOX"},
	{INTERFACEKEY_HOTKEY_BUILDING_BOOKCASE, "HOTKEY_BUILDING_BOOKCASE"},
	{INTERFACEKEY_HOTKEY_BUILDING_HIVE, "HOTKEY_BUILDING_HIVE"},
	{INTERFACEKEY_HOTKEY_BUILDING_DISPLAY_FURNITURE, "HOTKEY_BUILDING_DISPLAY_FURNITURE"},
	{INTERFACEKEY_HOTKEY_BUILDING_OFFERING_PLACE, "HOTKEY_BUILDING_OFFERING_PLACE"},
	{INTERFACEKEY_HOTKEY_BUILDING_CHAIR, "HOTKEY_BUILDING_CHAIR"},
	{INTERFACEKEY_HOTKEY_BUILDING_COFFIN, "HOTKEY_BUILDING_COFFIN"},
	{INTERFACEKEY_HOTKEY_BUILDING_DOOR, "HOTKEY_BUILDING_DOOR"},
	{INTERFACEKEY_HOTKEY_BUILDING_FLOODGATE, "HOTKEY_BUILDING_FLOODGATE"},
	{INTERFACEKEY_HOTKEY_BUILDING_HATCH, "HOTKEY_BUILDING_HATCH"},
	{INTERFACEKEY_HOTKEY_BUILDING_GRATE_WALL, "HOTKEY_BUILDING_GRATE_WALL"},
	{INTERFACEKEY_HOTKEY_BUILDING_GRATE_FLOOR, "HOTKEY_BUILDING_GRATE_FLOOR"},
	{INTERFACEKEY_HOTKEY_BUILDING_BARS_VERTICAL, "HOTKEY_BUILDING_BARS_VERTICAL"},
	{INTERFACEKEY_HOTKEY_BUILDING_BARS_FLOOR, "HOTKEY_BUILDING_BARS_FLOOR"},
	{INTERFACEKEY_HOTKEY_BUILDING_CABINET, "HOTKEY_BUILDING_CABINET"},
	{INTERFACEKEY_HOTKEY_BUILDING_BOX, "HOTKEY_BUILDING_BOX"},
	{INTERFACEKEY_HOTKEY_BUILDING_KENNEL, "HOTKEY_BUILDING_KENNEL"},
	{INTERFACEKEY_HOTKEY_BUILDING_FARMPLOT, "HOTKEY_BUILDING_FARMPLOT"},
	{INTERFACEKEY_HOTKEY_BUILDING_WEAPONRACK, "HOTKEY_BUILDING_WEAPONRACK"},
	{INTERFACEKEY_HOTKEY_BUILDING_STATUE, "HOTKEY_BUILDING_STATUE"},
	{INTERFACEKEY_HOTKEY_BUILDING_TABLE, "HOTKEY_BUILDING_TABLE"},
	{INTERFACEKEY_HOTKEY_BUILDING_ROAD_DIRT, "HOTKEY_BUILDING_ROAD_DIRT"},
	{INTERFACEKEY_HOTKEY_BUILDING_ROAD_PAVED, "HOTKEY_BUILDING_ROAD_PAVED"},
	{INTERFACEKEY_HOTKEY_BUILDING_BRIDGE, "HOTKEY_BUILDING_BRIDGE"},
	{INTERFACEKEY_HOTKEY_BUILDING_WELL, "HOTKEY_BUILDING_WELL"},
	//{INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE, "HOTKEY_BUILDING_SIEGEENGINE"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP, "HOTKEY_BUILDING_WORKSHOP"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE, "HOTKEY_BUILDING_FURNACE"},
	{INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GLASS, "HOTKEY_BUILDING_WINDOW_GLASS"},
	{INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GEM, "HOTKEY_BUILDING_WINDOW_GEM"},
	//{INTERFACEKEY_HOTKEY_BUILDING_SHOP, "HOTKEY_BUILDING_SHOP"},
	{INTERFACEKEY_HOTKEY_BUILDING_ANIMALTRAP, "HOTKEY_BUILDING_ANIMALTRAP"},
	{INTERFACEKEY_HOTKEY_BUILDING_CHAIN, "HOTKEY_BUILDING_CHAIN"},
	{INTERFACEKEY_HOTKEY_BUILDING_CAGE, "HOTKEY_BUILDING_CAGE"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRADEDEPOT, "HOTKEY_BUILDING_TRADEDEPOT"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP, "HOTKEY_BUILDING_TRAP"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE, "HOTKEY_BUILDING_MACHINE"},
	{INTERFACEKEY_HOTKEY_BUILDING_INSTRUMENT, "HOTKEY_BUILDING_INSTRUMENT"},
	{INTERFACEKEY_HOTKEY_BUILDING_SUPPORT, "HOTKEY_BUILDING_SUPPORT"},
	{INTERFACEKEY_HOTKEY_BUILDING_ARCHERYTARGET, "HOTKEY_BUILDING_ARCHERYTARGET"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNITURE, "HOTKEY_BUILDING_FURNITURE"},
	{INTERFACEKEY_HOTKEY_BUILDING_PORTALS, "HOTKEY_BUILDING_PORTALS"},
	{INTERFACEKEY_HOTKEY_BUILDING_CAGES_CHAINS, "HOTKEY_BUILDING_CAGES_CHAINS"},
	{INTERFACEKEY_HOTKEY_BUILDING_MILITARY, "HOTKEY_BUILDING_MILITARY"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOPS_CLOTHING_LEATHER, "HOTKEY_BUILDING_WORKSHOPS_CLOTHING_LEATHER"},
	{INTERFACEKEY_HOTKEY_BUILDING_FARMING, "HOTKEY_BUILDING_FARMING"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_SCREW_PUMP, "HOTKEY_BUILDING_MACHINE_SCREW_PUMP"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WATER_WHEEL, "HOTKEY_BUILDING_MACHINE_WATER_WHEEL"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WINDMILL, "HOTKEY_BUILDING_MACHINE_WINDMILL"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY, "HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL, "HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL, "HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_ROLLERS, "HOTKEY_BUILDING_MACHINE_ROLLERS"},
	{INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_BALLISTA, "HOTKEY_BUILDING_SIEGEENGINE_BALLISTA"},
	{INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_CATAPULT, "HOTKEY_BUILDING_SIEGEENGINE_CATAPULT"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_STONE, "HOTKEY_BUILDING_TRAP_STONE"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_WEAPON, "HOTKEY_BUILDING_TRAP_WEAPON"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_LEVER, "HOTKEY_BUILDING_TRAP_LEVER"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_TRIGGER, "HOTKEY_BUILDING_TRAP_TRIGGER"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_CAGE, "HOTKEY_BUILDING_TRAP_CAGE"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_SPIKE, "HOTKEY_BUILDING_TRAP_SPIKE"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION, "HOTKEY_BUILDING_CONSTRUCTION"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION, "HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_WALL, "HOTKEY_BUILDING_CONSTRUCTION_WALL"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FLOOR, "HOTKEY_BUILDING_CONSTRUCTION_FLOOR"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_RAMP, "HOTKEY_BUILDING_CONSTRUCTION_RAMP"},
	//{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP, "HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP"},
	//{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN, "HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN, "HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK, "HOTKEY_BUILDING_CONSTRUCTION_TRACK"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK_STOP, "HOTKEY_BUILDING_CONSTRUCTION_TRACK_STOP"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LEATHER, "HOTKEY_BUILDING_WORKSHOP_LEATHER"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_QUERN, "HOTKEY_BUILDING_WORKSHOP_QUERN"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MILLSTONE, "HOTKEY_BUILDING_WORKSHOP_MILLSTONE"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LOOM, "HOTKEY_BUILDING_WORKSHOP_LOOM"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CLOTHES, "HOTKEY_BUILDING_WORKSHOP_CLOTHES"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BOWYER, "HOTKEY_BUILDING_WORKSHOP_BOWYER"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CARPENTER, "HOTKEY_BUILDING_WORKSHOP_CARPENTER"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_METALSMITH, "HOTKEY_BUILDING_WORKSHOP_METALSMITH"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LAVAMILL, "HOTKEY_BUILDING_WORKSHOP_LAVAMILL"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_JEWELER, "HOTKEY_BUILDING_WORKSHOP_JEWELER"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MASON, "HOTKEY_BUILDING_WORKSHOP_MASON"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BUTCHER, "HOTKEY_BUILDING_WORKSHOP_BUTCHER"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_TANNER, "HOTKEY_BUILDING_WORKSHOP_TANNER"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_DYER, "HOTKEY_BUILDING_WORKSHOP_DYER"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN, "HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_SIEGE, "HOTKEY_BUILDING_WORKSHOP_SIEGE"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MECHANIC, "HOTKEY_BUILDING_WORKSHOP_MECHANIC"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_STILL, "HOTKEY_BUILDING_WORKSHOP_STILL"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FARMER, "HOTKEY_BUILDING_WORKSHOP_FARMER"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_KITCHEN, "HOTKEY_BUILDING_WORKSHOP_KITCHEN"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FISHERY, "HOTKEY_BUILDING_WORKSHOP_FISHERY"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_ASHERY, "HOTKEY_BUILDING_WORKSHOP_ASHERY"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_WOOD, "HOTKEY_BUILDING_FURNACE_WOOD"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER, "HOTKEY_BUILDING_FURNACE_SMELTER"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS, "HOTKEY_BUILDING_FURNACE_GLASS"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN, "HOTKEY_BUILDING_FURNACE_KILN"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER_LAVA, "HOTKEY_BUILDING_FURNACE_SMELTER_LAVA"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS_LAVA, "HOTKEY_BUILDING_FURNACE_GLASS_LAVA"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN_LAVA, "HOTKEY_BUILDING_FURNACE_KILN_LAVA"},
	/*
	{INTERFACEKEY_HIVE_INSTALL_COLONY, "HIVE_INSTALL_COLONY"},
	{INTERFACEKEY_HIVE_GATHER_PRODUCTS, "HIVE_GATHER_PRODUCTS"},
	*/
	{INTERFACEKEY_D_ONESTEP, "D_ONESTEP"},
	{INTERFACEKEY_D_PAUSE, "D_PAUSE"},
	//{INTERFACEKEY_D_DEPOT, "D_DEPOT"},
	{INTERFACEKEY_D_HOT_KEYS, "D_HOT_KEYS"},
	{INTERFACEKEY_D_HOTKEY1, "D_HOTKEY1"},
	{INTERFACEKEY_D_HOTKEY2, "D_HOTKEY2"},
	{INTERFACEKEY_D_HOTKEY3, "D_HOTKEY3"},
	{INTERFACEKEY_D_HOTKEY4, "D_HOTKEY4"},
	{INTERFACEKEY_D_HOTKEY5, "D_HOTKEY5"},
	{INTERFACEKEY_D_HOTKEY6, "D_HOTKEY6"},
	{INTERFACEKEY_D_HOTKEY7, "D_HOTKEY7"},
	{INTERFACEKEY_D_HOTKEY8, "D_HOTKEY8"},
	{INTERFACEKEY_D_HOTKEY9, "D_HOTKEY9"},
	{INTERFACEKEY_D_HOTKEY10, "D_HOTKEY10"},
	{INTERFACEKEY_D_HOTKEY11, "D_HOTKEY11"},
	{INTERFACEKEY_D_HOTKEY12, "D_HOTKEY12"},
	{INTERFACEKEY_D_HOTKEY13, "D_HOTKEY13"},
	{INTERFACEKEY_D_HOTKEY14, "D_HOTKEY14"},
	{INTERFACEKEY_D_HOTKEY15, "D_HOTKEY15"},
	{INTERFACEKEY_D_HOTKEY16, "D_HOTKEY16"},

	{INTERFACEKEY_D_TOGGLE_RAMP_INDICATORS, "D_TOGGLE_RAMP_INDICATORS"},
	{INTERFACEKEY_D_TOGGLE_FLUID_NUMBERS, "D_TOGGLE_FLUID_NUMBERS"},

	{INTERFACEKEY_D_DESIGNATE_DIG, "D_DESIGNATE_DIG"},
	{INTERFACEKEY_D_DESIGNATE_CHOP, "D_DESIGNATE_CHOP"},
	{INTERFACEKEY_D_DESIGNATE_GATHER, "D_DESIGNATE_GATHER"},
	{INTERFACEKEY_D_DESIGNATE_SMOOTH, "D_DESIGNATE_SMOOTH"},
	{INTERFACEKEY_D_DESIGNATE_ITEMS, "D_DESIGNATE_ITEMS"},
	{INTERFACEKEY_D_DESIGNATE_TRAFFIC, "D_DESIGNATE_TRAFFIC"},
	{INTERFACEKEY_D_DESIGNATE_ERASE, "D_DESIGNATE_ERASE"},

	{INTERFACEKEY_D_BUILDING, "D_BUILDING"},
	{INTERFACEKEY_D_STOCKPILES, "D_STOCKPILES"},
	{INTERFACEKEY_D_CIVZONE, "D_CIVZONE"},
	{INTERFACEKEY_D_BURROWS, "D_BURROWS"},
	{INTERFACEKEY_D_HAULING, "D_HAULING"},

	{INTERFACEKEY_D_UNITLIST, "D_UNITLIST"},
	{INTERFACEKEY_D_JOBLIST, "D_JOBLIST"},
	{INTERFACEKEY_D_LOCATIONS, "D_LOCATIONS"},
	{INTERFACEKEY_D_LABOR, "D_LABOR"},
	{INTERFACEKEY_D_ORDERS, "D_ORDERS"},
	{INTERFACEKEY_D_NOBLES, "D_NOBLES"},
	{INTERFACEKEY_D_ARTLIST, "D_ARTLIST"},
	{INTERFACEKEY_D_SQUADS, "D_SQUADS"},
	{INTERFACEKEY_D_WORLD, "D_WORLD"},
	{INTERFACEKEY_D_JUSTICE, "D_JUSTICE"},

	{INTERFACEKEY_D_STOCKS, "D_STOCKS"},

	{INTERFACEKEY_D_ANNOUNCE, "D_ANNOUNCE"},

	{INTERFACEKEY_ARENA_CREATE_CREATURE, "ARENA_CREATE_CREATURE"},
	{INTERFACEKEY_ARENA_CREATURE_RESET, "ARENA_CREATURE_RESET"},
	{INTERFACEKEY_ARENA_FLUIDS, "ARENA_FLUIDS"},
	{INTERFACEKEY_ARENA_FLUIDS_WATER, "ARENA_FLUIDS_WATER"},
	{INTERFACEKEY_ARENA_FLUIDS_MAGMA, "ARENA_FLUIDS_MAGMA"},
	{INTERFACEKEY_ARENA_FLUIDS_SNOW, "ARENA_FLUIDS_SNOW"},
	{INTERFACEKEY_ARENA_FLUIDS_MUD, "ARENA_FLUIDS_MUD"},
	{INTERFACEKEY_ARENA_FLUIDS_REMOVE, "ARENA_FLUIDS_REMOVE"},
	{INTERFACEKEY_ARENA_CREATE_TREE, "ARENA_CREATE_TREE"},
	{INTERFACEKEY_ARENA_WEATHER, "ARENA_WEATHER"},
	{INTERFACEKEY_ARENA_CONFLICT_STATE_1, "ARENA_CONFLICT_STATE_1"},
	{INTERFACEKEY_ARENA_CONFLICT_STATE_2, "ARENA_CONFLICT_STATE_2"},
	{INTERFACEKEY_ARENA_MORALE, "ARENA_MORALE"},

	{INTERFACEKEY_RECENTER, "RECENTER"},
	{INTERFACEKEY_OPEN_SHEET, "OPEN_SHEET"},
	{INTERFACEKEY_FILTER, "FILTER"},

	{INTERFACEKEY_UNITLIST_RECENTER_JOB, "UNITLIST_RECENTER_JOB"},
	{INTERFACEKEY_UNITLIST_JOB_DETAILS, "UNITLIST_JOB_DETAILS"},

	{INTERFACEKEY_UNITLIST_SORT_NAME, "UNITLIST_SORT_NAME"},
	{INTERFACEKEY_UNITLIST_SORT_PROFA, "UNITLIST_SORT_CAT"},
	{INTERFACEKEY_UNITLIST_SORT_PROFB, "UNITLIST_SORT_PROF"},
	{INTERFACEKEY_UNITLIST_SORT_JOB, "UNITLIST_SORT_JOB"},
	{INTERFACEKEY_UNITLIST_SORT_HAPPINESS, "UNITLIST_SORT_HAPPINESS"},
	{INTERFACEKEY_UNITLIST_SORT_SKILLS, "UNITLIST_SORT_SKILLS"},
	{INTERFACEKEY_UNITLIST_SPECIALIZE, "UNITLIST_SPECIALIZE"},
	

	/*
	{INTERFACEKEY_D_HOTKEY_CHANGE_NAME, "D_HOTKEY_CHANGE_NAME"},
	{INTERFACEKEY_D_HOTKEY_ZOOM, "D_HOTKEY_ZOOM"},
	*/
	{INTERFACEKEY_D_ANNOUNCE, "D_ANNOUNCE"},
	/*
	{INTERFACEKEY_D_BUILDING, "D_BUILDING"},
	{INTERFACEKEY_D_CIVLIST, "D_CIVLIST"},
	{INTERFACEKEY_D_DESIGNATE, "D_DESIGNATE"},
	{INTERFACEKEY_D_ARTLIST, "D_ARTLIST"},
	{INTERFACEKEY_D_NOBLES, "D_NOBLES"},
	{INTERFACEKEY_D_ORDERS, "D_ORDERS"},
	{INTERFACEKEY_D_PETITIONS, "D_PETITIONS"},
	{INTERFACEKEY_D_LOCATIONS, "D_LOCATIONS"},
	{INTERFACEKEY_D_MILITARY, "D_MILITARY"},
	{INTERFACEKEY_D_MILITARY_CREATE_SQUAD, "D_MILITARY_CREATE_SQUAD"},
	{INTERFACEKEY_D_MILITARY_DISBAND_SQUAD, "D_MILITARY_DISBAND_SQUAD"},
	{INTERFACEKEY_D_MILITARY_CREATE_SUB_SQUAD, "D_MILITARY_CREATE_SUB_SQUAD"},
	{INTERFACEKEY_D_MILITARY_CANCEL_ORDERS, "D_MILITARY_CANCEL_ORDERS"},
	{INTERFACEKEY_D_MILITARY_POSITIONS, "D_MILITARY_POSITIONS"},
	{INTERFACEKEY_D_MILITARY_ALERTS, "D_MILITARY_ALERTS"},
	{INTERFACEKEY_D_MILITARY_ALERTS_ADD, "D_MILITARY_ALERTS_ADD"},
	{INTERFACEKEY_D_MILITARY_ALERTS_DELETE, "D_MILITARY_ALERTS_DELETE"},
	{INTERFACEKEY_D_MILITARY_ALERTS_SET, "D_MILITARY_ALERTS_SET"},
	{INTERFACEKEY_D_MILITARY_ALERTS_NAME, "D_MILITARY_ALERTS_NAME"},
	{INTERFACEKEY_D_MILITARY_ALERTS_SET_RETAIN, "D_MILITARY_ALERTS_SET_RETAIN"},
	{INTERFACEKEY_D_MILITARY_EQUIP, "D_MILITARY_EQUIP"},
	{INTERFACEKEY_D_MILITARY_EQUIP_CUSTOMIZE, "D_MILITARY_EQUIP_CUSTOMIZE"},
	{INTERFACEKEY_D_MILITARY_EQUIP_UNIFORM, "D_MILITARY_EQUIP_UNIFORM"},
	{INTERFACEKEY_D_MILITARY_EQUIP_PRIORITY, "D_MILITARY_EQUIP_PRIORITY"},
	{INTERFACEKEY_D_MILITARY_UNIFORMS, "D_MILITARY_UNIFORMS"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES, "D_MILITARY_SUPPLIES"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_DOWN, "D_MILITARY_SUPPLIES_WATER_DOWN"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_UP, "D_MILITARY_SUPPLIES_WATER_UP"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_DOWN, "D_MILITARY_SUPPLIES_FOOD_DOWN"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_UP, "D_MILITARY_SUPPLIES_FOOD_UP"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION, "D_MILITARY_AMMUNITION"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_ADD_ITEM, "D_MILITARY_AMMUNITION_ADD_ITEM"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_REMOVE_ITEM, "D_MILITARY_AMMUNITION_REMOVE_ITEM"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT, "D_MILITARY_AMMUNITION_LOWER_AMOUNT"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT, "D_MILITARY_AMMUNITION_RAISE_AMOUNT"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT_LOTS, "D_MILITARY_AMMUNITION_LOWER_AMOUNT_LOTS"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT_LOTS, "D_MILITARY_AMMUNITION_RAISE_AMOUNT_LOTS"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_MATERIAL, "D_MILITARY_AMMUNITION_MATERIAL"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_COMBAT, "D_MILITARY_AMMUNITION_COMBAT"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_TRAINING, "D_MILITARY_AMMUNITION_TRAINING"},
	{INTERFACEKEY_D_MILITARY_TRAINING, "D_MILITARY_TRAINING"},
	{INTERFACEKEY_D_MILITARY_SCHEDULE, "D_MILITARY_SCHEDULE"},
	{INTERFACEKEY_D_MILITARY_ADD_UNIFORM, "D_MILITARY_ADD_UNIFORM"},
	{INTERFACEKEY_D_MILITARY_DELETE_UNIFORM, "D_MILITARY_DELETE_UNIFORM"},
	{INTERFACEKEY_D_MILITARY_NAME_UNIFORM, "D_MILITARY_NAME_UNIFORM"},
	{INTERFACEKEY_D_MILITARY_NAME_SQUAD, "D_MILITARY_NAME_SQUAD"},
	{INTERFACEKEY_D_MILITARY_ADD_ARMOR, "D_MILITARY_ADD_ARMOR"},
	{INTERFACEKEY_D_MILITARY_ADD_PANTS, "D_MILITARY_ADD_PANTS"},
	{INTERFACEKEY_D_MILITARY_ADD_HELM, "D_MILITARY_ADD_HELM"},
	{INTERFACEKEY_D_MILITARY_ADD_GLOVES, "D_MILITARY_ADD_GLOVES"},
	{INTERFACEKEY_D_MILITARY_ADD_BOOTS, "D_MILITARY_ADD_BOOTS"},
	{INTERFACEKEY_D_MILITARY_ADD_SHIELD, "D_MILITARY_ADD_SHIELD"},
	{INTERFACEKEY_D_MILITARY_ADD_WEAPON, "D_MILITARY_ADD_WEAPON"},
	{INTERFACEKEY_D_MILITARY_ADD_MATERIAL, "D_MILITARY_ADD_MATERIAL"},
	{INTERFACEKEY_D_MILITARY_ADD_COLOR, "D_MILITARY_ADD_COLOR"},
	{INTERFACEKEY_D_MILITARY_REPLACE_CLOTHING, "D_MILITARY_REPLACE_CLOTHING"},
	{INTERFACEKEY_D_MILITARY_EXACT_MATCH, "D_MILITARY_EXACT_MATCH"},
	{INTERFACEKEY_D_ROOMS, "D_ROOMS"},
	{INTERFACEKEY_BUILDINGLIST_ZOOM_T, "BUILDINGLIST_ZOOM_T"},
	{INTERFACEKEY_BUILDINGLIST_ZOOM_Q, "BUILDINGLIST_ZOOM_Q"},
	{INTERFACEKEY_RECENTER_ON_LEVER, "RECENTER_ON_LEVER"},
	{INTERFACEKEY_ASSIGN_LOCATION, "ASSIGN_LOCATION"},
	{INTERFACEKEY_LOCATION_NEW, "LOCATION_NEW"},
	{INTERFACEKEY_LOCATION_RETIRE, "LOCATION_RETIRE"},
	{INTERFACEKEY_LOCATION_INN_TAVERN, "LOCATION_INN_TAVERN"},
	{INTERFACEKEY_LOCATION_TEMPLE, "LOCATION_TEMPLE"},
	{INTERFACEKEY_LOCATION_RECOGNIZE_PRIESTHOOD, "LOCATION_RECOGNIZE_PRIESTHOOD"},
	{INTERFACEKEY_LOCATION_LIBRARY, "LOCATION_LIBRARY"},
	{INTERFACEKEY_LOCATION_GUILDHALL, "LOCATION_GUILDHALL"},
	{INTERFACEKEY_LOCATION_MAIN_HALL, "LOCATION_MAIN_HALL"},
	{INTERFACEKEY_LOCATION_RENAME, "LOCATION_RENAME"},
	{INTERFACEKEY_LOCATION_DETAILS, "LOCATION_DETAILS"},
	{INTERFACEKEY_LOCATION_RESTRICTION, "LOCATION_RESTRICTION"},
	{INTERFACEKEY_LOCATION_SET_NUMBER_1, "LOCATION_SET_NUMBER_1"},
	{INTERFACEKEY_LOCATION_SET_NUMBER_2, "LOCATION_SET_NUMBER_2"},
	{INTERFACEKEY_D_SQUADS, "D_SQUADS"},
	{INTERFACEKEY_D_SQUADS_MOVE, "D_SQUADS_MOVE"},
	{INTERFACEKEY_D_SQUADS_KILL, "D_SQUADS_KILL"},
	{INTERFACEKEY_D_SQUADS_KILL_LIST, "D_SQUADS_KILL_LIST"},
	{INTERFACEKEY_D_SQUADS_KILL_RECT, "D_SQUADS_KILL_RECT"},
	{INTERFACEKEY_D_SQUADS_SCHEDULE, "D_SQUADS_SCHEDULE"},
	{INTERFACEKEY_D_SQUADS_CANCEL_ORDER, "D_SQUADS_CANCEL_ORDER"},
	{INTERFACEKEY_D_SQUADS_ALERT, "D_SQUADS_ALERT"},
	{INTERFACEKEY_D_SQUADS_SELECT_INDIVIDUALS, "D_SQUADS_SELECT_INDIVIDUALS"},
	{INTERFACEKEY_D_SQUADS_CENTER, "D_SQUADS_CENTER"},
	{INTERFACEKEY_D_SQUAD_SCH_SLEEP, "D_SQUAD_SCH_SLEEP"},
	{INTERFACEKEY_D_SQUAD_SCH_CIVILIAN_UNIFORM, "D_SQUAD_SCH_CIVILIAN_UNIFORM"},
	{INTERFACEKEY_D_SQUAD_SCH_GIVE_ORDER, "D_SQUAD_SCH_GIVE_ORDER"},
	{INTERFACEKEY_D_SQUAD_SCH_EDIT_ORDER, "D_SQUAD_SCH_EDIT_ORDER"},
	{INTERFACEKEY_D_SQUAD_SCH_CANCEL_ORDER, "D_SQUAD_SCH_CANCEL_ORDER"},
	{INTERFACEKEY_D_SQUAD_SCH_COPY_ORDERS, "D_SQUAD_SCH_COPY_ORDERS"},
	{INTERFACEKEY_D_SQUAD_SCH_PASTE_ORDERS, "D_SQUAD_SCH_PASTE_ORDERS"},
	{INTERFACEKEY_D_SQUAD_SCH_MS_NAME, "D_SQUAD_SCH_MS_NAME"},
	{INTERFACEKEY_D_STOCKPILES, "D_STOCKPILES"},
	{INTERFACEKEY_D_CIVZONE, "D_CIVZONE"},
	{INTERFACEKEY_D_VIEWUNIT, "D_VIEWUNIT"},
	{INTERFACEKEY_D_JOBLIST, "D_JOBLIST"},
	{INTERFACEKEY_D_UNITLIST, "D_UNITLIST"},
	{INTERFACEKEY_D_LOOK, "D_LOOK"},
	{INTERFACEKEY_D_HAULING, "D_HAULING"},
	{INTERFACEKEY_D_HAULING_NEW_ROUTE, "D_HAULING_NEW_ROUTE"},
	{INTERFACEKEY_D_HAULING_NEW_STOP, "D_HAULING_NEW_STOP"},
	{INTERFACEKEY_D_HAULING_REMOVE, "D_HAULING_REMOVE"},
	{INTERFACEKEY_D_HAULING_PROMOTE, "D_HAULING_PROMOTE"},
	{INTERFACEKEY_D_HAULING_VEHICLE, "D_HAULING_VEHICLE"},
	{INTERFACEKEY_D_HAULING_NICKNAME, "D_HAULING_NICKNAME"},
	{INTERFACEKEY_D_HAULING_STOP_NEW_DEPART, "D_HAULING_STOP_NEW_DEPART"},
	{INTERFACEKEY_D_HAULING_STOP_NEW_LINK, "D_HAULING_STOP_NEW_LINK"},
	{INTERFACEKEY_D_HAULING_STOP_REMOVE, "D_HAULING_STOP_REMOVE"},
	{INTERFACEKEY_D_HAULING_STOP_SL_SELECT_PILE, "D_HAULING_STOP_SL_SELECT_PILE"},
	{INTERFACEKEY_D_HAULING_STOP_SL_TAKE_GIVE, "D_HAULING_STOP_SL_TAKE_GIVE"},
	{INTERFACEKEY_D_HAULING_STOP_LC_DIR, "D_HAULING_STOP_LC_DIR"},
	{INTERFACEKEY_D_HAULING_STOP_LC_MODE, "D_HAULING_STOP_LC_MODE"},
	{INTERFACEKEY_D_HAULING_STOP_LC_TIMER_UP, "D_HAULING_STOP_LC_TIMER_UP"},
	{INTERFACEKEY_D_HAULING_STOP_LC_TIMER_DOWN, "D_HAULING_STOP_LC_TIMER_DOWN"},
	{INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_UP, "D_HAULING_STOP_LC_FULLNESS_UP"},
	{INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_DOWN, "D_HAULING_STOP_LC_FULLNESS_DOWN"},
	{INTERFACEKEY_D_HAULING_STOP_LC_MORE_LESS, "D_HAULING_STOP_LC_MORE_LESS"},
	{INTERFACEKEY_D_HAULING_STOP_LC_DESIRED_TOTAL, "D_HAULING_STOP_LC_DESIRED_TOTAL"},
	{INTERFACEKEY_D_HAULING_STOP_LC_CHANGE, "D_HAULING_STOP_LC_CHANGE"},
	{INTERFACEKEY_D_HAULING_STOP_LC_ADVANCED, "D_HAULING_STOP_LC_ADVANCED"},
	{INTERFACEKEY_D_BURROWS, "D_BURROWS"},
	{INTERFACEKEY_D_BURROWS_ADD, "D_BURROWS_ADD"},
	{INTERFACEKEY_D_BURROWS_DELETE, "D_BURROWS_DELETE"},
	{INTERFACEKEY_D_BURROWS_DEFINE, "D_BURROWS_DEFINE"},
	{INTERFACEKEY_D_BURROWS_ADD_UNIT, "D_BURROWS_ADD_UNIT"},
	{INTERFACEKEY_D_BURROWS_WORKSHOP_LIMIT, "D_BURROWS_WORKSHOP_LIMIT"},
	{INTERFACEKEY_D_BURROWS_CENTER, "D_BURROWS_CENTER"},
	{INTERFACEKEY_D_BURROWS_NAME, "D_BURROWS_NAME"},
	{INTERFACEKEY_D_BURROWS_CHANGE_SELECTION, "D_BURROWS_CHANGE_SELECTION"},
	{INTERFACEKEY_D_BURROWS_BRUSH, "D_BURROWS_BRUSH"},
	{INTERFACEKEY_D_BURROWS_REMOVE, "D_BURROWS_REMOVE"},
	{INTERFACEKEY_D_NOTE, "D_NOTE"},
	{INTERFACEKEY_D_NOTE_PLACE, "D_NOTE_PLACE"},
	{INTERFACEKEY_D_NOTE_DELETE, "D_NOTE_DELETE"},
	{INTERFACEKEY_D_NOTE_NAME, "D_NOTE_NAME"},
	{INTERFACEKEY_D_NOTE_ENTER, "D_NOTE_ENTER"},
	{INTERFACEKEY_D_NOTE_ADOPT_SYMBOL, "D_NOTE_ADOPT_SYMBOL"},
	{INTERFACEKEY_D_NOTE_CHANGE_SELECTION, "D_NOTE_CHANGE_SELECTION"},
	{INTERFACEKEY_D_NOTE_POINTS, "D_NOTE_POINTS"},
	{INTERFACEKEY_D_NOTE_ROUTE, "D_NOTE_ROUTE"},
	{INTERFACEKEY_D_NOTE_ROUTE_ADD, "D_NOTE_ROUTE_ADD"},
	{INTERFACEKEY_D_NOTE_ROUTE_EDIT, "D_NOTE_ROUTE_EDIT"},
	{INTERFACEKEY_D_NOTE_ROUTE_DELETE, "D_NOTE_ROUTE_DELETE"},
	{INTERFACEKEY_D_NOTE_ROUTE_CENTER, "D_NOTE_ROUTE_CENTER"},
	{INTERFACEKEY_D_NOTE_ROUTE_NAME, "D_NOTE_ROUTE_NAME"},
	{INTERFACEKEY_D_BUILDJOB, "D_BUILDJOB"},
	{INTERFACEKEY_D_STATUS, "D_STATUS"},
	{INTERFACEKEY_D_STATUS_OVERALL_HEALTH_RECENTER, "D_STATUS_OVERALL_HEALTH_RECENTER"},
	{INTERFACEKEY_D_BUILDITEM, "D_BUILDITEM"},
	{INTERFACEKEY_D_BITEM_FORBID, "D_BITEM_FORBID"},
	{INTERFACEKEY_D_BITEM_DUMP, "D_BITEM_DUMP"},
	{INTERFACEKEY_D_BITEM_HIDE, "D_BITEM_HIDE"},
	{INTERFACEKEY_D_BITEM_MELT, "D_BITEM_MELT"},
	{INTERFACEKEY_D_BITEM_NAME, "D_BITEM_NAME"},
	{INTERFACEKEY_D_LOOK_FORBID, "D_LOOK_FORBID"},
	{INTERFACEKEY_D_LOOK_DUMP, "D_LOOK_DUMP"},
	{INTERFACEKEY_D_LOOK_MELT, "D_LOOK_MELT"},
	{INTERFACEKEY_D_LOOK_HIDE, "D_LOOK_HIDE"},
	{INTERFACEKEY_D_LOOK_FOLLOW, "D_LOOK_FOLLOW"},
	{INTERFACEKEY_D_LOOK_ARENA_CREATURE, "D_LOOK_ARENA_CREATURE"},
	{INTERFACEKEY_D_LOOK_ARENA_ADV_MODE, "D_LOOK_ARENA_ADV_MODE"},
	{INTERFACEKEY_D_LOOK_ARENA_WATER, "D_LOOK_ARENA_WATER"},
	{INTERFACEKEY_D_LOOK_ARENA_MAGMA, "D_LOOK_ARENA_MAGMA"},
	{INTERFACEKEY_ARENA_CREATURE_SIDE_DOWN, "ARENA_CREATURE_SIDE_DOWN"},
	{INTERFACEKEY_ARENA_CREATURE_SIDE_UP, "ARENA_CREATURE_SIDE_UP"},
	{INTERFACEKEY_ARENA_CREATURE_NEW_ITEM, "ARENA_CREATURE_NEW_ITEM"},
	{INTERFACEKEY_ARENA_CREATURE_BLANK_LIST, "ARENA_CREATURE_BLANK_LIST"},
	{INTERFACEKEY_ARENA_CREATURE_REMOVE_ITEM, "ARENA_CREATURE_REMOVE_ITEM"},
	{INTERFACEKEY_ARENA_CREATURE_UNDEAD, "ARENA_CREATURE_UNDEAD"},
	{INTERFACEKEY_ARENA_CREATURE_TAME, "ARENA_CREATURE_TAME"},
	{INTERFACEKEY_ARENA_CREATURE_STRING, "ARENA_CREATURE_STRING"},
	{INTERFACEKEY_ARENA_CONFLICT_STATE_1, "ARENA_CONFLICT_STATE_1"},
	{INTERFACEKEY_ARENA_CONFLICT_STATE_2, "ARENA_CONFLICT_STATE_2"},
	{INTERFACEKEY_ARENA_MORALE, "ARENA_MORALE"},
	{INTERFACEKEY_ARENA_WEATHER, "ARENA_WEATHER"},
	{INTERFACEKEY_ARENA_WEATHER_SNOW, "ARENA_WEATHER_SNOW"},
	{INTERFACEKEY_ARENA_WEATHER_MUD, "ARENA_WEATHER_MUD"},
	{INTERFACEKEY_ARENA_WEATHER_CLEAR_SPATTER, "ARENA_WEATHER_CLEAR_SPATTER"},
	{INTERFACEKEY_D_LOOK_ARENA_TREE, "D_LOOK_ARENA_TREE"},
	{INTERFACEKEY_ARENA_TREE_FILTER, "ARENA_TREE_FILTER"},
	{INTERFACEKEY_ARENA_TREE_AGE, "ARENA_TREE_AGE"},
	{INTERFACEKEY_D_LOOK_ARENA_MOUNT, "D_LOOK_ARENA_MOUNT"},
	{INTERFACEKEY_CSHEET_BACKGROUND, "CSHEET_BACKGROUND"},
	{INTERFACEKEY_CSHEET_NEW_CHARACTER, "CSHEET_NEW_CHARACTER"},
	{INTERFACEKEY_CSHEET_SKILLS, "CSHEET_SKILLS"},
	{INTERFACEKEY_CSHEET_APPEARANCE, "CSHEET_APPEARANCE"},
	{INTERFACEKEY_CSHEET_PERSONALITY, "CSHEET_PERSONALITY"},
	{INTERFACEKEY_CSHEET_EQUIPMENT, "CSHEET_EQUIPMENT"},
	{INTERFACEKEY_CSHEET_PETS, "CSHEET_PETS"},
	{INTERFACEKEY_CSHEET_RANDOMIZE_BACKGROUND, "CSHEET_RANDOMIZE_BACKGROUND"},
	{INTERFACEKEY_CSHEET_SELECT_BACKGROUND_OPTION, "CSHEET_SELECT_BACKGROUND_OPTION"},
	{INTERFACEKEY_CSHEET_WORSHIP_UP, "CSHEET_WORSHIP_UP"},
	{INTERFACEKEY_CSHEET_WORSHIP_DOWN, "CSHEET_WORSHIP_DOWN"},
	{INTERFACEKEY_CSHEET_NEW_ITEM, "CSHEET_NEW_ITEM"},
	{INTERFACEKEY_CSHEET_QUALITY_UP, "CSHEET_QUALITY_UP"},
	{INTERFACEKEY_CSHEET_QUALITY_DOWN, "CSHEET_QUALITY_DOWN"},
	{INTERFACEKEY_CSHEET_NAME_PET, "CSHEET_NAME_PET"},
	{INTERFACEKEY_CSHEET_REMOVE_PET, "CSHEET_REMOVE_PET"},
	{INTERFACEKEY_CSHEET_ADD_PET, "CSHEET_ADD_PET"},
	{INTERFACEKEY_A_ENTER_NAME, "A_ENTER_NAME"},
	{INTERFACEKEY_A_CUST_NAME, "A_CUST_NAME"},
	{INTERFACEKEY_A_RANDOM_NAME, "A_RANDOM_NAME"},
	{INTERFACEKEY_A_RANDOM_APPEARANCE, "A_RANDOM_APPEARANCE"},
	{INTERFACEKEY_A_RANDOM_APPEARANCE_FULL, "A_RANDOM_APPEARANCE_FULL"},
	{INTERFACEKEY_A_RANDOM_PERSONALITY, "A_RANDOM_PERSONALITY"},
	{INTERFACEKEY_A_CUSTOM_PERSONALITY, "A_CUSTOM_PERSONALITY"},
	{INTERFACEKEY_A_CHANGE_DREAM, "A_CHANGE_DREAM"},
	{INTERFACEKEY_A_CHANGE_GENDER, "A_CHANGE_GENDER"},
	{INTERFACEKEY_A_END_TRAVEL, "A_END_TRAVEL"},
	{INTERFACEKEY_A_TRAVEL_CLOUDS, "A_TRAVEL_CLOUDS"},
	{INTERFACEKEY_A_LOG, "A_LOG"},
	{INTERFACEKEY_A_TRAVEL_LOG, "A_TRAVEL_LOG"},
	{INTERFACEKEY_A_LOG_SORT, "A_LOG_SORT"},
	{INTERFACEKEY_A_LOG_PIN, "A_LOG_PIN"},
	{INTERFACEKEY_A_LOG_ENTITIES, "A_LOG_ENTITIES"},
	{INTERFACEKEY_A_LOG_SITES, "A_LOG_SITES"},
	{INTERFACEKEY_A_LOG_SUBREGIONS, "A_LOG_SUBREGIONS"},
	{INTERFACEKEY_A_LOG_FEATURE_LAYERS, "A_LOG_FEATURE_LAYERS"},
	{INTERFACEKEY_A_LOG_PEOPLE, "A_LOG_PEOPLE"},
	{INTERFACEKEY_A_LOG_AGREEMENTS, "A_LOG_AGREEMENTS"},
	{INTERFACEKEY_A_LOG_EVENTS, "A_LOG_EVENTS"},
	{INTERFACEKEY_A_LOG_BESTIARY, "A_LOG_BESTIARY"},
	{INTERFACEKEY_A_LOG_ARTIFACTS, "A_LOG_ARTIFACTS"},
	{INTERFACEKEY_A_LOG_INTRIGUE, "A_LOG_INTRIGUE"},
	{INTERFACEKEY_A_LOG_FILTER, "A_LOG_FILTER"},
	{INTERFACEKEY_A_LOG_ZOOM_CURRENT_LOCATION, "A_LOG_ZOOM_CURRENT_LOCATION"},
	{INTERFACEKEY_A_LOG_ZOOM_SELECTED, "A_LOG_ZOOM_SELECTED"},
	{INTERFACEKEY_A_LOG_LINE, "A_LOG_LINE"},
	{INTERFACEKEY_A_LOG_MAP, "A_LOG_MAP"},
	{INTERFACEKEY_ORDERS_AUTOFORBID, "ORDERS_AUTOFORBID"},
	{INTERFACEKEY_ORDERS_FORBID_PROJECTILE, "ORDERS_FORBID_PROJECTILE"},
	{INTERFACEKEY_ORDERS_FORBID_YOUR_CORPSE, "ORDERS_FORBID_YOUR_CORPSE"},
	{INTERFACEKEY_ORDERS_FORBID_YOUR_ITEMS, "ORDERS_FORBID_YOUR_ITEMS"},
	{INTERFACEKEY_ORDERS_FORBID_OTHER_CORPSE, "ORDERS_FORBID_OTHER_CORPSE"},
	{INTERFACEKEY_ORDERS_FORBID_OTHER_ITEMS, "ORDERS_FORBID_OTHER_ITEMS"},
	{INTERFACEKEY_ORDERS_REFUSE_GATHER, "ORDERS_REFUSE_GATHER"},
	{INTERFACEKEY_ORDERS_REFUSE_OUTSIDE, "ORDERS_REFUSE_OUTSIDE"},
	{INTERFACEKEY_ORDERS_REFUSE_OUTSIDE_VERMIN, "ORDERS_REFUSE_OUTSIDE_VERMIN"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_CORPSE, "ORDERS_REFUSE_DUMP_CORPSE"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_SKULL, "ORDERS_REFUSE_DUMP_SKULL"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_SKIN, "ORDERS_REFUSE_DUMP_SKIN"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_BONE, "ORDERS_REFUSE_DUMP_BONE"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_SHELL, "ORDERS_REFUSE_DUMP_SHELL"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_OTHER, "ORDERS_REFUSE_DUMP_OTHER"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_STRAND_TISSUE, "ORDERS_REFUSE_DUMP_STRAND_TISSUE"},
	{INTERFACEKEY_ORDERS_GATHER_FURNITURE, "ORDERS_GATHER_FURNITURE"},
	{INTERFACEKEY_ORDERS_GATHER_ANIMALS, "ORDERS_GATHER_ANIMALS"},
	{INTERFACEKEY_ORDERS_GATHER_FOOD, "ORDERS_GATHER_FOOD"},
	{INTERFACEKEY_ORDERS_GATHER_BODIES, "ORDERS_GATHER_BODIES"},
	{INTERFACEKEY_ORDERS_REFUSE, "ORDERS_REFUSE"},
	{INTERFACEKEY_ORDERS_GATHER_STONE, "ORDERS_GATHER_STONE"},
	{INTERFACEKEY_ORDERS_GATHER_WOOD, "ORDERS_GATHER_WOOD"},
	{INTERFACEKEY_ORDERS_ALL_HARVEST, "ORDERS_ALL_HARVEST"},
	{INTERFACEKEY_ORDERS_SAMEPILE, "ORDERS_SAMEPILE"},
	{INTERFACEKEY_ORDERS_MIXFOODS, "ORDERS_MIXFOODS"},
	{INTERFACEKEY_ORDERS_EXCEPTIONS, "ORDERS_EXCEPTIONS"},
	{INTERFACEKEY_ORDERS_LOOM, "ORDERS_LOOM"},
	{INTERFACEKEY_ORDERS_DYED_CLOTH, "ORDERS_DYED_CLOTH"},
	{INTERFACEKEY_ORDERS_WORKSHOP, "ORDERS_WORKSHOP"},
	{INTERFACEKEY_ORDERS_COLLECT_WEB, "ORDERS_COLLECT_WEB"},
	{INTERFACEKEY_ORDERS_SLAUGHTER, "ORDERS_SLAUGHTER"},
	{INTERFACEKEY_ORDERS_BUTCHER, "ORDERS_BUTCHER"},
	{INTERFACEKEY_ORDERS_TAN, "ORDERS_TAN"},
	{INTERFACEKEY_ORDERS_AUTO_FISHERY, "ORDERS_AUTO_FISHERY"},
	{INTERFACEKEY_ORDERS_AUTO_KITCHEN, "ORDERS_AUTO_KITCHEN"},
	{INTERFACEKEY_ORDERS_AUTO_KILN, "ORDERS_AUTO_KILN"},
	{INTERFACEKEY_ORDERS_AUTO_SMELTER, "ORDERS_AUTO_SMELTER"},
	{INTERFACEKEY_ORDERS_AUTO_OTHER, "ORDERS_AUTO_OTHER"},
	{INTERFACEKEY_ORDERS_ZONE, "ORDERS_ZONE"},
	{INTERFACEKEY_ORDERS_ZONE_DRINKING, "ORDERS_ZONE_DRINKING"},
	{INTERFACEKEY_ORDERS_ZONE_FISHING, "ORDERS_ZONE_FISHING"},
	{INTERFACEKEY_DESTROYBUILDING, "DESTROYBUILDING"},
	{INTERFACEKEY_SUSPENDBUILDING, "SUSPENDBUILDING"},
	{INTERFACEKEY_MENU_CONFIRM, "MENU_CONFIRM"},
	{INTERFACEKEY_SAVE_BINDINGS, "SAVE_BINDINGS"},
	{INTERFACEKEY_LOAD_BINDINGS, "LOAD_BINDINGS"},
	*/
	{INTERFACEKEY_KEYBINDING_COMPLETE, "KEYBINDING_COMPLETE"},
	{INTERFACEKEY_ZOOM_IN, "ZOOM_IN"},
	{INTERFACEKEY_ZOOM_OUT, "ZOOM_OUT"},
	{INTERFACEKEY_MACRO_BREAK, "MACRO_BREAK"},
	{INTERFACEKEY_RECORD_MACRO, "RECORD_MACRO"},
	{INTERFACEKEY_PLAY_MACRO, "PLAY_MACRO"},
	{INTERFACEKEY_SAVE_MACRO, "SAVE_MACRO"},
	{INTERFACEKEY_LOAD_MACRO, "LOAD_MACRO"},
	/*
	{INTERFACEKEY_HOTKEY_ALCHEMIST_SOAP, "HOTKEY_ALCHEMIST_SOAP"},
	{INTERFACEKEY_HOTKEY_STILL_BREW, "HOTKEY_STILL_BREW"},
	{INTERFACEKEY_HOTKEY_STILL_EXTRACT, "HOTKEY_STILL_EXTRACT"},
	{INTERFACEKEY_HOTKEY_LOOM_COLLECT_SILK, "HOTKEY_LOOM_COLLECT_SILK"},
	{INTERFACEKEY_HOTKEY_LOOM_WEAVE_CLOTH, "HOTKEY_LOOM_WEAVE_CLOTH"},
	{INTERFACEKEY_HOTKEY_LOOM_WEAVE_SILK, "HOTKEY_LOOM_WEAVE_SILK"},
	{INTERFACEKEY_HOTKEY_LOOM_WEAVE_YARN, "HOTKEY_LOOM_WEAVE_YARN"},
	{INTERFACEKEY_HOTKEY_LOOM_WEAVE_METAL, "HOTKEY_LOOM_WEAVE_METAL"},
	{INTERFACEKEY_HOTKEY_KITCHEN_COOK_2, "HOTKEY_KITCHEN_COOK_2"},
	{INTERFACEKEY_HOTKEY_KITCHEN_COOK_3, "HOTKEY_KITCHEN_COOK_3"},
	{INTERFACEKEY_HOTKEY_KITCHEN_COOK_4, "HOTKEY_KITCHEN_COOK_4"},
	{INTERFACEKEY_HOTKEY_KITCHEN_RENDER_FAT, "HOTKEY_KITCHEN_RENDER_FAT"},
	{INTERFACEKEY_HOTKEY_FARMER_PROCESS, "HOTKEY_FARMER_PROCESS"},
	{INTERFACEKEY_HOTKEY_FARMER_PROCESS_VIAL, "HOTKEY_FARMER_PROCESS_VIAL"},
	{INTERFACEKEY_HOTKEY_FARMER_PROCESS_BAG, "HOTKEY_FARMER_PROCESS_BAG"},
	{INTERFACEKEY_HOTKEY_FARMER_PROCESS_BARREL, "HOTKEY_FARMER_PROCESS_BARREL"},
	{INTERFACEKEY_HOTKEY_FARMER_CHEESE, "HOTKEY_FARMER_CHEESE"},
	{INTERFACEKEY_HOTKEY_FARMER_MILK, "HOTKEY_FARMER_MILK"},
	{INTERFACEKEY_HOTKEY_FARMER_SHEAR_CREATURE, "HOTKEY_FARMER_SHEAR_CREATURE"},
	{INTERFACEKEY_HOTKEY_FARMER_SPIN_THREAD, "HOTKEY_FARMER_SPIN_THREAD"},
	{INTERFACEKEY_HOTKEY_MILL_MILL, "HOTKEY_MILL_MILL"},
	{INTERFACEKEY_HOTKEY_KENNEL_CATCH_VERMIN, "HOTKEY_KENNEL_CATCH_VERMIN"},
	{INTERFACEKEY_HOTKEY_KENNEL_TAME_VERMIN, "HOTKEY_KENNEL_TAME_VERMIN"},
	{INTERFACEKEY_HOTKEY_FISHERY_PROCESS, "HOTKEY_FISHERY_PROCESS"},
	{INTERFACEKEY_HOTKEY_FISHERY_EXTRACT, "HOTKEY_FISHERY_EXTRACT"},
	{INTERFACEKEY_HOTKEY_FISHERY_CATCH, "HOTKEY_FISHERY_CATCH"},
	{INTERFACEKEY_HOTKEY_BUTCHER_BUTCHER, "HOTKEY_BUTCHER_BUTCHER"},
	{INTERFACEKEY_HOTKEY_BUTCHER_EXTRACT, "HOTKEY_BUTCHER_EXTRACT"},
	{INTERFACEKEY_HOTKEY_BUTCHER_CATCH, "HOTKEY_BUTCHER_CATCH"},
	{INTERFACEKEY_HOTKEY_TANNER_TAN, "HOTKEY_TANNER_TAN"},
	{INTERFACEKEY_HOTKEY_DYER_THREAD, "HOTKEY_DYER_THREAD"},
	{INTERFACEKEY_HOTKEY_DYER_CLOTH, "HOTKEY_DYER_CLOTH"},
	{INTERFACEKEY_HOTKEY_JEWELER_FURNITURE, "HOTKEY_JEWELER_FURNITURE"},
	{INTERFACEKEY_HOTKEY_JEWELER_FINISHED, "HOTKEY_JEWELER_FINISHED"},
	{INTERFACEKEY_HOTKEY_JEWELER_AMMO, "HOTKEY_JEWELER_AMMO"},
	{INTERFACEKEY_HOTKEY_JEWELER_CUT, "HOTKEY_JEWELER_CUT"},
	{INTERFACEKEY_HOTKEY_JEWELER_ENCRUST, "HOTKEY_JEWELER_ENCRUST"},
	{INTERFACEKEY_HOTKEY_MECHANIC_PARTS, "HOTKEY_MECHANIC_PARTS"},
	{INTERFACEKEY_HOTKEY_MECHANIC_TRACTION_BENCH, "HOTKEY_MECHANIC_TRACTION_BENCH"},
	{INTERFACEKEY_HOTKEY_MASON_ARMORSTAND, "HOTKEY_MASON_ARMORSTAND"},
	{INTERFACEKEY_HOTKEY_MASON_BLOCKS, "HOTKEY_MASON_BLOCKS"},
	{INTERFACEKEY_HOTKEY_MASON_CHAIR, "HOTKEY_MASON_CHAIR"},
	{INTERFACEKEY_HOTKEY_MASON_COFFIN, "HOTKEY_MASON_COFFIN"},
	{INTERFACEKEY_HOTKEY_MASON_DOOR, "HOTKEY_MASON_DOOR"},
	{INTERFACEKEY_HOTKEY_MASON_FLOODGATE, "HOTKEY_MASON_FLOODGATE"},
	{INTERFACEKEY_HOTKEY_MASON_HATCH_COVER, "HOTKEY_MASON_HATCH_COVER"},
	{INTERFACEKEY_HOTKEY_MASON_GRATE, "HOTKEY_MASON_GRATE"},
	{INTERFACEKEY_HOTKEY_MASON_CABINET, "HOTKEY_MASON_CABINET"},
	{INTERFACEKEY_HOTKEY_MASON_BOX, "HOTKEY_MASON_BOX"},
	{INTERFACEKEY_HOTKEY_MASON_STATUE, "HOTKEY_MASON_STATUE"},
	{INTERFACEKEY_HOTKEY_MASON_QUERN, "HOTKEY_MASON_QUERN"},
	{INTERFACEKEY_HOTKEY_MASON_MILLSTONE, "HOTKEY_MASON_MILLSTONE"},
	{INTERFACEKEY_HOTKEY_MASON_TABLE, "HOTKEY_MASON_TABLE"},
	{INTERFACEKEY_HOTKEY_MASON_WEAPONRACK, "HOTKEY_MASON_WEAPONRACK"},
	{INTERFACEKEY_HOTKEY_MASON_SLAB, "HOTKEY_MASON_SLAB"},
	{INTERFACEKEY_HOTKEY_TRAP_BRIDGE, "HOTKEY_TRAP_BRIDGE"},
	{INTERFACEKEY_HOTKEY_TRAP_GEAR_ASSEMBLY, "HOTKEY_TRAP_GEAR_ASSEMBLY"},
	{INTERFACEKEY_HOTKEY_TRAP_DOOR, "HOTKEY_TRAP_DOOR"},
	{INTERFACEKEY_HOTKEY_TRAP_FLOODGATE, "HOTKEY_TRAP_FLOODGATE"},
	{INTERFACEKEY_HOTKEY_TRAP_SPIKE, "HOTKEY_TRAP_SPIKE"},
	{INTERFACEKEY_HOTKEY_TRAP_HATCH, "HOTKEY_TRAP_HATCH"},
	{INTERFACEKEY_HOTKEY_TRAP_GRATE_WALL, "HOTKEY_TRAP_GRATE_WALL"},
	{INTERFACEKEY_HOTKEY_TRAP_GRATE_FLOOR, "HOTKEY_TRAP_GRATE_FLOOR"},
	{INTERFACEKEY_HOTKEY_TRAP_BARS_VERTICAL, "HOTKEY_TRAP_BARS_VERTICAL"},
	{INTERFACEKEY_HOTKEY_TRAP_BARS_FLOOR, "HOTKEY_TRAP_BARS_FLOOR"},
	{INTERFACEKEY_HOTKEY_TRAP_SUPPORT, "HOTKEY_TRAP_SUPPORT"},
	{INTERFACEKEY_HOTKEY_TRAP_CHAIN, "HOTKEY_TRAP_CHAIN"},
	{INTERFACEKEY_HOTKEY_TRAP_CAGE, "HOTKEY_TRAP_CAGE"},
	{INTERFACEKEY_HOTKEY_TRAP_PULL_LEVER, "HOTKEY_TRAP_PULL_LEVER"},
	{INTERFACEKEY_HOTKEY_TRAP_TRACK_STOP, "HOTKEY_TRAP_TRACK_STOP"},
	{INTERFACEKEY_BUILDJOB_ADD, "BUILDJOB_ADD"},
	{INTERFACEKEY_BUILDJOB_CANCEL, "BUILDJOB_CANCEL"},
	{INTERFACEKEY_BUILDJOB_NAME, "BUILDJOB_NAME"},
	{INTERFACEKEY_BUILDJOB_PROMOTE, "BUILDJOB_PROMOTE"},
	{INTERFACEKEY_BUILDJOB_NOW, "BUILDJOB_NOW"},
	{INTERFACEKEY_BUILDJOB_REPEAT, "BUILDJOB_REPEAT"},
	{INTERFACEKEY_BUILDJOB_SUSPEND, "BUILDJOB_SUSPEND"},
	{INTERFACEKEY_BUILDJOB_WORKSHOP_PROFILE, "BUILDJOB_WORKSHOP_PROFILE"},
	{INTERFACEKEY_BUILDJOB_DETAILS, "BUILDJOB_DETAILS"},
	{INTERFACEKEY_BUILDJOB_DETAILS_FILTER, "BUILDJOB_DETAILS_FILTER"},
	{INTERFACEKEY_BUILDJOB_WELL_FREE, "BUILDJOB_WELL_FREE"},
	{INTERFACEKEY_BUILDJOB_WELL_SIZE, "BUILDJOB_WELL_SIZE"},
	{INTERFACEKEY_BUILDJOB_TARGET_FREE, "BUILDJOB_TARGET_FREE"},
	{INTERFACEKEY_BUILDJOB_TARGET_SIZE, "BUILDJOB_TARGET_SIZE"},
	{INTERFACEKEY_BUILDJOB_TARGET_DOWN, "BUILDJOB_TARGET_DOWN"},
	{INTERFACEKEY_BUILDJOB_TARGET_UP, "BUILDJOB_TARGET_UP"},
	{INTERFACEKEY_BUILDJOB_TARGET_RIGHT, "BUILDJOB_TARGET_RIGHT"},
	{INTERFACEKEY_BUILDJOB_TARGET_LEFT, "BUILDJOB_TARGET_LEFT"},
	{INTERFACEKEY_BUILDJOB_STATUE_ASSIGN, "BUILDJOB_STATUE_ASSIGN"},
	{INTERFACEKEY_BUILDJOB_STATUE_FREE, "BUILDJOB_STATUE_FREE"},
	{INTERFACEKEY_BUILDJOB_STATUE_SIZE, "BUILDJOB_STATUE_SIZE"},
	{INTERFACEKEY_BUILDJOB_CAGE_JUSTICE, "BUILDJOB_CAGE_JUSTICE"},
	{INTERFACEKEY_BUILDJOB_CAGE_FREE, "BUILDJOB_CAGE_FREE"},
	{INTERFACEKEY_BUILDJOB_CAGE_SIZE, "BUILDJOB_CAGE_SIZE"},
	{INTERFACEKEY_BUILDJOB_CAGE_ASSIGN_OCC, "BUILDJOB_CAGE_ASSIGN_OCC"},
	{INTERFACEKEY_BUILDJOB_CAGE_WATER, "BUILDJOB_CAGE_WATER"},
	{INTERFACEKEY_BUILDJOB_CAGE_ASSIGN, "BUILDJOB_CAGE_ASSIGN"},
	{INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN_OCC, "BUILDJOB_CHAIN_ASSIGN_OCC"},
	{INTERFACEKEY_BUILDJOB_CHAIN_JUSTICE, "BUILDJOB_CHAIN_JUSTICE"},
	{INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN, "BUILDJOB_CHAIN_ASSIGN"},
	{INTERFACEKEY_BUILDJOB_CHAIN_FREE, "BUILDJOB_CHAIN_FREE"},
	{INTERFACEKEY_BUILDJOB_CHAIN_SIZE, "BUILDJOB_CHAIN_SIZE"},
	{INTERFACEKEY_BUILDJOB_SIEGE_FIRING, "BUILDJOB_SIEGE_FIRING"},
	{INTERFACEKEY_BUILDJOB_SIEGE_ORIENT, "BUILDJOB_SIEGE_ORIENT"},
	{INTERFACEKEY_BUILDJOB_DOOR_INTERNAL, "BUILDJOB_DOOR_INTERNAL"},
	{INTERFACEKEY_BUILDJOB_DOOR_LOCK, "BUILDJOB_DOOR_LOCK"},
	{INTERFACEKEY_BUILDJOB_DOOR_AJAR, "BUILDJOB_DOOR_AJAR"},
	{INTERFACEKEY_BUILDJOB_COFFIN_ASSIGN, "BUILDJOB_COFFIN_ASSIGN"},
	{INTERFACEKEY_BUILDJOB_COFFIN_FREE, "BUILDJOB_COFFIN_FREE"},
	{INTERFACEKEY_BUILDJOB_COFFIN_SIZE, "BUILDJOB_COFFIN_SIZE"},
	{INTERFACEKEY_BUILDJOB_COFFIN_BURIAL, "BUILDJOB_COFFIN_BURIAL"},
	{INTERFACEKEY_BUILDJOB_COFFIN_CIV, "BUILDJOB_COFFIN_CIV"},
	{INTERFACEKEY_BUILDJOB_COFFIN_PET, "BUILDJOB_COFFIN_PET"},
	{INTERFACEKEY_BUILDJOB_CHAIR_ASSIGN, "BUILDJOB_CHAIR_ASSIGN"},
	{INTERFACEKEY_BUILDJOB_CHAIR_FREE, "BUILDJOB_CHAIR_FREE"},
	{INTERFACEKEY_BUILDJOB_CHAIR_SIZE, "BUILDJOB_CHAIR_SIZE"},
	{INTERFACEKEY_BUILDJOB_TABLE_ASSIGN, "BUILDJOB_TABLE_ASSIGN"},
	{INTERFACEKEY_BUILDJOB_TABLE_HALL, "BUILDJOB_TABLE_HALL"},
	{INTERFACEKEY_BUILDJOB_TABLE_FREE, "BUILDJOB_TABLE_FREE"},
	{INTERFACEKEY_BUILDJOB_TABLE_SIZE, "BUILDJOB_TABLE_SIZE"},
	{INTERFACEKEY_BUILDJOB_BED_ASSIGN, "BUILDJOB_BED_ASSIGN"},
	{INTERFACEKEY_BUILDJOB_BED_FREE, "BUILDJOB_BED_FREE"},
	{INTERFACEKEY_BUILDJOB_BED_BARRACKS, "BUILDJOB_BED_BARRACKS"},
	{INTERFACEKEY_BUILDJOB_BED_DORMITORY, "BUILDJOB_BED_DORMITORY"},
	{INTERFACEKEY_BUILDJOB_BED_RENT, "BUILDJOB_BED_RENT"},
	{INTERFACEKEY_BUILDJOB_BED_SIZE, "BUILDJOB_BED_SIZE"},
	{INTERFACEKEY_BUILDJOB_BED_SLEEP, "BUILDJOB_BED_SLEEP"},
	{INTERFACEKEY_BUILDJOB_BED_TRAIN, "BUILDJOB_BED_TRAIN"},
	{INTERFACEKEY_BUILDJOB_BED_INDIV_EQ, "BUILDJOB_BED_INDIV_EQ"},
	{INTERFACEKEY_BUILDJOB_BED_SQUAD_EQ, "BUILDJOB_BED_SQUAD_EQ"},
	{INTERFACEKEY_BUILDJOB_BED_POSITION, "BUILDJOB_BED_POSITION"},
	{INTERFACEKEY_BUILDJOB_DEPOT_BRING, "BUILDJOB_DEPOT_BRING"},
	{INTERFACEKEY_BUILDJOB_DEPOT_TRADE, "BUILDJOB_DEPOT_TRADE"},
	{INTERFACEKEY_BUILDJOB_DEPOT_REQUEST_TRADER, "BUILDJOB_DEPOT_REQUEST_TRADER"},
	{INTERFACEKEY_BUILDJOB_DEPOT_BROKER_ONLY, "BUILDJOB_DEPOT_BROKER_ONLY"},
	{INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_NONE, "BUILDJOB_ANIMALTRAP_BAIT_NONE"},
	{INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_MEAT, "BUILDJOB_ANIMALTRAP_BAIT_MEAT"},
	{INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_FISH, "BUILDJOB_ANIMALTRAP_BAIT_FISH"},
	{INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_GEM, "BUILDJOB_ANIMALTRAP_BAIT_GEM"},
	{INTERFACEKEY_BUILDJOB_FARM_FALLOW, "BUILDJOB_FARM_FALLOW"},
	{INTERFACEKEY_BUILDJOB_FARM_FERTILIZE, "BUILDJOB_FARM_FERTILIZE"},
	{INTERFACEKEY_BUILDJOB_FARM_SEASFERT, "BUILDJOB_FARM_SEASFERT"},
	{INTERFACEKEY_BUILDJOB_FARM_SPRING, "BUILDJOB_FARM_SPRING"},
	{INTERFACEKEY_BUILDJOB_FARM_SUMMER, "BUILDJOB_FARM_SUMMER"},
	{INTERFACEKEY_BUILDJOB_FARM_AUTUMN, "BUILDJOB_FARM_AUTUMN"},
	{INTERFACEKEY_BUILDJOB_FARM_WINTER, "BUILDJOB_FARM_WINTER"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_MASTER, "BUILDJOB_STOCKPILE_MASTER"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_LINK_ANYWHERE, "BUILDJOB_STOCKPILE_LINK_ANYWHERE"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_GIVE_TO, "BUILDJOB_STOCKPILE_GIVE_TO"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_WHEELBARROW, "BUILDJOB_STOCKPILE_WHEELBARROW"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_DELETE_CHILD, "BUILDJOB_STOCKPILE_DELETE_CHILD"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_SETTINGS, "BUILDJOB_STOCKPILE_SETTINGS"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_UP, "BUILDJOB_STOCKPILE_BARREL_UP"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_DOWN, "BUILDJOB_STOCKPILE_BARREL_DOWN"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_ZERO, "BUILDJOB_STOCKPILE_BARREL_ZERO"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_MAX, "BUILDJOB_STOCKPILE_BARREL_MAX"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_UP, "BUILDJOB_STOCKPILE_BIN_UP"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_DOWN, "BUILDJOB_STOCKPILE_BIN_DOWN"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_ZERO, "BUILDJOB_STOCKPILE_BIN_ZERO"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_MAX, "BUILDJOB_STOCKPILE_BIN_MAX"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_BONE, "BUILDJOB_RACK_MAT_BONE"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_BRONZE, "BUILDJOB_RACK_MAT_BRONZE"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_COPPER, "BUILDJOB_RACK_MAT_COPPER"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_IRON, "BUILDJOB_RACK_MAT_IRON"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_STEEL, "BUILDJOB_RACK_MAT_STEEL"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_WOOD, "BUILDJOB_RACK_MAT_WOOD"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_METAL, "BUILDJOB_RACK_MAT_METAL"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_BONE, "BUILDJOB_STAND_MAT_BONE"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_LEATHER, "BUILDJOB_STAND_MAT_LEATHER"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_COPPER, "BUILDJOB_STAND_MAT_COPPER"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_BRONZE, "BUILDJOB_STAND_MAT_BRONZE"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_STEEL, "BUILDJOB_STAND_MAT_STEEL"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_IRON, "BUILDJOB_STAND_MAT_IRON"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_WOOD, "BUILDJOB_STAND_MAT_WOOD"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_METAL, "BUILDJOB_STAND_MAT_METAL"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_ASSIGN, "BUILDJOB_RACKSTAND_ASSIGN"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_FREE, "BUILDJOB_RACKSTAND_FREE"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_SIZE, "BUILDJOB_RACKSTAND_SIZE"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_ITEM, "BUILDJOB_RACKSTAND_ITEM"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_MAT, "BUILDJOB_RACKSTAND_MAT"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS1, "BUILDJOB_RACKSTAND_DEFAULTS1"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_KILL1, "BUILDJOB_RACKSTAND_KILL1"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS2, "BUILDJOB_RACKSTAND_DEFAULTS2"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_KILL2, "BUILDJOB_RACKSTAND_KILL2"},
	{INTERFACEKEY_BUILDJOB_DISPLAY_FURNITURE_SET, "BUILDJOB_DISPLAY_FURNITURE_SET"},
	{INTERFACEKEY_BUILDJOB_DISPLAY_FURNITURE_CANCEL, "BUILDJOB_DISPLAY_FURNITURE_CANCEL"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_ENABLE, "STOCKPILE_SETTINGS_ENABLE"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_DISABLE, "STOCKPILE_SETTINGS_DISABLE"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_ALL, "STOCKPILE_SETTINGS_PERMIT_ALL"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_ALL, "STOCKPILE_SETTINGS_FORBID_ALL"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_SUB, "STOCKPILE_SETTINGS_PERMIT_SUB"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_SUB, "STOCKPILE_SETTINGS_FORBID_SUB"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC1, "STOCKPILE_SETTINGS_SPECIFIC1"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC2, "STOCKPILE_SETTINGS_SPECIFIC2"},
	{INTERFACEKEY_MOVIE_RECORD, "MOVIE_RECORD"},
	{INTERFACEKEY_MOVIE_PLAY, "MOVIE_PLAY"},
	{INTERFACEKEY_MOVIE_SAVE, "MOVIE_SAVE"},
	{INTERFACEKEY_MOVIE_LOAD, "MOVIE_LOAD"},
	{INTERFACEKEY_ASSIGNTRADE_VIEW, "ASSIGNTRADE_VIEW"},
	{INTERFACEKEY_ASSIGNTRADE_STRING, "ASSIGNTRADE_STRING"},
	{INTERFACEKEY_ASSIGNTRADE_EXCLUDE_PROHIBITED, "ASSIGNTRADE_EXCLUDE_PROHIBITED"},
	{INTERFACEKEY_ASSIGNTRADE_PENDING, "ASSIGNTRADE_PENDING"},
	{INTERFACEKEY_ASSIGNTRADE_SORT, "ASSIGNTRADE_SORT"},
	{INTERFACEKEY_NOBLELIST_REPLACE, "NOBLELIST_REPLACE"},
	{INTERFACEKEY_NOBLELIST_SETTINGS, "NOBLELIST_SETTINGS"},
	{INTERFACEKEY_NOBLELIST_CAPITAL, "NOBLELIST_CAPITAL"},
	{INTERFACEKEY_NOBLELIST_VIEW_CANDIDATE, "NOBLELIST_VIEW_CANDIDATE"},
	{INTERFACEKEY_A_BARTER_VIEW, "A_BARTER_VIEW"},
	{INTERFACEKEY_A_BARTER_CURRENCY_1, "A_BARTER_CURRENCY_1"},
	{INTERFACEKEY_A_BARTER_CURRENCY_2, "A_BARTER_CURRENCY_2"},
	{INTERFACEKEY_A_BARTER_TRADE, "A_BARTER_TRADE"},
	{INTERFACEKEY_A_BARTER_SHOW, "A_BARTER_SHOW"},
	{INTERFACEKEY_TRADE_VIEW, "TRADE_VIEW"},
	{INTERFACEKEY_TRADE_TRADE, "TRADE_TRADE"},
	{INTERFACEKEY_TRADE_OFFER, "TRADE_OFFER"},
	{INTERFACEKEY_TRADE_SEIZE, "TRADE_SEIZE"},
	{INTERFACEKEY_STORES_VIEW, "STORES_VIEW"},
	{INTERFACEKEY_STORES_ZOOM, "STORES_ZOOM"},
	{INTERFACEKEY_STORES_FORBID, "STORES_FORBID"},
	{INTERFACEKEY_STORES_MELT, "STORES_MELT"},
	{INTERFACEKEY_STORES_DUMP, "STORES_DUMP"},
	{INTERFACEKEY_STORES_HIDE, "STORES_HIDE"},
	{INTERFACEKEY_MILITARY_ACTIVATE, "MILITARY_ACTIVATE"},
	{INTERFACEKEY_MILITARY_VIEW, "MILITARY_VIEW"},
	{INTERFACEKEY_MILITARY_WEAPON, "MILITARY_WEAPON"},
	{INTERFACEKEY_MILITARY_ZOOM, "MILITARY_ZOOM"},
	{INTERFACEKEY_ANNOUNCE_ZOOM, "ANNOUNCE_ZOOM"},
	{INTERFACEKEY_ANNOUNCE_ZOOM_2, "ANNOUNCE_ZOOM_2"},
	{INTERFACEKEY_UNITJOB_REMOVE_CRE, "UNITJOB_REMOVE_CRE"},
	{INTERFACEKEY_UNITJOB_ZOOM_CRE, "UNITJOB_ZOOM_CRE"},
	{INTERFACEKEY_UNITJOB_ZOOM_BUILD, "UNITJOB_ZOOM_BUILD"},
	{INTERFACEKEY_UNITJOB_VIEW_UNIT, "UNITJOB_VIEW_UNIT"},
	{INTERFACEKEY_UNITJOB_VIEW_JOB, "UNITJOB_VIEW_JOB"},
	{INTERFACEKEY_UNITJOB_MANAGER, "UNITJOB_MANAGER"},
	{INTERFACEKEY_MANAGER_NEW_ORDER, "MANAGER_NEW_ORDER"},
	{INTERFACEKEY_MANAGER_REMOVE, "MANAGER_REMOVE"},
	{INTERFACEKEY_MANAGER_PROMOTE, "MANAGER_PROMOTE"},
	{INTERFACEKEY_MANAGER_MAX, "MANAGER_MAX"},
	{INTERFACEKEY_MANAGER_WAGES, "MANAGER_WAGES"},
	{INTERFACEKEY_MANAGER_CONDITIONS, "MANAGER_CONDITIONS"},
	{INTERFACEKEY_MANAGER_DETAILS, "MANAGER_DETAILS"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ADD_ITEM, "WORK_ORDER_CONDITION_ADD_ITEM"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ADD_ORDER, "WORK_ORDER_CONDITION_ADD_ORDER"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_TYPE, "WORK_ORDER_CONDITION_ITEM_TYPE"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_MATERIAL, "WORK_ORDER_CONDITION_ITEM_MATERIAL"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_TRAITS, "WORK_ORDER_CONDITION_ITEM_TRAITS"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_INEQUALITY, "WORK_ORDER_CONDITION_ITEM_INEQUALITY"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_NUMBER, "WORK_ORDER_CONDITION_ITEM_NUMBER"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_DELETE, "WORK_ORDER_CONDITION_DELETE"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ORDER_ACTIVATION, "WORK_ORDER_CONDITION_ORDER_ACTIVATION"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_REAGENTS, "WORK_ORDER_CONDITION_REAGENTS"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_PRODUCTS, "WORK_ORDER_CONDITION_PRODUCTS"},
	*/
	{INTERFACEKEY_PET_BUTCHER, "PET_BUTCHER"},
	{INTERFACEKEY_PET_GELD, "PET_GELD"},
	{INTERFACEKEY_PET_AVAILABLE,"PET_AVAILABLE"},
	{INTERFACEKEY_ANIMAL_SELECT_TRAINER, "ANIMAL_SELECT_TRAINER"},
	{INTERFACEKEY_ANIMAL_WAR_TRAINING, "ANIMAL_WAR_TRAINING"},
	{INTERFACEKEY_ANIMAL_HUNTING_TRAINING, "ANIMAL_HUNTING_TRAINING"},
	{INTERFACEKEY_ANIMAL_ASSIGN_WORKER,"ANIMAL_ASSIGN_WORKER"},
	{INTERFACEKEY_KITCHEN_COOK, "KITCHEN_COOK"},
	{INTERFACEKEY_KITCHEN_BREW, "KITCHEN_BREW"},
	{INTERFACEKEY_JUSTICE_INTERROGATE, "JUSTICE_INTERROGATE"},
	{INTERFACEKEY_JUSTICE_CONVICT, "JUSTICE_CONVICT"},
	/*
	{INTERFACEKEY_JUSTICE_COUNTERINTELLIGENCE, "JUSTICE_COUNTERINTELLIGENCE"},
	{INTERFACEKEY_SETUPGAME_NEW, "SETUPGAME_NEW"},
	{INTERFACEKEY_SETUPGAME_VIEW, "SETUPGAME_VIEW"},
	{INTERFACEKEY_SETUPGAME_CUSTOMIZE_UNIT, "SETUPGAME_CUSTOMIZE_UNIT"},
	{INTERFACEKEY_SETUPGAME_SAVE_PROFILE, "SETUPGAME_SAVE_PROFILE"},
	{INTERFACEKEY_SETUPGAME_SAVE_PROFILE_ABORT, "SETUPGAME_SAVE_PROFILE_ABORT"},
	{INTERFACEKEY_SETUPGAME_SAVE_PROFILE_GO, "SETUPGAME_SAVE_PROFILE_GO"},
	{INTERFACEKEY_SETUPGAME_VIEW_PROFILE_PROBLEMS, "SETUPGAME_VIEW_PROFILE_PROBLEMS"},
	{INTERFACEKEY_CIVZONE_NAME, "CIVZONE_NAME"},
	{INTERFACEKEY_CIVZONE_REMOVE, "CIVZONE_REMOVE"},
	{INTERFACEKEY_CIVZONE_REMOVE_ZONE, "CIVZONE_REMOVE_ZONE"},
	{INTERFACEKEY_CIVZONE_SHAPE, "CIVZONE_SHAPE"},
	{INTERFACEKEY_CIVZONE_NEXT, "CIVZONE_NEXT"},
	{INTERFACEKEY_CIVZONE_POND_OPTIONS, "CIVZONE_POND_OPTIONS"},
	{INTERFACEKEY_CIVZONE_GATHER_OPTIONS, "CIVZONE_GATHER_OPTIONS"},
	{INTERFACEKEY_CIVZONE_GATHER_OPTIONS_PICK_TREES, "CIVZONE_GATHER_OPTIONS_PICK_TREES"},
	{INTERFACEKEY_CIVZONE_GATHER_OPTIONS_PICK_SHRUBS, "CIVZONE_GATHER_OPTIONS_PICK_SHRUBS"},
	{INTERFACEKEY_CIVZONE_GATHER_OPTIONS_GATHER_FALLEN, "CIVZONE_GATHER_OPTIONS_GATHER_FALLEN"},
	{INTERFACEKEY_CIVZONE_WATER_SOURCE, "CIVZONE_WATER_SOURCE"},
	{INTERFACEKEY_CIVZONE_FISH, "CIVZONE_FISH"},
	{INTERFACEKEY_CIVZONE_GATHER, "CIVZONE_GATHER"},
	{INTERFACEKEY_CIVZONE_DUMP, "CIVZONE_DUMP"},
	{INTERFACEKEY_CIVZONE_POND, "CIVZONE_POND"},
	{INTERFACEKEY_CIVZONE_SAND_COLLECT, "CIVZONE_SAND_COLLECT"},
	{INTERFACEKEY_CIVZONE_CLAY_COLLECT, "CIVZONE_CLAY_COLLECT"},
	{INTERFACEKEY_CIVZONE_ACTIVE, "CIVZONE_ACTIVE"},
	{INTERFACEKEY_CIVZONE_MEETING, "CIVZONE_MEETING"},
	{INTERFACEKEY_CIVZONE_ANIMAL_TRAINING, "CIVZONE_ANIMAL_TRAINING"},
	{INTERFACEKEY_CIVZONE_POND_WATER, "CIVZONE_POND_WATER"},
	{INTERFACEKEY_CIVZONE_PEN, "CIVZONE_PEN"},
	{INTERFACEKEY_CIVZONE_PEN_OPTIONS, "CIVZONE_PEN_OPTIONS"},
	{INTERFACEKEY_STOCKPILE_ANIMAL, "STOCKPILE_ANIMAL"},
	{INTERFACEKEY_STOCKPILE_FOOD, "STOCKPILE_FOOD"},
	{INTERFACEKEY_STOCKPILE_WEAPON, "STOCKPILE_WEAPON"},
	{INTERFACEKEY_STOCKPILE_ARMOR, "STOCKPILE_ARMOR"},
	{INTERFACEKEY_STOCKPILE_CUSTOM, "STOCKPILE_CUSTOM"},
	{INTERFACEKEY_STOCKPILE_CUSTOM_SETTINGS, "STOCKPILE_CUSTOM_SETTINGS"},
	{INTERFACEKEY_STOCKPILE_FURNITURE, "STOCKPILE_FURNITURE"},
	{INTERFACEKEY_STOCKPILE_GRAVEYARD, "STOCKPILE_GRAVEYARD"},
	{INTERFACEKEY_STOCKPILE_REFUSE, "STOCKPILE_REFUSE"},
	{INTERFACEKEY_STOCKPILE_WOOD, "STOCKPILE_WOOD"},
	{INTERFACEKEY_STOCKPILE_STONE, "STOCKPILE_STONE"},
	{INTERFACEKEY_STOCKPILE_GEM, "STOCKPILE_GEM"},
	{INTERFACEKEY_STOCKPILE_BARBLOCK, "STOCKPILE_BARBLOCK"},
	{INTERFACEKEY_STOCKPILE_CLOTH, "STOCKPILE_CLOTH"},
	{INTERFACEKEY_STOCKPILE_LEATHER, "STOCKPILE_LEATHER"},
	{INTERFACEKEY_STOCKPILE_AMMO, "STOCKPILE_AMMO"},
	{INTERFACEKEY_STOCKPILE_COINS, "STOCKPILE_COINS"},
	{INTERFACEKEY_STOCKPILE_FINISHED, "STOCKPILE_FINISHED"},
	{INTERFACEKEY_STOCKPILE_SHEET, "STOCKPILE_SHEET"},
	{INTERFACEKEY_STOCKPILE_NONE, "STOCKPILE_NONE"},
	*/

	{INTERFACEKEY_DESIGNATE_DIG, "DESIGNATE_DIG"},
	{INTERFACEKEY_DESIGNATE_STAIR_UPDOWN, "DESIGNATE_STAIR_UPDOWN"},
	{INTERFACEKEY_DESIGNATE_RAMP, "DESIGNATE_RAMP"},
	{INTERFACEKEY_DESIGNATE_CHANNEL, "DESIGNATE_CHANNEL"},
	{INTERFACEKEY_DESIGNATE_DIG_REMOVE_STAIRS_RAMPS, "DESIGNATE_DIG_REMOVE_STAIRS_RAMPS"},

	{INTERFACEKEY_DESIGNATE_RECTANGLE, "DESIGNATE_RECTANGLE"},
	{INTERFACEKEY_DESIGNATE_FREE_DRAW, "DESIGNATE_FREE_DRAW"},

	{INTERFACEKEY_DESIGNATE_TOGGLE_ADVANCED_OPTIONS, "DESIGNATE_TOGGLE_ADVANCED_OPTIONS"},

	{INTERFACEKEY_DESIGNATE_MINE_MODE_ALL, "DESIGNATE_MINE_MODE_ALL"},
	{INTERFACEKEY_DESIGNATE_MINE_MODE_AUTO, "DESIGNATE_MINE_MODE_AUTO"},
	{INTERFACEKEY_DESIGNATE_MINE_MODE_ORE_GEM, "DESIGNATE_MINE_MODE_ORE_GEM"},
	{INTERFACEKEY_DESIGNATE_MINE_MODE_GEM, "DESIGNATE_MINE_MODE_GEM"},

	{INTERFACEKEY_DESIGNATE_PRIORITY_UP, "DESIGNATE_PRIORITY_UP"},
	{INTERFACEKEY_DESIGNATE_PRIORITY_DOWN, "DESIGNATE_PRIORITY_DOWN"},

	{INTERFACEKEY_DESIGNATE_TOGGLE_MARKER, "DESIGNATE_TOGGLE_MARKER"},
	{INTERFACEKEY_DESIGNATE_MARKER_TO_STANDARD, "DESIGNATE_MARKER_TO_STANDARD"},
	{INTERFACEKEY_DESIGNATE_STANDARD_TO_MARKER, "DESIGNATE_STANDARD_TO_MARKER"},

	{INTERFACEKEY_DESIGNATE_CHOP, "DESIGNATE_CHOP"},

	{INTERFACEKEY_DESIGNATE_PLANTS, "DESIGNATE_PLANTS"},

	{INTERFACEKEY_DESIGNATE_SMOOTH, "DESIGNATE_SMOOTH"},
	{INTERFACEKEY_DESIGNATE_ENGRAVE, "DESIGNATE_ENGRAVE"},
	{INTERFACEKEY_DESIGNATE_TRACK, "DESIGNATE_TRACK"},
	{INTERFACEKEY_DESIGNATE_FORTIFY, "DESIGNATE_FORTIFY"},

	{INTERFACEKEY_DESIGNATE_CLAIM, "DESIGNATE_CLAIM"},
	{INTERFACEKEY_DESIGNATE_UNCLAIM, "DESIGNATE_UNCLAIM"},
	{INTERFACEKEY_DESIGNATE_MELT, "DESIGNATE_MELT"},
	{INTERFACEKEY_DESIGNATE_NO_MELT, "DESIGNATE_NO_MELT"},
	{INTERFACEKEY_DESIGNATE_DUMP, "DESIGNATE_DUMP"},
	{INTERFACEKEY_DESIGNATE_NO_DUMP, "DESIGNATE_NO_DUMP"},
	{INTERFACEKEY_DESIGNATE_HIDE, "DESIGNATE_HIDE"},
	{INTERFACEKEY_DESIGNATE_NO_HIDE, "DESIGNATE_NO_HIDE"},

	{INTERFACEKEY_DESIGNATE_TRAFFIC_HIGH, "DESIGNATE_TRAFFIC_HIGH"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_NORMAL, "DESIGNATE_TRAFFIC_NORMAL"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_LOW, "DESIGNATE_TRAFFIC_LOW"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_RESTRICTED, "DESIGNATE_TRAFFIC_RESTRICTED"},

	/*
	{INTERFACEKEY_DESIGNATE_BITEM, "DESIGNATE_BITEM"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC, "DESIGNATE_TRAFFIC"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT, "DESIGNATE_TRAFFIC_INCREASE_WEIGHT"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT, "DESIGNATE_TRAFFIC_DECREASE_WEIGHT"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE, "DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE, "DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE"},
	{INTERFACEKEY_DESIGNATE_STAIR_UP, "DESIGNATE_STAIR_UP"},
	{INTERFACEKEY_DESIGNATE_STAIR_DOWN, "DESIGNATE_STAIR_DOWN"},
	{INTERFACEKEY_DESIGNATE_DETAILS, "DESIGNATE_DETAILS"},
	{INTERFACEKEY_DESIGNATE_TOGGLE_ENGRAVING, "DESIGNATE_TOGGLE_ENGRAVING"},
	{INTERFACEKEY_DESIGNATE_STANDARD_MARKER, "DESIGNATE_STANDARD_MARKER"},
	{INTERFACEKEY_DESIGNATE_MINE_MODE, "DESIGNATE_MINE_MODE"},
	{INTERFACEKEY_DESIGNATE_TOGGLE_MARKER, "DESIGNATE_TOGGLE_MARKER"},
	{INTERFACEKEY_DESIGNATE_UNDO, "DESIGNATE_UNDO"},
	{INTERFACEKEY_DESIGNATE_REMOVE_CONSTRUCTION, "DESIGNATE_REMOVE_CONSTRUCTION"},
	{INTERFACEKEY_BUILDING_DIM_Y_UP, "BUILDING_DIM_Y_UP"},
	{INTERFACEKEY_BUILDING_DIM_Y_DOWN, "BUILDING_DIM_Y_DOWN"},
	{INTERFACEKEY_BUILDING_DIM_X_UP, "BUILDING_DIM_X_UP"},
	{INTERFACEKEY_BUILDING_DIM_X_DOWN, "BUILDING_DIM_X_DOWN"},
	{INTERFACEKEY_BUILDING_ORIENT_UP, "BUILDING_ORIENT_UP"},
	{INTERFACEKEY_BUILDING_ORIENT_LEFT, "BUILDING_ORIENT_LEFT"},
	{INTERFACEKEY_BUILDING_ORIENT_RIGHT, "BUILDING_ORIENT_RIGHT"},
	{INTERFACEKEY_BUILDING_ORIENT_DOWN, "BUILDING_ORIENT_DOWN"},
	{INTERFACEKEY_BUILDING_ORIENT_NONE, "BUILDING_ORIENT_NONE"},
	{INTERFACEKEY_BUILDING_VIEW_ITEM, "BUILDING_VIEW_ITEM"},
	{INTERFACEKEY_BUILDING_ADVANCE_STAGE, "BUILDING_ADVANCE_STAGE"},
	{INTERFACEKEY_BUILDING_EXPAND_CONTRACT, "BUILDING_EXPAND_CONTRACT"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_WATER, "BUILDING_TRIGGER_ENABLE_WATER"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_UP, "BUILDING_TRIGGER_MIN_WATER_UP"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_DOWN, "BUILDING_TRIGGER_MIN_WATER_DOWN"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_UP, "BUILDING_TRIGGER_MAX_WATER_UP"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_DOWN, "BUILDING_TRIGGER_MAX_WATER_DOWN"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_MAGMA, "BUILDING_TRIGGER_ENABLE_MAGMA"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_UP, "BUILDING_TRIGGER_MIN_MAGMA_UP"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_DOWN, "BUILDING_TRIGGER_MIN_MAGMA_DOWN"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_UP, "BUILDING_TRIGGER_MAX_MAGMA_UP"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_DOWN, "BUILDING_TRIGGER_MAX_MAGMA_DOWN"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_TRACK_CART, "BUILDING_TRIGGER_ENABLE_TRACK_CART"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_DOWN, "BUILDING_TRIGGER_MIN_TRACK_CART_DOWN"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_UP, "BUILDING_TRIGGER_MIN_TRACK_CART_UP"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_DOWN, "BUILDING_TRIGGER_MAX_TRACK_CART_DOWN"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_UP, "BUILDING_TRIGGER_MAX_TRACK_CART_UP"},
	{INTERFACEKEY_BUILDING_ROLLERS_SPEED_UP, "BUILDING_ROLLERS_SPEED_UP"},
	{INTERFACEKEY_BUILDING_ROLLERS_SPEED_DOWN, "BUILDING_ROLLERS_SPEED_DOWN"},
	{INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_UP, "BUILDING_TRACK_STOP_FRICTION_UP"},
	{INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_DOWN, "BUILDING_TRACK_STOP_FRICTION_DOWN"},
	{INTERFACEKEY_BUILDING_TRACK_STOP_DUMP, "BUILDING_TRACK_STOP_DUMP"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_CREATURE, "BUILDING_TRIGGER_ENABLE_CREATURE"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_LOCALS, "BUILDING_TRIGGER_ENABLE_LOCALS"},
	{INTERFACEKEY_BUILDING_TRIGGER_RESETS, "BUILDING_TRIGGER_RESETS"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_UP, "BUILDING_TRIGGER_MIN_SIZE_UP"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_DOWN, "BUILDING_TRIGGER_MIN_SIZE_DOWN"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_UP, "BUILDING_TRIGGER_MAX_SIZE_UP"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_DOWN, "BUILDING_TRIGGER_MAX_SIZE_DOWN"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_UP_PLUS, "BUILDING_TRIGGER_MIN_SIZE_UP_PLUS"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_DOWN_PLUS, "BUILDING_TRIGGER_MIN_SIZE_DOWN_PLUS"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_UP_PLUS, "BUILDING_TRIGGER_MAX_SIZE_UP_PLUS"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_DOWN_PLUS, "BUILDING_TRIGGER_MAX_SIZE_DOWN_PLUS"},
	{INTERFACEKEY_UNITVIEW_GEN, "UNITVIEW_GEN"},
	{INTERFACEKEY_UNITVIEW_INV, "UNITVIEW_INV"},
	{INTERFACEKEY_UNITVIEW_PRF, "UNITVIEW_PRF"},
	{INTERFACEKEY_UNITVIEW_WND, "UNITVIEW_WND"},
	{INTERFACEKEY_UNITVIEW_FOLLOW, "UNITVIEW_FOLLOW"},
	{INTERFACEKEY_UNITVIEW_NEXT, "UNITVIEW_NEXT"},
	{INTERFACEKEY_UNITVIEW_SLAUGHTER, "UNITVIEW_SLAUGHTER"},
	{INTERFACEKEY_UNITVIEW_GELD, "UNITVIEW_GELD"},
	{INTERFACEKEY_UNITVIEW_GEN_COMBAT, "UNITVIEW_GEN_COMBAT"},
	{INTERFACEKEY_UNITVIEW_GEN_LABOR, "UNITVIEW_GEN_LABOR"},
	{INTERFACEKEY_UNITVIEW_GEN_MISC, "UNITVIEW_GEN_MISC"},
	{INTERFACEKEY_UNITVIEW_PRF_PROF, "UNITVIEW_PRF_PROF"},
	{INTERFACEKEY_UNITVIEW_PRF_PET, "UNITVIEW_PRF_PET"},
	{INTERFACEKEY_UNITVIEW_PRF_EXPEL, "UNITVIEW_PRF_EXPEL"},
	{INTERFACEKEY_UNITVIEW_PRF_VIEW, "UNITVIEW_PRF_VIEW"},
	{INTERFACEKEY_UNITVIEW_PRF_NEW_SQUAD, "UNITVIEW_PRF_NEW_SQUAD"},
	{INTERFACEKEY_UNITVIEW_PRF_REMOVE_FROM_SQUAD, "UNITVIEW_PRF_REMOVE_FROM_SQUAD"},
	{INTERFACEKEY_UNITVIEW_PRF_NAME_CURRENT_SQUAD, "UNITVIEW_PRF_NAME_CURRENT_SQUAD"},
	{INTERFACEKEY_UNITVIEW_PRF_NAME_SELECTED_SQUAD, "UNITVIEW_PRF_NAME_SELECTED_SQUAD"},
	{INTERFACEKEY_UNITVIEW_PRF_OCCUPATION, "UNITVIEW_PRF_OCCUPATION"},
	*/

	{INTERFACEKEY_STRING_A000, "STRING_A000"},
	{INTERFACEKEY_STRING_A001, "STRING_A001"},
	{INTERFACEKEY_STRING_A002, "STRING_A002"},
	{INTERFACEKEY_STRING_A003, "STRING_A003"},
	{INTERFACEKEY_STRING_A004, "STRING_A004"},
	{INTERFACEKEY_STRING_A005, "STRING_A005"},
	{INTERFACEKEY_STRING_A006, "STRING_A006"},
	{INTERFACEKEY_STRING_A007, "STRING_A007"},
	{INTERFACEKEY_STRING_A008, "STRING_A008"},
	{INTERFACEKEY_STRING_A009, "STRING_A009"},
	{INTERFACEKEY_STRING_A010, "STRING_A010"},
	{INTERFACEKEY_STRING_A011, "STRING_A011"},
	{INTERFACEKEY_STRING_A012, "STRING_A012"},
	{INTERFACEKEY_STRING_A013, "STRING_A013"},
	{INTERFACEKEY_STRING_A014, "STRING_A014"},
	{INTERFACEKEY_STRING_A015, "STRING_A015"},
	{INTERFACEKEY_STRING_A016, "STRING_A016"},
	{INTERFACEKEY_STRING_A017, "STRING_A017"},
	{INTERFACEKEY_STRING_A018, "STRING_A018"},
	{INTERFACEKEY_STRING_A019, "STRING_A019"},
	{INTERFACEKEY_STRING_A020, "STRING_A020"},
	{INTERFACEKEY_STRING_A021, "STRING_A021"},
	{INTERFACEKEY_STRING_A022, "STRING_A022"},
	{INTERFACEKEY_STRING_A023, "STRING_A023"},
	{INTERFACEKEY_STRING_A024, "STRING_A024"},
	{INTERFACEKEY_STRING_A025, "STRING_A025"},
	{INTERFACEKEY_STRING_A026, "STRING_A026"},
	{INTERFACEKEY_STRING_A027, "STRING_A027"},
	{INTERFACEKEY_STRING_A028, "STRING_A028"},
	{INTERFACEKEY_STRING_A029, "STRING_A029"},
	{INTERFACEKEY_STRING_A030, "STRING_A030"},
	{INTERFACEKEY_STRING_A031, "STRING_A031"},
	{INTERFACEKEY_STRING_A032, "STRING_A032"},
	{INTERFACEKEY_STRING_A033, "STRING_A033"},
	{INTERFACEKEY_STRING_A034, "STRING_A034"},
	{INTERFACEKEY_STRING_A035, "STRING_A035"},
	{INTERFACEKEY_STRING_A036, "STRING_A036"},
	{INTERFACEKEY_STRING_A037, "STRING_A037"},
	{INTERFACEKEY_STRING_A038, "STRING_A038"},
	{INTERFACEKEY_STRING_A039, "STRING_A039"},
	{INTERFACEKEY_STRING_A040, "STRING_A040"},
	{INTERFACEKEY_STRING_A041, "STRING_A041"},
	{INTERFACEKEY_STRING_A042, "STRING_A042"},
	{INTERFACEKEY_STRING_A043, "STRING_A043"},
	{INTERFACEKEY_STRING_A044, "STRING_A044"},
	{INTERFACEKEY_STRING_A045, "STRING_A045"},
	{INTERFACEKEY_STRING_A046, "STRING_A046"},
	{INTERFACEKEY_STRING_A047, "STRING_A047"},
	{INTERFACEKEY_STRING_A048, "STRING_A048"},
	{INTERFACEKEY_STRING_A049, "STRING_A049"},
	{INTERFACEKEY_STRING_A050, "STRING_A050"},
	{INTERFACEKEY_STRING_A051, "STRING_A051"},
	{INTERFACEKEY_STRING_A052, "STRING_A052"},
	{INTERFACEKEY_STRING_A053, "STRING_A053"},
	{INTERFACEKEY_STRING_A054, "STRING_A054"},
	{INTERFACEKEY_STRING_A055, "STRING_A055"},
	{INTERFACEKEY_STRING_A056, "STRING_A056"},
	{INTERFACEKEY_STRING_A057, "STRING_A057"},
	{INTERFACEKEY_STRING_A058, "STRING_A058"},
	{INTERFACEKEY_STRING_A059, "STRING_A059"},
	{INTERFACEKEY_STRING_A060, "STRING_A060"},
	{INTERFACEKEY_STRING_A061, "STRING_A061"},
	{INTERFACEKEY_STRING_A062, "STRING_A062"},
	{INTERFACEKEY_STRING_A063, "STRING_A063"},
	{INTERFACEKEY_STRING_A064, "STRING_A064"},
	{INTERFACEKEY_STRING_A065, "STRING_A065"},
	{INTERFACEKEY_STRING_A066, "STRING_A066"},
	{INTERFACEKEY_STRING_A067, "STRING_A067"},
	{INTERFACEKEY_STRING_A068, "STRING_A068"},
	{INTERFACEKEY_STRING_A069, "STRING_A069"},
	{INTERFACEKEY_STRING_A070, "STRING_A070"},
	{INTERFACEKEY_STRING_A071, "STRING_A071"},
	{INTERFACEKEY_STRING_A072, "STRING_A072"},
	{INTERFACEKEY_STRING_A073, "STRING_A073"},
	{INTERFACEKEY_STRING_A074, "STRING_A074"},
	{INTERFACEKEY_STRING_A075, "STRING_A075"},
	{INTERFACEKEY_STRING_A076, "STRING_A076"},
	{INTERFACEKEY_STRING_A077, "STRING_A077"},
	{INTERFACEKEY_STRING_A078, "STRING_A078"},
	{INTERFACEKEY_STRING_A079, "STRING_A079"},
	{INTERFACEKEY_STRING_A080, "STRING_A080"},
	{INTERFACEKEY_STRING_A081, "STRING_A081"},
	{INTERFACEKEY_STRING_A082, "STRING_A082"},
	{INTERFACEKEY_STRING_A083, "STRING_A083"},
	{INTERFACEKEY_STRING_A084, "STRING_A084"},
	{INTERFACEKEY_STRING_A085, "STRING_A085"},
	{INTERFACEKEY_STRING_A086, "STRING_A086"},
	{INTERFACEKEY_STRING_A087, "STRING_A087"},
	{INTERFACEKEY_STRING_A088, "STRING_A088"},
	{INTERFACEKEY_STRING_A089, "STRING_A089"},
	{INTERFACEKEY_STRING_A090, "STRING_A090"},
	{INTERFACEKEY_STRING_A091, "STRING_A091"},
	{INTERFACEKEY_STRING_A092, "STRING_A092"},
	{INTERFACEKEY_STRING_A093, "STRING_A093"},
	{INTERFACEKEY_STRING_A094, "STRING_A094"},
	{INTERFACEKEY_STRING_A095, "STRING_A095"},
	{INTERFACEKEY_STRING_A096, "STRING_A096"},
	{INTERFACEKEY_STRING_A097, "STRING_A097"},
	{INTERFACEKEY_STRING_A098, "STRING_A098"},
	{INTERFACEKEY_STRING_A099, "STRING_A099"},
	{INTERFACEKEY_STRING_A100, "STRING_A100"},
	{INTERFACEKEY_STRING_A101, "STRING_A101"},
	{INTERFACEKEY_STRING_A102, "STRING_A102"},
	{INTERFACEKEY_STRING_A103, "STRING_A103"},
	{INTERFACEKEY_STRING_A104, "STRING_A104"},
	{INTERFACEKEY_STRING_A105, "STRING_A105"},
	{INTERFACEKEY_STRING_A106, "STRING_A106"},
	{INTERFACEKEY_STRING_A107, "STRING_A107"},
	{INTERFACEKEY_STRING_A108, "STRING_A108"},
	{INTERFACEKEY_STRING_A109, "STRING_A109"},
	{INTERFACEKEY_STRING_A110, "STRING_A110"},
	{INTERFACEKEY_STRING_A111, "STRING_A111"},
	{INTERFACEKEY_STRING_A112, "STRING_A112"},
	{INTERFACEKEY_STRING_A113, "STRING_A113"},
	{INTERFACEKEY_STRING_A114, "STRING_A114"},
	{INTERFACEKEY_STRING_A115, "STRING_A115"},
	{INTERFACEKEY_STRING_A116, "STRING_A116"},
	{INTERFACEKEY_STRING_A117, "STRING_A117"},
	{INTERFACEKEY_STRING_A118, "STRING_A118"},
	{INTERFACEKEY_STRING_A119, "STRING_A119"},
	{INTERFACEKEY_STRING_A120, "STRING_A120"},
	{INTERFACEKEY_STRING_A121, "STRING_A121"},
	{INTERFACEKEY_STRING_A122, "STRING_A122"},
	{INTERFACEKEY_STRING_A123, "STRING_A123"},
	{INTERFACEKEY_STRING_A124, "STRING_A124"},
	{INTERFACEKEY_STRING_A125, "STRING_A125"},
	{INTERFACEKEY_STRING_A126, "STRING_A126"},
	{INTERFACEKEY_STRING_A128, "STRING_A128"},
	{INTERFACEKEY_STRING_A129, "STRING_A129"},
	{INTERFACEKEY_STRING_A130, "STRING_A130"},
	{INTERFACEKEY_STRING_A131, "STRING_A131"},
	{INTERFACEKEY_STRING_A132, "STRING_A132"},
	{INTERFACEKEY_STRING_A133, "STRING_A133"},
	{INTERFACEKEY_STRING_A134, "STRING_A134"},
	{INTERFACEKEY_STRING_A135, "STRING_A135"},
	{INTERFACEKEY_STRING_A136, "STRING_A136"},
	{INTERFACEKEY_STRING_A137, "STRING_A137"},
	{INTERFACEKEY_STRING_A138, "STRING_A138"},
	{INTERFACEKEY_STRING_A139, "STRING_A139"},
	{INTERFACEKEY_STRING_A140, "STRING_A140"},
	{INTERFACEKEY_STRING_A141, "STRING_A141"},
	{INTERFACEKEY_STRING_A142, "STRING_A142"},
	{INTERFACEKEY_STRING_A143, "STRING_A143"},
	{INTERFACEKEY_STRING_A144, "STRING_A144"},
	{INTERFACEKEY_STRING_A145, "STRING_A145"},
	{INTERFACEKEY_STRING_A146, "STRING_A146"},
	{INTERFACEKEY_STRING_A147, "STRING_A147"},
	{INTERFACEKEY_STRING_A148, "STRING_A148"},
	{INTERFACEKEY_STRING_A149, "STRING_A149"},
	{INTERFACEKEY_STRING_A150, "STRING_A150"},
	{INTERFACEKEY_STRING_A151, "STRING_A151"},
	{INTERFACEKEY_STRING_A152, "STRING_A152"},
	{INTERFACEKEY_STRING_A153, "STRING_A153"},
	{INTERFACEKEY_STRING_A154, "STRING_A154"},
	{INTERFACEKEY_STRING_A155, "STRING_A155"},
	{INTERFACEKEY_STRING_A156, "STRING_A156"},
	{INTERFACEKEY_STRING_A157, "STRING_A157"},
	{INTERFACEKEY_STRING_A158, "STRING_A158"},
	{INTERFACEKEY_STRING_A159, "STRING_A159"},
	{INTERFACEKEY_STRING_A160, "STRING_A160"},
	{INTERFACEKEY_STRING_A161, "STRING_A161"},
	{INTERFACEKEY_STRING_A162, "STRING_A162"},
	{INTERFACEKEY_STRING_A163, "STRING_A163"},
	{INTERFACEKEY_STRING_A164, "STRING_A164"},
	{INTERFACEKEY_STRING_A165, "STRING_A165"},
	{INTERFACEKEY_STRING_A166, "STRING_A166"},
	{INTERFACEKEY_STRING_A167, "STRING_A167"},
	{INTERFACEKEY_STRING_A168, "STRING_A168"},
	{INTERFACEKEY_STRING_A169, "STRING_A169"},
	{INTERFACEKEY_STRING_A170, "STRING_A170"},
	{INTERFACEKEY_STRING_A171, "STRING_A171"},
	{INTERFACEKEY_STRING_A172, "STRING_A172"},
	{INTERFACEKEY_STRING_A173, "STRING_A173"},
	{INTERFACEKEY_STRING_A174, "STRING_A174"},
	{INTERFACEKEY_STRING_A175, "STRING_A175"},
	{INTERFACEKEY_STRING_A176, "STRING_A176"},
	{INTERFACEKEY_STRING_A177, "STRING_A177"},
	{INTERFACEKEY_STRING_A178, "STRING_A178"},
	{INTERFACEKEY_STRING_A179, "STRING_A179"},
	{INTERFACEKEY_STRING_A180, "STRING_A180"},
	{INTERFACEKEY_STRING_A181, "STRING_A181"},
	{INTERFACEKEY_STRING_A182, "STRING_A182"},
	{INTERFACEKEY_STRING_A183, "STRING_A183"},
	{INTERFACEKEY_STRING_A184, "STRING_A184"},
	{INTERFACEKEY_STRING_A185, "STRING_A185"},
	{INTERFACEKEY_STRING_A186, "STRING_A186"},
	{INTERFACEKEY_STRING_A187, "STRING_A187"},
	{INTERFACEKEY_STRING_A188, "STRING_A188"},
	{INTERFACEKEY_STRING_A189, "STRING_A189"},
	{INTERFACEKEY_STRING_A190, "STRING_A190"},
	{INTERFACEKEY_STRING_A191, "STRING_A191"},
	{INTERFACEKEY_STRING_A192, "STRING_A192"},
	{INTERFACEKEY_STRING_A193, "STRING_A193"},
	{INTERFACEKEY_STRING_A194, "STRING_A194"},
	{INTERFACEKEY_STRING_A195, "STRING_A195"},
	{INTERFACEKEY_STRING_A196, "STRING_A196"},
	{INTERFACEKEY_STRING_A197, "STRING_A197"},
	{INTERFACEKEY_STRING_A198, "STRING_A198"},
	{INTERFACEKEY_STRING_A199, "STRING_A199"},
	{INTERFACEKEY_STRING_A200, "STRING_A200"},
	{INTERFACEKEY_STRING_A201, "STRING_A201"},
	{INTERFACEKEY_STRING_A202, "STRING_A202"},
	{INTERFACEKEY_STRING_A203, "STRING_A203"},
	{INTERFACEKEY_STRING_A204, "STRING_A204"},
	{INTERFACEKEY_STRING_A205, "STRING_A205"},
	{INTERFACEKEY_STRING_A206, "STRING_A206"},
	{INTERFACEKEY_STRING_A207, "STRING_A207"},
	{INTERFACEKEY_STRING_A208, "STRING_A208"},
	{INTERFACEKEY_STRING_A209, "STRING_A209"},
	{INTERFACEKEY_STRING_A210, "STRING_A210"},
	{INTERFACEKEY_STRING_A211, "STRING_A211"},
	{INTERFACEKEY_STRING_A212, "STRING_A212"},
	{INTERFACEKEY_STRING_A213, "STRING_A213"},
	{INTERFACEKEY_STRING_A214, "STRING_A214"},
	{INTERFACEKEY_STRING_A215, "STRING_A215"},
	{INTERFACEKEY_STRING_A216, "STRING_A216"},
	{INTERFACEKEY_STRING_A217, "STRING_A217"},
	{INTERFACEKEY_STRING_A218, "STRING_A218"},
	{INTERFACEKEY_STRING_A219, "STRING_A219"},
	{INTERFACEKEY_STRING_A220, "STRING_A220"},
	{INTERFACEKEY_STRING_A221, "STRING_A221"},
	{INTERFACEKEY_STRING_A222, "STRING_A222"},
	{INTERFACEKEY_STRING_A223, "STRING_A223"},
	{INTERFACEKEY_STRING_A224, "STRING_A224"},
	{INTERFACEKEY_STRING_A225, "STRING_A225"},
	{INTERFACEKEY_STRING_A226, "STRING_A226"},
	{INTERFACEKEY_STRING_A227, "STRING_A227"},
	{INTERFACEKEY_STRING_A228, "STRING_A228"},
	{INTERFACEKEY_STRING_A229, "STRING_A229"},
	{INTERFACEKEY_STRING_A230, "STRING_A230"},
	{INTERFACEKEY_STRING_A231, "STRING_A231"},
	{INTERFACEKEY_STRING_A232, "STRING_A232"},
	{INTERFACEKEY_STRING_A233, "STRING_A233"},
	{INTERFACEKEY_STRING_A234, "STRING_A234"},
	{INTERFACEKEY_STRING_A235, "STRING_A235"},
	{INTERFACEKEY_STRING_A236, "STRING_A236"},
	{INTERFACEKEY_STRING_A237, "STRING_A237"},
	{INTERFACEKEY_STRING_A238, "STRING_A238"},
	{INTERFACEKEY_STRING_A239, "STRING_A239"},
	{INTERFACEKEY_STRING_A240, "STRING_A240"},
	{INTERFACEKEY_STRING_A241, "STRING_A241"},
	{INTERFACEKEY_STRING_A242, "STRING_A242"},
	{INTERFACEKEY_STRING_A243, "STRING_A243"},
	{INTERFACEKEY_STRING_A244, "STRING_A244"},
	{INTERFACEKEY_STRING_A245, "STRING_A245"},
	{INTERFACEKEY_STRING_A246, "STRING_A246"},
	{INTERFACEKEY_STRING_A247, "STRING_A247"},
	{INTERFACEKEY_STRING_A248, "STRING_A248"},
	{INTERFACEKEY_STRING_A249, "STRING_A249"},
	{INTERFACEKEY_STRING_A250, "STRING_A250"},
	{INTERFACEKEY_STRING_A251, "STRING_A251"},
	{INTERFACEKEY_STRING_A252, "STRING_A252"},
	{INTERFACEKEY_STRING_A253, "STRING_A253"},
	{INTERFACEKEY_STRING_A254, "STRING_A254"},
	{INTERFACEKEY_STRING_A255, "STRING_A255"},
	{INTERFACEKEY_CUSTOM_A, "CUSTOM_A"},
	{INTERFACEKEY_CUSTOM_B, "CUSTOM_B"},
	{INTERFACEKEY_CUSTOM_C, "CUSTOM_C"},
	{INTERFACEKEY_CUSTOM_D, "CUSTOM_D"},
	{INTERFACEKEY_CUSTOM_E, "CUSTOM_E"},
	{INTERFACEKEY_CUSTOM_F, "CUSTOM_F"},
	{INTERFACEKEY_CUSTOM_G, "CUSTOM_G"},
	{INTERFACEKEY_CUSTOM_H, "CUSTOM_H"},
	{INTERFACEKEY_CUSTOM_I, "CUSTOM_I"},
	{INTERFACEKEY_CUSTOM_J, "CUSTOM_J"},
	{INTERFACEKEY_CUSTOM_K, "CUSTOM_K"},
	{INTERFACEKEY_CUSTOM_L, "CUSTOM_L"},
	{INTERFACEKEY_CUSTOM_M, "CUSTOM_M"},
	{INTERFACEKEY_CUSTOM_N, "CUSTOM_N"},
	{INTERFACEKEY_CUSTOM_O, "CUSTOM_O"},
	{INTERFACEKEY_CUSTOM_P, "CUSTOM_P"},
	{INTERFACEKEY_CUSTOM_Q, "CUSTOM_Q"},
	{INTERFACEKEY_CUSTOM_R, "CUSTOM_R"},
	{INTERFACEKEY_CUSTOM_S, "CUSTOM_S"},
	{INTERFACEKEY_CUSTOM_T, "CUSTOM_T"},
	{INTERFACEKEY_CUSTOM_U, "CUSTOM_U"},
	{INTERFACEKEY_CUSTOM_V, "CUSTOM_V"},
	{INTERFACEKEY_CUSTOM_W, "CUSTOM_W"},
	{INTERFACEKEY_CUSTOM_X, "CUSTOM_X"},
	{INTERFACEKEY_CUSTOM_Y, "CUSTOM_Y"},
	{INTERFACEKEY_CUSTOM_Z, "CUSTOM_Z"},
	{INTERFACEKEY_CUSTOM_SHIFT_A, "CUSTOM_SHIFT_A"},
	{INTERFACEKEY_CUSTOM_SHIFT_B, "CUSTOM_SHIFT_B"},
	{INTERFACEKEY_CUSTOM_SHIFT_C, "CUSTOM_SHIFT_C"},
	{INTERFACEKEY_CUSTOM_SHIFT_D, "CUSTOM_SHIFT_D"},
	{INTERFACEKEY_CUSTOM_SHIFT_E, "CUSTOM_SHIFT_E"},
	{INTERFACEKEY_CUSTOM_SHIFT_F, "CUSTOM_SHIFT_F"},
	{INTERFACEKEY_CUSTOM_SHIFT_G, "CUSTOM_SHIFT_G"},
	{INTERFACEKEY_CUSTOM_SHIFT_H, "CUSTOM_SHIFT_H"},
	{INTERFACEKEY_CUSTOM_SHIFT_I, "CUSTOM_SHIFT_I"},
	{INTERFACEKEY_CUSTOM_SHIFT_J, "CUSTOM_SHIFT_J"},
	{INTERFACEKEY_CUSTOM_SHIFT_K, "CUSTOM_SHIFT_K"},
	{INTERFACEKEY_CUSTOM_SHIFT_L, "CUSTOM_SHIFT_L"},
	{INTERFACEKEY_CUSTOM_SHIFT_M, "CUSTOM_SHIFT_M"},
	{INTERFACEKEY_CUSTOM_SHIFT_N, "CUSTOM_SHIFT_N"},
	{INTERFACEKEY_CUSTOM_SHIFT_O, "CUSTOM_SHIFT_O"},
	{INTERFACEKEY_CUSTOM_SHIFT_P, "CUSTOM_SHIFT_P"},
	{INTERFACEKEY_CUSTOM_SHIFT_Q, "CUSTOM_SHIFT_Q"},
	{INTERFACEKEY_CUSTOM_SHIFT_R, "CUSTOM_SHIFT_R"},
	{INTERFACEKEY_CUSTOM_SHIFT_S, "CUSTOM_SHIFT_S"},
	{INTERFACEKEY_CUSTOM_SHIFT_T, "CUSTOM_SHIFT_T"},
	{INTERFACEKEY_CUSTOM_SHIFT_U, "CUSTOM_SHIFT_U"},
	{INTERFACEKEY_CUSTOM_SHIFT_V, "CUSTOM_SHIFT_V"},
	{INTERFACEKEY_CUSTOM_SHIFT_W, "CUSTOM_SHIFT_W"},
	{INTERFACEKEY_CUSTOM_SHIFT_X, "CUSTOM_SHIFT_X"},
	{INTERFACEKEY_CUSTOM_SHIFT_Y, "CUSTOM_SHIFT_Y"},
	{INTERFACEKEY_CUSTOM_SHIFT_Z, "CUSTOM_SHIFT_Z"},
	{INTERFACEKEY_CUSTOM_CTRL_A, "CUSTOM_CTRL_A"},
	{INTERFACEKEY_CUSTOM_CTRL_B, "CUSTOM_CTRL_B"},
	{INTERFACEKEY_CUSTOM_CTRL_C, "CUSTOM_CTRL_C"},
	{INTERFACEKEY_CUSTOM_CTRL_D, "CUSTOM_CTRL_D"},
	{INTERFACEKEY_CUSTOM_CTRL_E, "CUSTOM_CTRL_E"},
	{INTERFACEKEY_CUSTOM_CTRL_F, "CUSTOM_CTRL_F"},
	{INTERFACEKEY_CUSTOM_CTRL_G, "CUSTOM_CTRL_G"},
	{INTERFACEKEY_CUSTOM_CTRL_H, "CUSTOM_CTRL_H"},
	{INTERFACEKEY_CUSTOM_CTRL_I, "CUSTOM_CTRL_I"},
	{INTERFACEKEY_CUSTOM_CTRL_J, "CUSTOM_CTRL_J"},
	{INTERFACEKEY_CUSTOM_CTRL_K, "CUSTOM_CTRL_K"},
	{INTERFACEKEY_CUSTOM_CTRL_L, "CUSTOM_CTRL_L"},
	{INTERFACEKEY_CUSTOM_CTRL_M, "CUSTOM_CTRL_M"},
	{INTERFACEKEY_CUSTOM_CTRL_N, "CUSTOM_CTRL_N"},
	{INTERFACEKEY_CUSTOM_CTRL_O, "CUSTOM_CTRL_O"},
	{INTERFACEKEY_CUSTOM_CTRL_P, "CUSTOM_CTRL_P"},
	{INTERFACEKEY_CUSTOM_CTRL_Q, "CUSTOM_CTRL_Q"},
	{INTERFACEKEY_CUSTOM_CTRL_R, "CUSTOM_CTRL_R"},
	{INTERFACEKEY_CUSTOM_CTRL_S, "CUSTOM_CTRL_S"},
	{INTERFACEKEY_CUSTOM_CTRL_T, "CUSTOM_CTRL_T"},
	{INTERFACEKEY_CUSTOM_CTRL_U, "CUSTOM_CTRL_U"},
	{INTERFACEKEY_CUSTOM_CTRL_V, "CUSTOM_CTRL_V"},
	{INTERFACEKEY_CUSTOM_CTRL_W, "CUSTOM_CTRL_W"},
	{INTERFACEKEY_CUSTOM_CTRL_X, "CUSTOM_CTRL_X"},
	{INTERFACEKEY_CUSTOM_CTRL_Y, "CUSTOM_CTRL_Y"},
	{INTERFACEKEY_CUSTOM_CTRL_Z, "CUSTOM_CTRL_Z"},
	{INTERFACEKEY_CUSTOM_ALT_A, "CUSTOM_ALT_A"},
	{INTERFACEKEY_CUSTOM_ALT_B, "CUSTOM_ALT_B"},
	{INTERFACEKEY_CUSTOM_ALT_C, "CUSTOM_ALT_C"},
	{INTERFACEKEY_CUSTOM_ALT_D, "CUSTOM_ALT_D"},
	{INTERFACEKEY_CUSTOM_ALT_E, "CUSTOM_ALT_E"},
	{INTERFACEKEY_CUSTOM_ALT_F, "CUSTOM_ALT_F"},
	{INTERFACEKEY_CUSTOM_ALT_G, "CUSTOM_ALT_G"},
	{INTERFACEKEY_CUSTOM_ALT_H, "CUSTOM_ALT_H"},
	{INTERFACEKEY_CUSTOM_ALT_I, "CUSTOM_ALT_I"},
	{INTERFACEKEY_CUSTOM_ALT_J, "CUSTOM_ALT_J"},
	{INTERFACEKEY_CUSTOM_ALT_K, "CUSTOM_ALT_K"},
	{INTERFACEKEY_CUSTOM_ALT_L, "CUSTOM_ALT_L"},
	{INTERFACEKEY_CUSTOM_ALT_M, "CUSTOM_ALT_M"},
	{INTERFACEKEY_CUSTOM_ALT_N, "CUSTOM_ALT_N"},
	{INTERFACEKEY_CUSTOM_ALT_O, "CUSTOM_ALT_O"},
	{INTERFACEKEY_CUSTOM_ALT_P, "CUSTOM_ALT_P"},
	{INTERFACEKEY_CUSTOM_ALT_Q, "CUSTOM_ALT_Q"},
	{INTERFACEKEY_CUSTOM_ALT_R, "CUSTOM_ALT_R"},
	{INTERFACEKEY_CUSTOM_ALT_S, "CUSTOM_ALT_S"},
	{INTERFACEKEY_CUSTOM_ALT_T, "CUSTOM_ALT_T"},
	{INTERFACEKEY_CUSTOM_ALT_U, "CUSTOM_ALT_U"},
	{INTERFACEKEY_CUSTOM_ALT_V, "CUSTOM_ALT_V"},
	{INTERFACEKEY_CUSTOM_ALT_W, "CUSTOM_ALT_W"},
	{INTERFACEKEY_CUSTOM_ALT_X, "CUSTOM_ALT_X"},
	{INTERFACEKEY_CUSTOM_ALT_Y, "CUSTOM_ALT_Y"},
	{INTERFACEKEY_CUSTOM_ALT_Z, "CUSTOM_ALT_Z"},
	{INTERFACEKEY_FPS_UP, "FPS_UP"},
	{INTERFACEKEY_FPS_DOWN, "FPS_DOWN"},
	//{INTERFACEKEY_TOGGLE_TTF, "TOGGLE_TTF"},
	{INTERFACEKEY_PREFIX, "PREFIX"},
	{INTERFACEKEY_CUSTOM_UP, "CUSTOM_UP"},
	{INTERFACEKEY_CUSTOM_DOWN, "CUSTOM_DOWN"},
	{INTERFACEKEY_CUSTOM_LEFT, "CUSTOM_LEFT"},
	{INTERFACEKEY_CUSTOM_RIGHT, "CUSTOM_RIGHT"},
	{INTERFACEKEY_CUSTOM_TAB, "CUSTOM_TAB"},
	{INTERFACEKEY_CUSTOM_HOME, "CUSTOM_HOME"},
	{INTERFACEKEY_CUSTOM_END, "CUSTOM_END"},
	{INTERFACEKEY_CUSTOM_PGUP, "CUSTOM_PGUP"},
	{INTERFACEKEY_CUSTOM_PGDN, "CUSTOM_PGDN"},
	{INTERFACEKEY_CUSTOM_INSERT, "CUSTOM_INSERT"},
	{INTERFACEKEY_CUSTOM_DELETE, "CUSTOM_DELETE"},
	{INTERFACEKEY_CUSTOM_SHIFT_ENTER, "CUSTOM_SHIFT_ENTER"},
	{INTERFACEKEY_CUSTOM_SHIFT_BACKSPACE, "CUSTOM_SHIFT_BACKSPACE"},
	{INTERFACEKEY_CUSTOM_SHIFT_UP, "CUSTOM_SHIFT_UP"},
	{INTERFACEKEY_CUSTOM_SHIFT_DOWN, "CUSTOM_SHIFT_DOWN"},
	{INTERFACEKEY_CUSTOM_SHIFT_LEFT, "CUSTOM_SHIFT_LEFT"},
	{INTERFACEKEY_CUSTOM_SHIFT_RIGHT, "CUSTOM_SHIFT_RIGHT"},
	{INTERFACEKEY_CUSTOM_SHIFT_TAB, "CUSTOM_SHIFT_TAB"},
	{INTERFACEKEY_CUSTOM_SHIFT_HOME, "CUSTOM_SHIFT_HOME"},
	{INTERFACEKEY_CUSTOM_SHIFT_END, "CUSTOM_SHIFT_END"},
	{INTERFACEKEY_CUSTOM_SHIFT_PGUP, "CUSTOM_SHIFT_PGUP"},
	{INTERFACEKEY_CUSTOM_SHIFT_PGDN, "CUSTOM_SHIFT_PGDN"},
	{INTERFACEKEY_CUSTOM_SHIFT_INSERT, "CUSTOM_SHIFT_INSERT"},
	{INTERFACEKEY_CUSTOM_SHIFT_DELETE, "CUSTOM_SHIFT_DELETE"},
	{INTERFACEKEY_CUSTOM_CTRL_ENTER, "CUSTOM_CTRL_ENTER"},
	{INTERFACEKEY_CUSTOM_CTRL_BACKSPACE, "CUSTOM_CTRL_BACKSPACE"},
	{INTERFACEKEY_CUSTOM_CTRL_UP, "CUSTOM_CTRL_UP"},
	{INTERFACEKEY_CUSTOM_CTRL_DOWN, "CUSTOM_CTRL_DOWN"},
	{INTERFACEKEY_CUSTOM_CTRL_LEFT, "CUSTOM_CTRL_LEFT"},
	{INTERFACEKEY_CUSTOM_CTRL_RIGHT, "CUSTOM_CTRL_RIGHT"},
	{INTERFACEKEY_CUSTOM_CTRL_TAB, "CUSTOM_CTRL_TAB"},
	{INTERFACEKEY_CUSTOM_CTRL_HOME, "CUSTOM_CTRL_HOME"},
	{INTERFACEKEY_CUSTOM_CTRL_END, "CUSTOM_CTRL_END"},
	{INTERFACEKEY_CUSTOM_CTRL_PGUP, "CUSTOM_CTRL_PGUP"},
	{INTERFACEKEY_CUSTOM_CTRL_PGDN, "CUSTOM_CTRL_PGDN"},
	{INTERFACEKEY_CUSTOM_CTRL_INSERT, "CUSTOM_CTRL_INSERT"},
	{INTERFACEKEY_CUSTOM_CTRL_DELETE, "CUSTOM_CTRL_DELETE"},
	{INTERFACEKEY_CUSTOM_CTRL_SLASH, "CUSTOM_CTRL_SLASH"},
	{INTERFACEKEY_CUSTOM_CTRL_0, "CUSTOM_CTRL_0"},
	{INTERFACEKEY_CUSTOM_CTRL_1, "CUSTOM_CTRL_1"},
	{INTERFACEKEY_CUSTOM_CTRL_2, "CUSTOM_CTRL_2"},
	{INTERFACEKEY_CUSTOM_CTRL_3, "CUSTOM_CTRL_3"},
	{INTERFACEKEY_CUSTOM_CTRL_4, "CUSTOM_CTRL_4"},
	{INTERFACEKEY_CUSTOM_CTRL_5, "CUSTOM_CTRL_5"},
	{INTERFACEKEY_CUSTOM_CTRL_6, "CUSTOM_CTRL_6"},
	{INTERFACEKEY_CUSTOM_CTRL_7, "CUSTOM_CTRL_7"},
	{INTERFACEKEY_CUSTOM_CTRL_8, "CUSTOM_CTRL_8"},
	{INTERFACEKEY_CUSTOM_CTRL_9, "CUSTOM_CTRL_9"},
	{INTERFACEKEY_CUSTOM_CTRL_SHIFT_UP, "CUSTOM_CTRL_SHIFT_UP"},
	{INTERFACEKEY_CUSTOM_CTRL_SHIFT_DOWN, "CUSTOM_CTRL_SHIFT_DOWN"},
	{INTERFACEKEY_CUSTOM_CTRL_SHIFT_LEFT, "CUSTOM_CTRL_SHIFT_LEFT"},
	{INTERFACEKEY_CUSTOM_CTRL_SHIFT_RIGHT, "CUSTOM_CTRL_SHIFT_RIGHT"},
	{INTERFACEKEY_CUSTOM_ALT_0, "CUSTOM_ALT_0"},
	{INTERFACEKEY_CUSTOM_ALT_1, "CUSTOM_ALT_1"},
	{INTERFACEKEY_CUSTOM_ALT_2, "CUSTOM_ALT_2"},
	{INTERFACEKEY_CUSTOM_ALT_3, "CUSTOM_ALT_3"},
	{INTERFACEKEY_CUSTOM_ALT_4, "CUSTOM_ALT_4"},
	{INTERFACEKEY_CUSTOM_ALT_5, "CUSTOM_ALT_5"},
	{INTERFACEKEY_CUSTOM_ALT_6, "CUSTOM_ALT_6"},
	{INTERFACEKEY_CUSTOM_ALT_7, "CUSTOM_ALT_7"},
	{INTERFACEKEY_CUSTOM_ALT_8, "CUSTOM_ALT_8"},
	{INTERFACEKEY_CUSTOM_ALT_9, "CUSTOM_ALT_9"},
	};
        
	// DISPLAY NAMES
	displayNames = bimap<InterfaceKey, std::string>{
	//********************* MAIN KEY LOSS
	{INTERFACEKEY_NONE, "None"},
	{INTERFACEKEY_SELECT, "Select"},
	/*
	{INTERFACEKEY_SEC_SELECT, "Secondary Select"},
	{INTERFACEKEY_DESELECT, "Deselect"},
	*/
	{INTERFACEKEY_SELECT_ALL, "Select all"},
	/*
	{INTERFACEKEY_DESELECT_ALL, "Deselect All"},
	*/
	{INTERFACEKEY_LEAVESCREEN, "Leave screen"},
	//{INTERFACEKEY_LEAVESCREEN_ALL, "Leave all screens"},
	{INTERFACEKEY_CLOSE_MEGA_ANNOUNCEMENT, "Close mega announcement"},
	{INTERFACEKEY_TOGGLE_FULLSCREEN, "Toggle Fullscreen"},
	/*
	{INTERFACEKEY_WORLD_PARAM_ADD, "World Param: Add"},
	{INTERFACEKEY_WORLD_PARAM_COPY, "World Param: Copy"},
	{INTERFACEKEY_WORLD_PARAM_DELETE, "World Param: Delete"},
	{INTERFACEKEY_WORLD_PARAM_TITLE, "World Param: Title"},
	{INTERFACEKEY_WORLD_PARAM_NAME_RANDOM, "World Param: Name, Random"},
	{INTERFACEKEY_WORLD_PARAM_NAME_ENTER, "World Param: Name, Enter"},
	{INTERFACEKEY_WORLD_PARAM_SEED_RANDOM, "World Param: Seed, Random"},
	{INTERFACEKEY_WORLD_PARAM_SEED_ENTER, "World Param: Seed, Enter"},
	{INTERFACEKEY_WORLD_PARAM_LOAD, "World Param: Load"},
	{INTERFACEKEY_WORLD_PARAM_SAVE, "World Param: Save"},
	{INTERFACEKEY_WORLD_PARAM_DIM_X_UP, "World Param: Dim X, Up"},
	{INTERFACEKEY_WORLD_PARAM_DIM_X_DOWN, "World Param: Dim X, Down"},
	{INTERFACEKEY_WORLD_PARAM_DIM_Y_UP, "World Param: Dim Y, Up"},
	{INTERFACEKEY_WORLD_PARAM_DIM_Y_DOWN, "World Param: Dim Y, Down"},
	{INTERFACEKEY_WORLD_PARAM_SET, "World Param: Enter Advanced Parameters"},
	{INTERFACEKEY_WORLD_PARAM_INCREASE, "World Param: Increase Parameter"},
	{INTERFACEKEY_WORLD_PARAM_DECREASE, "World Param: Decrease Parameter"},
	{INTERFACEKEY_WORLD_PARAM_ENTER_VALUE, "World Param: Enter Value"},
	{INTERFACEKEY_WORLD_PARAM_NULLIFY, "World Param: Nullify Parameter"},
	{INTERFACEKEY_WORLD_PARAM_PRESET, "World Param: Set Presets"},
	{INTERFACEKEY_WORLD_PARAM_REJECT_CONTINUE, "World Param: Reject, Continue"},
	{INTERFACEKEY_WORLD_PARAM_REJECT_ABORT, "World Param: Reject, Abort"},
	{INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_THIS, "World Param: Reject, Allow This"},
	{INTERFACEKEY_WORLD_PARAM_REJECT_ALLOW_ALL, "World Param: Reject, Allow All"},
	{INTERFACEKEY_WORLD_GEN_CONTINUE, "World Generation: Continue"},
	{INTERFACEKEY_WORLD_GEN_USE, "World Generation: Use"},
	{INTERFACEKEY_WORLD_GEN_ABORT, "World Generation: Abort"},
	{INTERFACEKEY_SETUP_EMBARK, "Setup game: Embark"},
	{INTERFACEKEY_SETUP_NAME_FORT, "Setup game: Name Fort"},
	{INTERFACEKEY_SETUP_NAME_GROUP, "Setup game: Name Group"},
	{INTERFACEKEY_SETUP_SYMBOL, "Setup game: Symbol"},
	{INTERFACEKEY_SETUP_RECLAIM, "Setup game: Reclaim"},
	{INTERFACEKEY_SETUP_FIND, "Setup game: Find"},
	{INTERFACEKEY_SETUP_NOTES, "Setup game: Notes"},
	{INTERFACEKEY_SETUP_NOTES_TAKE_NOTES, "Setup game: Notes, New Note"},
	{INTERFACEKEY_SETUP_NOTES_DELETE_NOTE, "Setup game: Notes, Delete Note"},
	{INTERFACEKEY_SETUP_NOTES_CHANGE_SYMBOL_SELECTION, "Setup game: Notes, Change Symbol Selection"},
	{INTERFACEKEY_SETUP_NOTES_ADOPT_SYMBOL, "Setup game: Notes, Adopt Symbol"},
	{INTERFACEKEY_SETUP_LOCAL_Y_UP, "Setup game: Resize Local Y Up"},
	{INTERFACEKEY_SETUP_LOCAL_Y_DOWN, "Setup game: Resize Local Y Down"},
	{INTERFACEKEY_SETUP_LOCAL_X_UP, "Setup game: Resize Local X Up"},
	{INTERFACEKEY_SETUP_LOCAL_X_DOWN, "Setup game: Resize Local X Down"},
	{INTERFACEKEY_SETUP_LOCAL_Y_MUP, "Setup game: Move Local Y Up"},
	{INTERFACEKEY_SETUP_LOCAL_Y_MDOWN, "Setup game: Move Local Y Down"},
	{INTERFACEKEY_SETUP_LOCAL_X_MUP, "Setup game: Move Local X Up"},
	{INTERFACEKEY_SETUP_LOCAL_X_MDOWN, "Setup game: Move Local X Down"},
	{INTERFACEKEY_SETUP_BIOME_1, "Setup game: View Biome 1"},
	{INTERFACEKEY_SETUP_BIOME_2, "Setup game: View Biome 2"},
	{INTERFACEKEY_SETUP_BIOME_3, "Setup game: View Biome 3"},
	{INTERFACEKEY_SETUP_BIOME_4, "Setup game: View Biome 4"},
	{INTERFACEKEY_SETUP_BIOME_5, "Setup game: View Biome 5"},
	{INTERFACEKEY_SETUP_BIOME_6, "Setup game: View Biome 6"},
	{INTERFACEKEY_SETUP_BIOME_7, "Setup game: View Biome 7"},
	{INTERFACEKEY_SETUP_BIOME_8, "Setup game: View Biome 8"},
	{INTERFACEKEY_SETUP_BIOME_9, "Setup game: View Biome 9"},
	{INTERFACEKEY_CHOOSE_NAME_RANDOM, "Choose name: Random"},
	{INTERFACEKEY_CHOOSE_NAME_CLEAR, "Choose name: Clear"},
	{INTERFACEKEY_CHOOSE_NAME_TYPE, "Choose name: Type"},
	{INTERFACEKEY_CHOOSE_NAME_FIRST, "Choose name: First"},
	{INTERFACEKEY_ITEM_DESCRIPTION, "View item: Description"},
	{INTERFACEKEY_ITEM_FORBID, "View item: Forbid"},
	{INTERFACEKEY_ITEM_MELT, "View item: Melt"},
	{INTERFACEKEY_ITEM_DUMP, "View item: Dump"},
	{INTERFACEKEY_ITEM_HIDE, "View item: Hide"},
	*/
	{INTERFACEKEY_OPTIONS, "Main menu"},
	/*
	{INTERFACEKEY_OPTION_EXPORT, "Options, Export Local Image"},
	{INTERFACEKEY_HELP, "Help"},
	{INTERFACEKEY_MOVIES, "Movies"},
	*/
	{INTERFACEKEY_CHANGETAB, "Change tab or highlight selection"},
	{INTERFACEKEY_SEC_CHANGETAB, "Change tab or highlight selection, secondary"},
	{INTERFACEKEY_STANDARDSCROLL_UP, "Move selector up"},
	{INTERFACEKEY_STANDARDSCROLL_DOWN, "Move selector down"},
	{INTERFACEKEY_STANDARDSCROLL_LEFT, "Move selector left"},
	{INTERFACEKEY_STANDARDSCROLL_RIGHT, "Move selector right"},
	{INTERFACEKEY_STANDARDSCROLL_PAGEUP, "Page selector up"},
	{INTERFACEKEY_STANDARDSCROLL_PAGEDOWN, "Page selector down"},
	{INTERFACEKEY_CONTEXT_SCROLL_UP, "Mouse-context scrollbar up"},
	{INTERFACEKEY_CONTEXT_SCROLL_DOWN, "Mouse-context scrollbar down"},
	{INTERFACEKEY_CONTEXT_SCROLL_PAGEUP, "Mouse-context scrollbar page up"},
	{INTERFACEKEY_CONTEXT_SCROLL_PAGEDOWN, "Mouse-context scrollbar page down"},
	/*
	{INTERFACEKEY_SECONDSCROLL_UP, "Move secondary selector up"},
	{INTERFACEKEY_SECONDSCROLL_DOWN, "Move secondary selector down"},
	{INTERFACEKEY_SECONDSCROLL_PAGEUP, "Page secondary selector up"},
	{INTERFACEKEY_SECONDSCROLL_PAGEDOWN, "Page secondary selector down"},
	*/
	{INTERFACEKEY_CURSOR_UP, "Move view/cursor up"},
	{INTERFACEKEY_CURSOR_DOWN, "Move view/cursor down"},
	{INTERFACEKEY_CURSOR_LEFT, "Move view/cursor left"},
	{INTERFACEKEY_CURSOR_RIGHT, "Move view/cursor right"},
	{INTERFACEKEY_CURSOR_UPLEFT, "Move view/cursor up and left"},
	{INTERFACEKEY_CURSOR_UPRIGHT, "Move view/cursor up and right"},
	{INTERFACEKEY_CURSOR_DOWNLEFT, "Move view/cursor down and left"},
	{INTERFACEKEY_CURSOR_DOWNRIGHT, "Move view/cursor down and right"},
	{INTERFACEKEY_CURSOR_UP_FAST, "Move view/cursor up, fast"},
	{INTERFACEKEY_CURSOR_DOWN_FAST, "Move view/cursor down, fast"},
	{INTERFACEKEY_CURSOR_LEFT_FAST, "Move view/cursor left, fast"},
	{INTERFACEKEY_CURSOR_RIGHT_FAST, "Move view/cursor right, fast"},
	{INTERFACEKEY_CURSOR_UPLEFT_FAST, "Move view/cursor up and left, fast"},
	{INTERFACEKEY_CURSOR_UPRIGHT_FAST, "Move view/cursor up and right, fast"},
	{INTERFACEKEY_CURSOR_DOWNLEFT_FAST, "Move view/cursor down and left, fast"},
	{INTERFACEKEY_CURSOR_DOWNRIGHT_FAST, "Move view/cursor down and right, fast"},
	{INTERFACEKEY_CURSOR_UP_Z, "Move view/cursor up (z)"},
	{INTERFACEKEY_CURSOR_DOWN_Z, "Move view/cursor down (z)"},
	{INTERFACEKEY_CURSOR_UP_Z_AUX, "Move view/cursor up (z), aux"},
	{INTERFACEKEY_CURSOR_DOWN_Z_AUX, "Move view/cursor down (z), aux"},
	{INTERFACEKEY_CURSOR_UP_Z_FAST, "Move view/cursor up (z), fast"},
	{INTERFACEKEY_CURSOR_DOWN_Z_FAST, "Move view/cursor down (z), fast"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UP, "Move keyboard cursor up"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWN, "Move keyboard cursor down"},
	{INTERFACEKEY_KEYBOARD_CURSOR_LEFT, "Move keyboard cursor left"},
	{INTERFACEKEY_KEYBOARD_CURSOR_RIGHT, "Move keyboard cursor right"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UPLEFT, "Move keyboard cursor up and left"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UPRIGHT, "Move keyboard cursor up and right"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWNLEFT, "Move keyboard cursor down and left"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWNRIGHT, "Move keyboard cursor down and right"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UP_FAST, "Move keyboard cursor up, fast"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWN_FAST, "Move keyboard cursor down, fast"},
	{INTERFACEKEY_KEYBOARD_CURSOR_LEFT_FAST, "Move keyboard cursor left, fast"},
	{INTERFACEKEY_KEYBOARD_CURSOR_RIGHT_FAST, "Move keyboard cursor right, fast"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UPLEFT_FAST, "Move keyboard cursor up and left, fast"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UPRIGHT_FAST, "Move keyboard cursor up and right, fast"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWNLEFT_FAST, "Move keyboard cursor down and left, fast"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWNRIGHT_FAST, "Move keyboard cursor down and right, fast"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UP_Z, "Move keyboard cursor up (z)"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWN_Z, "Move keyboard cursor down (z)"},
	{INTERFACEKEY_KEYBOARD_CURSOR_UP_Z_AUX, "Move keyboard cursor up (z), aux"},
	{INTERFACEKEY_KEYBOARD_CURSOR_DOWN_Z_AUX, "Move keyboard cursor down (z), aux"},
	/*
	{INTERFACEKEY_A_RETURN_TO_ARENA, "Adventure: return to arena"},
	{INTERFACEKEY_A_MOVE_N, "Adventure: move north"},
	{INTERFACEKEY_A_MOVE_S, "Adventure: move south"},
	{INTERFACEKEY_A_MOVE_E, "Adventure: move east"},
	{INTERFACEKEY_A_MOVE_W, "Adventure: move west"},
	{INTERFACEKEY_A_MOVE_NW, "Adventure: move northwest"},
	{INTERFACEKEY_A_MOVE_NE, "Adventure: move northeast"},
	{INTERFACEKEY_A_MOVE_SW, "Adventure: move southwest"},
	{INTERFACEKEY_A_MOVE_SE, "Adventure: move southeast"},
	{INTERFACEKEY_A_MOVE_SAME_SQUARE, "Adventure: move same square"},
	{INTERFACEKEY_A_CARE_MOVE_N, "Adventure: careful move north up/down"},
	{INTERFACEKEY_A_CARE_MOVE_S, "Adventure: careful move south up/down"},
	{INTERFACEKEY_A_CARE_MOVE_E, "Adventure: careful move east up/down"},
	{INTERFACEKEY_A_CARE_MOVE_W, "Adventure: careful move west up/down"},
	{INTERFACEKEY_A_CARE_MOVE_NW, "Adventure: careful move northwest up/down"},
	{INTERFACEKEY_A_CARE_MOVE_NE, "Adventure: careful move northeast up/down"},
	{INTERFACEKEY_A_CARE_MOVE_SW, "Adventure: careful move southwest up/down"},
	{INTERFACEKEY_A_CARE_MOVE_SE, "Adventure: careful move southeast up/down"},
	{INTERFACEKEY_A_CARE_MOVE_UPDOWN, "Adventure: careful move up/down"},
	{INTERFACEKEY_A_MOVE_N_UP, "Adventure: move north/up"},
	{INTERFACEKEY_A_MOVE_S_UP, "Adventure: move south/up"},
	{INTERFACEKEY_A_MOVE_E_UP, "Adventure: move east/up"},
	{INTERFACEKEY_A_MOVE_W_UP, "Adventure: move west/up"},
	{INTERFACEKEY_A_MOVE_NW_UP, "Adventure: move northwest/up"},
	{INTERFACEKEY_A_MOVE_NE_UP, "Adventure: move northeast/up"},
	{INTERFACEKEY_A_MOVE_SW_UP, "Adventure: move southwest/up"},
	{INTERFACEKEY_A_MOVE_SE_UP, "Adventure: move southeast/up"},
	{INTERFACEKEY_A_MOVE_UP, "Adventure: move up"},
	{INTERFACEKEY_A_MOVE_N_DOWN, "Adventure: move north/down"},
	{INTERFACEKEY_A_MOVE_S_DOWN, "Adventure: move south/down"},
	{INTERFACEKEY_A_MOVE_E_DOWN, "Adventure: move east/down"},
	{INTERFACEKEY_A_MOVE_W_DOWN, "Adventure: move west/down"},
	{INTERFACEKEY_A_MOVE_NW_DOWN, "Adventure: move northwest/down"},
	{INTERFACEKEY_A_MOVE_NE_DOWN, "Adventure: move northeast/down"},
	{INTERFACEKEY_A_MOVE_SW_DOWN, "Adventure: move southwest/down"},
	{INTERFACEKEY_A_MOVE_SE_DOWN, "Adventure: move southeast/down"},
	{INTERFACEKEY_A_MOVE_DOWN, "Adventure: move down"},
	{INTERFACEKEY_A_MOVE_UP_AUX, "Adventure: move up, aux"},
	{INTERFACEKEY_A_MOVE_DOWN_AUX, "Adventure: move down, aux"},
	{INTERFACEKEY_WORLDGEN_EXPORT_MAP, "World Gen: Export Map"},
	{INTERFACEKEY_LEGENDS_EXPORT_MAP, "Legends: Export Map"},
	{INTERFACEKEY_LEGENDS_EXPORT_XML, "Legends: Export XML"},
	{INTERFACEKEY_LEGENDS_EXPORT_DETAILED_MAP, "Legends: Export Detailed Map"},
	{INTERFACEKEY_LEGENDS_TOGGLE_CIVSITE, "Legends: Civ/Site"},
	{INTERFACEKEY_LEGENDS_STRING_FILTER, "Legends: String filter"},
	{INTERFACEKEY_A_COMBAT_ATTACK, "Adventure: Combat, Attack Mode"},
	{INTERFACEKEY_A_COMBAT_DODGE, "Adventure: Combat, Dodge Mode"},
	{INTERFACEKEY_A_COMBAT_CHARGEDEF, "Adventure: Combat, Charge Defend Mode"},
	{INTERFACEKEY_A_STATUS, "Adventure: Status"},
	{INTERFACEKEY_A_STATUS_WRESTLE, "Adventure: Status, Close Combat"},
	{INTERFACEKEY_A_STATUS_CUSTOMIZE, "Adventure: Status, Customize"},
	{INTERFACEKEY_A_STATUS_KILLS, "Adventure: Status, Kills"},
	{INTERFACEKEY_A_STATUS_HEALTH, "Adventure: Status, Health"},
	{INTERFACEKEY_A_STATUS_ATT_SKILL, "Adventure: Status, Att/Skills"},
	{INTERFACEKEY_A_STATUS_DESC, "Adventure: Status, Desc"},
	{INTERFACEKEY_UNITVIEW_CUSTOMIZE, "Unit View, Customize"},
	{INTERFACEKEY_UNITVIEW_HEALTH, "Unit View, Health"},
	{INTERFACEKEY_UNITVIEW_RELATIONSHIPS, "Unit View, Relationships"},
	{INTERFACEKEY_UNITVIEW_RELATIONSHIPS_ZOOM, "Unit View, Relationships, Zoom"},
	{INTERFACEKEY_UNITVIEW_RELATIONSHIPS_VIEW, "Unit View, Relationships, View"},
	{INTERFACEKEY_UNITVIEW_KILLS, "Unit View, Kills"},
	{INTERFACEKEY_CUSTOMIZE_UNIT_NICKNAME, "Customize Unit, Nickname"},
	{INTERFACEKEY_CUSTOMIZE_UNIT_PROFNAME, "Customize Unit, Profession"},
	{INTERFACEKEY_IMAGE_CREATOR_FILTER, "Image Creator: Filter"},
	{INTERFACEKEY_IMAGE_CREATOR_NAME, "Image Creator: Name"},
	{INTERFACEKEY_IMAGE_CREATOR_DONE, "Image Creator: Done"},
	{INTERFACEKEY_CIV_RAID, "World: Raid"},
	{INTERFACEKEY_CIV_CENTER_ON_FORT, "World: Center on Fort"},
	{INTERFACEKEY_CIV_HOLDINGS, "World: Holdings"},
	{INTERFACEKEY_CIV_MAP_LEGEND, "World: Map Legend"},
	{INTERFACEKEY_CIV_REMOVE_MISSION, "World: Remove Mission"},
	{INTERFACEKEY_CIV_RESCUE, "World: Rescue Person"},
	{INTERFACEKEY_CIV_RECOVER, "World: Recover Artifact"},
	{INTERFACEKEY_CIV_WORLD, "World: World Map"},
	{INTERFACEKEY_CIV_MISSIONS, "World: Missions"},
	{INTERFACEKEY_CIV_MISSION_DETAILS, "World: Missions, Details"},
	{INTERFACEKEY_CIV_MISSION_FREE_CAPTIVES, "World: Missions, Details, Free Captives"},
	{INTERFACEKEY_CIV_MISSION_RELEASE_OTHERS, "World: Missions, Details, Release Others"},
	{INTERFACEKEY_CIV_MISSION_TAKE_ARTIFACTS, "World: Missions, Details, Artifacts"},
	{INTERFACEKEY_CIV_MISSION_TAKE_ITEMS, "World: Missions, Details, Items"},
	{INTERFACEKEY_CIV_MISSION_TAKE_LIVESTOCK, "World: Missions, Details, Livestock"},
	{INTERFACEKEY_CIV_MISSION_RAID, "World: Missions, Details, Raid"},
	{INTERFACEKEY_CIV_MISSION_PILLAGE, "World: Missions, Details, Pillage"},
	{INTERFACEKEY_CIV_MISSION_RAZE, "World: Missions, Details, Raze"},
	{INTERFACEKEY_CIV_MISSION_TRIBUTE_ONE_TIME, "World: Missions, Details, One-Time Tribute"},
	{INTERFACEKEY_CIV_MISSION_TRIBUTE_ONGOING, "World: Missions, Details, Ongoing Tribute"},
	{INTERFACEKEY_CIV_MISSION_CONQUER, "World: Missions, Details, Conquer"},
	{INTERFACEKEY_CIV_MISSION_DEMAND_SURRENDER, "World: Missions, Details, Demand Surrender"},
	{INTERFACEKEY_CIV_NEWS, "World: News and Rumors"},
	{INTERFACEKEY_CIV_PEOPLE, "World: People"},
	{INTERFACEKEY_CIV_ARTIFACTS, "World: Artifacts"},
	{INTERFACEKEY_CIV_CIVS, "World: Civilizations"},
	{INTERFACEKEY_A_CLEAR_ANNOUNCEMENTS, "Adventure: Clear announcements"},
	{INTERFACEKEY_A_SLEEP, "Adventure: Sleep"},
	{INTERFACEKEY_A_SLEEP_SLEEP, "Adventure: Sleep, Sleep"},
	{INTERFACEKEY_A_SLEEP_WAIT, "Adventure: Sleep, Wait"},
	{INTERFACEKEY_A_SLEEP_DAWN, "Adventure: Sleep, Dawn"},
	{INTERFACEKEY_A_WAIT, "Adventure: Wait Ten Instants"},
	{INTERFACEKEY_A_SHORT_WAIT, "Adventure: Wait One Instant"},
	{INTERFACEKEY_A_ATTACK, "Adventure: Attack"},
	{INTERFACEKEY_A_ATTACK_CONFIRM, "Adventure: Attack, Confirm"},
	{INTERFACEKEY_QUICK_ATTACK, "Adventure: Attack, Quick"},
	{INTERFACEKEY_HEAVY_ATTACK, "Adventure: Attack, Heavy"},
	{INTERFACEKEY_WILD_ATTACK, "Adventure: Attack, Wild"},
	{INTERFACEKEY_PRECISE_ATTACK, "Adventure: Attack, Precise"},
	{INTERFACEKEY_CHARGE_ATTACK, "Adventure: Attack, Charge"},
	{INTERFACEKEY_MULTI_ATTACK, "Adventure: Attack, Multi"},
	{INTERFACEKEY_A_LOOK, "Adventure: Look"},
	{INTERFACEKEY_A_SEARCH, "Adventure: Search"},
	{INTERFACEKEY_A_ODOR, Adventure: Describe Odor},
	{INTERFACEKEY_A_DISPLAY_ODOR, Adventure: Display Strongest Odor},
	{INTERFACEKEY_A_YIELD, Adventure: Yield},
	{INTERFACEKEY_A_DISPLAY_TRACKS, Adventure: Display Tracks},
	{INTERFACEKEY_A_FRESHEST_TRACK, Adventure: Freshest Track},
	{INTERFACEKEY_A_INV_DRAW_WEAPON, Adventure: Inv. Draw Weapon},
	{INTERFACEKEY_A_JUMP, Adventure: Jump},
	{INTERFACEKEY_A_HOLD, Adventure: Hold/Hang (Climb)},
	{INTERFACEKEY_A_TALK, "Adventure: Talk"},
	{INTERFACEKEY_A_CONV_PERSUADE, "Adventure: Talk, Persuade"},
	{INTERFACEKEY_A_CONV_INTIMIDATE, "Adventure: Talk, Intimidate"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_NEW, "Adventure: Assume Identity, New"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_NONE, "Adventure: Assume Identity, None"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_NAME, "Adventure: Assume Identity, Name"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_ORIGIN, "Adventure: Assume Identity, Origin"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_PROFESSION, "Adventure: Assume Identity, Profession"},
	{INTERFACEKEY_A_ASSUME_IDENTITY_WORSHIP, "Adventure: Assume Identity, Worship"},
	{INTERFACEKEY_A_INTERACT, "Adventure: Inv. Interact"},
	{INTERFACEKEY_A_ACTION, "Adventure: Misc. Action"},
	{INTERFACEKEY_A_ACTION_CREATE, "Adventure: Misc. Action, Create"},
	{INTERFACEKEY_A_ACTION_BUTCHER, "Adventure: Misc. Action, Butcher"},
	{INTERFACEKEY_A_ACTION_ABILITY, "Adventure: Misc. Action, Ability"},
	{INTERFACEKEY_A_ACTION_POWER, "Adventure: Misc. Action, Power"},
	{INTERFACEKEY_A_ACTION_COMPOSE, "Adventure: Misc. Action, Compose"},
	{INTERFACEKEY_A_ACTION_WRITE, "Adventure: Misc. Action, Write"},
	{INTERFACEKEY_A_CONSTRUCTION, "Adventure: Construction"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_NEW, "Adventure: Construction, New Zone"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_EDIT, "Adventure: Construction, Edit Zone"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_ASSIGN, "Adventure: Construction, Assign Zone"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_DELETE, "Adventure: Construction, Delete Zone"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_RECT, "Adventure: Construction, Zone Rect"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_FLOW, "Adventure: Construction, Zone Flow"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE_REMOVE_RECT, "Adventure: Construction, Remove Zone Rect"},
	{INTERFACEKEY_ADV_CONSTRUCTION_STAIR_UPDOWN, "Adventure: Construction, Stair Up/down"},
	{INTERFACEKEY_ADV_CONSTRUCTION_REMOVE_PLANS, "Adventure: Construction, Remove Plans"},
	{INTERFACEKEY_ADV_CONSTRUCTION_REMOVE_EXISTING, "Adventure: Construction, Remove Existing"},
	{INTERFACEKEY_ADV_CONSTRUCTION_MATERIAL, "Adventure: Construction, Material"},
	{INTERFACEKEY_ADV_CONSTRUCTION_CONSTRUCTION, "Adventure: Construction, Constructions"},
	{INTERFACEKEY_ADV_CONSTRUCTION_BUILDING, "Adventure: Construction, Buildings"},
	{INTERFACEKEY_ADV_CONSTRUCTION_ZONE, "Adventure: Construction, Zones"},
	{INTERFACEKEY_ADV_CONSTRUCTION_WORK_MENU, "Adventure: Construction, Work Menu"},
	{INTERFACEKEY_ADV_CONSTRUCTION_NAME_SITE, "Adventure: Construction, Name Site"},
	{INTERFACEKEY_ADV_CONSTRUCTION_YOU_WORK, "Adventure: Construction, You Work"},
	{INTERFACEKEY_ADV_CONSTRUCTION_START, "Adventure: Construction, Start"},
	{INTERFACEKEY_A_COMPOSE_FILTER, "Adventure: Compose, Filter"},
	{INTERFACEKEY_A_INV_LOOK, "Adventure: Inv. Look"},
	{INTERFACEKEY_A_INV_REMOVE, "Adventure: Inv. Remove"},
	{INTERFACEKEY_A_INV_WEAR, "Adventure: Inv. Wear"},
	{INTERFACEKEY_A_INV_EATDRINK, "Adventure: Inv. Eat/Drink"},
	{INTERFACEKEY_A_INV_PUTIN, "Adventure: Inv. Put In"},
	{INTERFACEKEY_A_INV_DROP, "Adventure: Inv. Drop"},
	{INTERFACEKEY_A_GROUND, "Adventure: Get/Ground"},
	{INTERFACEKEY_A_THROW, "Adventure: Throw"},
	{INTERFACEKEY_A_SHOOT, "Adventure: Fire"},
	{INTERFACEKEY_A_ANNOUNCEMENTS, "Adventure: Announcements"},
	{INTERFACEKEY_A_COMBAT, "Adventure: Combat Options"},
	{INTERFACEKEY_A_TACTICAL_SETTINGS, "Adventure: Party Tactical Settings"},
	{INTERFACEKEY_A_MOVEMENT, "Adventure: Movement Options"},
	{INTERFACEKEY_A_MOVEMENT_SWIM, "Adventure: Movement Options, Swim"},
	{INTERFACEKEY_A_SNEAK, "Adventure: Sneak"},
	{INTERFACEKEY_A_SPEED_SNEAK, "Adventure: Speed and Sneaking Options"},
	{INTERFACEKEY_A_CENTER, "Adventure: Center"},
	{INTERFACEKEY_A_COMPANIONS, "Adventure: Companions"},
	{INTERFACEKEY_A_BUILDING, "Adventure: Building Interact"},
	{INTERFACEKEY_A_TRAVEL, "Adventure: Travel"},
	{INTERFACEKEY_A_TRAVEL_SLEEP, "Adventure: Travel, Sleep"},
	{INTERFACEKEY_A_TRAVEL_MAP, "Adventure: Travel, Map"},
	{INTERFACEKEY_A_TRAVEL_HIDE_INSTRUCTIONS, "Adventure: Travel, Hide Instructions"},
	{INTERFACEKEY_A_DATE, "Adventure: Get Date"},
	{INTERFACEKEY_A_WEATHER, "Adventure: Get Weather"},
	{INTERFACEKEY_A_TEMPERATURE, "Adventure: Get Temperature"},
	{INTERFACEKEY_A_STANCE, "Adventure: Change Stance"},
	{INTERFACEKEY_OPTION1, "Option 1"},
	{INTERFACEKEY_OPTION2, "Option 2"},
	{INTERFACEKEY_OPTION3, "Option 3"},
	{INTERFACEKEY_OPTION4, "Option 4"},
	{INTERFACEKEY_OPTION5, "Option 5"},
	{INTERFACEKEY_OPTION6, "Option 6"},
	{INTERFACEKEY_OPTION7, "Option 7"},
	{INTERFACEKEY_OPTION8, "Option 8"},
	{INTERFACEKEY_OPTION9, "Option 9"},
	{INTERFACEKEY_OPTION10, "Option 10"},
	{INTERFACEKEY_OPTION11, "Option 11"},
	{INTERFACEKEY_OPTION12, "Option 12"},
	{INTERFACEKEY_OPTION13, "Option 13"},
	{INTERFACEKEY_OPTION14, "Option 14"},
	{INTERFACEKEY_OPTION15, "Option 15"},
	{INTERFACEKEY_OPTION16, "Option 16"},
	{INTERFACEKEY_OPTION17, "Option 17"},
	{INTERFACEKEY_OPTION18, "Option 18"},
	{INTERFACEKEY_OPTION19, "Option 19"},
	{INTERFACEKEY_OPTION20, "Option 20"},
	{INTERFACEKEY_SEC_OPTION1, "Secondary Option 1"},
	{INTERFACEKEY_SEC_OPTION2, "Secondary Option 2"},
	{INTERFACEKEY_SEC_OPTION3, "Secondary Option 3"},
	{INTERFACEKEY_SEC_OPTION4, "Secondary Option 4"},
	{INTERFACEKEY_SEC_OPTION5, "Secondary Option 5"},
	{INTERFACEKEY_SEC_OPTION6, "Secondary Option 6"},
	{INTERFACEKEY_SEC_OPTION7, "Secondary Option 7"},
	{INTERFACEKEY_SEC_OPTION8, "Secondary Option 8"},
	{INTERFACEKEY_SEC_OPTION9, "Secondary Option 9"},
	{INTERFACEKEY_SEC_OPTION10, "Secondary Option 10"},
	{INTERFACEKEY_SEC_OPTION11, "Secondary Option 11"},
	{INTERFACEKEY_SEC_OPTION12, "Secondary Option 12"},
	{INTERFACEKEY_SEC_OPTION13, "Secondary Option 13"},
	{INTERFACEKEY_SEC_OPTION14, "Secondary Option 14"},
	{INTERFACEKEY_SEC_OPTION15, "Secondary Option 15"},
	{INTERFACEKEY_SEC_OPTION16, "Secondary Option 16"},
	{INTERFACEKEY_SEC_OPTION17, "Secondary Option 17"},
	{INTERFACEKEY_SEC_OPTION18, "Secondary Option 18"},
	{INTERFACEKEY_SEC_OPTION19, "Secondary Option 19"},
	{INTERFACEKEY_SEC_OPTION20, "Secondary Option 20"},
	{INTERFACEKEY_HOTKEY_MAKE_ASH, "Hotkey: Make Ash"},
	{INTERFACEKEY_HOTKEY_MAKE_CHARCOAL, "Hotkey: Make Charcoal"},
	{INTERFACEKEY_HOTKEY_MELT_OBJECT, "Hotkey: Melt Object"},
	{INTERFACEKEY_HOTKEY_GLASS_GREEN, "Hotkey: Green Glass"},
	{INTERFACEKEY_HOTKEY_GLASS_CLEAR, "Hotkey: Clear Glass"},
	{INTERFACEKEY_HOTKEY_GLASS_CRYSTAL, "Hotkey: Crystal Glass"},
	{INTERFACEKEY_HOTKEY_COLLECT_SAND, "Hotkey: Collect Sand"},
	{INTERFACEKEY_HOTKEY_COLLECT_CLAY, "Hotkey: Collect Clay"},
	{INTERFACEKEY_HOTKEY_GLASS_ROUGH, "Hotkey: Raw Glass"},
	{INTERFACEKEY_HOTKEY_GLASS_ARMORSTAND, "Hotkey: Glass Armorstand"},
	{INTERFACEKEY_HOTKEY_GLASS_BOX, "Hotkey: Glass Box"},
	{INTERFACEKEY_HOTKEY_GLASS_CABINET, "Hotkey: Glass Cabinet"},
	{INTERFACEKEY_HOTKEY_GLASS_COFFIN, "Hotkey: Glass Coffin"},
	{INTERFACEKEY_HOTKEY_GLASS_FLOODGATE, "Hotkey: Glass Floodgate"},
	{INTERFACEKEY_HOTKEY_GLASS_HATCH_COVER, "Hotkey: Glass Hatch Cover"},
	{INTERFACEKEY_HOTKEY_GLASS_GRATE, "Hotkey: Glass Grate"},
	{INTERFACEKEY_HOTKEY_GLASS_GOBLET, "Hotkey: Glass Goblet"},
	{INTERFACEKEY_HOTKEY_GLASS_TOY, "Hotkey: Glass Toy"},
	{INTERFACEKEY_HOTKEY_GLASS_DOOR, "Hotkey: Glass Portal"},
	{INTERFACEKEY_HOTKEY_GLASS_STATUE, "Hotkey: Glass Statue"},
	{INTERFACEKEY_HOTKEY_GLASS_TABLE, "Hotkey: Glass Table"},
	{INTERFACEKEY_HOTKEY_GLASS_CAGE, "Hotkey: Glass Cage"},
	{INTERFACEKEY_HOTKEY_GLASS_CHAIR, "Hotkey: Glass Chair"},
	{INTERFACEKEY_HOTKEY_GLASS_BLOCKS, "Hotkey: Glass Blocks"},
	{INTERFACEKEY_HOTKEY_GLASS_FLASK, "Hotkey: Glass Vial"},
	{INTERFACEKEY_HOTKEY_GLASS_WEAPONRACK, "Hotkey: Glass Weaponrack"},
	{INTERFACEKEY_HOTKEY_GLASS_WINDOW, "Hotkey: Glass Window"},
	{INTERFACEKEY_HOTKEY_ASHERY_LYE, "Hotkey: Ashery, Lye"},
	{INTERFACEKEY_HOTKEY_ASHERY_POTASH, "Hotkey: Ashery, Potash (Lye)"},
	{INTERFACEKEY_HOTKEY_ASHERY_POTASH_DIRECT, "Hotkey: Ashery, Potash (Ash)"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BARREL, "Hotkey: Carpenter, Barrel"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BLOCKS, "Hotkey: Carpenter, Blocks"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BUCKET, "Hotkey: Carpenter, Bucket"},
	{INTERFACEKEY_HOTKEY_CARPENTER_TRAP_ANIMAL, "Hotkey: Carpenter, Animal Trap"},
	{INTERFACEKEY_HOTKEY_CARPENTER_CAGE, "Hotkey: Carpenter, Cage"},
	{INTERFACEKEY_HOTKEY_CARPENTER_ARMORSTAND, "Hotkey: Carpenter, Armorstand"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BED, "Hotkey: Carpenter, Bed"},
	{INTERFACEKEY_HOTKEY_CARPENTER_CHAIR, "Hotkey: Carpenter, Chair"},
	{INTERFACEKEY_HOTKEY_CARPENTER_COFFIN, "Hotkey: Carpenter, Coffin"},
	{INTERFACEKEY_HOTKEY_CARPENTER_DOOR, "Hotkey: Carpenter, Door"},
	{INTERFACEKEY_HOTKEY_CARPENTER_FLOODGATE, "Hotkey: Carpenter, Floodgate"},
	{INTERFACEKEY_HOTKEY_CARPENTER_HATCH_COVER, "Hotkey: Carpenter, Hatch Cover"},
	{INTERFACEKEY_HOTKEY_CARPENTER_GRATE, "Hotkey: Carpenter, Grate"},
	{INTERFACEKEY_HOTKEY_CARPENTER_CABINET, "Hotkey: Carpenter, Cabinet"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BIN, "Hotkey: Carpenter, Bin"},
	{INTERFACEKEY_HOTKEY_CARPENTER_BOX, "Hotkey: Carpenter, Box"},
	{INTERFACEKEY_HOTKEY_CARPENTER_WEAPONRACK, "Hotkey: Carpenter, Weaponrack"},
	{INTERFACEKEY_HOTKEY_CARPENTER_TABLE, "Hotkey: Carpenter, Table"},
	{INTERFACEKEY_HOTKEY_SIEGE_BALLISTA, "Hotkey: Siege Shop, Ballista"},
	{INTERFACEKEY_HOTKEY_SIEGE_CATAPULT, "Hotkey: Siege Shop, Catapult"},
	{INTERFACEKEY_HOTKEY_LEATHER_BOX, "Hotkey: Leather, Bag"},
	{INTERFACEKEY_HOTKEY_LEATHER_FLASK, "Hotkey: Leather, Flask"},
	{INTERFACEKEY_HOTKEY_LEATHER_SHIRT, "Hotkey: Leather, Shirt"},
	{INTERFACEKEY_HOTKEY_LEATHER_CLOAK, "Hotkey: Leather, Cloak"},
	{INTERFACEKEY_HOTKEY_LEATHER_BACKPACK, "Hotkey: Leather, Backpack"},
	{INTERFACEKEY_HOTKEY_LEATHER_QUIVER, "Hotkey: Leather, Quiver"},
	{INTERFACEKEY_HOTKEY_LEATHER_IMAGE, "Hotkey: Leather, Image"},
	{INTERFACEKEY_HOTKEY_CLOTHES_MAT_PLANT, "Hotkey: Clothes, Cloth"},
	{INTERFACEKEY_HOTKEY_CLOTHES_MAT_SILK, "Hotkey: Clothes, Silk"},
	{INTERFACEKEY_HOTKEY_CLOTHES_MAT_YARN, "Hotkey: Clothes, Yarn"},
	{INTERFACEKEY_HOTKEY_CLOTHES_SHIRT, "Hotkey: Clothes, Shirt"},
	{INTERFACEKEY_HOTKEY_CLOTHES_CLOAK, "Hotkey: Clothes, Cloak"},
	{INTERFACEKEY_HOTKEY_CLOTHES_BOX, "Hotkey: Clothes, Box"},
	{INTERFACEKEY_HOTKEY_CLOTHES_CHAIN, "Hotkey: Clothes, Rope"},
	{INTERFACEKEY_HOTKEY_CLOTHES_IMAGE, "Hotkey: Clothes, Image"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_STONE, "Hotkey: Crafts, Mat Stone"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_WOOD, "Hotkey: Crafts, Mat Wood"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_BONE, "Hotkey: Crafts, Dec Bone"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_SHELL, "Hotkey: Crafts, Dec Shell"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_TOOTH, "Hotkey: Crafts, Dec Tooth"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_HORN, "Hotkey: Crafts, Dec Horn"},
	{INTERFACEKEY_HOTKEY_CRAFTS_DEC_PEARL, "Hotkey: Crafts, Dec Pearl"},
	{INTERFACEKEY_HOTKEY_CRAFTS_TOTEM, "Hotkey: Crafts, Totem"},
	{INTERFACEKEY_HOTKEY_CRAFTS_CLOTH, "Hotkey: Crafts, Cloth"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SILK, "Hotkey: Crafts, Silk"},
	{INTERFACEKEY_HOTKEY_CRAFTS_YARN, "Hotkey: Crafts, Yarn"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SEL_WOOD, "Hotkey: Crafts, Wood Material"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SEL_BONE, "Hotkey: Crafts, Bone Material"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SEL_SHELL, "Hotkey: Crafts, Shell Material"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SHELL, "Hotkey: Crafts, Shell"},
	{INTERFACEKEY_HOTKEY_CRAFTS_TOOTH, "Hotkey: Crafts, Tooth"},
	{INTERFACEKEY_HOTKEY_CRAFTS_HORN, "Hotkey: Crafts, Horn"},
	{INTERFACEKEY_HOTKEY_CRAFTS_PEARL, "Hotkey: Crafts, Pearl"},
	{INTERFACEKEY_HOTKEY_CRAFTS_BONE, "Hotkey: Crafts, Bone"},
	{INTERFACEKEY_HOTKEY_CRAFTS_LEATHER, "Hotkey: Crafts, Leather"},
	{INTERFACEKEY_HOTKEY_CRAFTS_SLAB, "Hotkey: Crafts, Slab"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_CRAFTS, "Hotkey: Crafts, Mat Crafts"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_GOBLET, "Hotkey: Crafts, Mat Goblet"},
	{INTERFACEKEY_HOTKEY_CRAFTS_MAT_TOY, "Hotkey: Crafts, Mat Toy"},
	{INTERFACEKEY_HOTKEY_SMITH_WEAPON, "Hotkey: Forge, Weapon"},
	{INTERFACEKEY_HOTKEY_SMITH_ARMOR, "Hotkey: Forge, Armor"},
	{INTERFACEKEY_HOTKEY_SMITH_FURNITURE, "Hotkey: Forge, Furniture"},
	{INTERFACEKEY_HOTKEY_SMITH_SIEGE, "Hotkey: Forge, Siege"},
	{INTERFACEKEY_HOTKEY_SMITH_TRAP, "Hotkey: Forge, Trap"},
	{INTERFACEKEY_HOTKEY_SMITH_OTHER, "Hotkey: Forge, Other"},
	{INTERFACEKEY_HOTKEY_SMITH_METAL, "Hotkey: Forge, Metal Clothing"},
	*/
	{INTERFACEKEY_HOTKEY_BUILDING_ARMORSTAND, "Hotkey: Building, Armorstand"},
	{INTERFACEKEY_HOTKEY_BUILDING_BED, "Hotkey: Building, Bed"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRACTION_BENCH, "Hotkey: Building, Traction Bench"},
	{INTERFACEKEY_HOTKEY_BUILDING_SLAB, "Hotkey: Building, Slab"},
	{INTERFACEKEY_HOTKEY_BUILDING_NEST_BOX, "Hotkey: Building, Nest Box"},
	{INTERFACEKEY_HOTKEY_BUILDING_BOOKCASE, "Hotkey: Building, Bookcase"},
	{INTERFACEKEY_HOTKEY_BUILDING_HIVE, "Hotkey: Building, Hive"},
	{INTERFACEKEY_HOTKEY_BUILDING_DISPLAY_FURNITURE, "Hotkey: Building, Display Furniture"},
	{INTERFACEKEY_HOTKEY_BUILDING_OFFERING_PLACE, "Hotkey: Building, Altar"},
	{INTERFACEKEY_HOTKEY_BUILDING_CHAIR, "Hotkey: Building, Chair"},
	{INTERFACEKEY_HOTKEY_BUILDING_COFFIN, "Hotkey: Building, Coffin"},
	{INTERFACEKEY_HOTKEY_BUILDING_DOOR, "Hotkey: Building, Door"},
	{INTERFACEKEY_HOTKEY_BUILDING_FLOODGATE, "Hotkey: Building, Floodgate"},
	{INTERFACEKEY_HOTKEY_BUILDING_HATCH, "Hotkey: Building, Hatch"},
	{INTERFACEKEY_HOTKEY_BUILDING_GRATE_WALL, "Hotkey: Building, Wall Grate"},
	{INTERFACEKEY_HOTKEY_BUILDING_GRATE_FLOOR, "Hotkey: Building, Floor Grate"},
	{INTERFACEKEY_HOTKEY_BUILDING_BARS_VERTICAL, "Hotkey: Building, Vertical Bars"},
	{INTERFACEKEY_HOTKEY_BUILDING_BARS_FLOOR, "Hotkey: Building, Floor Bars"},
	{INTERFACEKEY_HOTKEY_BUILDING_CABINET, "Hotkey: Building, Cabinet"},
	{INTERFACEKEY_HOTKEY_BUILDING_BOX, "Hotkey: Building, Chest"},
	{INTERFACEKEY_HOTKEY_BUILDING_KENNEL, "Hotkey: Building, Kennel"},
	{INTERFACEKEY_HOTKEY_BUILDING_FARMPLOT, "Hotkey: Building, Farm Plot"},
	{INTERFACEKEY_HOTKEY_BUILDING_WEAPONRACK, "Hotkey: Building, Weaponrack"},
	{INTERFACEKEY_HOTKEY_BUILDING_STATUE, "Hotkey: Building, Statue"},
	{INTERFACEKEY_HOTKEY_BUILDING_TABLE, "Hotkey: Building, Table"},
	{INTERFACEKEY_HOTKEY_BUILDING_ROAD_DIRT, "Hotkey: Building, Dirt Road"},
	{INTERFACEKEY_HOTKEY_BUILDING_ROAD_PAVED, "Hotkey: Building, Paved Road"},
	{INTERFACEKEY_HOTKEY_BUILDING_BRIDGE, "Hotkey: Building, Bridge"},
	{INTERFACEKEY_HOTKEY_BUILDING_WELL, "Hotkey: Building, Well"},
	//{INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE, "Hotkey: Building, Siege"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP, "Hotkey: Building, Workshop"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE, "Hotkey: Building, Furnace"},
	{INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GLASS, "Hotkey: Building, Glass Window"},
	{INTERFACEKEY_HOTKEY_BUILDING_WINDOW_GEM, "Hotkey: Building, Gem Window"},
	//{INTERFACEKEY_HOTKEY_BUILDING_SHOP, "Hotkey: Building, Shop"},
	{INTERFACEKEY_HOTKEY_BUILDING_ANIMALTRAP, "Hotkey: Building, Animal Trap"},
	{INTERFACEKEY_HOTKEY_BUILDING_CHAIN, "Hotkey: Building, Chain"},
	{INTERFACEKEY_HOTKEY_BUILDING_CAGE, "Hotkey: Building, Cage"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRADEDEPOT, "Hotkey: Building, Trade Depot"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP, "Hotkey: Building, Trap"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE, "Hotkey: Building, Machine Component"},
	{INTERFACEKEY_HOTKEY_BUILDING_INSTRUMENT, "Hotkey: Building, Instrument"},
	{INTERFACEKEY_HOTKEY_BUILDING_SUPPORT, "Hotkey: Building, Support"},
	{INTERFACEKEY_HOTKEY_BUILDING_ARCHERYTARGET, "Hotkey: Building, Archery Target"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNITURE, "Hotkey: Building, Furniture"},
	{INTERFACEKEY_HOTKEY_BUILDING_PORTALS, "Hotkey: Building, Doors and Hatches"},
	{INTERFACEKEY_HOTKEY_BUILDING_CAGES_CHAINS, "Hotkey: Building, Cages and Chains"},
	{INTERFACEKEY_HOTKEY_BUILDING_MILITARY, "Hotkey: Building, Military"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOPS_CLOTHING_LEATHER, "Hotkey: Building, Workshops, Cloth/Leather"},
	{INTERFACEKEY_HOTKEY_BUILDING_FARMING, "Hotkey: Building, Workshops, Farming"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_SCREW_PUMP, "Hotkey: Building, Machine Component, Screw Pump"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WATER_WHEEL, "Hotkey: Building, Machine Component, Water Wheel"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_WINDMILL, "Hotkey: Building, Machine Component, Windmill"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_GEAR_ASSEMBLY, "Hotkey: Building, Machine Component, Gear Assembly"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_HORIZONTAL, "Hotkey: Building, Machine Component, Horizontal Axle"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_AXLE_VERTICAL, "Hotkey: Building, Machine Component, Vertical Axle"},
	{INTERFACEKEY_HOTKEY_BUILDING_MACHINE_ROLLERS, "Hotkey: Building, Machine Component, Rollers"},
	{INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_BALLISTA, "Hotkey: Building, Siege, Ballista"},
	{INTERFACEKEY_HOTKEY_BUILDING_SIEGEENGINE_CATAPULT, "Hotkey: Building, Siege, Catapult"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_STONE, "Hotkey: Building, Trap, Stone"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_WEAPON, "Hotkey: Building, Trap, Weapon"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_LEVER, "Hotkey: Building, Trap, Lever"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_TRIGGER, "Hotkey: Building, Trap, Trigger"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_CAGE, "Hotkey: Building, Trap, Cage"},
	{INTERFACEKEY_HOTKEY_BUILDING_TRAP_SPIKE, "Hotkey: Building, Trap, Upright Spear/Spike"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION, "Hotkey: Building, Wall/Floor/Stairs"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FORTIFICATION, "Hotkey: Building, Construction, Fortification"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_WALL, "Hotkey: Building, Construction, Wall"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_FLOOR, "Hotkey: Building, Construction, Floor"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_RAMP, "Hotkey: Building, Construction, Ramp"},
	//{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UP, "Hotkey: Building, Construction, Upward Stair"},
	//{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_DOWN, "Hotkey: Building, Construction, Downward Stair"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_STAIR_UPDOWN, "Hotkey: Building, Construction, Up/Down Stair"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK, "Hotkey: Building, Construction, Track"},
	{INTERFACEKEY_HOTKEY_BUILDING_CONSTRUCTION_TRACK_STOP, "Hotkey: Building, Construction, Track Stop"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LEATHER, "Hotkey: Building, Wksp, Leather"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_QUERN, "Hotkey: Building, Wksp, Quern"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MILLSTONE, "Hotkey: Building, Wksp, Millstone"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LOOM, "Hotkey: Building, Wksp, Loom"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CLOTHES, "Hotkey: Building, Wksp, Clothes"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BOWYER, "Hotkey: Building, Wksp, Bowyer"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CARPENTER, "Hotkey: Building, Wksp, Carpenter"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_METALSMITH, "Hotkey: Building, Wksp, Metalsmith"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_LAVAMILL, "Hotkey: Building, Wksp, Lavamill"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_JEWELER, "Hotkey: Building, Wksp, Jeweler"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MASON, "Hotkey: Building, Wksp, Mason"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_BUTCHER, "Hotkey: Building, Wksp, Butcher"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_TANNER, "Hotkey: Building, Wksp, Tanner"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_DYER, "Hotkey: Building, Wksp, Dyer"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_CRAFTSMAN, "Hotkey: Building, Wksp, Craftsman"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_SIEGE, "Hotkey: Building, Wksp, Siege"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_MECHANIC, "Hotkey: Building, Wksp, Mechanic"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_STILL, "Hotkey: Building, Wksp, Still"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FARMER, "Hotkey: Building, Wksp, Farmer"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_KITCHEN, "Hotkey: Building, Wksp, Kitchen"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_FISHERY, "Hotkey: Building, Wksp, Fishery"},
	{INTERFACEKEY_HOTKEY_BUILDING_WORKSHOP_ASHERY, "Hotkey: Building, Wksp, Ashery"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_WOOD, "Hotkey: Building, Furn, Wood"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER, "Hotkey: Building, Furn, Smelter"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS, "Hotkey: Building, Furn, Glass"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN, "Hotkey: Building, Furn, Kiln"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_SMELTER_LAVA, "Hotkey: Building, Furn, Smelter"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_GLASS_LAVA, "Hotkey: Building, Furn, Glass"},
	{INTERFACEKEY_HOTKEY_BUILDING_FURNACE_KILN_LAVA, "Hotkey: Building, Furn, Kiln"},
	/*
	{INTERFACEKEY_HIVE_INSTALL_COLONY, "Hotkey: Building, Hive, Install Colony"},
	{INTERFACEKEY_HIVE_GATHER_PRODUCTS, "Hotkey: Building, Hive, Gather Products"},
	*/
	{INTERFACEKEY_D_ONESTEP, "Main: One-Step"},
	{INTERFACEKEY_D_PAUSE, "Main: Pause/Resume"},
	//{INTERFACEKEY_D_DEPOT, "Depot Access"},
	{INTERFACEKEY_D_HOT_KEYS, "Main: Hot Keys"},
	{INTERFACEKEY_D_HOTKEY1, "Main: Hot Key 1"},
	{INTERFACEKEY_D_HOTKEY2, "Main: Hot Key 2"},
	{INTERFACEKEY_D_HOTKEY3, "Main: Hot Key 3"},
	{INTERFACEKEY_D_HOTKEY4, "Main: Hot Key 4"},
	{INTERFACEKEY_D_HOTKEY5, "Main: Hot Key 5"},
	{INTERFACEKEY_D_HOTKEY6, "Main: Hot Key 6"},
	{INTERFACEKEY_D_HOTKEY7, "Main: Hot Key 7"},
	{INTERFACEKEY_D_HOTKEY8, "Main: Hot Key 8"},
	{INTERFACEKEY_D_HOTKEY9, "Main: Hot Key 9"},
	{INTERFACEKEY_D_HOTKEY10, "Main: Hot Key 10"},
	{INTERFACEKEY_D_HOTKEY11, "Main: Hot Key 11"},
	{INTERFACEKEY_D_HOTKEY12, "Main: Hot Key 12"},
	{INTERFACEKEY_D_HOTKEY13, "Main: Hot Key 13"},
	{INTERFACEKEY_D_HOTKEY14, "Main: Hot Key 14"},
	{INTERFACEKEY_D_HOTKEY15, "Main: Hot Key 15"},
	{INTERFACEKEY_D_HOTKEY16, "Main: Hot Key 16"},

	{INTERFACEKEY_D_TOGGLE_RAMP_INDICATORS, "Main: Toggle ramp indicators"},
	{INTERFACEKEY_D_TOGGLE_FLUID_NUMBERS, "Main: Toggle fluid numbers"},

	{INTERFACEKEY_D_DESIGNATE_DIG, "Main: Dig"},
	{INTERFACEKEY_D_DESIGNATE_CHOP, "Main: Chop tress"},
	{INTERFACEKEY_D_DESIGNATE_GATHER, "Main: Gather plants"},
	{INTERFACEKEY_D_DESIGNATE_SMOOTH, "Main: Smooth and engrave"},
	{INTERFACEKEY_D_DESIGNATE_ITEMS, "Main: Item properties"},
	{INTERFACEKEY_D_DESIGNATE_TRAFFIC, "Main: Traffic designations"},
	{INTERFACEKEY_D_DESIGNATE_ERASE, "Main: Erase designations"},

	{INTERFACEKEY_D_BUILDING, "Main: Buildings"},
	{INTERFACEKEY_D_STOCKPILES, "Main: Stockpiles"},
	{INTERFACEKEY_D_CIVZONE, "Main: Zones"},
	{INTERFACEKEY_D_BURROWS, "Main: Burrows"},
	{INTERFACEKEY_D_HAULING, "Main: Hauling"},

	{INTERFACEKEY_D_UNITLIST, "Main: Units"},
	{INTERFACEKEY_D_JOBLIST, "Main: Tasks"},
	{INTERFACEKEY_D_LOCATIONS, "Main: Locations"},
	{INTERFACEKEY_D_LABOR, "Main: Labor"},
	{INTERFACEKEY_D_ORDERS, "Main: Work orders"},
	{INTERFACEKEY_D_NOBLES, "Main: Nobles"},
	{INTERFACEKEY_D_ARTLIST, "Main: Artifacts"},
	{INTERFACEKEY_D_SQUADS, "Main: Squads"},
	{INTERFACEKEY_D_WORLD, "Main: World"},
	{INTERFACEKEY_D_JUSTICE, "Main: Justice"},

	{INTERFACEKEY_D_STOCKS, "Main: Stocks"},
	{INTERFACEKEY_D_ANNOUNCE, "Main: Announcements"},

	{INTERFACEKEY_D_ANNOUNCE, "Main: Announcements"},

	{INTERFACEKEY_ARENA_CREATE_CREATURE, "Arena: Create creature"},
	{INTERFACEKEY_ARENA_CREATURE_RESET, "Arena: Creature, reset"},
	{INTERFACEKEY_ARENA_FLUIDS, "Arena: Fluids"},
	{INTERFACEKEY_ARENA_FLUIDS_WATER, "Arena: Fluids, water"},
	{INTERFACEKEY_ARENA_FLUIDS_MAGMA, "Arena: Fluids, magma"},
	{INTERFACEKEY_ARENA_FLUIDS_SNOW, "Arena: Fluids, snow"},
	{INTERFACEKEY_ARENA_FLUIDS_MUD, "Arena: Fluids, mud"},
	{INTERFACEKEY_ARENA_FLUIDS_REMOVE, "Arena: Fluids, remove"},
	{INTERFACEKEY_ARENA_CREATE_TREE, "Arena: Create tree"},
	{INTERFACEKEY_ARENA_WEATHER, "Arena: Weather"},
	{INTERFACEKEY_ARENA_CONFLICT_STATE_1, "Arena: Conflict state down"},
	{INTERFACEKEY_ARENA_CONFLICT_STATE_2, "Arena: Conflict state up"},
	{INTERFACEKEY_ARENA_MORALE, "Arena: Morale"},
	{INTERFACEKEY_RECENTER, "Main: Recenter"},
	{INTERFACEKEY_OPEN_SHEET, "Main: Open Item/Unit sheet"},
	{INTERFACEKEY_FILTER, "Main: Select filter box"},
	{INTERFACEKEY_UNITLIST_RECENTER_JOB, "Unit lists: Recenter on job"},
	{INTERFACEKEY_UNITLIST_JOB_DETAILS, "Unit lists: Open job details"},

	{INTERFACEKEY_UNITLIST_SORT_NAME, "Unit lists: Sort by name"},
	{INTERFACEKEY_UNITLIST_SORT_PROFA, "Unit lists: Sort by category"},
	{INTERFACEKEY_UNITLIST_SORT_PROFB, "Unit lists: Sort by profession"},
	{INTERFACEKEY_UNITLIST_SORT_JOB, "Unit lists: Sort by job"},
	{INTERFACEKEY_UNITLIST_SORT_HAPPINESS, "Unit lists: Sort by happiness"},
	{INTERFACEKEY_UNITLIST_SORT_SKILLS, "Unit list: Sort by skills"},
	{INTERFACEKEY_UNITLIST_SPECIALIZE, "Unit list: Toggle specialization"},
	/*
	{INTERFACEKEY_D_HOTKEY_CHANGE_NAME, "Hot Keys: Change Name"},
	{INTERFACEKEY_D_HOTKEY_ZOOM, "Hot Keys: Zoom"},
	{INTERFACEKEY_D_BUILDING, "Main: Place Building"},
	{INTERFACEKEY_D_CIVLIST, "Main: Civilizations"},
	{INTERFACEKEY_D_DESIGNATE, "Main: Designations"},
	{INTERFACEKEY_D_ARTLIST, "Main: Artifacts"},
	{INTERFACEKEY_D_NOBLES, "Main: Nobles"},
	{INTERFACEKEY_D_ORDERS, "Main: Standing Orders"},
	{INTERFACEKEY_D_PETITIONS, "Main: Petitions"},
	{INTERFACEKEY_D_LOCATIONS, "Main: Locations"},
	{INTERFACEKEY_D_MILITARY, "Main: Military"},
	{INTERFACEKEY_D_MILITARY_CREATE_SQUAD, "Main: Military, Create Squad"},
	{INTERFACEKEY_D_MILITARY_DISBAND_SQUAD, "Main: Military, Disband Squad"},
	{INTERFACEKEY_D_MILITARY_CREATE_SUB_SQUAD, "Main: Military, Create Sub-Squad"},
	{INTERFACEKEY_D_MILITARY_CANCEL_ORDERS, "Main: Military, Cancel Orders"},
	{INTERFACEKEY_D_MILITARY_POSITIONS, "Main: Military, Positions"},
	{INTERFACEKEY_D_MILITARY_ALERTS, "Main: Military, Alerts"},
	{INTERFACEKEY_D_MILITARY_ALERTS_ADD, "Main: Military, Alerts, Add"},
	{INTERFACEKEY_D_MILITARY_ALERTS_DELETE, "Main: Military, Alerts, Delete"},
	{INTERFACEKEY_D_MILITARY_ALERTS_SET, "Main: Military, Alerts, Set"},
	{INTERFACEKEY_D_MILITARY_ALERTS_NAME, "Main: Military, Alerts, Name"},
	{INTERFACEKEY_D_MILITARY_ALERTS_SET_RETAIN, "Main: Military, Alerts, Set/Retain"},
	{INTERFACEKEY_D_MILITARY_EQUIP, "Main: Military, Equip"},
	{INTERFACEKEY_D_MILITARY_EQUIP_CUSTOMIZE, "Main: Military, Equip, Customize"},
	{INTERFACEKEY_D_MILITARY_EQUIP_UNIFORM, "Main: Military, Equip, Uniform"},
	{INTERFACEKEY_D_MILITARY_EQUIP_PRIORITY, "Main: Military, Equip, Priority"},
	{INTERFACEKEY_D_MILITARY_UNIFORMS, "Main: Military, Uniforms"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES, "Main: Military, Supplies"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_DOWN, "Main: Military, Supplies, Water Down"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES_WATER_UP, "Main: Military, Supplies, Water Up"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_DOWN, "Main: Military, Supplies, Food Down"},
	{INTERFACEKEY_D_MILITARY_SUPPLIES_FOOD_UP, "Main: Military, Supplies, Food Up"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION, "Main: Military, Ammunition"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_ADD_ITEM, "Main: Military, Ammunition, Add Item"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_REMOVE_ITEM, "Main: Military, Ammunition, Remove Item"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT, "Main: Military, Ammunition, Lower Amount"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT, "Main: Military, Ammunition, Raise Amount"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_LOWER_AMOUNT_LOTS, "Main: Military, Ammunition, Lower Amount Lots"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_RAISE_AMOUNT_LOTS, "Main: Military, Ammunition, Raise Amount Lots"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_MATERIAL, "Main: Military, Ammunition, Material"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_COMBAT, "Main: Military, Ammunition, Combat"},
	{INTERFACEKEY_D_MILITARY_AMMUNITION_TRAINING, "Main: Military, Ammunition, Training"},
	{INTERFACEKEY_D_MILITARY_TRAINING, "Main: Military, Training"},
	{INTERFACEKEY_D_MILITARY_SCHEDULE, "Main: Military, Schedule"},
	{INTERFACEKEY_D_MILITARY_ADD_UNIFORM, "Main: Military, Add Uniform"},
	{INTERFACEKEY_D_MILITARY_DELETE_UNIFORM, "Main: Military, Delete Uniform"},
	{INTERFACEKEY_D_MILITARY_NAME_UNIFORM, "Main: Military, Name Uniform"},
	{INTERFACEKEY_D_MILITARY_NAME_SQUAD, "Main: Military, Name Squad"},
	{INTERFACEKEY_D_MILITARY_ADD_ARMOR, "Main: Military, Add Armor"},
	{INTERFACEKEY_D_MILITARY_ADD_PANTS, "Main: Military, Add Pants"},
	{INTERFACEKEY_D_MILITARY_ADD_HELM, "Main: Military, Add Helm"},
	{INTERFACEKEY_D_MILITARY_ADD_GLOVES, "Main: Military, Add Gloves"},
	{INTERFACEKEY_D_MILITARY_ADD_BOOTS, "Main: Military, Add Boots"},
	{INTERFACEKEY_D_MILITARY_ADD_SHIELD, "Main: Military, Add Shield"},
	{INTERFACEKEY_D_MILITARY_ADD_WEAPON, "Main: Military, Add Weapon"},
	{INTERFACEKEY_D_MILITARY_ADD_MATERIAL, "Main: Military, Add Material"},
	{INTERFACEKEY_D_MILITARY_ADD_COLOR, "Main: Military, Add Color"},
	{INTERFACEKEY_D_MILITARY_REPLACE_CLOTHING, "Main: Military, Replace Clothing"},
	{INTERFACEKEY_D_MILITARY_EXACT_MATCH, "Main: Military, Exact Match"},
	{INTERFACEKEY_D_ROOMS, "Main: Rooms"},
	{INTERFACEKEY_BUILDINGLIST_ZOOM_T, "Building List: Zoom T"},
	{INTERFACEKEY_BUILDINGLIST_ZOOM_Q, "Building List: Zoom Q"},
	{INTERFACEKEY_RECENTER_ON_LEVER, "Recenter on Lever"},
	{INTERFACEKEY_ASSIGN_LOCATION, "Assign Location"},
	{INTERFACEKEY_LOCATION_NEW, "Location: New"},
	{INTERFACEKEY_LOCATION_RETIRE, "Location: Retire"},
	{INTERFACEKEY_LOCATION_INN_TAVERN, "Location: Inn/Tavern"},
	{INTERFACEKEY_LOCATION_TEMPLE, "Location: Temple"},
	{INTERFACEKEY_LOCATION_RECOGNIZE_PRIESTHOOD, "Location: Recognize Priesthood"},
	{INTERFACEKEY_LOCATION_LIBRARY, "Location: Library"},
	{INTERFACEKEY_LOCATION_GUILDHALL, "Location: Guildhall"},
	{INTERFACEKEY_LOCATION_MAIN_HALL, "Location: Main Hall"},
	{INTERFACEKEY_LOCATION_RENAME, "Location: Rename"},
	{INTERFACEKEY_LOCATION_DETAILS, "Location: Details"},
	{INTERFACEKEY_LOCATION_RESTRICTION, "Location: Restriction"},
	{INTERFACEKEY_LOCATION_SET_NUMBER_1, "Location: Set Number 1"},
	{INTERFACEKEY_LOCATION_SET_NUMBER_2, "Location: Set Number 2"},
	{INTERFACEKEY_D_SQUADS, "Main: Control Squads"},
	{INTERFACEKEY_D_SQUADS_MOVE, "Main: Control Squads, Move"},
	{INTERFACEKEY_D_SQUADS_KILL, "Main: Control Squads, Kill"},
	{INTERFACEKEY_D_SQUADS_KILL_LIST, "Main: Control Squads, Kill List"},
	{INTERFACEKEY_D_SQUADS_KILL_RECT, "Main: Control Squads, Kill Rect"},
	{INTERFACEKEY_D_SQUADS_SCHEDULE, "Main: Control Squads, Schedule"},
	{INTERFACEKEY_D_SQUADS_CANCEL_ORDER, "Main: Control Squads, Cancel Order"},
	{INTERFACEKEY_D_SQUADS_ALERT, "Main: Control Squads, Alert"},
	{INTERFACEKEY_D_SQUADS_SELECT_INDIVIDUALS, "Main: Control Squads, Select Individuals"},
	{INTERFACEKEY_D_SQUADS_CENTER, "Main: Control Squads, Center"},
	{INTERFACEKEY_D_SQUAD_SCH_SLEEP, "Squad Schedule: Sleep"},
	{INTERFACEKEY_D_SQUAD_SCH_CIVILIAN_UNIFORM, "Squad Schedule: Civilian Uniform"},
	{INTERFACEKEY_D_SQUAD_SCH_GIVE_ORDER, "Squad Schedule: Give Order"},
	{INTERFACEKEY_D_SQUAD_SCH_EDIT_ORDER, "Squad Schedule: Edit Order"},
	{INTERFACEKEY_D_SQUAD_SCH_CANCEL_ORDER, "Squad Schedule: Cancel Order"},
	{INTERFACEKEY_D_SQUAD_SCH_COPY_ORDERS, "Squad Schedule: Copy Orders"},
	{INTERFACEKEY_D_SQUAD_SCH_PASTE_ORDERS, "Squad Schedule: Paste Orders"},
	{INTERFACEKEY_D_SQUAD_SCH_MS_NAME, "Squad Schedule: Name Grid Cell"},
	{INTERFACEKEY_D_STOCKPILES, "Main: Stockpiles"},
	{INTERFACEKEY_D_CIVZONE, "Main: Activity Zone"},
	{INTERFACEKEY_D_VIEWUNIT, "Main: View Units"},
	{INTERFACEKEY_D_JOBLIST, "Main: Job List"},
	{INTERFACEKEY_D_UNITLIST, "Main: Unit List"},
	{INTERFACEKEY_D_LOOK, "Main: Look"},
	{INTERFACEKEY_D_HAULING, "Main: Hauling"},
	{INTERFACEKEY_D_HAULING_NEW_ROUTE, "Main: Hauling, New Route"},
	{INTERFACEKEY_D_HAULING_NEW_STOP, "Main: Hauling, New Stop"},
	{INTERFACEKEY_D_HAULING_REMOVE, "Main: Hauling, Remove"},
	{INTERFACEKEY_D_HAULING_PROMOTE, "Main: Hauling, Promote"},
	{INTERFACEKEY_D_HAULING_VEHICLE, "Main: Hauling, Vehicle"},
	{INTERFACEKEY_D_HAULING_NICKNAME, "Main: Hauling, Name"},
	{INTERFACEKEY_D_HAULING_STOP_NEW_DEPART, "Main: Hauling, Stop, New Leave Condition"},
	{INTERFACEKEY_D_HAULING_STOP_NEW_LINK, "Main: Hauling, Stop, New Stockpile Link"},
	{INTERFACEKEY_D_HAULING_STOP_REMOVE, "Main: Hauling, Stop, Remove"},
	{INTERFACEKEY_D_HAULING_STOP_SL_SELECT_PILE, "Main: Hauling, Stop, Stockpile, Select"},
	{INTERFACEKEY_D_HAULING_STOP_SL_TAKE_GIVE, "Main: Hauling, Stop, Stockpile, Take/Give"},
	{INTERFACEKEY_D_HAULING_STOP_LC_DIR, "Main: Hauling, Stop, Leave Condition, Dir"},
	{INTERFACEKEY_D_HAULING_STOP_LC_MODE, "Main: Hauling, Stop, Leave Condition, Mode"},
	{INTERFACEKEY_D_HAULING_STOP_LC_TIMER_UP, "Main: Hauling, Stop, Leave Condition, Timer Up"},
	{INTERFACEKEY_D_HAULING_STOP_LC_TIMER_DOWN, "Main: Hauling, Stop, Leave Condition, Timer Down"},
	{INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_UP, "Main: Hauling, Stop, Leave Condition, Fullness Up"},
	{INTERFACEKEY_D_HAULING_STOP_LC_FULLNESS_DOWN, "Main: Hauling, Stop, Leave Condition, Fullness Down"},
	{INTERFACEKEY_D_HAULING_STOP_LC_MORE_LESS, "Main: Hauling, Stop, Leave Condition, More/Less"},
	{INTERFACEKEY_D_HAULING_STOP_LC_DESIRED_TOTAL, "Main: Hauling, Stop, Leave Condition, Desired/Total"},
	{INTERFACEKEY_D_HAULING_STOP_LC_CHANGE, "Main: Hauling, Stop, Leave Condition, Change"},
	{INTERFACEKEY_D_HAULING_STOP_LC_ADVANCED, "Main: Hauling, Stop, Leave Condition, Advanced"},
	{INTERFACEKEY_D_BURROWS, "Main: Burrows"},
	{INTERFACEKEY_D_BURROWS_ADD, "Main: Burrows, Add"},
	{INTERFACEKEY_D_BURROWS_DELETE, "Main: Burrows, Delete"},
	{INTERFACEKEY_D_BURROWS_DEFINE, "Main: Burrows, Define"},
	{INTERFACEKEY_D_BURROWS_ADD_UNIT, "Main: Burrows, Add Citizen"},
	{INTERFACEKEY_D_BURROWS_WORKSHOP_LIMIT, "Main: Burrows, Limit Workshops"},
	{INTERFACEKEY_D_BURROWS_CENTER, "Main: Burrows, Center"},
	{INTERFACEKEY_D_BURROWS_NAME, "Main: Burrows, Name"},
	{INTERFACEKEY_D_BURROWS_CHANGE_SELECTION, "Main: Burrows, Change Selector"},
	{INTERFACEKEY_D_BURROWS_BRUSH, "Main: Burrows, Brush"},
	{INTERFACEKEY_D_BURROWS_REMOVE, "Main: Burrows, Paint/Erase"},
	{INTERFACEKEY_D_NOTE, "Main: Note"},
	{INTERFACEKEY_D_NOTE_PLACE, "Main: Note, Place"},
	{INTERFACEKEY_D_NOTE_DELETE, "Main: Note, Delete"},
	{INTERFACEKEY_D_NOTE_NAME, "Main: Note, Enter Name"},
	{INTERFACEKEY_D_NOTE_ENTER, "Main: Note, Enter Text"},
	{INTERFACEKEY_D_NOTE_ADOPT_SYMBOL, "Main: Note, Adopt Symbol"},
	{INTERFACEKEY_D_NOTE_CHANGE_SELECTION, "Main: Note, Change Selection"},
	{INTERFACEKEY_D_NOTE_POINTS, "Main: Note, Route, Done"},
	{INTERFACEKEY_D_NOTE_ROUTE, "Main: Note, Routes"},
	{INTERFACEKEY_D_NOTE_ROUTE_ADD, "Main: Note, Route, Add"},
	{INTERFACEKEY_D_NOTE_ROUTE_EDIT, "Main: Note, Route, Edit"},
	{INTERFACEKEY_D_NOTE_ROUTE_DELETE, "Main: Note, Route, Delete"},
	{INTERFACEKEY_D_NOTE_ROUTE_CENTER, "Main: Note, Route, Center"},
	{INTERFACEKEY_D_NOTE_ROUTE_NAME, "Main: Note, Route, Name"},
	{INTERFACEKEY_D_BUILDJOB, "Main: Building Jobs"},
	{INTERFACEKEY_D_STATUS, "Main: Overall Status"},
	{INTERFACEKEY_D_STATUS_OVERALL_HEALTH_RECENTER, "Main: Status, Overall Health, Recenter"},
	{INTERFACEKEY_D_BUILDITEM, "Main: Building Items"},
	{INTERFACEKEY_D_BITEM_FORBID, "Building Items: Forbid"},
	{INTERFACEKEY_D_BITEM_DUMP, "Building Items: Dump"},
	{INTERFACEKEY_D_BITEM_MELT, "Building Items: Melt"},
	{INTERFACEKEY_D_BITEM_HIDE, "Building Items: Hide"},
	{INTERFACEKEY_D_BITEM_NAME, "Building Items: Name"},
	{INTERFACEKEY_D_LOOK_FORBID, "Dwf Look: Forbid"},
	{INTERFACEKEY_D_LOOK_DUMP, "Dwf Look: Dump"},
	{INTERFACEKEY_D_LOOK_MELT, "Dwf Look: Melt"},
	{INTERFACEKEY_D_LOOK_HIDE, "Dwf Look: Hide"},
	{INTERFACEKEY_D_LOOK_FOLLOW, "Dwf Look: Follow"},
	{INTERFACEKEY_D_LOOK_ARENA_CREATURE, "Dwf Look: Arena Creature"},
	{INTERFACEKEY_D_LOOK_ARENA_ADV_MODE, "Dwf Look: Arena Adv Mode"},
	{INTERFACEKEY_D_LOOK_ARENA_WATER, "Dwf Look: Arena Water"},
	{INTERFACEKEY_D_LOOK_ARENA_MAGMA, "Dwf Look: Arena Magma"},
	{INTERFACEKEY_ARENA_CREATURE_SIDE_DOWN, "Arena Creature: Side Down"},
	{INTERFACEKEY_ARENA_CREATURE_SIDE_UP, "Arena Creature: Side Up"},
	{INTERFACEKEY_ARENA_CREATURE_NEW_ITEM, "Arena Creature: New Item"},
	{INTERFACEKEY_ARENA_CREATURE_BLANK_LIST, "Arena Creature: Blank List"},
	{INTERFACEKEY_ARENA_CREATURE_REMOVE_ITEM, "Arena Creature: Remove Item"},
	{INTERFACEKEY_ARENA_CREATURE_UNDEAD, "Arena Creature: Undead"},
	{INTERFACEKEY_ARENA_CREATURE_TAME, "Arena Creature: Tame"},
	{INTERFACEKEY_ARENA_CREATURE_STRING, "Arena Creature: String"},
	{INTERFACEKEY_ARENA_CONFLICT_STATE_1, "Arena Conflict State 1"},
	{INTERFACEKEY_ARENA_CONFLICT_STATE_2, "Arena Conflict State 2"},
	{INTERFACEKEY_ARENA_MORALE, "Arena Morale"},
	{INTERFACEKEY_ARENA_WEATHER, "Arena Weather"},
	{INTERFACEKEY_ARENA_WEATHER_SNOW, "Arena Weather: Snow"},
	{INTERFACEKEY_ARENA_WEATHER_MUD, "Arena Weather: Mud"},
	{INTERFACEKEY_ARENA_WEATHER_CLEAR_SPATTER, "Arena Weather: Clear Spatter"},
	{INTERFACEKEY_D_LOOK_ARENA_TREE, "Dwf Look: Arena Tree"},
	{INTERFACEKEY_ARENA_TREE_FILTER, "Arena Tree: Filter"},
	{INTERFACEKEY_ARENA_TREE_AGE, "Arena Tree: Age"},
	{INTERFACEKEY_D_LOOK_ARENA_MOUNT, "Dwf Look: Arena Mount"},
	{INTERFACEKEY_CSHEET_BACKGROUND, "Adventure: Creation, Background"},
	{INTERFACEKEY_CSHEET_NEW_CHARACTER, "Adventure: Creation, New Character"},
	{INTERFACEKEY_CSHEET_SKILLS, "Adventure: Creation, Skills"},
	{INTERFACEKEY_CSHEET_APPEARANCE, "Adventure: Creation, Appearance"},
	{INTERFACEKEY_CSHEET_PERSONALITY, "Adventure: Creation, Personality"},
	{INTERFACEKEY_CSHEET_EQUIPMENT, "Adventure: Creation, Equipment"},
	{INTERFACEKEY_CSHEET_PETS, "Adventure: Creation, Pets"},
	{INTERFACEKEY_CSHEET_RANDOMIZE_BACKGROUND, "Adventure: Creation, Randomize Background"},
	{INTERFACEKEY_CSHEET_SELECT_BACKGROUND_OPTION, "Adventure: Creation, Select Background"},
	{INTERFACEKEY_CSHEET_WORSHIP_UP, "Adventure: Creation, Belief Up"},
	{INTERFACEKEY_CSHEET_WORSHIP_DOWN, "Adventure: Creation, Belief Down"},
	{INTERFACEKEY_CSHEET_NEW_ITEM, "Adventure: Creation, New Item"},
	{INTERFACEKEY_CSHEET_QUALITY_UP, "Adventure: Creation, Quality Up"},
	{INTERFACEKEY_CSHEET_QUALITY_DOWN, "Adventure: Creation, Quality Down"},
	{INTERFACEKEY_CSHEET_NAME_PET, "Adventure: Creation, Name Pet"},
	{INTERFACEKEY_CSHEET_REMOVE_PET, "Adventure: Creation, Remove Pet"},
	{INTERFACEKEY_CSHEET_ADD_PET, "Adventure: Creation, Add Pet"},
	{INTERFACEKEY_A_ENTER_NAME, "Adventure: Creation, Name Entry"},
	{INTERFACEKEY_A_CUST_NAME, "Adventure: Creation, Customize Name"},
	{INTERFACEKEY_A_RANDOM_NAME, "Adventure: Creation, Random Name"},
	{INTERFACEKEY_A_RANDOM_APPEARANCE, "Adventure: Creation, Random Appearance"},
	{INTERFACEKEY_A_RANDOM_APPEARANCE_FULL, "Adventure: Creation, Full Random Appearance"},
	{INTERFACEKEY_A_RANDOM_PERSONALITY, "Adventure: Creation, Random Personality"},
	{INTERFACEKEY_A_CUSTOM_PERSONALITY, "Adventure: Creation, Custom Personality"},
	{INTERFACEKEY_A_CHANGE_DREAM, "Adventure: Creation, Change Dream/Goal"},
	{INTERFACEKEY_A_CHANGE_GENDER, "Adventure: Creation, Change Gender"},
	{INTERFACEKEY_A_END_TRAVEL, "Adventure: Travel, Visit Site"},
	{INTERFACEKEY_A_TRAVEL_CLOUDS, "Adventure: Travel, Clouds"},
	{INTERFACEKEY_A_LOG, "Adventure: Log"},
	{INTERFACEKEY_A_TRAVEL_LOG, "Adventure: Travel, Log"},
	{INTERFACEKEY_A_LOG_SORT, "Adventure: Log, Sort"},
	{INTERFACEKEY_A_LOG_PIN, "Adventure: Log, Pin"},
	{INTERFACEKEY_A_LOG_ENTITIES, "Adventure: Log, Entities"},
	{INTERFACEKEY_A_LOG_SITES, "Adventure: Log, Sites"},
	{INTERFACEKEY_A_LOG_SUBREGIONS, "Adventure: Log, Regions"},
	{INTERFACEKEY_A_LOG_FEATURE_LAYERS, "Adventure: Log, Feature Layers"},
	{INTERFACEKEY_A_LOG_PEOPLE, "Adventure: Log, People"},
	{INTERFACEKEY_A_LOG_AGREEMENTS, "Adventure: Log, Agreements"},
	{INTERFACEKEY_A_LOG_EVENTS, "Adventure: Log, Events"},
	{INTERFACEKEY_A_LOG_BESTIARY, "Adventure: Log, Bestiary"},
	{INTERFACEKEY_A_LOG_ARTIFACTS, "Adventure: Log, Artifacts"},
	{INTERFACEKEY_A_LOG_INTRIGUE, "Adventure: Log, Intrigue"},
	{INTERFACEKEY_A_LOG_FILTER, "Adventure: Log, Filter"},
	{INTERFACEKEY_A_LOG_ZOOM_CURRENT_LOCATION, "Adventure: Log, Zoom to Current Location"},
	{INTERFACEKEY_A_LOG_ZOOM_SELECTED, "Adventure: Log, Zoom to Selected"},
	{INTERFACEKEY_A_LOG_LINE, "Adventure: Log, Toggle Line"},
	{INTERFACEKEY_A_LOG_MAP, "Adventure: Log, Toggle Map/Info"},
	{INTERFACEKEY_ORDERS_AUTOFORBID, "Orders: Forbid"},
	{INTERFACEKEY_ORDERS_FORBID_PROJECTILE, "Orders: Forbid Projectiles"},
	{INTERFACEKEY_ORDERS_FORBID_YOUR_CORPSE, "Orders: Forbid Your Corpse"},
	{INTERFACEKEY_ORDERS_FORBID_YOUR_ITEMS, "Orders: Forbid Your Items"},
	{INTERFACEKEY_ORDERS_FORBID_OTHER_CORPSE, "Orders: Forbid Other Corpse"},
	{INTERFACEKEY_ORDERS_FORBID_OTHER_ITEMS, "Orders: Forbid Other Items"},
	{INTERFACEKEY_ORDERS_REFUSE_GATHER, "Orders: Gather Refuse"},
	{INTERFACEKEY_ORDERS_REFUSE_OUTSIDE, "Orders: Gather Outside"},
	{INTERFACEKEY_ORDERS_REFUSE_OUTSIDE_VERMIN, "Orders: Gather Outside Vermin"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_CORPSE, "Orders: Dump Corpse"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_SKULL, "Orders: Dump Skull"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_SKIN, "Orders: Dump Skin"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_BONE, "Orders: Dump Bone"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_SHELL, "Orders: Dump Shell"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_OTHER, "Orders: Dump Other"},
	{INTERFACEKEY_ORDERS_REFUSE_DUMP_STRAND_TISSUE, "Orders: Dump Strand Tissue"},
	{INTERFACEKEY_ORDERS_GATHER_FURNITURE, "Orders: Gather Furniture"},
	{INTERFACEKEY_ORDERS_GATHER_ANIMALS, "Orders: Gather Animals"},
	{INTERFACEKEY_ORDERS_GATHER_FOOD, "Orders: Gather Food"},
	{INTERFACEKEY_ORDERS_GATHER_BODIES, "Orders: Gather Bodies"},
	{INTERFACEKEY_ORDERS_REFUSE, "Orders: Refuse"},
	{INTERFACEKEY_ORDERS_GATHER_STONE, "Orders: Gather Stone"},
	{INTERFACEKEY_ORDERS_GATHER_WOOD, "Orders: Gather Wood"},
	{INTERFACEKEY_ORDERS_ALL_HARVEST, "Orders: All Harvest"},
	{INTERFACEKEY_ORDERS_SAMEPILE, "Orders: Piles Same"},
	{INTERFACEKEY_ORDERS_MIXFOODS, "Orders: Mix Foods"},
	{INTERFACEKEY_ORDERS_EXCEPTIONS, "Orders: Exceptions"},
	{INTERFACEKEY_ORDERS_LOOM, "Orders: Loom"},
	{INTERFACEKEY_ORDERS_DYED_CLOTH, "Orders: Dyed Cloth"},
	{INTERFACEKEY_ORDERS_WORKSHOP, "Orders: Workshop"},
	{INTERFACEKEY_ORDERS_COLLECT_WEB, "Orders: Auto-Collect Web"},
	{INTERFACEKEY_ORDERS_SLAUGHTER, "Orders: Auto-Slaughter"},
	{INTERFACEKEY_ORDERS_BUTCHER, "Orders: Auto-Butcher"},
	{INTERFACEKEY_ORDERS_TAN, "Orders: Auto-Tan"},
	{INTERFACEKEY_ORDERS_AUTO_FISHERY, "Orders: Auto-Fishery"},
	{INTERFACEKEY_ORDERS_AUTO_KITCHEN, "Orders: Auto-Kitchen"},
	{INTERFACEKEY_ORDERS_AUTO_KILN, "Orders: Auto-Kiln"},
	{INTERFACEKEY_ORDERS_AUTO_SMELTER, "Orders: Auto-Smelter"},
	{INTERFACEKEY_ORDERS_AUTO_OTHER, "Orders: Auto-Other"},
	{INTERFACEKEY_ORDERS_ZONE, "Orders: Zone"},
	{INTERFACEKEY_ORDERS_ZONE_DRINKING, "Orders: Zone, Drinking"},
	{INTERFACEKEY_ORDERS_ZONE_FISHING, "Orders: Zone, Fishing"},
	{INTERFACEKEY_DESTROYBUILDING, "Destroy Building"},
	{INTERFACEKEY_SUSPENDBUILDING, "Suspend Building"},
	{INTERFACEKEY_MENU_CONFIRM, "Menu Confirm"},
	{INTERFACEKEY_SAVE_BINDINGS, "Save Bindings"},
	{INTERFACEKEY_LOAD_BINDINGS, "Load Bindings"},
	*/
	{INTERFACEKEY_KEYBINDING_COMPLETE, "Complete Binding"},
	{INTERFACEKEY_ZOOM_IN, "Zoom In"},
	{INTERFACEKEY_ZOOM_OUT, "Zoom Out"},
	{INTERFACEKEY_MACRO_BREAK, "Macro, Break"},
	{INTERFACEKEY_RECORD_MACRO, "Macro, Record"},
	{INTERFACEKEY_PLAY_MACRO, "Macro, Play"},
	{INTERFACEKEY_SAVE_MACRO, "Macro, Save"},
	{INTERFACEKEY_LOAD_MACRO, "Macro, Load"},
	/*
	{INTERFACEKEY_HOTKEY_ALCHEMIST_SOAP, "Hotkey: Alchemist, Soap"},
	{INTERFACEKEY_HOTKEY_STILL_BREW, "Hotkey: Still, Brew"},
	{INTERFACEKEY_HOTKEY_STILL_EXTRACT, "Hotkey: Still, Extract"},
	{INTERFACEKEY_HOTKEY_LOOM_COLLECT_SILK, "Hotkey: Loom, Collect Silk"},
	{INTERFACEKEY_HOTKEY_LOOM_WEAVE_CLOTH, "Hotkey: Loom, Weave Cloth"},
	{INTERFACEKEY_HOTKEY_LOOM_WEAVE_SILK, "Hotkey: Loom, Weave Silk"},
	{INTERFACEKEY_HOTKEY_LOOM_WEAVE_YARN, "Hotkey: Loom, Weave Yarn"},
	{INTERFACEKEY_HOTKEY_LOOM_WEAVE_METAL, "Hotkey: Loom, Metal"},
	{INTERFACEKEY_HOTKEY_KITCHEN_COOK_2, "Hotkey: Kitchen, Meal 1"},
	{INTERFACEKEY_HOTKEY_KITCHEN_COOK_3, "Hotkey: Kitchen, Meal 2"},
	{INTERFACEKEY_HOTKEY_KITCHEN_COOK_4, "Hotkey: Kitchen, Meal 3"},
	{INTERFACEKEY_HOTKEY_KITCHEN_RENDER_FAT, "Hotkey: Kitchen, Render Fat"},
	{INTERFACEKEY_HOTKEY_FARMER_PROCESS, "Hotkey: Farmer, Process"},
	{INTERFACEKEY_HOTKEY_FARMER_PROCESS_VIAL, "Hotkey: Farmer, Vial"},
	{INTERFACEKEY_HOTKEY_FARMER_PROCESS_BAG, "Hotkey: Farmer, Bag"},
	{INTERFACEKEY_HOTKEY_FARMER_PROCESS_BARREL, "Hotkey: Farmer, Barrel"},
	{INTERFACEKEY_HOTKEY_FARMER_CHEESE, "Hotkey: Farmer, Cheese"},
	{INTERFACEKEY_HOTKEY_FARMER_MILK, "Hotkey: Farmer, Milk"},
	{INTERFACEKEY_HOTKEY_FARMER_SHEAR_CREATURE, "Hotkey: Farmer, Shear"},
	{INTERFACEKEY_HOTKEY_FARMER_SPIN_THREAD, "Hotkey: Farmer, Spin"},
	{INTERFACEKEY_HOTKEY_MILL_MILL, "Hotkey: Mill, Mill"},
	{INTERFACEKEY_HOTKEY_KENNEL_CATCH_VERMIN, "Hotkey: Kennel, Catch"},
	{INTERFACEKEY_HOTKEY_KENNEL_TAME_VERMIN, "Hotkey: Kennel, Tame Small"},
	{INTERFACEKEY_HOTKEY_FISHERY_PROCESS, "Hotkey: Fishery, Process"},
	{INTERFACEKEY_HOTKEY_FISHERY_EXTRACT, "Hotkey: Fishery, Extract"},
	{INTERFACEKEY_HOTKEY_FISHERY_CATCH, "Hotkey: Fishery, Catch"},
	{INTERFACEKEY_HOTKEY_BUTCHER_BUTCHER, "Hotkey: Butcher, Butcher"},
	{INTERFACEKEY_HOTKEY_BUTCHER_EXTRACT, "Hotkey: Butcher, Extract"},
	{INTERFACEKEY_HOTKEY_BUTCHER_CATCH, "Hotkey: Butcher, Catch"},
	{INTERFACEKEY_HOTKEY_TANNER_TAN, "Hotkey: Tanner, Tan"},
	{INTERFACEKEY_HOTKEY_DYER_THREAD, "Hotkey: Dyer, Thread"},
	{INTERFACEKEY_HOTKEY_DYER_CLOTH, "Hotkey: Dyer, Cloth"},
	{INTERFACEKEY_HOTKEY_JEWELER_FURNITURE, "Hotkey: Jeweler, Furniture"},
	{INTERFACEKEY_HOTKEY_JEWELER_FINISHED, "Hotkey: Jeweler, Finished"},
	{INTERFACEKEY_HOTKEY_JEWELER_AMMO, "Hotkey: Jeweler, Ammo"},
	{INTERFACEKEY_HOTKEY_JEWELER_CUT, "Hotkey: Jeweler, Cut"},
	{INTERFACEKEY_HOTKEY_JEWELER_ENCRUST, "Hotkey: Jeweler, Encrust"},
	{INTERFACEKEY_HOTKEY_MECHANIC_PARTS, "Hotkey: Mechanic, Mechanisms"},
	{INTERFACEKEY_HOTKEY_MECHANIC_TRACTION_BENCH, "Hotkey: Mechanic, Traction Bench"},
	{INTERFACEKEY_HOTKEY_MASON_ARMORSTAND, "Hotkey: Mason, Armorstand"},
	{INTERFACEKEY_HOTKEY_MASON_BLOCKS, "Hotkey: Mason, Blocks"},
	{INTERFACEKEY_HOTKEY_MASON_CHAIR, "Hotkey: Mason, Chair"},
	{INTERFACEKEY_HOTKEY_MASON_COFFIN, "Hotkey: Mason, Coffin"},
	{INTERFACEKEY_HOTKEY_MASON_DOOR, "Hotkey: Mason, Door"},
	{INTERFACEKEY_HOTKEY_MASON_FLOODGATE, "Hotkey: Mason, Floodgate"},
	{INTERFACEKEY_HOTKEY_MASON_HATCH_COVER, "Hotkey: Mason, Hatch Cover"},
	{INTERFACEKEY_HOTKEY_MASON_GRATE, "Hotkey: Mason, Grate"},
	{INTERFACEKEY_HOTKEY_MASON_CABINET, "Hotkey: Mason, Cabinet"},
	{INTERFACEKEY_HOTKEY_MASON_BOX, "Hotkey: Mason, Box"},
	{INTERFACEKEY_HOTKEY_MASON_STATUE, "Hotkey: Mason, Statue"},
	{INTERFACEKEY_HOTKEY_MASON_QUERN, "Hotkey: Mason, Quern"},
	{INTERFACEKEY_HOTKEY_MASON_MILLSTONE, "Hotkey: Mason, Millstone"},
	{INTERFACEKEY_HOTKEY_MASON_TABLE, "Hotkey: Mason, Table"},
	{INTERFACEKEY_HOTKEY_MASON_WEAPONRACK, "Hotkey: Mason, Weaponrack"},
	{INTERFACEKEY_HOTKEY_MASON_SLAB, "Hotkey: Mason, Slab"},
	{INTERFACEKEY_HOTKEY_TRAP_BRIDGE, "Hotkey: Trap, Bridge"},
	{INTERFACEKEY_HOTKEY_TRAP_GEAR_ASSEMBLY, "Hotkey: Trap, Gear Assembly"},
	{INTERFACEKEY_HOTKEY_TRAP_DOOR, "Hotkey: Trap, Door"},
	{INTERFACEKEY_HOTKEY_TRAP_FLOODGATE, "Hotkey: Trap, Floodgate"},
	{INTERFACEKEY_HOTKEY_TRAP_SPIKE, "Hotkey: Trap, Spike"},
	{INTERFACEKEY_HOTKEY_TRAP_HATCH, "Hotkey: Trap, Hatch"},
	{INTERFACEKEY_HOTKEY_TRAP_GRATE_WALL, "Hotkey: Trap, Wall Grate"},
	{INTERFACEKEY_HOTKEY_TRAP_GRATE_FLOOR, "Hotkey: Trap, Floor Grate"},
	{INTERFACEKEY_HOTKEY_TRAP_BARS_VERTICAL, "Hotkey: Trap, Vertical Bars"},
	{INTERFACEKEY_HOTKEY_TRAP_BARS_FLOOR, "Hotkey: Trap, Floor Bars"},
	{INTERFACEKEY_HOTKEY_TRAP_SUPPORT, "Hotkey: Trap, Support"},
	{INTERFACEKEY_HOTKEY_TRAP_CHAIN, "Hotkey: Trap, Chain"},
	{INTERFACEKEY_HOTKEY_TRAP_CAGE, "Hotkey: Trap, Cage"},
	{INTERFACEKEY_HOTKEY_TRAP_PULL_LEVER, "Hotkey: Trap, Lever"},
	{INTERFACEKEY_HOTKEY_TRAP_TRACK_STOP, "Hotkey: Trap, Track Stop"},
	{INTERFACEKEY_BUILDJOB_ADD, "Buildjob: Add"},
	{INTERFACEKEY_BUILDJOB_CANCEL, "Buildjob: Cancel"},
	{INTERFACEKEY_BUILDJOB_NAME, "Buildjob: Name"},
	{INTERFACEKEY_BUILDJOB_PROMOTE, "Buildjob: Promote"},
	{INTERFACEKEY_BUILDJOB_NOW, "Buildjob: Now"},
	{INTERFACEKEY_BUILDJOB_REPEAT, "Buildjob: Repeat"},
	{INTERFACEKEY_BUILDJOB_SUSPEND, "Buildjob: Suspend"},
	{INTERFACEKEY_BUILDJOB_WORKSHOP_PROFILE, "Buildjob: Workshop Profile"},
	{INTERFACEKEY_BUILDJOB_DETAILS, "Buildjob: Details"},
	{INTERFACEKEY_BUILDJOB_DETAILS_FILTER, "Buildjob: Details, Filter"},
	{INTERFACEKEY_BUILDJOB_WELL_FREE, "Buildjob: Well, Free"},
	{INTERFACEKEY_BUILDJOB_WELL_SIZE, "Buildjob: Well, Size"},
	{INTERFACEKEY_BUILDJOB_TARGET_FREE, "Buildjob: Target, Free"},
	{INTERFACEKEY_BUILDJOB_TARGET_SIZE, "Buildjob: Target, Size"},
	{INTERFACEKEY_BUILDJOB_TARGET_DOWN, "Buildjob: Target, Down"},
	{INTERFACEKEY_BUILDJOB_TARGET_UP, "Buildjob: Target, Up"},
	{INTERFACEKEY_BUILDJOB_TARGET_RIGHT, "Buildjob: Target, Right"},
	{INTERFACEKEY_BUILDJOB_TARGET_LEFT, "Buildjob: Target, Left"},
	{INTERFACEKEY_BUILDJOB_STATUE_ASSIGN, "Buildjob: Statue, Assign"},
	{INTERFACEKEY_BUILDJOB_STATUE_FREE, "Buildjob: Statue, Free"},
	{INTERFACEKEY_BUILDJOB_STATUE_SIZE, "Buildjob: Statue, Size"},
	{INTERFACEKEY_BUILDJOB_CAGE_JUSTICE, "Buildjob: Cage, Justice"},
	{INTERFACEKEY_BUILDJOB_CAGE_FREE, "Buildjob: Cage, Free"},
	{INTERFACEKEY_BUILDJOB_CAGE_SIZE, "Buildjob: Cage, Size"},
	{INTERFACEKEY_BUILDJOB_CAGE_ASSIGN_OCC, "Buildjob: Cage, Assign Occ"},
	{INTERFACEKEY_BUILDJOB_CAGE_WATER, "Buildjob: Cage, Water"},
	{INTERFACEKEY_BUILDJOB_CAGE_ASSIGN, "Buildjob: Cage, Assign Owner"},
	{INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN_OCC, "Buildjob: Chain, Assign Occ"},
	{INTERFACEKEY_BUILDJOB_CHAIN_JUSTICE, "Buildjob: Chain, Justice"},
	{INTERFACEKEY_BUILDJOB_CHAIN_ASSIGN, "Buildjob: Chain, Assign Owner"},
	{INTERFACEKEY_BUILDJOB_CHAIN_FREE, "Buildjob: Chain, Free"},
	{INTERFACEKEY_BUILDJOB_CHAIN_SIZE, "Buildjob: Chain, Size"},
	{INTERFACEKEY_BUILDJOB_SIEGE_FIRING, "Buildjob: Siege, Fire"},
	{INTERFACEKEY_BUILDJOB_SIEGE_ORIENT, "Buildjob: Siege, Orient"},
	{INTERFACEKEY_BUILDJOB_DOOR_INTERNAL, "Buildjob: Door, Internal"},
	{INTERFACEKEY_BUILDJOB_DOOR_LOCK, "Buildjob: Door, Forbid"},
	{INTERFACEKEY_BUILDJOB_DOOR_AJAR, "Buildjob: Door, Pet-passable"},
	{INTERFACEKEY_BUILDJOB_COFFIN_ASSIGN, "Buildjob: Coffin, Assign"},
	{INTERFACEKEY_BUILDJOB_COFFIN_FREE, "Buildjob: Coffin, Free"},
	{INTERFACEKEY_BUILDJOB_COFFIN_SIZE, "Buildjob: Coffin, Size"},
	{INTERFACEKEY_BUILDJOB_COFFIN_BURIAL, "Buildjob: Coffin, Gen. Burial"},
	{INTERFACEKEY_BUILDJOB_COFFIN_CIV, "Buildjob: Coffin, Allow Citizens"},
	{INTERFACEKEY_BUILDJOB_COFFIN_PET, "Buildjob: Coffin, Allow Pets"},
	{INTERFACEKEY_BUILDJOB_CHAIR_ASSIGN, "Buildjob: Chair, Assign"},
	{INTERFACEKEY_BUILDJOB_CHAIR_FREE, "Buildjob: Chair, Free"},
	{INTERFACEKEY_BUILDJOB_CHAIR_SIZE, "Buildjob: Chair, Size"},
	{INTERFACEKEY_BUILDJOB_TABLE_ASSIGN, "Buildjob: Table, Assign"},
	{INTERFACEKEY_BUILDJOB_TABLE_HALL, "Buildjob: Table, Hall"},
	{INTERFACEKEY_BUILDJOB_TABLE_FREE, "Buildjob: Table, Free"},
	{INTERFACEKEY_BUILDJOB_TABLE_SIZE, "Buildjob: Table, Size"},
	{INTERFACEKEY_BUILDJOB_BED_ASSIGN, "Buildjob: Bed, Assign"},
	{INTERFACEKEY_BUILDJOB_BED_FREE, "Buildjob: Bed, Free"},
	{INTERFACEKEY_BUILDJOB_BED_BARRACKS, "Buildjob: Bed, Barracks"},
	{INTERFACEKEY_BUILDJOB_BED_DORMITORY, "Buildjob: Bed, Dormitory"},
	{INTERFACEKEY_BUILDJOB_BED_RENT, "Buildjob: Bed, Rent"},
	{INTERFACEKEY_BUILDJOB_BED_SIZE, "Buildjob: Bed, Size"},
	{INTERFACEKEY_BUILDJOB_BED_SLEEP, "Buildjob: Bed, Sleep"},
	{INTERFACEKEY_BUILDJOB_BED_TRAIN, "Buildjob: Bed, Train"},
	{INTERFACEKEY_BUILDJOB_BED_INDIV_EQ, "Buildjob: Bed, Indiv Eq"},
	{INTERFACEKEY_BUILDJOB_BED_SQUAD_EQ, "Buildjob: Bed, Squad Eq"},
	{INTERFACEKEY_BUILDJOB_BED_POSITION, "Buildjob: Bed, Position"},
	{INTERFACEKEY_BUILDJOB_DEPOT_BRING, "Buildjob: Depot, Bring"},
	{INTERFACEKEY_BUILDJOB_DEPOT_TRADE, "Buildjob: Depot, Trade"},
	{INTERFACEKEY_BUILDJOB_DEPOT_REQUEST_TRADER, "Buildjob: Depot, Request Trader"},
	{INTERFACEKEY_BUILDJOB_DEPOT_BROKER_ONLY, "Buildjob: Depot, Broker Only"},
	{INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_NONE, "Buildjob: Animal Trap, No Bait"},
	{INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_MEAT, "Buildjob: Animal Trap, Meat Bait"},
	{INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_FISH, "Buildjob: Animal Trap, Fish Bait"},
	{INTERFACEKEY_BUILDJOB_ANIMALTRAP_BAIT_GEM, "Buildjob: Animal Trap, Gem Bait"},
	{INTERFACEKEY_BUILDJOB_FARM_FALLOW, "Buildjob: Farm, Fallow"},
	{INTERFACEKEY_BUILDJOB_FARM_FERTILIZE, "Buildjob: Farm, Fertilize"},
	{INTERFACEKEY_BUILDJOB_FARM_SEASFERT, "Buildjob: Farm, Seas Fert"},
	{INTERFACEKEY_BUILDJOB_FARM_SPRING, "Buildjob: Farm, Spring"},
	{INTERFACEKEY_BUILDJOB_FARM_SUMMER, "Buildjob: Farm, Summer"},
	{INTERFACEKEY_BUILDJOB_FARM_AUTUMN, "Buildjob: Farm, Autumn"},
	{INTERFACEKEY_BUILDJOB_FARM_WINTER, "Buildjob: Farm, Winter"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_MASTER, "Buildjob: Stockpile, Master"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_LINK_ANYWHERE, "Buildjob: Stockpile, Link/Anywhere"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_GIVE_TO, "Buildjob: Stockpile, Give To"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_WHEELBARROW, "Buildjob: Stockpile, Wheelbarrow"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_DELETE_CHILD, "Buildjob: Stockpile, Delete Child"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_SETTINGS, "Buildjob: Stockpile, Settings"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_UP, "Buildjob: Stockpile, Barrel Up"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_DOWN, "Buildjob: Stockpile, Barrel Down"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_ZERO, "Buildjob: Stockpile, Barrel Zero"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BARREL_MAX, "Buildjob: Stockpile, Barrel Max"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_UP, "Buildjob: Stockpile, Bin Up"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_DOWN, "Buildjob: Stockpile, Bin Down"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_ZERO, "Buildjob: Stockpile, Bin Zero"},
	{INTERFACEKEY_BUILDJOB_STOCKPILE_BIN_MAX, "Buildjob: Stockpile, Bin Max"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_BONE, "Buildjob: Rack, Mat, Bone"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_BRONZE, "Buildjob: Rack, Mat, Bronze"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_COPPER, "Buildjob: Rack, Mat, Copper"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_IRON, "Buildjob: Rack, Mat, Iron"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_STEEL, "Buildjob: Rack, Mat, Steel"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_WOOD, "Buildjob: Rack, Mat, Wood"},
	{INTERFACEKEY_BUILDJOB_RACK_MAT_METAL, "Buildjob: Rack, Mat, Special Metal"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_BONE, "Buildjob: Stand, Mat, Bone"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_LEATHER, "Buildjob: Stand, Mat, Leather"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_COPPER, "Buildjob: Stand, Mat, Copper"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_BRONZE, "Buildjob: Stand, Mat, Bronze"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_STEEL, "Buildjob: Stand, Mat, Steel"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_IRON, "Buildjob: Stand, Mat, Iron"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_WOOD, "Buildjob: Stand, Mat, Wood"},
	{INTERFACEKEY_BUILDJOB_STAND_MAT_METAL, "Buildjob: Stand, Mat, Special Metal"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_ASSIGN, "Buildjob: Rackstand, Assign"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_FREE, "Buildjob: Rackstand, Free"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_SIZE, "Buildjob: Rackstand, Size"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_ITEM, "Buildjob: Rackstand, Item"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_MAT, "Buildjob: Rackstand, Mat"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS1, "Buildjob: Rackstand, All Items"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_KILL1, "Buildjob: Rackstand, No Items"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_DEFAULTS2, "Buildjob: Rackstand, All Mats"},
	{INTERFACEKEY_BUILDJOB_RACKSTAND_KILL2, "Buildjob: Rackstand, No Mats"},
	{INTERFACEKEY_BUILDJOB_DISPLAY_FURNITURE_SET, "Buildjob: Display Furniture, Set"},
	{INTERFACEKEY_BUILDJOB_DISPLAY_FURNITURE_CANCEL, "Buildjob: Display Furniture, Cancel"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_ENABLE, "Stockpile Settings: Enable"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_DISABLE, "Stockpile Settings: Disable"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_ALL, "Stockpile Settings: Permit All"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_ALL, "Stockpile Settings: Forbid All"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_PERMIT_SUB, "Stockpile Settings: Permit Sub"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_FORBID_SUB, "Stockpile Settings: Forbit Sub"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC1, "Stockpile Settings: Specific 1"},
	{INTERFACEKEY_STOCKPILE_SETTINGS_SPECIFIC2, "Stockpile Settings: Specific 2"},
	{INTERFACEKEY_MOVIE_RECORD, "Movie: Record"},
	{INTERFACEKEY_MOVIE_PLAY, "Movie: Play"},
	{INTERFACEKEY_MOVIE_SAVE, "Movie: Save"},
	{INTERFACEKEY_MOVIE_LOAD, "Movie: Load"},
	{INTERFACEKEY_ASSIGNTRADE_VIEW, "Assign Trade: View"},
	{INTERFACEKEY_ASSIGNTRADE_STRING, "Assign Trade: String"},
	{INTERFACEKEY_ASSIGNTRADE_EXCLUDE_PROHIBITED, "Assign Trade: Exclude Prohibited"},
	{INTERFACEKEY_ASSIGNTRADE_PENDING, "Assign Trade: Pending"},
	{INTERFACEKEY_ASSIGNTRADE_SORT, "Assign Trade: Sort"},
	{INTERFACEKEY_NOBLELIST_REPLACE, "Noble List: Replace"},
	{INTERFACEKEY_NOBLELIST_SETTINGS, "Noble List: Settings"},
	{INTERFACEKEY_NOBLELIST_CAPITAL, "Noble List: Capital"},
	{INTERFACEKEY_NOBLELIST_VIEW_CANDIDATE, "Noble List: View Candidate"},
	{INTERFACEKEY_A_BARTER_VIEW, "Adventure: Barter, View"},
	{INTERFACEKEY_A_BARTER_CURRENCY_1, "Adventure: Barter, Currency 1"},
	{INTERFACEKEY_A_BARTER_CURRENCY_2, "Adventure: Barter, Currency 2"},
	{INTERFACEKEY_A_BARTER_TRADE, "Adventure: Barter, Trade"},
	{INTERFACEKEY_A_BARTER_SHOW, "Adventure: Barter, Show"},
	{INTERFACEKEY_TRADE_VIEW, "Trade, View"},
	{INTERFACEKEY_TRADE_TRADE, "Trade, Trade"},
	{INTERFACEKEY_TRADE_OFFER, "Trade, Offer"},
	{INTERFACEKEY_TRADE_SEIZE, "Trade, Seize"},
	{INTERFACEKEY_STORES_VIEW, "Stores, View"},
	{INTERFACEKEY_STORES_FORBID, "Stores, Forbid"},
	{INTERFACEKEY_STORES_MELT, "Stores, Melt"},
	{INTERFACEKEY_STORES_DUMP, "Stores, Dump"},
	{INTERFACEKEY_STORES_ZOOM, "Stores, Zoom"},
	{INTERFACEKEY_STORES_HIDE, "Stores, Hide"},
	{INTERFACEKEY_MILITARY_ACTIVATE, "Military, Activate"},
	{INTERFACEKEY_MILITARY_VIEW, "Military, View"},
	{INTERFACEKEY_MILITARY_WEAPON, "Military, Weapon"},
	{INTERFACEKEY_MILITARY_ZOOM, "Military, Zoom"},
	{INTERFACEKEY_ANNOUNCE_ZOOM, "Announcements, Zoom"},
	{INTERFACEKEY_ANNOUNCE_ZOOM_2, "Announcements, Zoom 2"},
	{INTERFACEKEY_UNITJOB_REMOVE_CRE, "Unitjob, Remove Unit"},
	{INTERFACEKEY_UNITJOB_ZOOM_CRE, "Unitjob, Zoom Unit"},
	{INTERFACEKEY_UNITJOB_ZOOM_BUILD, "Unitjob, Zoom Building"},
	{INTERFACEKEY_UNITJOB_VIEW_UNIT, "Unitjob, View Unit"},
	{INTERFACEKEY_UNITJOB_VIEW_JOB, "Unitjob, View Job"},
	{INTERFACEKEY_UNITJOB_MANAGER, "Unitjob, Manager"},
	{INTERFACEKEY_MANAGER_NEW_ORDER, "Manager, New Order"},
	{INTERFACEKEY_MANAGER_REMOVE, "Manager, Remove"},
	{INTERFACEKEY_MANAGER_PROMOTE, "Manager, Promote"},
	{INTERFACEKEY_MANAGER_MAX, "Manager, Max"},
	{INTERFACEKEY_MANAGER_WAGES, "Manager, Wages"},
	{INTERFACEKEY_MANAGER_CONDITIONS, "Manager, Conditions"},
	{INTERFACEKEY_MANAGER_DETAILS, "Manager, Details"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ADD_ITEM, "Work Order, Conditions, Add Item Condition"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ADD_ORDER, "Work Order, Conditions, Add Order Condition"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_TYPE, "Work Order, Conditions, Item Type"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_MATERIAL, "Work Order, Conditions, Item Material"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_TRAITS, "Work Order, Conditions, Item Traits"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_INEQUALITY, "Work Order, Conditions, Item Inequality"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ITEM_NUMBER, "Work Order, Conditions, Item Number"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_DELETE, "Work Order, Conditions, Delete"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_ORDER_ACTIVATION, "Work Order, Conditions, Order Activation"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_REAGENTS, "Work Order, Conditions, Reagents"},
	{INTERFACEKEY_WORK_ORDER_CONDITION_PRODUCTS, "Work Order, Conditions, Products"},
	*/
	{INTERFACEKEY_PET_BUTCHER, "Animals, Slaughter"},
	{INTERFACEKEY_PET_GELD, "Animals, Geld"},
	{INTERFACEKEY_PET_AVAILABLE,"Animals, Toggle Available"},
	{INTERFACEKEY_ANIMAL_SELECT_TRAINER, "Animals, Trainer"},
	{INTERFACEKEY_ANIMAL_WAR_TRAINING, "Animals, War Training"},
	{INTERFACEKEY_ANIMAL_HUNTING_TRAINING, "Animals, Hunting Training"},
	{INTERFACEKEY_ANIMAL_ASSIGN_WORKER,"Animals, Assign Work Animal"},
	{INTERFACEKEY_KITCHEN_COOK, "Kitchen, Cook"},
	{INTERFACEKEY_KITCHEN_BREW, "Kitchen, Brew"},
	{INTERFACEKEY_JUSTICE_INTERROGATE, "Justice, Interrogate"},
	{INTERFACEKEY_JUSTICE_CONVICT, "Justice, Convict"},
	/*
	{INTERFACEKEY_JUSTICE_COUNTERINTELLIGENCE, "Justice, Counterintelligence"},
	{INTERFACEKEY_SETUPGAME_NEW, "Setup, New"},
	{INTERFACEKEY_SETUPGAME_VIEW, "Setup, View"},
	{INTERFACEKEY_SETUPGAME_CUSTOMIZE_UNIT, "Setup, Customize Unit"},
	{INTERFACEKEY_SETUPGAME_SAVE_PROFILE, "Setup, Save Profile"},
	{INTERFACEKEY_SETUPGAME_SAVE_PROFILE_ABORT, "Setup, Save Profile, Abort"},
	{INTERFACEKEY_SETUPGAME_SAVE_PROFILE_GO, "Setup, Save Profile, Go"},
	{INTERFACEKEY_SETUPGAME_VIEW_PROFILE_PROBLEMS, "Setup, View Profile Problems"},
	{INTERFACEKEY_CIVZONE_NAME, "Main: Activity Zone, Name"},
	{INTERFACEKEY_CIVZONE_REMOVE, "Main: Activity Zone, Remove"},
	{INTERFACEKEY_CIVZONE_REMOVE_ZONE, "Main: Activity Zone, Remove Zone"},
	{INTERFACEKEY_CIVZONE_SHAPE, "Main: Activity Zone, Shape"},
	{INTERFACEKEY_CIVZONE_NEXT, "Main: Activity Zone, Next"},
	{INTERFACEKEY_CIVZONE_WATER_SOURCE, "Main: Activity Zone, Water Source"},
	{INTERFACEKEY_CIVZONE_GATHER, "Main: Activity Zone, Gather"},
	{INTERFACEKEY_CIVZONE_DUMP, "Main: Activity Zone, Garbage Dump"},
	{INTERFACEKEY_CIVZONE_POND, "Main: Activity Zone, Pond"},
	{INTERFACEKEY_CIVZONE_SAND_COLLECT, "Main: Activity Zone, Sand Collect"},
	{INTERFACEKEY_CIVZONE_CLAY_COLLECT, "Main: Activity Zone, Clay Collect"},
	{INTERFACEKEY_CIVZONE_ACTIVE, "Main: Activity Zone, Active"},
	{INTERFACEKEY_CIVZONE_FISH, "Main: Activity Zone, Fish"},
	{INTERFACEKEY_CIVZONE_MEETING, "Main: Activity Zone, Meeting"},
	{INTERFACEKEY_CIVZONE_ANIMAL_TRAINING, "Main: Activity Zone, Animal Training"},
	{INTERFACEKEY_CIVZONE_POND_OPTIONS, "Main: Activity Zone, Pond Options"},
	{INTERFACEKEY_CIVZONE_POND_WATER, "Main: Activity Zone: Pond, Water"},
	{INTERFACEKEY_CIVZONE_GATHER_OPTIONS, "Main: Activity Zone, Gather Options"},
	{INTERFACEKEY_CIVZONE_GATHER_OPTIONS_PICK_TREES, "Main: Activity Zone, Gather Options, Pick Trees"},
	{INTERFACEKEY_CIVZONE_GATHER_OPTIONS_PICK_SHRUBS, "Main: Activity Zone, Gather Options, Pick Shrubs"},
	{INTERFACEKEY_CIVZONE_GATHER_OPTIONS_GATHER_FALLEN, "Main: Activity Zone, Gather Options, Gather Fallen"},
	{INTERFACEKEY_CIVZONE_PEN, "Main: Activity Zone, Pen"},
	{INTERFACEKEY_CIVZONE_PEN_OPTIONS, "Main: Activity Zone, Pen Options"},
	{INTERFACEKEY_STOCKPILE_ANIMAL, "Stockpile, Animal"},
	{INTERFACEKEY_STOCKPILE_FOOD, "Stockpile, Food"},
	{INTERFACEKEY_STOCKPILE_WEAPON, "Stockpile, Weapon"},
	{INTERFACEKEY_STOCKPILE_ARMOR, "Stockpile, Armor"},
	{INTERFACEKEY_STOCKPILE_CUSTOM, "Stockpile, Custom"},
	{INTERFACEKEY_STOCKPILE_CUSTOM_SETTINGS, "Stockpile, Custom Settings"},
	{INTERFACEKEY_STOCKPILE_FURNITURE, "Stockpile, Furniture"},
	{INTERFACEKEY_STOCKPILE_GRAVEYARD, "Stockpile, Corpse"},
	{INTERFACEKEY_STOCKPILE_REFUSE, "Stockpile, Refuse"},
	{INTERFACEKEY_STOCKPILE_WOOD, "Stockpile, Wood"},
	{INTERFACEKEY_STOCKPILE_STONE, "Stockpile, Stone"},
	{INTERFACEKEY_STOCKPILE_GEM, "Stockpile, Gem"},
	{INTERFACEKEY_STOCKPILE_BARBLOCK, "Stockpile, Bar/Block"},
	{INTERFACEKEY_STOCKPILE_CLOTH, "Stockpile, Cloth"},
	{INTERFACEKEY_STOCKPILE_LEATHER, "Stockpile, Leather"},
	{INTERFACEKEY_STOCKPILE_AMMO, "Stockpile, Ammo"},
	{INTERFACEKEY_STOCKPILE_COINS, "Stockpile, Coins"},
	{INTERFACEKEY_STOCKPILE_FINISHED, "Stockpile, Finished"},
	{INTERFACEKEY_STOCKPILE_SHEET, "Stockpile, Sheet"},
	{INTERFACEKEY_STOCKPILE_NONE, "Stockpile, None"},
	*/

	{INTERFACEKEY_DESIGNATE_DIG, "Designate, Dig"},
	{INTERFACEKEY_DESIGNATE_STAIR_UPDOWN, "Designate, UD Stair"},
	{INTERFACEKEY_DESIGNATE_RAMP, "Designate, Ramp"},
	{INTERFACEKEY_DESIGNATE_CHANNEL, "Designate, Channel"},
	{INTERFACEKEY_DESIGNATE_DIG_REMOVE_STAIRS_RAMPS, "Designate, Dig Remove Stairs Ramps"},

	{INTERFACEKEY_DESIGNATE_RECTANGLE, "Designate, Rectangle"},
	{INTERFACEKEY_DESIGNATE_FREE_DRAW, "Designate, Free Draw"},

	{INTERFACEKEY_DESIGNATE_TOGGLE_ADVANCED_OPTIONS, "Designate, Toggle Advanced Options"},

	{INTERFACEKEY_DESIGNATE_MINE_MODE_ALL, "Designate, Mine All"},
	{INTERFACEKEY_DESIGNATE_MINE_MODE_AUTO, "Designate, Mine Auto"},
	{INTERFACEKEY_DESIGNATE_MINE_MODE_ORE_GEM, "Designate, Mine Ore+Gems"},
	{INTERFACEKEY_DESIGNATE_MINE_MODE_GEM, "Designate, Min Gems"},

	{INTERFACEKEY_DESIGNATE_PRIORITY_UP, "Designate, Priority Up"},
	{INTERFACEKEY_DESIGNATE_PRIORITY_DOWN, "Designate, Priority Down"},

	{INTERFACEKEY_DESIGNATE_TOGGLE_MARKER, "Designate, Toggle Blueprint"},
	{INTERFACEKEY_DESIGNATE_MARKER_TO_STANDARD, "Designate, Blueprint to Standard"},
	{INTERFACEKEY_DESIGNATE_STANDARD_TO_MARKER, "Designate, Standard to Blueprint"},

	{INTERFACEKEY_DESIGNATE_CHOP, "Designate, Chop Trees"},

	{INTERFACEKEY_DESIGNATE_PLANTS, "Designate, Gather Plants"},

	{INTERFACEKEY_DESIGNATE_SMOOTH, "Designate, Smooth"},
	{INTERFACEKEY_DESIGNATE_ENGRAVE, "Designate, Engrave"},
	{INTERFACEKEY_DESIGNATE_TRACK, "Designate, Carve Track"},
	{INTERFACEKEY_DESIGNATE_FORTIFY, "Designate, Fortify"},

	{INTERFACEKEY_DESIGNATE_CLAIM, "Designate, Reclaim"},
	{INTERFACEKEY_DESIGNATE_UNCLAIM, "Designate, Forbid"},
	{INTERFACEKEY_DESIGNATE_MELT, "Designate, Melt"},
	{INTERFACEKEY_DESIGNATE_NO_MELT, "Designate, No Melt"},
	{INTERFACEKEY_DESIGNATE_DUMP, "Designate, Dump"},
	{INTERFACEKEY_DESIGNATE_NO_DUMP, "Designate, No Dump"},
	{INTERFACEKEY_DESIGNATE_HIDE, "Designate, Hide"},
	{INTERFACEKEY_DESIGNATE_NO_HIDE, "Designate, No Hide"},

	{INTERFACEKEY_DESIGNATE_TRAFFIC_HIGH, "Designate, High Traffic"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_NORMAL, "Designate, Normal Traffic"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_LOW, "Designate, Low Traffic"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_RESTRICTED, "Designate, Restricted Traffic"},

	/*
	{INTERFACEKEY_DESIGNATE_BITEM, "Designate, Building/Item"},
	{INTERFACEKEY_DESIGNATE_CLAIM, "Designate, Reclaim"},
	{INTERFACEKEY_DESIGNATE_UNCLAIM, "Designate, Forbid"},
	{INTERFACEKEY_DESIGNATE_MELT, "Designate, Melt"},
	{INTERFACEKEY_DESIGNATE_NO_MELT, "Designate, No Melt"},
	{INTERFACEKEY_DESIGNATE_DUMP, "Designate, Dump"},
	{INTERFACEKEY_DESIGNATE_NO_DUMP, "Designate, No Dump"},
	{INTERFACEKEY_DESIGNATE_HIDE, "Designate, Hide"},
	{INTERFACEKEY_DESIGNATE_NO_HIDE, "Designate, No Hide"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC, "Designate, Traffic"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT, "Designate, Increase Weight"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT, "Designate, Decrease Weight"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_INCREASE_WEIGHT_MORE, "Designate, Increase Weight More"},
	{INTERFACEKEY_DESIGNATE_TRAFFIC_DECREASE_WEIGHT_MORE, "Designate, Decrease Weight More"},
	{INTERFACEKEY_DESIGNATE_STAIR_UP, "Designate, U Stair"},
	{INTERFACEKEY_DESIGNATE_STAIR_DOWN, "Designate, D Stair"},
	{INTERFACEKEY_DESIGNATE_DETAILS, "Designate, Details"},
	{INTERFACEKEY_DESIGNATE_TOGGLE_ENGRAVING, "Designate, Toggle Engraving"},
	{INTERFACEKEY_DESIGNATE_STANDARD_MARKER, "Designate, Standard/Marker"},
	{INTERFACEKEY_DESIGNATE_MINE_MODE, "Designate, Mine Mode"},
	{INTERFACEKEY_DESIGNATE_TOGGLE_MARKER, "Designate, Toggle Marker"},
	{INTERFACEKEY_DESIGNATE_UNDO, "Designate, Undo"},
	{INTERFACEKEY_DESIGNATE_REMOVE_CONSTRUCTION, "Designate, Remove Construction"},
	{INTERFACEKEY_BUILDING_DIM_Y_UP, "Building, Change Height +"},
	{INTERFACEKEY_BUILDING_DIM_Y_DOWN, "Building, Change Height -"},
	{INTERFACEKEY_BUILDING_DIM_X_UP, "Building, Change Width +"},
	{INTERFACEKEY_BUILDING_DIM_X_DOWN, "Building, Change Width -"},
	{INTERFACEKEY_BUILDING_ORIENT_UP, "Building, Orient Up"},
	{INTERFACEKEY_BUILDING_ORIENT_LEFT, "Building, Orient Left"},
	{INTERFACEKEY_BUILDING_ORIENT_RIGHT, "Building, Orient Right"},
	{INTERFACEKEY_BUILDING_ORIENT_DOWN, "Building, Orient Down"},
	{INTERFACEKEY_BUILDING_ORIENT_NONE, "Building, Orient None"},
	{INTERFACEKEY_BUILDING_VIEW_ITEM, "Building, View Item"},
	{INTERFACEKEY_BUILDING_ADVANCE_STAGE, "Building, Done Selecting"},
	{INTERFACEKEY_BUILDING_EXPAND_CONTRACT, "Building, Expand/Contract"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_WATER, "Building, Trigger, Enable Water"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_UP, "Building, Trigger, Min Water Up"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_WATER_DOWN, "Building, Trigger, Min Water Down"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_UP, "Building, Trigger, Max Water Up"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_WATER_DOWN, "Building, Trigger, Max Water Down"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_MAGMA, "Building, Trigger, Enabler Magma"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_UP, "Building, Trigger, Min Magma Up"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_MAGMA_DOWN, "Building, Trigger, Min Magma Down"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_UP, "Building, Trigger, Max Magma Up"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_MAGMA_DOWN, "Building, Trigger, Max Magma Down"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_TRACK_CART, "Building, Trigger, Enable Cart"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_DOWN, "Building, Trigger, Min Cart Down"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_TRACK_CART_UP, "Building, Trigger, Min Cart Up"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_DOWN, "Building, Trigger, Max Cart Down"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_TRACK_CART_UP, "Building, Trigger, Max Cart Up"},
	{INTERFACEKEY_BUILDING_ROLLERS_SPEED_UP, "Building, Rollers, Speed Up"},
	{INTERFACEKEY_BUILDING_ROLLERS_SPEED_DOWN, "Building, Rollers, Speed Down"},
	{INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_UP, "Building, Track Stop, Friction Up"},
	{INTERFACEKEY_BUILDING_TRACK_STOP_FRICTION_DOWN, "Building, Track Stop, Friction Down"},
	{INTERFACEKEY_BUILDING_TRACK_STOP_DUMP, "Building, Track Stop, Dump"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_CREATURE, "Building, Trigger, Enable Creature"},
	{INTERFACEKEY_BUILDING_TRIGGER_ENABLE_LOCALS, "Building, Trigger, Enable Locals"},
	{INTERFACEKEY_BUILDING_TRIGGER_RESETS, "Building, Trigger, Resets"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_UP, "Building, Trigger, Min Size Up"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_DOWN, "Building, Trigger, Min Size Down"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_UP, "Building, Trigger, Max Size Up"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_DOWN, "Building, Trigger, Max Size Down"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_UP_PLUS, "Building, Trigger, Min Size Up+"},
	{INTERFACEKEY_BUILDING_TRIGGER_MIN_SIZE_DOWN_PLUS, "Building, Trigger, Min Size Down+"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_UP_PLUS, "Building, Trigger, Max Size Up+"},
	{INTERFACEKEY_BUILDING_TRIGGER_MAX_SIZE_DOWN_PLUS, "Building, Trigger, Max Size Down+"},
	{INTERFACEKEY_UNITVIEW_GEN, "Unitview, General"},
	{INTERFACEKEY_UNITVIEW_INV, "Unitview, Inventory"},
	{INTERFACEKEY_UNITVIEW_PRF, "Unitview, Prefs"},
	{INTERFACEKEY_UNITVIEW_WND, "Unitview, Wounds"},
	{INTERFACEKEY_UNITVIEW_NEXT, "Unitview, Next Unit"},
	{INTERFACEKEY_UNITVIEW_FOLLOW, "Unitview, Follow"},
	{INTERFACEKEY_UNITVIEW_SLAUGHTER, "Unitview, Slaughter"},
	{INTERFACEKEY_UNITVIEW_GELD, "Unitview, Geld"},
	{INTERFACEKEY_UNITVIEW_GEN_COMBAT, "Unitview, General, Combat"},
	{INTERFACEKEY_UNITVIEW_GEN_LABOR, "Unitview, General, Labor"},
	{INTERFACEKEY_UNITVIEW_GEN_MISC, "Unitview, General, Misc"},
	{INTERFACEKEY_UNITVIEW_PRF_PROF, "Unitview, Prefs, Labor"},
	{INTERFACEKEY_UNITVIEW_PRF_PET, "Unitview, Prefs, Pets"},
	{INTERFACEKEY_UNITVIEW_PRF_EXPEL, "Unitview, Prefs, Expel"},
	{INTERFACEKEY_UNITVIEW_PRF_VIEW, "Unitview, Prefs, Profile"},
	{INTERFACEKEY_UNITVIEW_PRF_NEW_SQUAD, "Unitview, Prefs, New Squad"},
	{INTERFACEKEY_UNITVIEW_PRF_REMOVE_FROM_SQUAD, "Unitview, Prefs, Remove From Squad"},
	{INTERFACEKEY_UNITVIEW_PRF_NAME_CURRENT_SQUAD, "Unitview, Prefs, Name Current Squad"},
	{INTERFACEKEY_UNITVIEW_PRF_NAME_SELECTED_SQUAD, "Unitview, Prefs, Name Selected Squad"},
	{INTERFACEKEY_UNITVIEW_PRF_OCCUPATION, "Unitview, Prefs, Occupation"},
	*/

	{INTERFACEKEY_STRING_A000, "String: Backspace"},
	{INTERFACEKEY_STRING_A001, "String: Character 001"},
	{INTERFACEKEY_STRING_A002, "String: Character 002"},
	{INTERFACEKEY_STRING_A003, "String: Character 003"},
	{INTERFACEKEY_STRING_A004, "String: Character 004"},
	{INTERFACEKEY_STRING_A005, "String: Character 005"},
	{INTERFACEKEY_STRING_A006, "String: Character 006"},
	{INTERFACEKEY_STRING_A007, "String: Character 007"},
	{INTERFACEKEY_STRING_A008, "String: Character 008"},
	{INTERFACEKEY_STRING_A009, "String: Character 009"},
	{INTERFACEKEY_STRING_A010, "String: Character 010"},
	{INTERFACEKEY_STRING_A011, "String: Character 011"},
	{INTERFACEKEY_STRING_A012, "String: Character 012"},
	{INTERFACEKEY_STRING_A013, "String: Character 013"},
	{INTERFACEKEY_STRING_A014, "String: Character 014"},
	{INTERFACEKEY_STRING_A015, "String: Character 015"},
	{INTERFACEKEY_STRING_A016, "String: Character 016"},
	{INTERFACEKEY_STRING_A017, "String: Character 017"},
	{INTERFACEKEY_STRING_A018, "String: Character 018"},
	{INTERFACEKEY_STRING_A019, "String: Character 019"},
	{INTERFACEKEY_STRING_A020, "String: Character 020"},
	{INTERFACEKEY_STRING_A021, "String: Character 021"},
	{INTERFACEKEY_STRING_A022, "String: Character 022"},
	{INTERFACEKEY_STRING_A023, "String: Character 023"},
	{INTERFACEKEY_STRING_A024, "String: Character 024"},
	{INTERFACEKEY_STRING_A025, "String: Character 025"},
	{INTERFACEKEY_STRING_A026, "String: Character 026"},
	{INTERFACEKEY_STRING_A027, "String: Character 027"},
	{INTERFACEKEY_STRING_A028, "String: Character 028"},
	{INTERFACEKEY_STRING_A029, "String: Character 029"},
	{INTERFACEKEY_STRING_A030, "String: Character 030"},
	{INTERFACEKEY_STRING_A031, "String: Character 031"},
	{INTERFACEKEY_STRING_A032, "String: Character 032"},
	{INTERFACEKEY_STRING_A033, "String: Character 033"},
	{INTERFACEKEY_STRING_A034, "String: Character 034"},
	{INTERFACEKEY_STRING_A035, "String: Character 035"},
	{INTERFACEKEY_STRING_A036, "String: Character 036"},
	{INTERFACEKEY_STRING_A037, "String: Character 037"},
	{INTERFACEKEY_STRING_A038, "String: Character 038"},
	{INTERFACEKEY_STRING_A039, "String: Character 039"},
	{INTERFACEKEY_STRING_A040, "String: Character 040"},
	{INTERFACEKEY_STRING_A041, "String: Character 041"},
	{INTERFACEKEY_STRING_A042, "String: Character 042"},
	{INTERFACEKEY_STRING_A043, "String: Character 043"},
	{INTERFACEKEY_STRING_A044, "String: Character 044"},
	{INTERFACEKEY_STRING_A045, "String: Character 045"},
	{INTERFACEKEY_STRING_A046, "String: Character 046"},
	{INTERFACEKEY_STRING_A047, "String: Character 047"},
	{INTERFACEKEY_STRING_A048, "String: Character 048"},
	{INTERFACEKEY_STRING_A049, "String: Character 049"},
	{INTERFACEKEY_STRING_A050, "String: Character 050"},
	{INTERFACEKEY_STRING_A051, "String: Character 051"},
	{INTERFACEKEY_STRING_A052, "String: Character 052"},
	{INTERFACEKEY_STRING_A053, "String: Character 053"},
	{INTERFACEKEY_STRING_A054, "String: Character 054"},
	{INTERFACEKEY_STRING_A055, "String: Character 055"},
	{INTERFACEKEY_STRING_A056, "String: Character 056"},
	{INTERFACEKEY_STRING_A057, "String: Character 057"},
	{INTERFACEKEY_STRING_A058, "String: Character 058"},
	{INTERFACEKEY_STRING_A059, "String: Character 059"},
	{INTERFACEKEY_STRING_A060, "String: Character 060"},
	{INTERFACEKEY_STRING_A061, "String: Character 061"},
	{INTERFACEKEY_STRING_A062, "String: Character 062"},
	{INTERFACEKEY_STRING_A063, "String: Character 063"},
	{INTERFACEKEY_STRING_A064, "String: Character 064"},
	{INTERFACEKEY_STRING_A065, "String: Character 065"},
	{INTERFACEKEY_STRING_A066, "String: Character 066"},
	{INTERFACEKEY_STRING_A067, "String: Character 067"},
	{INTERFACEKEY_STRING_A068, "String: Character 068"},
	{INTERFACEKEY_STRING_A069, "String: Character 069"},
	{INTERFACEKEY_STRING_A070, "String: Character 070"},
	{INTERFACEKEY_STRING_A071, "String: Character 071"},
	{INTERFACEKEY_STRING_A072, "String: Character 072"},
	{INTERFACEKEY_STRING_A073, "String: Character 073"},
	{INTERFACEKEY_STRING_A074, "String: Character 074"},
	{INTERFACEKEY_STRING_A075, "String: Character 075"},
	{INTERFACEKEY_STRING_A076, "String: Character 076"},
	{INTERFACEKEY_STRING_A077, "String: Character 077"},
	{INTERFACEKEY_STRING_A078, "String: Character 078"},
	{INTERFACEKEY_STRING_A079, "String: Character 079"},
	{INTERFACEKEY_STRING_A080, "String: Character 080"},
	{INTERFACEKEY_STRING_A081, "String: Character 081"},
	{INTERFACEKEY_STRING_A082, "String: Character 082"},
	{INTERFACEKEY_STRING_A083, "String: Character 083"},
	{INTERFACEKEY_STRING_A084, "String: Character 084"},
	{INTERFACEKEY_STRING_A085, "String: Character 085"},
	{INTERFACEKEY_STRING_A086, "String: Character 086"},
	{INTERFACEKEY_STRING_A087, "String: Character 087"},
	{INTERFACEKEY_STRING_A088, "String: Character 088"},
	{INTERFACEKEY_STRING_A089, "String: Character 089"},
	{INTERFACEKEY_STRING_A090, "String: Character 090"},
	{INTERFACEKEY_STRING_A091, "String: Character 091"},
	{INTERFACEKEY_STRING_A092, "String: Character 092"},
	{INTERFACEKEY_STRING_A093, "String: Character 093"},
	{INTERFACEKEY_STRING_A094, "String: Character 094"},
	{INTERFACEKEY_STRING_A095, "String: Character 095"},
	{INTERFACEKEY_STRING_A096, "String: Character 096"},
	{INTERFACEKEY_STRING_A097, "String: Character 097"},
	{INTERFACEKEY_STRING_A098, "String: Character 098"},
	{INTERFACEKEY_STRING_A099, "String: Character 099"},
	{INTERFACEKEY_STRING_A100, "String: Character 100"},
	{INTERFACEKEY_STRING_A101, "String: Character 101"},
	{INTERFACEKEY_STRING_A102, "String: Character 102"},
	{INTERFACEKEY_STRING_A103, "String: Character 103"},
	{INTERFACEKEY_STRING_A104, "String: Character 104"},
	{INTERFACEKEY_STRING_A105, "String: Character 105"},
	{INTERFACEKEY_STRING_A106, "String: Character 106"},
	{INTERFACEKEY_STRING_A107, "String: Character 107"},
	{INTERFACEKEY_STRING_A108, "String: Character 108"},
	{INTERFACEKEY_STRING_A109, "String: Character 109"},
	{INTERFACEKEY_STRING_A110, "String: Character 110"},
	{INTERFACEKEY_STRING_A111, "String: Character 111"},
	{INTERFACEKEY_STRING_A112, "String: Character 112"},
	{INTERFACEKEY_STRING_A113, "String: Character 113"},
	{INTERFACEKEY_STRING_A114, "String: Character 114"},
	{INTERFACEKEY_STRING_A115, "String: Character 115"},
	{INTERFACEKEY_STRING_A116, "String: Character 116"},
	{INTERFACEKEY_STRING_A117, "String: Character 117"},
	{INTERFACEKEY_STRING_A118, "String: Character 118"},
	{INTERFACEKEY_STRING_A119, "String: Character 119"},
	{INTERFACEKEY_STRING_A120, "String: Character 120"},
	{INTERFACEKEY_STRING_A121, "String: Character 121"},
	{INTERFACEKEY_STRING_A122, "String: Character 122"},
	{INTERFACEKEY_STRING_A123, "String: Character 123"},
	{INTERFACEKEY_STRING_A124, "String: Character 124"},
	{INTERFACEKEY_STRING_A125, "String: Character 125"},
	{INTERFACEKEY_STRING_A126, "String: Character 126"},
	{INTERFACEKEY_STRING_A128, "String: Character 128"},
	{INTERFACEKEY_STRING_A129, "String: Character 129"},
	{INTERFACEKEY_STRING_A130, "String: Character 130"},
	{INTERFACEKEY_STRING_A131, "String: Character 131"},
	{INTERFACEKEY_STRING_A132, "String: Character 132"},
	{INTERFACEKEY_STRING_A133, "String: Character 133"},
	{INTERFACEKEY_STRING_A134, "String: Character 134"},
	{INTERFACEKEY_STRING_A135, "String: Character 135"},
	{INTERFACEKEY_STRING_A136, "String: Character 136"},
	{INTERFACEKEY_STRING_A137, "String: Character 137"},
	{INTERFACEKEY_STRING_A138, "String: Character 138"},
	{INTERFACEKEY_STRING_A139, "String: Character 139"},
	{INTERFACEKEY_STRING_A140, "String: Character 140"},
	{INTERFACEKEY_STRING_A141, "String: Character 141"},
	{INTERFACEKEY_STRING_A142, "String: Character 142"},
	{INTERFACEKEY_STRING_A143, "String: Character 143"},
	{INTERFACEKEY_STRING_A144, "String: Character 144"},
	{INTERFACEKEY_STRING_A145, "String: Character 145"},
	{INTERFACEKEY_STRING_A146, "String: Character 146"},
	{INTERFACEKEY_STRING_A147, "String: Character 147"},
	{INTERFACEKEY_STRING_A148, "String: Character 148"},
	{INTERFACEKEY_STRING_A149, "String: Character 149"},
	{INTERFACEKEY_STRING_A150, "String: Character 150"},
	{INTERFACEKEY_STRING_A151, "String: Character 151"},
	{INTERFACEKEY_STRING_A152, "String: Character 152"},
	{INTERFACEKEY_STRING_A153, "String: Character 153"},
	{INTERFACEKEY_STRING_A154, "String: Character 154"},
	{INTERFACEKEY_STRING_A155, "String: Character 155"},
	{INTERFACEKEY_STRING_A156, "String: Character 156"},
	{INTERFACEKEY_STRING_A157, "String: Character 157"},
	{INTERFACEKEY_STRING_A158, "String: Character 158"},
	{INTERFACEKEY_STRING_A159, "String: Character 159"},
	{INTERFACEKEY_STRING_A160, "String: Character 160"},
	{INTERFACEKEY_STRING_A161, "String: Character 161"},
	{INTERFACEKEY_STRING_A162, "String: Character 162"},
	{INTERFACEKEY_STRING_A163, "String: Character 163"},
	{INTERFACEKEY_STRING_A164, "String: Character 164"},
	{INTERFACEKEY_STRING_A165, "String: Character 165"},
	{INTERFACEKEY_STRING_A166, "String: Character 166"},
	{INTERFACEKEY_STRING_A167, "String: Character 167"},
	{INTERFACEKEY_STRING_A168, "String: Character 168"},
	{INTERFACEKEY_STRING_A169, "String: Character 169"},
	{INTERFACEKEY_STRING_A170, "String: Character 170"},
	{INTERFACEKEY_STRING_A171, "String: Character 171"},
	{INTERFACEKEY_STRING_A172, "String: Character 172"},
	{INTERFACEKEY_STRING_A173, "String: Character 173"},
	{INTERFACEKEY_STRING_A174, "String: Character 174"},
	{INTERFACEKEY_STRING_A175, "String: Character 175"},
	{INTERFACEKEY_STRING_A176, "String: Character 176"},
	{INTERFACEKEY_STRING_A177, "String: Character 177"},
	{INTERFACEKEY_STRING_A178, "String: Character 178"},
	{INTERFACEKEY_STRING_A179, "String: Character 179"},
	{INTERFACEKEY_STRING_A180, "String: Character 180"},
	{INTERFACEKEY_STRING_A181, "String: Character 181"},
	{INTERFACEKEY_STRING_A182, "String: Character 182"},
	{INTERFACEKEY_STRING_A183, "String: Character 183"},
	{INTERFACEKEY_STRING_A184, "String: Character 184"},
	{INTERFACEKEY_STRING_A185, "String: Character 185"},
	{INTERFACEKEY_STRING_A186, "String: Character 186"},
	{INTERFACEKEY_STRING_A187, "String: Character 187"},
	{INTERFACEKEY_STRING_A188, "String: Character 188"},
	{INTERFACEKEY_STRING_A189, "String: Character 189"},
	{INTERFACEKEY_STRING_A190, "String: Character 190"},
	{INTERFACEKEY_STRING_A191, "String: Character 191"},
	{INTERFACEKEY_STRING_A192, "String: Character 192"},
	{INTERFACEKEY_STRING_A193, "String: Character 193"},
	{INTERFACEKEY_STRING_A194, "String: Character 194"},
	{INTERFACEKEY_STRING_A195, "String: Character 195"},
	{INTERFACEKEY_STRING_A196, "String: Character 196"},
	{INTERFACEKEY_STRING_A197, "String: Character 197"},
	{INTERFACEKEY_STRING_A198, "String: Character 198"},
	{INTERFACEKEY_STRING_A199, "String: Character 199"},
	{INTERFACEKEY_STRING_A200, "String: Character 200"},
	{INTERFACEKEY_STRING_A201, "String: Character 201"},
	{INTERFACEKEY_STRING_A202, "String: Character 202"},
	{INTERFACEKEY_STRING_A203, "String: Character 203"},
	{INTERFACEKEY_STRING_A204, "String: Character 204"},
	{INTERFACEKEY_STRING_A205, "String: Character 205"},
	{INTERFACEKEY_STRING_A206, "String: Character 206"},
	{INTERFACEKEY_STRING_A207, "String: Character 207"},
	{INTERFACEKEY_STRING_A208, "String: Character 208"},
	{INTERFACEKEY_STRING_A209, "String: Character 209"},
	{INTERFACEKEY_STRING_A210, "String: Character 210"},
	{INTERFACEKEY_STRING_A211, "String: Character 211"},
	{INTERFACEKEY_STRING_A212, "String: Character 212"},
	{INTERFACEKEY_STRING_A213, "String: Character 213"},
	{INTERFACEKEY_STRING_A214, "String: Character 214"},
	{INTERFACEKEY_STRING_A215, "String: Character 215"},
	{INTERFACEKEY_STRING_A216, "String: Character 216"},
	{INTERFACEKEY_STRING_A217, "String: Character 217"},
	{INTERFACEKEY_STRING_A218, "String: Character 218"},
	{INTERFACEKEY_STRING_A219, "String: Character 219"},
	{INTERFACEKEY_STRING_A220, "String: Character 220"},
	{INTERFACEKEY_STRING_A221, "String: Character 221"},
	{INTERFACEKEY_STRING_A222, "String: Character 222"},
	{INTERFACEKEY_STRING_A223, "String: Character 223"},
	{INTERFACEKEY_STRING_A224, "String: Character 224"},
	{INTERFACEKEY_STRING_A225, "String: Character 225"},
	{INTERFACEKEY_STRING_A226, "String: Character 226"},
	{INTERFACEKEY_STRING_A227, "String: Character 227"},
	{INTERFACEKEY_STRING_A228, "String: Character 228"},
	{INTERFACEKEY_STRING_A229, "String: Character 229"},
	{INTERFACEKEY_STRING_A230, "String: Character 230"},
	{INTERFACEKEY_STRING_A231, "String: Character 231"},
	{INTERFACEKEY_STRING_A232, "String: Character 232"},
	{INTERFACEKEY_STRING_A233, "String: Character 233"},
	{INTERFACEKEY_STRING_A234, "String: Character 234"},
	{INTERFACEKEY_STRING_A235, "String: Character 235"},
	{INTERFACEKEY_STRING_A236, "String: Character 236"},
	{INTERFACEKEY_STRING_A237, "String: Character 237"},
	{INTERFACEKEY_STRING_A238, "String: Character 238"},
	{INTERFACEKEY_STRING_A239, "String: Character 239"},
	{INTERFACEKEY_STRING_A240, "String: Character 240"},
	{INTERFACEKEY_STRING_A241, "String: Character 241"},
	{INTERFACEKEY_STRING_A242, "String: Character 242"},
	{INTERFACEKEY_STRING_A243, "String: Character 243"},
	{INTERFACEKEY_STRING_A244, "String: Character 244"},
	{INTERFACEKEY_STRING_A245, "String: Character 245"},
	{INTERFACEKEY_STRING_A246, "String: Character 246"},
	{INTERFACEKEY_STRING_A247, "String: Character 247"},
	{INTERFACEKEY_STRING_A248, "String: Character 248"},
	{INTERFACEKEY_STRING_A249, "String: Character 249"},
	{INTERFACEKEY_STRING_A250, "String: Character 250"},
	{INTERFACEKEY_STRING_A251, "String: Character 251"},
	{INTERFACEKEY_STRING_A252, "String: Character 252"},
	{INTERFACEKEY_STRING_A253, "String: Character 253"},
	{INTERFACEKEY_STRING_A254, "String: Character 254"},
	{INTERFACEKEY_STRING_A255, "String: Character 255"},
	{INTERFACEKEY_CUSTOM_A, "Custom: A"},
	{INTERFACEKEY_CUSTOM_B, "Custom: B"},
	{INTERFACEKEY_CUSTOM_C, "Custom: C"},
	{INTERFACEKEY_CUSTOM_D, "Custom: D"},
	{INTERFACEKEY_CUSTOM_E, "Custom: E"},
	{INTERFACEKEY_CUSTOM_F, "Custom: F"},
	{INTERFACEKEY_CUSTOM_G, "Custom: G"},
	{INTERFACEKEY_CUSTOM_H, "Custom: H"},
	{INTERFACEKEY_CUSTOM_I, "Custom: I"},
	{INTERFACEKEY_CUSTOM_J, "Custom: J"},
	{INTERFACEKEY_CUSTOM_K, "Custom: K"},
	{INTERFACEKEY_CUSTOM_L, "Custom: L"},
	{INTERFACEKEY_CUSTOM_M, "Custom: M"},
	{INTERFACEKEY_CUSTOM_N, "Custom: N"},
	{INTERFACEKEY_CUSTOM_O, "Custom: O"},
	{INTERFACEKEY_CUSTOM_P, "Custom: P"},
	{INTERFACEKEY_CUSTOM_Q, "Custom: Q"},
	{INTERFACEKEY_CUSTOM_R, "Custom: R"},
	{INTERFACEKEY_CUSTOM_S, "Custom: S"},
	{INTERFACEKEY_CUSTOM_T, "Custom: T"},
	{INTERFACEKEY_CUSTOM_U, "Custom: U"},
	{INTERFACEKEY_CUSTOM_V, "Custom: V"},
	{INTERFACEKEY_CUSTOM_W, "Custom: W"},
	{INTERFACEKEY_CUSTOM_X, "Custom: X"},
	{INTERFACEKEY_CUSTOM_Y, "Custom: Y"},
	{INTERFACEKEY_CUSTOM_Z, "Custom: Z"},
	{INTERFACEKEY_CUSTOM_SHIFT_A, "Custom: Shift + A"},
	{INTERFACEKEY_CUSTOM_SHIFT_B, "Custom: Shift + B"},
	{INTERFACEKEY_CUSTOM_SHIFT_C, "Custom: Shift + C"},
	{INTERFACEKEY_CUSTOM_SHIFT_D, "Custom: Shift + D"},
	{INTERFACEKEY_CUSTOM_SHIFT_E, "Custom: Shift + E"},
	{INTERFACEKEY_CUSTOM_SHIFT_F, "Custom: Shift + F"},
	{INTERFACEKEY_CUSTOM_SHIFT_G, "Custom: Shift + G"},
	{INTERFACEKEY_CUSTOM_SHIFT_H, "Custom: Shift + H"},
	{INTERFACEKEY_CUSTOM_SHIFT_I, "Custom: Shift + I"},
	{INTERFACEKEY_CUSTOM_SHIFT_J, "Custom: Shift + J"},
	{INTERFACEKEY_CUSTOM_SHIFT_K, "Custom: Shift + K"},
	{INTERFACEKEY_CUSTOM_SHIFT_L, "Custom: Shift + L"},
	{INTERFACEKEY_CUSTOM_SHIFT_M, "Custom: Shift + M"},
	{INTERFACEKEY_CUSTOM_SHIFT_N, "Custom: Shift + N"},
	{INTERFACEKEY_CUSTOM_SHIFT_O, "Custom: Shift + O"},
	{INTERFACEKEY_CUSTOM_SHIFT_P, "Custom: Shift + P"},
	{INTERFACEKEY_CUSTOM_SHIFT_Q, "Custom: Shift + Q"},
	{INTERFACEKEY_CUSTOM_SHIFT_R, "Custom: Shift + R"},
	{INTERFACEKEY_CUSTOM_SHIFT_S, "Custom: Shift + S"},
	{INTERFACEKEY_CUSTOM_SHIFT_T, "Custom: Shift + T"},
	{INTERFACEKEY_CUSTOM_SHIFT_U, "Custom: Shift + U"},
	{INTERFACEKEY_CUSTOM_SHIFT_V, "Custom: Shift + V"},
	{INTERFACEKEY_CUSTOM_SHIFT_W, "Custom: Shift + W"},
	{INTERFACEKEY_CUSTOM_SHIFT_X, "Custom: Shift + X"},
	{INTERFACEKEY_CUSTOM_SHIFT_Y, "Custom: Shift + Y"},
	{INTERFACEKEY_CUSTOM_SHIFT_Z, "Custom: Shift + Z"},
	{INTERFACEKEY_CUSTOM_CTRL_A, "Custom: Ctrl + A"},
	{INTERFACEKEY_CUSTOM_CTRL_B, "Custom: Ctrl + B"},
	{INTERFACEKEY_CUSTOM_CTRL_C, "Custom: Ctrl + C"},
	{INTERFACEKEY_CUSTOM_CTRL_D, "Custom: Ctrl + D"},
	{INTERFACEKEY_CUSTOM_CTRL_E, "Custom: Ctrl + E"},
	{INTERFACEKEY_CUSTOM_CTRL_F, "Custom: Ctrl + F"},
	{INTERFACEKEY_CUSTOM_CTRL_G, "Custom: Ctrl + G"},
	{INTERFACEKEY_CUSTOM_CTRL_H, "Custom: Ctrl + H"},
	{INTERFACEKEY_CUSTOM_CTRL_I, "Custom: Ctrl + I"},
	{INTERFACEKEY_CUSTOM_CTRL_J, "Custom: Ctrl + J"},
	{INTERFACEKEY_CUSTOM_CTRL_K, "Custom: Ctrl + K"},
	{INTERFACEKEY_CUSTOM_CTRL_L, "Custom: Ctrl + L"},
	{INTERFACEKEY_CUSTOM_CTRL_M, "Custom: Ctrl + M"},
	{INTERFACEKEY_CUSTOM_CTRL_N, "Custom: Ctrl + N"},
	{INTERFACEKEY_CUSTOM_CTRL_O, "Custom: Ctrl + O"},
	{INTERFACEKEY_CUSTOM_CTRL_P, "Custom: Ctrl + P"},
	{INTERFACEKEY_CUSTOM_CTRL_Q, "Custom: Ctrl + Q"},
	{INTERFACEKEY_CUSTOM_CTRL_R, "Custom: Ctrl + R"},
	{INTERFACEKEY_CUSTOM_CTRL_S, "Custom: Ctrl + S"},
	{INTERFACEKEY_CUSTOM_CTRL_T, "Custom: Ctrl + T"},
	{INTERFACEKEY_CUSTOM_CTRL_U, "Custom: Ctrl + U"},
	{INTERFACEKEY_CUSTOM_CTRL_V, "Custom: Ctrl + V"},
	{INTERFACEKEY_CUSTOM_CTRL_W, "Custom: Ctrl + W"},
	{INTERFACEKEY_CUSTOM_CTRL_X, "Custom: Ctrl + X"},
	{INTERFACEKEY_CUSTOM_CTRL_Y, "Custom: Ctrl + Y"},
	{INTERFACEKEY_CUSTOM_CTRL_Z, "Custom: Ctrl + Z"},
	{INTERFACEKEY_CUSTOM_ALT_A, "Custom: Alt + A"},
	{INTERFACEKEY_CUSTOM_ALT_B, "Custom: Alt + B"},
	{INTERFACEKEY_CUSTOM_ALT_C, "Custom: Alt + C"},
	{INTERFACEKEY_CUSTOM_ALT_D, "Custom: Alt + D"},
	{INTERFACEKEY_CUSTOM_ALT_E, "Custom: Alt + E"},
	{INTERFACEKEY_CUSTOM_ALT_F, "Custom: Alt + F"},
	{INTERFACEKEY_CUSTOM_ALT_G, "Custom: Alt + G"},
	{INTERFACEKEY_CUSTOM_ALT_H, "Custom: Alt + H"},
	{INTERFACEKEY_CUSTOM_ALT_I, "Custom: Alt + I"},
	{INTERFACEKEY_CUSTOM_ALT_J, "Custom: Alt + J"},
	{INTERFACEKEY_CUSTOM_ALT_K, "Custom: Alt + K"},
	{INTERFACEKEY_CUSTOM_ALT_L, "Custom: Alt + L"},
	{INTERFACEKEY_CUSTOM_ALT_M, "Custom: Alt + M"},
	{INTERFACEKEY_CUSTOM_ALT_N, "Custom: Alt + N"},
	{INTERFACEKEY_CUSTOM_ALT_O, "Custom: Alt + O"},
	{INTERFACEKEY_CUSTOM_ALT_P, "Custom: Alt + P"},
	{INTERFACEKEY_CUSTOM_ALT_Q, "Custom: Alt + Q"},
	{INTERFACEKEY_CUSTOM_ALT_R, "Custom: Alt + R"},
	{INTERFACEKEY_CUSTOM_ALT_S, "Custom: Alt + S"},
	{INTERFACEKEY_CUSTOM_ALT_T, "Custom: Alt + T"},
	{INTERFACEKEY_CUSTOM_ALT_U, "Custom: Alt + U"},
	{INTERFACEKEY_CUSTOM_ALT_V, "Custom: Alt + V"},
	{INTERFACEKEY_CUSTOM_ALT_W, "Custom: Alt + W"},
	{INTERFACEKEY_CUSTOM_ALT_X, "Custom: Alt + X"},
	{INTERFACEKEY_CUSTOM_ALT_Y, "Custom: Alt + Y"},
	{INTERFACEKEY_CUSTOM_ALT_Z, "Custom: Alt + Z"},
	{INTERFACEKEY_FPS_UP, "Increase FPS limit"},
	{INTERFACEKEY_FPS_DOWN, "Decrease FPS limit"},
	//{INTERFACEKEY_TOGGLE_TTF, "Toggle Truetype rendering"},
	{INTERFACEKEY_PREFIX, "Command repeat prefix-key"},
	{INTERFACEKEY_CUSTOM_UP, "Custom: Up"},
	{INTERFACEKEY_CUSTOM_DOWN, "Custom: Down"},
	{INTERFACEKEY_CUSTOM_LEFT, "Custom: Left"},
	{INTERFACEKEY_CUSTOM_RIGHT, "Custom: Right"},
	{INTERFACEKEY_CUSTOM_TAB, "Custom: Tab"},
	{INTERFACEKEY_CUSTOM_HOME, "Custom: Home"},
	{INTERFACEKEY_CUSTOM_END, "Custom: End"},
	{INTERFACEKEY_CUSTOM_PGUP, "Custom: PgUp"},
	{INTERFACEKEY_CUSTOM_PGDN, "Custom: PgDn"},
	{INTERFACEKEY_CUSTOM_INSERT, "Custom: Insert"},
	{INTERFACEKEY_CUSTOM_DELETE, "Custom: Delete"},
	{INTERFACEKEY_CUSTOM_SHIFT_ENTER, "Custom: Shift + Enter"},
	{INTERFACEKEY_CUSTOM_SHIFT_BACKSPACE, "Custom: Shift + Backspace"},
	{INTERFACEKEY_CUSTOM_SHIFT_UP, "Custom: Shift + Up"},
	{INTERFACEKEY_CUSTOM_SHIFT_DOWN, "Custom: Shift + Down"},
	{INTERFACEKEY_CUSTOM_SHIFT_LEFT, "Custom: Shift + Left"},
	{INTERFACEKEY_CUSTOM_SHIFT_RIGHT, "Custom: Shift + Right"},
	{INTERFACEKEY_CUSTOM_SHIFT_TAB, "Custom: Shift + Tab"},
	{INTERFACEKEY_CUSTOM_SHIFT_HOME, "Custom: Shift + Home"},
	{INTERFACEKEY_CUSTOM_SHIFT_END, "Custom: Shift + End"},
	{INTERFACEKEY_CUSTOM_SHIFT_PGUP, "Custom: Shift + PgUp"},
	{INTERFACEKEY_CUSTOM_SHIFT_PGDN, "Custom: Shift + PgDn"},
	{INTERFACEKEY_CUSTOM_SHIFT_INSERT, "Custom: Shift + Insert"},
	{INTERFACEKEY_CUSTOM_SHIFT_DELETE, "Custom: Shift + Delete"},
	{INTERFACEKEY_CUSTOM_CTRL_ENTER, "Custom: Ctrl + Enter"},
	{INTERFACEKEY_CUSTOM_CTRL_BACKSPACE, "Custom: Ctrl + Backspace"},
	{INTERFACEKEY_CUSTOM_CTRL_UP, "Custom: Ctrl + Up"},
	{INTERFACEKEY_CUSTOM_CTRL_DOWN, "Custom: Ctrl + Down"},
	{INTERFACEKEY_CUSTOM_CTRL_LEFT, "Custom: Ctrl + Left"},
	{INTERFACEKEY_CUSTOM_CTRL_RIGHT, "Custom: Ctrl + Right"},
	{INTERFACEKEY_CUSTOM_CTRL_TAB, "Custom: Ctrl + Tab"},
	{INTERFACEKEY_CUSTOM_CTRL_HOME, "Custom: Ctrl + Home"},
	{INTERFACEKEY_CUSTOM_CTRL_END, "Custom: Ctrl + End"},
	{INTERFACEKEY_CUSTOM_CTRL_PGUP, "Custom: Ctrl + PgUp"},
	{INTERFACEKEY_CUSTOM_CTRL_PGDN, "Custom: Ctrl + PgDn"},
	{INTERFACEKEY_CUSTOM_CTRL_INSERT, "Custom: Ctrl + Insert"},
	{INTERFACEKEY_CUSTOM_CTRL_DELETE, "Custom: Ctrl + Delete"},
	{INTERFACEKEY_CUSTOM_CTRL_SLASH, "Custom: Ctrl + /"},
	{INTERFACEKEY_CUSTOM_CTRL_0, "Custom: Ctrl + 0"},
	{INTERFACEKEY_CUSTOM_CTRL_1, "Custom: Ctrl + 1"},
	{INTERFACEKEY_CUSTOM_CTRL_2, "Custom: Ctrl + 2"},
	{INTERFACEKEY_CUSTOM_CTRL_3, "Custom: Ctrl + 3"},
	{INTERFACEKEY_CUSTOM_CTRL_4, "Custom: Ctrl + 4"},
	{INTERFACEKEY_CUSTOM_CTRL_5, "Custom: Ctrl + 5"},
	{INTERFACEKEY_CUSTOM_CTRL_6, "Custom: Ctrl + 6"},
	{INTERFACEKEY_CUSTOM_CTRL_7, "Custom: Ctrl + 7"},
	{INTERFACEKEY_CUSTOM_CTRL_8, "Custom: Ctrl + 8"},
	{INTERFACEKEY_CUSTOM_CTRL_9, "Custom: Ctrl + 9"},
	{INTERFACEKEY_CUSTOM_CTRL_SHIFT_UP, "Custom: Ctrl + Shift + Up"},
	{INTERFACEKEY_CUSTOM_CTRL_SHIFT_DOWN, "Custom: Ctrl + Shift + Down"},
	{INTERFACEKEY_CUSTOM_CTRL_SHIFT_LEFT, "Custom: Ctrl + Shift + Left"},
	{INTERFACEKEY_CUSTOM_CTRL_SHIFT_RIGHT, "Custom: Ctrl + Shift + Right"},
	{INTERFACEKEY_CUSTOM_ALT_0, "Custom: Alt + 0"},
	{INTERFACEKEY_CUSTOM_ALT_1, "Custom: Alt + 1"},
	{INTERFACEKEY_CUSTOM_ALT_2, "Custom: Alt + 2"},
	{INTERFACEKEY_CUSTOM_ALT_3, "Custom: Alt + 3"},
	{INTERFACEKEY_CUSTOM_ALT_4, "Custom: Alt + 4"},
	{INTERFACEKEY_CUSTOM_ALT_5, "Custom: Alt + 5"},
	{INTERFACEKEY_CUSTOM_ALT_6, "Custom: Alt + 6"},
	{INTERFACEKEY_CUSTOM_ALT_7, "Custom: Alt + 7"},
	{INTERFACEKEY_CUSTOM_ALT_8, "Custom: Alt + 8"},
	{INTERFACEKEY_CUSTOM_ALT_9, "Custom: Alt + 9"},
		};
	// SDLNAMES
		sdlNames = bimap<SDL_Keycode, std::string>{
	  {SDLK_BACKSPACE, "Backspace"},
	  {SDLK_TAB, "Tab"},
	  {SDLK_CLEAR, "Clear"},
	  {SDLK_RETURN, "Enter"},
	  {SDLK_PAUSE, "Pause"},
	  {SDLK_ESCAPE, "ESC"},
	  {SDLK_SPACE, "Space"},
	  {SDLK_EXCLAIM, "Exclaim"},
	  {SDLK_QUOTEDBL, "Quotedbl"},
	  {SDLK_HASH, "Hash"},
	  {SDLK_DOLLAR, "Dollar"},
	  {SDLK_AMPERSAND, "Ampersand"},
	  {SDLK_QUOTE, "Quote"},
	  {SDLK_LEFTPAREN, "Leftparen"},
	  {SDLK_RIGHTPAREN, "Rightparen"},
	  {SDLK_ASTERISK, "Asterisk"},
	  {SDLK_PLUS, "Plus"},
	  {SDLK_COMMA, "Comma"},
	  {SDLK_MINUS, "Minus"},
	  {SDLK_PERIOD, "Period"},
	  {SDLK_SLASH, "Slash"},
	  {SDLK_0, "0"},
	  {SDLK_1, "1"},
	  {SDLK_2, "2"},
	  {SDLK_3, "3"},
	  {SDLK_4, "4"},
	  {SDLK_5, "5"},
	  {SDLK_6, "6"},
	  {SDLK_7, "7"},
	  {SDLK_8, "8"},
	  {SDLK_9, "9"},
	  {SDLK_COLON, "Colon"},
	  {SDLK_SEMICOLON, "Semicolon"},
	  {SDLK_LESS, "Less"},
	  {SDLK_EQUALS, "Equals"},
	  {SDLK_GREATER, "Greater"},
	  {SDLK_QUESTION, "Question"},
	  {SDLK_AT, "At"},
	  {SDLK_LEFTBRACKET, "Leftbracket"},
	  {SDLK_BACKSLASH, "Backslash"},
	  {SDLK_RIGHTBRACKET, "Rightbracket"},
	  {SDLK_CARET, "Caret"},
	  {SDLK_UNDERSCORE, "Underscore"},
	  {SDLK_BACKQUOTE, "Backquote"},
	  {SDLK_a, "a"},
	  {SDLK_b, "b"},
	  {SDLK_c, "c"},
	  {SDLK_d, "d"},
	  {SDLK_e, "e"},
	  {SDLK_f, "f"},
	  {SDLK_g, "g"},
	  {SDLK_h, "h"},
	  {SDLK_i, "i"},
	  {SDLK_j, "j"},
	  {SDLK_k, "k"},
	  {SDLK_l, "l"},
	  {SDLK_m, "m"},
	  {SDLK_n, "n"},
	  {SDLK_o, "o"},
	  {SDLK_p, "p"},
	  {SDLK_q, "q"},
	  {SDLK_r, "r"},
	  {SDLK_s, "s"},
	  {SDLK_t, "t"},
	  {SDLK_u, "u"},
	  {SDLK_v, "v"},
	  {SDLK_w, "w"},
	  {SDLK_x, "x"},
	  {SDLK_y, "y"},
	  {SDLK_z, "z"},
	  {SDLK_DELETE, "Delete"},
	  {SDLK_KP_0, "Numpad 0"},
	  {SDLK_KP_1, "Numpad 1"},
	  {SDLK_KP_2, "Numpad 2"},
	  {SDLK_KP_3, "Numpad 3"},
	  {SDLK_KP_4, "Numpad 4"},
	  {SDLK_KP_5, "Numpad 5"},
	  {SDLK_KP_6, "Numpad 6"},
	  {SDLK_KP_7, "Numpad 7"},
	  {SDLK_KP_8, "Numpad 8"},
	  {SDLK_KP_9, "Numpad 9"},
	  {SDLK_KP_PERIOD, "Numpad Period"},
	  {SDLK_KP_DIVIDE, "Numpad Divide"},
	  {SDLK_KP_MULTIPLY, "Numpad Multiply"},
	  {SDLK_KP_PLUS, "Numpad Plus"},
	  {SDLK_KP_MINUS, "Numpad Minus"},
	  {SDLK_KP_ENTER, "Numpad Enter"},
	  {SDLK_KP_EQUALS, "Numpad Equals"},
	  {SDLK_UP, "Up"},
	  {SDLK_DOWN, "Down"},
	  {SDLK_RIGHT, "Right"},
	  {SDLK_LEFT, "Left"},
	  {SDLK_INSERT, "Insert"},
	  {SDLK_HOME, "Home"},
	  {SDLK_END, "End"},
	  {SDLK_PAGEUP, "Page Up"},
	  {SDLK_PAGEDOWN, "Page Down"},
	  {SDLK_F1, "F1"},
	  {SDLK_F2, "F2"},
	  {SDLK_F3, "F3"},
	  {SDLK_F4, "F4"},
	  {SDLK_F5, "F5"},
	  {SDLK_F6, "F6"},
	  {SDLK_F7, "F7"},
	  {SDLK_F8, "F8"},
	  {SDLK_F9, "F9"},
	  {SDLK_F10, "F10"},
	  {SDLK_F11, "F11"},
	  {SDLK_F12, "F12"},
	  {SDLK_F13, "F13"},
	  {SDLK_F14, "F14"},
	  {SDLK_F15, "F15"},
	  {SDLK_NUMLOCKCLEAR, "Numlock"},
	  {SDLK_CAPSLOCK, "Capslock"},
	  {SDLK_SCROLLLOCK, "Scrollock"},
	  {SDLK_RSHIFT, "Rshift"},
	  {SDLK_LSHIFT, "Lshift"},
	  {SDLK_RCTRL, "Rctrl"},
	  {SDLK_LCTRL, "Lctrl"},
	  {SDLK_RALT, "Ralt"},
	  {SDLK_LALT, "Lalt"},
	  {SDLK_RGUI, "Rgui"},
	  {SDLK_LGUI, "Lgui"},
	  {SDLK_MODE, "Mode"},
	  {SDLK_HELP, "Help"},
	  {SDLK_PRINTSCREEN, "Print"},
	  {SDLK_SYSREQ, "Sysreq"},
	  {SDLK_MENU, "Menu"},
	  {SDLK_POWER, "Power"},
	  {SDLK_UNDO, "Undo"},
		};
		sdlUnicode = bimap<SDL_Keycode, int>{
	  {SDLK_UNKNOWN, '\0'},
	  {SDLK_BACKSPACE, '\b'},
	  {SDLK_TAB, '\t'},
	  {SDLK_RETURN, '\r'},
	  {SDLK_ESCAPE, '\033'},
	  {SDLK_SPACE, ' '},
	  {SDLK_EXCLAIM, '!'},
	  {SDLK_QUOTEDBL, '"'},
	  {SDLK_HASH, '#'},
	  {SDLK_DOLLAR, '$'},
	  {SDLK_PERCENT, '%'},
	  {SDLK_AMPERSAND, '&'},
	  {SDLK_QUOTE, '\''},
	  {SDLK_LEFTPAREN, '('},
	  {SDLK_RIGHTPAREN, ')'},
	  {SDLK_ASTERISK, '*'},
	  {SDLK_PLUS, '+'},
	  {SDLK_COMMA, ','},
	  {SDLK_MINUS, '-'},
	  {SDLK_PERIOD, '.'},
	  {SDLK_SLASH, '/'},
	  {SDLK_0, '0'},
	  {SDLK_1, '1'},
	  {SDLK_2, '2'},
	  {SDLK_3, '3'},
	  {SDLK_4, '4'},
	  {SDLK_5, '5'},
	  {SDLK_6, '6'},
	  {SDLK_7, '7'},
	  {SDLK_8, '8'},
	  {SDLK_9, '9'},
	  {SDLK_COLON, ':'},
	  {SDLK_SEMICOLON, ';'},
	  {SDLK_LESS, '<'},
	  {SDLK_EQUALS, '='},
	  {SDLK_GREATER, '>'},
	  {SDLK_QUESTION, '?'},
	  {SDLK_AT, '@'},
	  {SDLK_LEFTBRACKET, '['},
	  {SDLK_BACKSLASH, '\\'},
	  {SDLK_RIGHTBRACKET, ']'},
	  {SDLK_CARET, '^'},
	  {SDLK_UNDERSCORE, '_'},
	  {SDLK_BACKQUOTE, '`'},
	  {SDLK_a, 'a'},
	  {SDLK_b, 'b'},
	  {SDLK_c, 'c'},
	  {SDLK_d, 'd'},
	  {SDLK_e, 'e'},
	  {SDLK_f, 'f'},
	  {SDLK_g, 'g'},
	  {SDLK_h, 'h'},
	  {SDLK_i, 'i'},
	  {SDLK_j, 'j'},
	  {SDLK_k, 'k'},
	  {SDLK_l, 'l'},
	  {SDLK_m, 'm'},
	  {SDLK_n, 'n'},
	  {SDLK_o, 'o'},
	  {SDLK_p, 'p'},
	  {SDLK_q, 'q'},
	  {SDLK_r, 'r'},
	  {SDLK_s, 's'},
	  {SDLK_t, 't'},
	  {SDLK_u, 'u'},
	  {SDLK_v, 'v'},
	  {SDLK_w, 'w'},
	  {SDLK_x, 'x'},
	  {SDLK_y, 'y'},
	  {SDLK_z, 'z'},
		};
  unicodeCapitals = { 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z' };
}
