define(["exports","./../globalize.js","./../../emby-apiclient/connectionmanager.js","./../../loading/loading.js","./../dataformatter.js","./../servicelocator.js","./../playback/playbackmanager.js","./../../layoutmanager.js","./../../emby-apiclient/apiclient.js","./../datetime.js","./../usersettings/usersettings.js","./../textencoding.js","./../../approuter.js"],function(_exports,_globalize,_connectionmanager,_loading,_dataformatter,_servicelocator,_playbackmanager,_layoutmanager,_apiclient,_datetime,_usersettings,_textencoding,_approuter){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;function showToast(options){return Emby.importModule("./modules/toast/toast.js").then(function(toast){return toast(options)})}function showDialog(options){return Emby.importModule("./modules/dialog/dialog.js").then(function(dialog){return dialog(options)})}function showConfirm(options){return Emby.importModule("./modules/common/dialogs/confirm.js").then(function(confirm){return confirm(options)})}function showAlertAndReject(options,response){function onDone(){return Promise.reject(response)}return function(options){return Emby.importModule("./modules/common/dialogs/alert.js").then(function(alert){return alert(options)})}(options).then(onDone,onDone)}function rejectNoSupportedCommands(){return Promise.reject("nocommands")}function rejectNoItems(){return Promise.reject("noitems")}function BaseItemController(){}function canEditInternal(item,user,checkAdmin){if(!item.Id)return!1;if(!1!==checkAdmin&&(null==user||!user.Policy.IsAdministrator))return!1;switch(item.Type){case"UserRootFolder":case"CollectionFolder":case"UserView":case"PlaylistsFolder":case"ApiKey":case"Program":case"Genre":case"MusicGenre":case"GameGenre":case"Studio":case"Tag":case"RemoteSubtitle":case"GenericListItem":case"Log":case"Timer":case"SeriesTimer":case"Plugin":case"Server":case"ItemImage":case"Recording":case"ActivityLogEntry":case"ActiveSession":case"Chapter":return!1;case"ChannelManagementInfo":return item.ManagementId&&item.ManagementId!==item.Id;default:return!_apiclient.default.isLocalItem(item)}}function mapToPlaylistItemId(item){return item.PlaylistItemId}BaseItemController.prototype.getTypeNames=function(){return[]},BaseItemController.prototype.getDisplayName=function(item,options){options=options||{};var number,nameSeparator,name,itemType=item.Type;switch(itemType){case"Timer":name=(item=item.ProgramInfo||item).IsSeries||item.EpisodeTitle?item.EpisodeTitle||"":item.Name||item.DisplayTitle||"";break;case"Program":case"Recording":name=item.IsSeries||item.EpisodeTitle?item.EpisodeTitle||"":item.Name||item.DisplayTitle||"";break;case"ApiKey":name=item.AppName;break;case"TvChannel":case"ChannelManagementInfo":return name=item.Name,item.ChannelNumber&&!1!==options.includeIndexNumber?options.channelNumberFirst?item.ChannelNumber+" "+name:(name.endsWith(item.ChannelNumber)||(name+=" "+item.ChannelNumber),name):name;default:name=item.Name||item.DisplayTitle||""}return!1!==options.enableSpecialEpisodePrefix&&0===item.ParentIndexNumber&&"Episode"===itemType?name=_globalize.default.translate("ValueSpecialEpisodeName",name):null==item.IndexNumber||!1===options.includeIndexNumber||"Episode"!==itemType&&"Program"!==itemType&&"Recording"!==itemType?null!=item.IndexNumber&&!1!==options.includeIndexNumber&&item.SupportsResume&&"Audio"===itemType&&(nameSeparator=" - ",number=item.IndexNumber)&&(name=name?number+nameSeparator+name:number):(number=item.IndexNumber,!(nameSeparator=" - ")!==options.includeParentInfo&&null!=item.ParentIndexNumber?number="S"+item.ParentIndexNumber+":E"+number:nameSeparator=". ",null!=item.IndexNumberEnd&&(number+="-"+item.IndexNumberEnd),(number="Program"!==item.Type&&"Recording"!==item.Type||item.EpisodeTitle?number:null)&&(name=name?number+nameSeparator+name:number)),name},BaseItemController.prototype.canAddToCollection=function(item,user){var itemType=item.Type;return("Recording"!==itemType||"Completed"===item.Status)&&!(item.CollectionType||["ActiveSession","Genre","MusicGenre","Studio","GameGenre","Log","Tag","UserView","CollectionFolder","Audio","Program","Timer","SeriesTimer","BoxSet","ApiKey","TvChannel","RemoteSubtitle","Chapter"].includes(itemType)||_apiclient.default.isLocalItem(item)||"Device"===itemType||"User"===itemType||"Plugin"===itemType||"Server"===itemType||"ActivityLogEntry"===itemType||"ItemImage"===itemType||"LiveTVTunerDevice"===itemType||"LiveTVGuideSource"===itemType||"ChannelManagementInfo"===itemType||!item.Id)&&(!user||canEditInternal(item,user))},BaseItemController.prototype.removeFromPlayQueue=function(items,options){return _playbackmanager.default.removeFromPlaylist(items.map(mapToPlaylistItemId))},BaseItemController.prototype.canRemoveFromCollection=function(item,user){return item.CollectionId&&this.canAddToCollection(item,user)},BaseItemController.prototype.canAddToPlaylist=function(item){var mediaType,itemType=item.Type;return"Program"!==itemType&&"TvChannel"!==itemType&&"Timer"!==itemType&&"SeriesTimer"!==itemType&&"VirtualFolder"!==itemType&&"ActiveSession"!==itemType&&"Chapter"!==itemType&&("Recording"!==itemType||"Completed"===item.Status)&&"Photo"!==(mediaType=item.MediaType)&&"Game"!==mediaType&&"livetv"!==(mediaType=item.CollectionType)&&"playlists"!==mediaType&&!_apiclient.default.isLocalItem(item)&&(!(!item.IsFolder&&"Genre"!==itemType&&"MusicGenre"!==itemType&&"MusicAlbum"!==itemType&&"MusicArtist"!==itemType&&"Studio"!==itemType&&"Tag"!==itemType)||"Device"!==itemType&&"User"!==itemType&&"Plugin"!==itemType&&"Log"!==itemType&&"Server"!==itemType&&"ActivityLogEntry"!==itemType&&"ApiKey"!==itemType&&!!item.Id&&item.MediaType)},BaseItemController.prototype.canRemoveFromPlayQueue=function(item){return item.PlaylistItemId&&!item.PlaylistId},BaseItemController.prototype.canRemoveFromPlaylist=function(item){return item.PlaylistItemId&&item.PlaylistId},BaseItemController.prototype.canManageMultiVersionGrouping=function(item,user){return!item.IsFolder&&"Video"===item.MediaType&&!_apiclient.default.isLocalItem(item)&&!!user.Policy.IsAdministrator&&"TvChannel"!==item.Type},BaseItemController.prototype.canRate=function(item){if(!item.UserData)return!1;switch(item.Type){case"Program":case"Timer":case"SeriesTimer":case"CollectionFolder":case"UserView":case"Channel":case"Season":case"Studio":case"Folder":return!1;default:return!0}},BaseItemController.prototype.canMarkPlayed=function(item){if(item.SupportsResume)return!0;switch(item.Type){case"AudioBook":case"Series":case"Season":case"Recording":return!0;case"TvChannel":case"Program":case"Chapter":return!1;case"Folder":return!0;case"CollectionFolder":return"boxsets"===item.CollectionType||"playlists"===item.CollectionType||"music"===item.CollectionType?!1:!0}switch(item.MediaType){case"Game":case"Book":case"Video":return!0}return!1},BaseItemController.prototype.canConvert=function(item,user){if(!item.Id)return!1;switch(item.MediaType){case"Book":case"Photo":case"Game":case"Audio":return!1}switch(item.CollectionType){case"livetv":case"playlists":case"boxsets":return!1}switch(item.Type){case"Book":case"Photo":case"Game":case"Audio":case"TvChannel":case"Channel":case"Person":case"Year":case"Program":case"Timer":case"SeriesTimer":case"GameGenre":case"Device":case"User":case"Log":case"Plugin":case"VirtualFolder":case"ItemImage":case"Server":case"ActivityLogEntry":case"ApiKey":case"LiveTVTunerDevice":case"LiveTVGuideSource":case"ChannelManagementInfo":case"ActiveSession":case"RemoteSubtitle":case"Chapter":return!1}return!("Virtual"===item.LocationType&&!item.IsFolder||user&&!user.Policy.EnableMediaConversion||_apiclient.default.isLocalItem(item))},BaseItemController.prototype.getEditCommand=function(items){var text;switch(items[0].Type){case"":case"Folder":case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicGenre":case"MusicVideo":case"Playlist":case"Video":case"Game":case"Book":case"Genre":case"GameGenre":case"Person":case"GameSystem":case"Photo":case"PhotoAlbum":case"TvChannel":case"Studio":case"Channel":case"UserView":case"Tag":case"Device":text=_globalize.default.translate("HeaderEditMetadata");break;default:text=_globalize.default.translate("Edit")}return{name:text,id:"edit",icon:"edit"}},BaseItemController.prototype.editItems=function(items,options){if(!items.length)return rejectNoItems();switch(items[0].Type){case"Device":case"User":case"ActiveSession":case"SeriesTimer":case"Timer":case"LiveTVTunerDevice":case"LiveTVGuideSource":return rejectNoSupportedCommands();case"VirtualFolder":return function(item,options){var view=(options=options.positionTo).closest(".page"),refreshLibrary=!!options&&"true"===view.getAttribute("data-refreshlibrary");return Emby.importModule("./components/medialibraryeditor/medialibraryeditor.js").then(function(Medialibraryeditor){return(new Medialibraryeditor).show({refresh:refreshLibrary,library:item})})}(items[0],options);default:return function(items){return Emby.importModule("./modules/metadataeditor/metadataeditor.js").then(function(MetadataEditor){var MetadataEditor=new MetadataEditor,item=items[0],apiClient=_connectionmanager.default.getApiClient(item);return MetadataEditor.show(item.Id,apiClient.serverId())})}(items)}},BaseItemController.prototype.canEdit=function(items,user){return 1===items.length&&canEditInternal(items[0],user)},BaseItemController.prototype.canSync=function(item,user){return!(user&&!user.Policy.EnableContentDownloading||_apiclient.default.isLocalItem(item))&&item.SupportsSync},BaseItemController.prototype.canDownload=function(item){switch(item.Type){case"Log":case"RemoteSubtitle":return item.CanDownload;case"MediaStream":return item.IsExternal&&"Subtitle"===item.StreamType&&_servicelocator.appHost.supports("filedownload");default:return item.CanDownload&&_servicelocator.appHost.supports("filedownload")}},BaseItemController.prototype.canDownloadSubtitles=function(item,user){switch(item.Type){case"Movie":case"Episode":return this.canEditSubtitles(item,user);default:return!1}},BaseItemController.prototype.canIdentify=function(item,user){var itemType=item.Type;return!("Movie"!==itemType&&"Trailer"!==itemType&&"Series"!==itemType&&"Game"!==itemType&&"BoxSet"!==itemType&&"Person"!==itemType&&"Book"!==itemType&&"MusicAlbum"!==itemType&&"MusicArtist"!==itemType&&"MusicVideo"!==itemType||!user.Policy.IsAdministrator||_apiclient.default.isLocalItem(item))},BaseItemController.prototype.canShare=function(item,user){switch(item.Type){case"TvChannel":case"Channel":case"Person":case"Year":case"Program":case"Timer":case"SeriesTimer":case"GameGenre":case"MusicGenre":case"Genre":case"Device":case"User":case"Plugin":case"Server":case"ActivityLogEntry":case"ApiKey":case"Tag":case"VirtualFolder":case"ItemImage":case"LiveTVTunerDevice":case"LiveTVGuideSource":case"ChannelManagementInfo":case"ActiveSession":case"CollectionFolder":case"UserView":case"RemoteSubtitle":case"Chapter":case"Recording":return!1;case"Log":return item.CanShare;default:return user?!!item.Id&&!_apiclient.default.isLocalItem(item)&&user.Policy.EnablePublicSharing&&"Photo"===item.Type&&_servicelocator.appHost.supports("sharing"):!1}},BaseItemController.prototype.canEditImages=function(item,user){var itemType=item.Type;if("Photo"===item.MediaType)return!1;if(("CollectionFolder"===itemType||"UserView"===itemType||"PlaylistsFolder"===itemType||"Genre"===itemType||"MusicGenre"===itemType||"GameGenre"===itemType||"Studio"===itemType||"Tag"===itemType)&&!_apiclient.default.isLocalItem(item))return!!user.Policy.IsAdministrator;switch(itemType){case"Device":case"User":case"Plugin":case"LiveTVTunerDevice":case"LiveTVGuideSource":case"Recording":if("Completed"!==item.Status)return!1}return canEditInternal(item,user)},BaseItemController.prototype.canEditSubtitles=function(item,user){if(user&&function(item){var itemType=item.Type;return"Video"===item.MediaType&&"TvChannel"!==itemType&&"Trailer"!==itemType&&"Program"!==itemType&&"Virtual"!==item.LocationType&&("Recording"!==itemType||"Completed"===item.Status)||"Audio"===item.MediaType}(item)){if(user.Policy.EnableSubtitleDownloading||user.Policy.EnableSubtitleManagement)return canEditInternal(item,user,!1);if(null==user.Policy.EnableSubtitleDownloading&&null==user.Policy.EnableSubtitleManagement)return canEditInternal(item,user)}return!1},BaseItemController.prototype.canReorder=function(item,user){switch(item.Type){case"ChannelManagementInfo":return!0;case"ItemImage":return"Backdrop"===item.ImageType;default:return!1}},BaseItemController.prototype.canMoveUp=function(item,user){if(!this.canReorder(item,user))return!1;switch(item.Type){case"ChannelManagementInfo":return item.SortIndexNumber;case"ItemImage":return item.ImageIndex;default:return!1}},BaseItemController.prototype.canMoveDown=function(item,user){if(!this.canReorder(item,user))return!1;switch(item.Type){case"ChannelManagementInfo":return!0;case"ItemImage":return item.ImageIndex<item.TotalImages-1;default:return!1}},BaseItemController.prototype.moveInOrder=function(items,options){return Promise.resolve()},BaseItemController.prototype.canScanLibraryFiles=function(item,user){switch(item.Type){case"Playlist":case"Genre":case"MusicGenre":case"GameGenre":case"Channel":case"MusicArtist":return!1;default:return this.canRefreshMetadata(item,user)&&item.IsFolder}},BaseItemController.prototype.canRefreshMetadata=function(item,user){if(!item.Id)return!1;var itemType=item.Type;switch(itemType){case"Device":case"User":case"Plugin":case"Server":case"ActivityLogEntry":case"ApiKey":case"ItemImage":case"Log":case"LiveTVTunerDevice":case"LiveTVGuideSource":case"ChannelManagementInfo":case"ActiveSession":case"RemoteSubtitle":case"Chapter":return!1}switch(item.CollectionType){case"livetv":case"boxsets":return!1}return!(!user||!user.Policy.IsAdministrator||"Timer"===itemType||"SeriesTimer"===itemType||"Program"===itemType||"TvChannel"===itemType||"Recording"===itemType&&"Completed"!==item.Status||_apiclient.default.isLocalItem(item))},BaseItemController.prototype.canDelete=function(item,user){if(item.CanDelete)return!0;var itemType=item.Type;switch(itemType){case"ItemImage":return null!=item.ImageTag;case"Server":return!0;case"Timer":case"SeriesTimer":case"Recording":return null==user?void 0:user.Policy.EnableLiveTvManagement}if(user){if(("LiveTVTunerDevice"===itemType||"LiveTVGuideSource"===itemType)&&user.Policy.IsAdministrator)return!0;if("Plugin"===item.Type&&user.Policy.IsAdministrator)return!0;if(user.Policy.IsAdministrator&&"User"===item.Type&&item.Id!==_connectionmanager.default.getApiClient(item).getCurrentUserId())return!0;if(user.Policy.IsAdministrator&&"Device"===item.Type&&item.Id!==_connectionmanager.default.deviceId())return!0;if("MediaStream"===item.Type&&(user.Policy.EnableSubtitleManagement||null==user.Policy.EnableSubtitleManagement&&user.Policy.IsAdministrator)&&item.IsExternal)return!0;if("VirtualFolder"===itemType&&user.Policy.IsAdministrator&&"boxsets"!==item.CollectionType)return!0}return!1},BaseItemController.prototype.isSingleItemFetchRequired=function(type){switch(type){case"Plugin":case"Device":case"Server":case"Log":case"ApiKey":case"ActivityLogEntry":case"MediaStream":case"RemoteSubtitle":case"ItemImage":case"LiveTVTunerDevice":case"LiveTVGuideSource":case"ChannelManagementInfo":case"ActiveSession":case"ScheduledTask":case"Chapter":return!1;default:return!0}};var defaultIconsByItemType={MusicAlbum:"&#xe019;",MusicArtist:"&#xe7FD;",Person:"&#xe7FD;",Channel:"&#xe2C7;",Device:"&#xe333;",ActiveSession:"&#xe333;",User:"&#xe7fd;",Server:"&#xe328;",SelectServer:"&#xe328;",ManualLogin:"&#xe898;",Downloads:"&#xe2c7;",CollectionFolder:"&#xe2c7;",UserView:"&#xe2c7;",ForgotPassword:"&#xe887;",AddServer:"&#xe147;",AddVirtualFolder:"&#xe147;",ActivityLogEntry:"&#xe878;",Log:"&#xe873;",ApiKey:"&#xe0da;",Tag:"&#xe892;",ItemImage:"&#xe3f4;",PluginCatalogItem:"&#xe87b;",TvChannel:"&#xe639;",ChannelManagementInfo:"&#xe639;",RemoteSubtitle:"&#xe01c;",LiveTVTunerDevice:"&#xe639;",LiveTVGuideSource:"&#xe1b2;",Audio:"&#xe019;",Photo:"&#xe412;",Book:"&#xea19;",Game:"&#xea28;",Playlist:"&#xe0ee;",MusicVideo:"&#xe063;",Studio:"&#xe06b;"},defaultIconsByCollectionType={movies:"&#xe02c;",music:"&#xe310;",audiobooks:"&#xe310;",homevideos:"&#xe412;",photos:"&#xe412;",livetv:"&#xe1b2;",tvshows:"&#xe333;",games:defaultIconsByItemType.Game,trailers:"&#xe02c;",musicvideos:"&#xe063;",books:"&#xea19;",channels:"&#xe2C7;",playlists:defaultIconsByItemType.Playlist,boxsets:"&#xf1c8;"},defaultIconsByStreamType={Audio:"&#xe1b8;",Video:"&#xe04b;",Subtitle:defaultIconsByItemType.RemoteSubtitle,EmbeddedImage:"&#xe412;",Lyrics:"&#xec0b;"},defaultIconsByMediaType={Video:"&#xe02c;",Audio:defaultIconsByItemType.Audio,Photo:defaultIconsByItemType.Photo,Book:defaultIconsByItemType.Book,Game:defaultIconsByItemType.Game},DeleteMessages=(BaseItemController.prototype.getDefaultIcon=function(item){var icon,collectionType=item.CollectionType;return collectionType&&(icon=defaultIconsByCollectionType[collectionType])||(collectionType=item.Type)&&(icon=defaultIconsByItemType[collectionType])||(collectionType=item.StreamType)&&("Lyrics"===item.SubtitleType&&(collectionType="Lyrics"),icon=defaultIconsByStreamType[collectionType])||(collectionType=item.MediaType)&&(icon=defaultIconsByMediaType[collectionType])?icon:"&#xe2C7;"},{Item:{single:{text:_globalize.default.translate("ConfirmDeleteItem")+"\n\n"+_globalize.default.translate("AreYouSureToContinue"),title:_globalize.default.translate("HeaderDeleteItem")},plural:{text:_globalize.default.translate("ConfirmDeleteItems")+"\n\n"+_globalize.default.translate("AreYouSureToContinue"),title:_globalize.default.translate("HeaderDeleteItems")}},Device:{single:{text:_globalize.default.translate("DeleteDeviceConfirmation"),title:_globalize.default.translate("HeaderDeleteDevice")},plural:{text:_globalize.default.translate("DeleteDeviceConfirmation"),title:_globalize.default.translate("HeaderDeleteDevice")}},Plugin:{single:{text:_globalize.default.translate("UninstallPluginConfirmation"),title:_globalize.default.translate("HeaderUninstallPlugin"),confirmText:_globalize.default.translate("Uninstall")},plural:{text:_globalize.default.translate("UninstallPluginConfirmation"),title:_globalize.default.translate("HeaderUninstallPlugin"),confirmText:_globalize.default.translate("Uninstall")}},Server:{single:{text:"DeleteServerConfirmation",title:_globalize.default.translate("HeaderDeleteServer")},plural:{text:"DeleteServerConfirmation",title:_globalize.default.translate("HeaderDeleteServer")}},User:{single:{text:"DeleteUserConfirmation",title:_globalize.default.translate("HeaderDeleteUser")},plural:{text:"DeleteUserConfirmation",title:_globalize.default.translate("HeaderDeleteUser")}},LiveTVGuideSource:{single:{text:"MessageConfirmDeleteGuideProvider",title:_globalize.default.translate("HeaderDeleteProvider")},plural:{text:"MessageConfirmDeleteGuideProvider",title:_globalize.default.translate("HeaderDeleteProvider")}},LiveTVTunerDevice:{single:{text:"MessageConfirmDeleteTunerDevice",title:_globalize.default.translate("HeaderDeleteDevice")},plural:{text:"MessageConfirmDeleteTunerDevice",title:_globalize.default.translate("HeaderDeleteDevice")}},ApiKey:{single:{text:"MessageConfirmRevokeApiKey",title:_globalize.default.translate("HeaderConfirmRevokeApiKey")},plural:{text:"MessageConfirmRevokeApiKey",title:_globalize.default.translate("HeaderConfirmRevokeApiKey")}},ItemImage:{single:{text:"ConfirmDeleteImage"},plural:{text:"ConfirmDeleteImage"}},Timer:{single:{text:"MessageConfirmRecordingCancellation",title:_globalize.default.translate("HeaderCancelRecording"),confirmText:_globalize.default.translate("HeaderCancelRecording"),cancelText:_globalize.default.translate("HeaderKeepRecording"),notification:"RecordingCancelled"},plural:{text:"MessageConfirmRecordingCancellation",title:_globalize.default.translate("HeaderCancelRecording"),confirmText:_globalize.default.translate("HeaderCancelRecording"),cancelText:_globalize.default.translate("HeaderKeepRecording"),notification:"RecordingCancelled"}},Recording:{single:{text:"MessageConfirmRecordingCancellation",title:_globalize.default.translate("HeaderCancelRecording"),confirmText:_globalize.default.translate("HeaderCancelRecording"),cancelText:_globalize.default.translate("HeaderKeepRecording"),notification:"RecordingCancelled"},plural:{text:"MessageConfirmRecordingCancellation",title:_globalize.default.translate("HeaderCancelRecording"),confirmText:_globalize.default.translate("HeaderCancelRecording"),cancelText:_globalize.default.translate("HeaderKeepRecording"),notification:"RecordingCancelled"}},SeriesTimer:{single:{text:"MessageConfirmRecordingCancellation",title:_globalize.default.translate("HeaderCancelSeries"),confirmText:_globalize.default.translate("HeaderCancelSeries"),cancelText:_globalize.default.translate("HeaderKeepSeries"),notification:"SeriesCancelled"},plural:{text:"MessageConfirmRecordingCancellation",title:_globalize.default.translate("HeaderCancelSeries"),confirmText:_globalize.default.translate("HeaderCancelSeries"),cancelText:_globalize.default.translate("HeaderKeepSeries"),notification:"SeriesCancelled"}},VirtualFolder:{single:{text:"MessageAreYouSureYouWishToRemoveLibrary",title:_globalize.default.translate("HeaderRemoveLibrary"),confirmText:_globalize.default.translate("Remove")},plural:{text:"MessageAreYouSureYouWishToRemoveLibrary",title:_globalize.default.translate("HeaderRemoveLibrary"),confirmText:_globalize.default.translate("Remove")}}});function onItemsDeleted(instance,deleteOptions,deleteResult,showNotification){return showNotification&&instance.showAfterDeleteNotification(deleteOptions,deleteResult),Emby.importModule("./modules/approuter.js").then(function(appRouter){var parentId,item;return"back"===deleteOptions.navigate?appRouter.back():deleteOptions.navigate&&(parentId=(item=deleteOptions.items[0]).SeasonId||item.SeriesId||item.ParentId,item=item.ServerId,parentId?appRouter.showItem(parentId,item):appRouter.goHome()),Promise.resolve(deleteResult)})}function mapToId(i){return i.Id}function getLeaveSharedItemTitle(item){return item.Type,_globalize.default.translate("HeaderRemoveFromLibrary")}function htmlEncode(val){return val&&_textencoding.default.htmlEncode(val)}function filterItemsByMethod(instance,items,method,user,limit){for(var list=[],i=0,length=items.length;i<length;i++){var item=items[i];if(instance[method](item,user)&&(list.push(item),limit)&&limit<=list.length)break}return list}function addToList(items,listType){return Emby.importModule("./modules/addtolist/addtolist.js").then(function(AddToList){return(new AddToList).show({items:items,type:listType})})}function getNumberSortOption(itemType){return"TvChannel"!==itemType?{name:_globalize.default.translate("Number"),value:"ParentIndexNumber,IndexNumber,SortName",defaultSortOrder:"Ascending"}:{name:_globalize.default.translate("ChannelNumber"),value:"ChannelNumber,SortName",defaultSortOrder:"Ascending"}}function getFileSortOption(){return{name:_globalize.default.translate("FileName"),value:"IsFolder,Filename"}}function getDateLastActiveSortOption(itemType,apiClient){switch(itemType){case"User":case"Device":return null!=apiClient&&apiClient.isMinServerVersion("4.8.0.47")?{name:_globalize.default.translate("DateLastActive"),value:"DateLastActivity,SortName",defaultSortOrder:"Descending"}:null}}function getIpAddressSortOption(itemType,apiClient){if("Device"===itemType)return null!=apiClient&&apiClient.isMinServerVersion("4.8.0.48")?{name:_globalize.default.translate("IpAddress"),value:"IpAddress,DateLastActivity,SortName",defaultSortOrder:"Ascending",sortOrderAscending:"Ascending,Descending,Ascending",sortOrderDescending:"Descending,Descending,Ascending"}:null}function getDateAddedSortOption(itemType,apiClient){switch(itemType){case"":case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicVideo":case"Video":case"Game":case"Book":case"Person":case"Photo":case"TvChannel":case"Playlist":return{name:_globalize.default.translate("DateAdded"),value:"DateCreated,SortName",defaultSortOrder:"Descending"};case"User":return null!=apiClient&&apiClient.isMinServerVersion("4.8.0.47")?{name:_globalize.default.translate("DateAdded"),value:"DateCreated,SortName",defaultSortOrder:"Descending"}:null}}function getDatePlayedSortOption(itemType){return"Series"!==itemType?{name:_globalize.default.translate("DatePlayed"),value:"DatePlayed,SortName",defaultSortOrder:"Descending"}:{name:_globalize.default.translate("DatePlayed"),value:"SeriesDatePlayed,SortName",defaultSortOrder:"Descending"}}function getCriticRatingSortOption(){return{name:_globalize.default.translate("CriticRating"),value:"CriticRating,SortName",defaultSortOrder:"Descending"}}function getPlayCountSortOption(){return{name:_globalize.default.translate("Plays"),value:"PlayCount,SortName",defaultSortOrder:"Descending"}}function getRuntimeSortOption(){return{name:_globalize.default.translate("Runtime"),value:"Runtime,SortName",defaultSortOrder:"Ascending"}}function getParentalRatingSortOption(){return{name:_globalize.default.translate("ParentalRating"),value:"OfficialRating,SortName",defaultSortOrder:"Descending"}}function getProductionYearSortOption(){return{name:_globalize.default.translate("Year"),value:"ProductionYear,SortName",defaultSortOrder:"Descending"}}function getStartDateSortOption(itemType){return"Program"!==itemType?null:{name:_globalize.default.translate("AirDate"),value:"StartDate",defaultSortOrder:"Ascending"}}function getCommunityRatingOptionName(itemType){switch(itemType){case"Movie":case"Trailer":case"Series":return _globalize.default.translate("ImdbRating")}return _globalize.default.translate("CommunityRating")}function getCommunityRatingSortOption(itemType){return{name:getCommunityRatingOptionName(itemType),value:"CommunityRating,SortName",defaultSortOrder:"Descending"}}function getContainerSortOption(){return{name:_globalize.default.translate("Container"),value:"Container,SortName",defaultSortOrder:"Descending"}}function getSizeSortOption(itemType){return"Log"!==itemType?{name:_globalize.default.translate("Size"),value:"Size,SortName",defaultSortOrder:"Descending"}:null}function getBitrateSortOption(){return{name:_globalize.default.translate("Bitrate"),value:"TotalBitrate,SortName",defaultSortOrder:"Descending"}}function getResolutionSortOption(){return{name:_globalize.default.translate("Resolution"),value:"Resolution,SortName",defaultSortOrder:"Descending"}}function getReleaseDateSortOption(){return{name:_globalize.default.translate("ReleaseDate"),value:"ProductionYear,PremiereDate,SortName",defaultSortOrder:"Descending"}}function getSeriesSortOption(itemType){return"Episode"!==itemType?null:{name:_globalize.default.translate("Series"),value:"SeriesSortName,ParentIndexNumber,IndexNumber,SortName",defaultSortOrder:"Ascending"}}function getAlbumSortOption(){return{name:_globalize.default.translate("Album"),value:"Album,ParentIndexNumber,IndexNumber"}}function getArtistSortValue(){return"Artist,Album,ParentIndexNumber,IndexNumber,SortName"}function getArtistSortOption(){return{name:_globalize.default.translate("Artist"),value:getArtistSortValue()}}function getComposerSortOption(){return{name:_globalize.default.translate("Composer"),value:getArtistSortValue().replace("Artist","Composer")}}function getAlbumArtistSortOption(){return{name:_globalize.default.translate("AlbumArtist"),value:getArtistSortValue().replace("Artist","AlbumArtist")}}function getColumnSize(id){switch(id){case"IndexNumber":case"ParentIndexNumber":case"Video3DFormat":return 3;case"ProductionYear":case"PlayCount":return 4;case"Image":case"Icon":return 4;case"CommunityRating":case"CriticRating":case"Number":return 6;case"EpisodeNumber":case"Runtime":return 10;case"Date":case"Bitrate":case"Size":case"Resolution":case"Container":case"Version":return 12;case"DateTime":return 20;case"Artist":case"AlbumArtist":case"Composer":case"SeriesName":case"Album":case"Genres":case"Email":return 30;case"Studios":case"Name":case"OriginalTitle":case"SortName":case"Filename":case"IpAddress":return 40;case"Path":return 80;default:return 15}}function compareByName(a,b){a=a.menuSortKey||a.name,b=b.menuSortKey||b.name;return a<b?-1:b<a?1:0}function getPlaylistOrCollectionSortMenuOptions(listType){var options=[];return options.push({name:"Playlist"===listType?_globalize.default.translate("PlaylistOrder"):"BoxSet"===listType?_globalize.default.translate("CollectionOrder"):_globalize.default.translate("Default"),value:"default",defaultSortOrder:"Ascending"}),options.push({name:_globalize.default.translate("Album"),value:"Album,ParentIndexNumber,IndexNumber",defaultSortOrder:"Ascending"}),"Playlist"===listType&&options.push({name:_globalize.default.translate("AlbumArtist"),value:"AlbumArtist,Album,ParentIndexNumber,IndexNumber,SortName",defaultSortOrder:"Ascending"}),options.push({name:_globalize.default.translate("Artist"),value:"Artist,Album,ParentIndexNumber,IndexNumber,SortName",defaultSortOrder:"Ascending"}),options.push({name:_globalize.default.translate("CommunityRating"),value:"CommunityRating",defaultSortOrder:"Descending"}),options.push({name:_globalize.default.translate("Runtime"),value:"Runtime",defaultSortOrder:"Ascending"}),options.push({name:_globalize.default.translate("Title"),value:"SortName",defaultSortOrder:"Ascending"}),options.push({name:_globalize.default.translate("ReleaseDate"),value:"ProductionYear,PremiereDate",defaultSortOrder:"Descending"}),options.push({name:_globalize.default.translate("Year"),value:"ProductionYear",defaultSortOrder:"Descending"}),options}function notifyAddedToList(listName,listType,numItems){listName=_textencoding.default.htmlEncode(listName);numItems=1===numItems?_globalize.default.translate("OneItemAddedTo",listName):_globalize.default.translate("ItemsAddedTo",numItems,listName);showToast({text:"Playlist"===listType?_globalize.default.translate("HeaderAddedToPlaylist"):_globalize.default.translate("HeaderAddedToCollection"),secondaryText:numItems,icon:"&#xe03b;"})}function onAddedToList(type,id){"Playlist"===type?_usersettings.default.set("playlisteditor-lastplaylistid",id):"Collection"===type&&_usersettings.default.set("collectioneditor-lastcollectionid",id)}BaseItemController.prototype.getDeleteMessages=function(item){return"MediaStream"===item.Type&&"Subtitle"===item.StreamType?{single:{text:"MessageAreYouSureDeleteSubtitles",title:_globalize.default.translate("ConfirmDeletion"),confirmText:_globalize.default.translate("Delete")},plural:{text:"MessageAreYouSureDeleteSubtitles",title:_globalize.default.translate("ConfirmDeletion"),confirmText:_globalize.default.translate("Delete")}}:DeleteMessages[item.Type]},BaseItemController.prototype.getDeleteMessageOptions=function(options){var items=options.items,options=options.deleteMessages||this.getDeleteMessages(items[0])||DeleteMessages.Item,options=1<items.length?options.plural:options.single;return(options=Object.assign({},options)).primary="cancel",options.confirmText||(options.confirmText=_globalize.default.translate("Delete")),1===items.length?options.text=_globalize.default.translate(options.text,items[0].Name):options.text=_globalize.default.translate(options.text,items.length),options},BaseItemController.prototype.showSeriesDeleteConfirmation=function(options){var item=options.items[0],apiClient=_connectionmanager.default.getApiClient(item),instance=this;return apiClient.getEpisodes(item.Id,{Limit:1,SortBy:"DatePlayed",SortOrder:"Descending",IsPlayed:!0,UserId:apiClient.getCurrentUserId(),ExcludeLocationTypes:"Virtual"}).then(function(result){return result.Items.length?showDialog({title:_globalize.default.translate("HeaderDeleteSeries"),text:"",buttons:[{name:_globalize.default.translate("Cancel"),id:"cancel",type:"submit"},{name:_globalize.default.translate("HeaderDeleteLastPlayedEpisode"),id:"deletelastplayed",type:"cancel"},{name:_globalize.default.translate("HeaderDeleteSeries"),id:"deleteseries",type:"cancel"}]}).then(function(id){return"deleteseries"===id?{deleteType:id}:"deletelastplayed"===id?{deleteType:id,item:result.Items[0]}:"cancel"===id?Promise.reject():rejectNoSupportedCommands()}):instance.showLibraryItemDeleteConfirmation(options).then(function(){return{deleteType:"deleteseries"}})})},BaseItemController.prototype.showDeleteConfirmation=function(options){if(1===options.items.length)switch(options.items[0].Type){case"VirtualFolder":case"SeriesTimer":case"Timer":case"Recording":case"ItemImage":case"LiveTVGuideSource":case"LiveTVTunerDevice":case"ApiKey":case"Server":case"MediaStream":case"Device":case"Plugin":case"User":break;case"Series":return this.showSeriesDeleteConfirmation(options);default:if(this.enableLibraryItemDeleteConfirmation())return this.showLibraryItemDeleteConfirmation(options)}return showConfirm(this.getDeleteMessageOptions(options))},BaseItemController.prototype.enableLibraryItemDeleteConfirmation=function(){return!0},BaseItemController.prototype.showLibraryItemDeleteConfirmation=function(options){var item=options.items[0],options=_connectionmanager.default.getApiClient(item),itemId=item.Id;return options.getDeleteInfo(itemId).then(function(deleteInfo){return showConfirm({title:_globalize.default.translate("HeaderDeleteItem"),text:function(deleteInfo,item){var msg=deleteInfo.Paths.length?(msg=_globalize.default.translate("ConfirmDeleteItem"),(msg+="\n\n"+_globalize.default.translate("FollowingFilesWillBeDeleted")+"\n"+deleteInfo.Paths.join("\n"))+"\n\n"+_globalize.default.translate("AreYouSureToContinue")):_globalize.default.translate("DeleteItemConfirmation",item.Name);return msg}(deleteInfo,item),html:function(deleteInfo,item){var msg;if(deleteInfo.Paths.length){msg=_globalize.default.translate("ConfirmDeleteItem"),msg+="<p>"+_globalize.default.translate("FollowingFilesWillBeDeleted")+"</p>";for(var i=0,length=deleteInfo.Paths.length;i<length;i++)msg+='<div class="secondaryText">'+deleteInfo.Paths[i]+"</div>";msg+='<p style="margin-bottom:0;">'+_globalize.default.translate("AreYouSureToContinue")+"</p>"}else msg=_globalize.default.translate("DeleteItemConfirmation",item.Name);return msg}(deleteInfo,item),confirmText:_globalize.default.translate("Delete"),primary:"cancel",centerText:!1})})},BaseItemController.prototype.deleteItems=function(options){var instance,optionsClone,apiClient;return"leaveshareditems"===options.deleteType?function(instance,items,options){var item=items[0],title=getLeaveSharedItemTitle(item);return showConfirm({title:title,text:_globalize.default.translate("RemoveSharedItemConfirmation"),confirmText:title,primary:"cancel"}).then(function(){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.leaveSharedItems({UserId:apiClient.getCurrentUserId(),ItemIds:items.map(mapToId)}).then(function(result){return onItemsDeleted(instance,options,result,!1)})})}(this,options.items,options):(instance=this,optionsClone=Object.assign({},options),(null!=(apiClient=_connectionmanager.default.getApiClient(optionsClone.items[0]))&&apiClient.getCurrentUserId()&&"Server"!==optionsClone.items[0].Type?apiClient.getCurrentUser():Promise.resolve()).then(function(user){user=filterItemsByMethod(instance,optionsClone.items,"canDelete",user);return user.length?(optionsClone.items=user,(!1===(null==options?void 0:options.confirm)?Promise.resolve():instance.showDeleteConfirmation(options)).then(function(deleteConfirmationResult){return _loading.default.show(),instance.deleteItemsInternal(optionsClone,deleteConfirmationResult).then(function(result){return _loading.default.hide(),onItemsDeleted(instance,options,result,!0)})})):rejectNoItems()}))},BaseItemController.prototype.getItemTypeName=function(type){if(!type)return null;switch(type){case"Genre":case"MusicGenre":case"GameGenre":return _globalize.default.translate("Genre");case"BoxSet":return _globalize.default.translate("Collection");case"Audio":return _globalize.default.translate("Song");case"MusicArtist":return _globalize.default.translate("Artist");case"MusicAlbum":return _globalize.default.translate("Album");case"MusicVideo":return _globalize.default.translate("HeaderMusicVideo");case"TvChannel":return _globalize.default.translate("Channel");case"LiveTvProgram":return _globalize.default.translate("Program");case"ApiKey":return _globalize.default.translate("HeaderApiKey");case"Timer":return _globalize.default.translate("Recording");case"SeriesTimer":return _globalize.default.translate("SeriesRecording")}return _globalize.default.translate(type)},BaseItemController.prototype.getPluralItemTypeName=function(type){switch(type){case"Genre":case"MusicGenre":case"GameGenre":return _globalize.default.translate("Genres");case"BoxSet":return _globalize.default.translate("Collections");case"Audio":return _globalize.default.translate("Songs");case"MusicArtist":return _globalize.default.translate("Artists");case"MusicAlbum":return _globalize.default.translate("Albums");case"MusicVideo":return _globalize.default.translate("HeaderMusicVideos");case"Person":return _globalize.default.translate("People");case"TvChannel":return _globalize.default.translate("Channels");case"Series":return _globalize.default.translate("Shows");case"LiveTvProgram":return _globalize.default.translate("Programs");case"ApiKey":return _globalize.default.translate("HeaderApiKeys")}return _globalize.default.translate(type+"s")},BaseItemController.prototype.showAfterDeleteNotification=function(deleteOptions,deleteResult){var items=deleteOptions.items,deleteOptions=deleteOptions.deleteMessages||this.getDeleteMessages(items[0])||DeleteMessages.Item,deleteOptions=(1<items.length?deleteOptions.plural:deleteOptions.single).notification;deleteOptions&&showToast(deleteOptions=1===items.length?_globalize.default.translate(deleteOptions,items[0].Name):_globalize.default.translate(deleteOptions,items.length))},BaseItemController.prototype.supportsContextMenu=function(item){switch(item.Type){case"Program":case"AddServer":case"EmbyConnect":return!1;case"MediaStream":return"Subtitle"===item.StreamType&&item.IsExternal?!0:!1;case"Trailer":return item.Id?!0:!1;default:return!0}},BaseItemController.prototype.resolveField=function(item,field,options){switch(field){case"LastActivityDateRelative":var val=item.LastActivityDate||item.DateLastActivity;return val?_dataformatter.default.formatRelativeTime(val):null;case"LastActivityDate":var val=item.LastActivityDate||item.DateLastActivity;return val?_datetime.default.toLocaleString(new Date(Date.parse(val))):null;case"LastUser":var val=item.LastUserId?_approuter.default.getRouteUrl({Type:"User",Name:item.LastUserName,Id:item.LastUserId,ServerId:item.ServerId}):null,lastUserName=_textencoding.default.htmlEncode(item.LastUserName||"");return val?'<a is="emby-linkbutton" class="button-link button-link-color-inherit button-link-fontweight-inherit" href="'+val+'">'+lastUserName+"</a>":lastUserName;case"DateCreated":val=item.DateCreated;return val?_datetime.default.toLocaleDateString(new Date(Date.parse(val))):null;case"DateModified":lastUserName=item.DateModified;return lastUserName?_datetime.default.toLocaleString(new Date(Date.parse(lastUserName))):null;case"ShortOverviewHtml":return item.ShortOverviewHtml;case"Container":return htmlEncode(null==(val=item.Container)?void 0:val.toUpperCase());case"AppNameVersion":lastUserName=[];return item.AppName&&lastUserName.push(item.AppName),item.AppVersion&&lastUserName.push(item.AppVersion),_textencoding.default.htmlEncode(lastUserName.join(" "))||null;case"Size":val=item.Size;return null!=val?_dataformatter.default.sizeToString(val):null;case"Bitrate":lastUserName=item.Bitrate;return null!=lastUserName?_dataformatter.default.bitrateToString(lastUserName):null;default:return htmlEncode(item[field])}},BaseItemController.prototype.deleteItemsInternal=function(options,deleteConfirmationResult){var items=options.items,item=items[0];switch(item.Type){case"Device":return _connectionmanager.default.getApiClient(item).deleteDevices(options.items);case"Plugin":return _connectionmanager.default.getApiClient(item).uninstallPlugins(options.items);case"User":return _connectionmanager.default.getApiClient(item).deleteUsers(options.items);case"VirtualFolder":return function(virtualFolder,apiClient,options){return options="true"===options.positionTo.closest(".page").getAttribute("data-refreshlibrary"),apiClient.removeVirtualFolder(virtualFolder,options)}(item,_connectionmanager.default.getApiClient(item),options);case"SeriesTimer":return _connectionmanager.default.getApiClient(item).cancelLiveTvSeriesTimer(item.Id);case"Timer":case"Recording":return _connectionmanager.default.getApiClient(item).cancelLiveTvTimer(item.TimerId||item.Id);case"ItemImage":return _connectionmanager.default.getApiClient(item).deleteItemImage(item.ItemId,item.ImageType,item.ImageIndex);case"LiveTVGuideSource":return _connectionmanager.default.getApiClient(item).deleteLiveTVGuideSource(item.Id);case"LiveTVTunerDevice":return _connectionmanager.default.getApiClient(item).deleteLiveTVTunerDevice(item.Id);case"ApiKey":return _connectionmanager.default.getApiClient(item).deleteApiKeys(items);case"Server":return _connectionmanager.default.deleteServer(item.Id);case"Series":return"deletelastplayed"===(null==deleteConfirmationResult?void 0:deleteConfirmationResult.deleteType)?(options.navigate=null,_connectionmanager.default.getApiClient(item).deleteItems([deleteConfirmationResult.item])):_connectionmanager.default.getApiClient(item).deleteItems(items);case"MediaStream":return"Subtitle"===item.StreamType?_connectionmanager.default.getApiClient(item).deleteSubtitles(item.ItemId,item.MediaSourceId,item.Index):rejectNoSupportedCommands();default:return _connectionmanager.default.getApiClient(item).deleteItems(items)}},BaseItemController.prototype.getDeleteCommand=function(items){var items=items[0].Type;if("Plugin"!==items&&"VirtualFolder"!==items&&"Timer"!==items&&"SeriesTimer"!==items)return items=this.isDeletePrimaryCommand(items),{name:_globalize.default.translate("Delete"),id:"delete",icon:"delete",primaryCommand:items,horizontalDragSection:"right"}},BaseItemController.prototype.getCommands=function(options){var commands=[],items=options.items,item=(items||(items=[],options.item&&items.push(options.item)),items[0]),canPlay=_playbackmanager.default.canPlay(item),apiClient=(1<items.length&&"Playlist"===items[0].Type&&(canPlay=!1),_connectionmanager.default.getApiClient(item)),user=function(options,apiClient){var user=options.user;return user=!user&&apiClient&&options.users?options.users[apiClient.serverId()]:user}(options,apiClient),itemType=item.Type,needsDivider=(options.setChecked?commands.push({name:_globalize.default.translate("Enable"),id:"togglecheckbox",icon:"&#xe834;"}):options.setUnchecked&&commands.push({name:_globalize.default.translate("Disable"),id:"togglecheckbox",icon:"&#xe835;"}),options.programInfo&&"Program"===itemType&&commands.push({name:_globalize.default.translate("Info"),id:"link",icon:"&#xe88e;"}),canPlay&&("Photo"===item.MediaType?!1!==options.playSlideshow&&commands.push({name:_globalize.default.translate("PlaySlideshow"),id:"playallfromhereautoplay",icon:"&#xe037;"}):(!1===options.play||(isPlayQueueItem=item.PlaylistItemId&&!item.PlaylistId)&&1!==items.length||commands.push({name:_globalize.default.translate("Play"),id:"resume",icon:"&#xe037;",primaryCommand:!isPlayQueueItem}),1===items.length&&(options.playFromBeginning&&("Series"===itemType||"MusicAlbum"===itemType&&item.SupportsResume||item.UserData&&0<item.UserData.PlaybackPositionTicks)&&commands.push({name:_globalize.default.translate("PlayFromBeginning"),id:"playfrombeginning",icon:"&#xe037;"}),filterItemsByMethod(this,items,"canRemoveFromPlayQueue",user,1).length||options.playAllFromHere&&"Program"!==itemType&&"Recording"!==itemType&&"TvChannel"!==itemType&&"Chapter"!==itemType&&commands.push({name:_globalize.default.translate("PlayAllFromHere"),id:"playallfromhere",icon:"&#xe037;"})))),filterItemsByMethod(this,items,"canRemoveFromPlayQueue",user,1).length?commands.push({name:_globalize.default.translate("HeaderRemoveFromPlayQueue"),id:"removefromplayqueue",icon:"remove_circle_outline",primaryCommand:!0,horizontalDragSection:"right"}):_playbackmanager.default.canQueue(item)&&(!1!==options.queue&&commands.push({name:_globalize.default.translate("HeaderAddToPlayQueue"),id:"queue",icon:"&#xe03b;",horizontalDragSection:"left"}),!1!==options.queue)&&commands.push({name:_globalize.default.translate("HeaderPlayNext"),id:"queuenext",icon:"&#xe03b;",horizontalDragSection:"left"}),(item.IsFolder||"MusicArtist"===itemType||"MusicGenre"===itemType)&&"livetv"!==item.CollectionType&&canPlay&&!1!==options.shuffle&&commands.push({name:_globalize.default.translate("Shuffle"),id:"shuffle",icon:"&#xe043;"}),1===items.length&&("Audio"!==item.MediaType&&"MusicAlbum"!==itemType&&"MusicArtist"!==itemType||!1===options.instantMix||_apiclient.default.isLocalItem(item)||commands.push({name:_globalize.default.translate("HeaderInstantMix"),id:"instantmix",icon:"&#xe043;"}),options.gotoItem)&&commands.push({name:_globalize.default.translate("HeaderGoToItem"),id:"link",icon:this.getDefaultIcon(item)}),commands.length&&(commands[commands.length-1].dividerAfter=!0),!1),isPlayQueueItem=filterItemsByMethod(this,items,"canAddToPlaylist",user,1).length;if(filterItemsByMethod(this,items,"canAddToCollection",user,1).length&&(commands.push({name:_globalize.default.translate("HeaderAddToCollection"),id:"addtocollection",icon:"&#xe03b;",horizontalDragSection:isPlayQueueItem?null:"left"}),needsDivider=!0),isPlayQueueItem&&(commands.push({name:_globalize.default.translate("HeaderAddToPlaylist"),id:"addtoplaylist",icon:"&#xe03b;",primaryCommand:!0,horizontalDragSection:"left"}),needsDivider=!0),user&&!1!==options.favorites&&filterItemsByMethod(this,items,"canRate",user,1).length&&(item.UserData&&item.UserData.IsFavorite?commands.push({name:_globalize.default.translate("HeaderRemoveFromFavorites"),id:"unfavorite",icon:"&#xe87d;",iconClass:"icon_circle_strike"}):commands.push({name:_globalize.default.translate("HeaderAddToFavorites"),id:"favorite",icon:"&#xe87d;"}),needsDivider=!0),user&&!1!==options.played&&filterItemsByMethod(this,items,"canMarkPlayed",user,1).length&&(canPlay=item.UserData&&item.UserData.Played,commands.push(canPlay?{name:_globalize.default.translate("HeaderMarkUnplayed"),id:"markunplayed",icon:"check",iconClass:"icon_circle_strike"}:{name:_globalize.default.translate("HeaderMarkPlayed"),id:"markplayed",icon:"check"}),needsDivider=!0),needsDivider=needsDivider&&!(commands[commands.length-1].dividerAfter=!0),1===items.length&&(options.multiSelect&&!_layoutmanager.default.tv&&(needsDivider=!0,commands.push({name:_globalize.default.translate("MultiSelect"),id:"multiselect",icon:"select_all"})),"MediaStream"===itemType&&item.IsExternal&&"Subtitle"===item.StreamType&&(needsDivider=!0,commands.push({name:_globalize.default.translate("Preview"),id:"preview",icon:"&#xe89e;"})),"RemoteSubtitle"===itemType)&&(needsDivider=!0,commands.push({name:_globalize.default.translate("Preview"),id:"preview",icon:"&#xe89e;"})),needsDivider=needsDivider&&!(commands[commands.length-1].dividerAfter=!0),1===items.length&&(user&&("Timer"===itemType&&filterItemsByMethod(this,items,"canDelete",user,1).length&&!1!==options.cancelTimer&&commands.push({name:_globalize.default.translate("HeaderCancelRecording"),id:"canceltimer",icon:"&#xe061;"}),"SeriesTimer"===itemType)&&filterItemsByMethod(this,items,"canDelete",user,1).length&&!1!==options.cancelTimer&&commands.push({name:_globalize.default.translate("HeaderCancelSeries"),id:"cancelseriestimer",icon:"&#xe3c9;"}),"VirtualFolder"===itemType&&user.Policy.IsAdministrator&&"boxsets"!==item.CollectionType&&commands.push({name:_globalize.default.translate("HeaderChangeFolderType"),id:"changelibrarycontenttype",icon:"&#xe2c7;"}),"Server"===itemType&&commands.push({name:_globalize.default.translate("Connect"),id:"connecttoserver",icon:"&#xe63E;"}),"ApiKey"===itemType)&&navigator.clipboard&&navigator.clipboard.writeText&&commands.push({name:_globalize.default.translate("HeaderCopyToClipboard"),id:"copytoclipboard",icon:"content_copy"}),1===items.length&&(!1!==options.openAlbum&&item.AlbumId&&"Photo"!==item.MediaType&&commands.push({name:_globalize.default.translate("HeaderGoToAlbum"),id:"album",icon:this.getDefaultIcon({Type:"MusicAlbum",IsFolder:!0})}),!1!==options.openArtist&&item.ArtistItems&&item.ArtistItems.length&&commands.push({name:_globalize.default.translate("HeaderGoToArtist"),id:"artist",icon:this.getDefaultIcon({Type:"MusicArtist",IsFolder:!0})}),!1!==options.showSeason&&"Episode"===itemType&&item.SeasonId&&commands.push({name:_globalize.default.translate("HeaderGoToSeason"),id:"season",icon:this.getDefaultIcon({Type:"Season",IsFolder:!0})}),!options.showSeries||"Episode"!==itemType&&"Season"!==itemType||commands.push({name:_globalize.default.translate("HeaderGoToSeries"),id:"series",icon:this.getDefaultIcon({Type:"Series",IsFolder:!0})})),_servicelocator.appHost.supports("sync")&&filterItemsByMethod(this,items,"canSync",user,1).length?!1!==options.syncLocal&&(needsDivider=!0,commands.push({name:_globalize.default.translate("Download"),id:"synclocal",icon:"&#xe5db;",horizontalDragSection:"right"})):filterItemsByMethod(this,items,"canDownload",user,1).length&&(needsDivider=!0,commands.push({name:_globalize.default.translate("Download"),id:"download",icon:"&#xe5db;",primaryCommand:"Log"===itemType,horizontalDragSection:"right"})),!1!==options.sync&&filterItemsByMethod(this,items,"canSync",user,1).length&&(needsDivider=!0,commands.push({name:_globalize.default.translate("HeaderDownloadToDots"),id:"sync",icon:"&#xe5db;"})),!1!==options.convert&&filterItemsByMethod(this,items,"canConvert",user,1).length&&(needsDivider=!0,commands.push({name:_globalize.default.translate("Convert"),id:"convert",icon:"sync"})),needsDivider=needsDivider&&!(commands[commands.length-1].dividerAfter=!0),1===items.length&&user&&!1!==options.createRecording&&user.Policy.EnableLiveTvManagement&&"TvChannel"===itemType&&commands.push({name:_globalize.default.translate("HeaderCreateRecording"),id:"record",icon:"&#xe061;"}),this.canEdit(items,user)&&!1!==options.edit&&"SeriesTimer"!==itemType&&(needsDivider=!0,commands.push(this.getEditCommand(items))),1===items.length&&(this.canEditImages(item,user)&&!1!==options.editImages&&(needsDivider=!0,commands.push({name:_globalize.default.translate("HeaderEditImages"),id:"editimages",icon:"photo"})),!1!==options.editSubtitles)&&this.canEditSubtitles(item,user)&&!1!==options.editSubtitles&&"Audio"!==item.MediaType&&(needsDivider=!0,commands.push({name:_globalize.default.translate("HeaderEditSubtitles"),id:"editsubtitles",icon:defaultIconsByStreamType.Subtitle})),!1!==options.deleteItem&&filterItemsByMethod(this,items,"canDelete",user,1).length&&"Plugin"!==itemType&&"VirtualFolder"!==itemType&&"Timer"!==itemType&&"SeriesTimer"!==itemType&&(isPlayQueueItem=this.getDeleteCommand(items))&&(needsDivider=!0,commands.push(isPlayQueueItem)),1<filterItemsByMethod(this,items,"canManageMultiVersionGrouping",user,2).length&&(needsDivider=!0,commands.push({name:_globalize.default.translate("HeaderGroupVersions"),id:"mergeversions",icon:"call_merge"})),!1!==options.identify&&filterItemsByMethod(this,items,"canIdentify",user,1).length&&(1===items.length&&(needsDivider=!0,commands.push({name:_globalize.default.translate("Identify"),id:"identify",icon:"&#xe85d;"})),apiClient)&&apiClient.isMinServerVersion("4.8.0.30")&&(needsDivider=!0,commands.push({name:_globalize.default.translate("HeaderRemoveIdentification"),id:"resetmetadata",icon:"&#xe0b8;"})),1===items.length&&(item.CanLeaveContent&&commands.push({name:getLeaveSharedItemTitle(item),id:"leaveshareditems",icon:"person_remove"}),item.CanManageAccess)&&commands.push({name:"Playlist"===itemType?_globalize.default.translate("HeaderManageCollaboration"):_globalize.default.translate("HeaderManageAccess"),id:"manageaccess",icon:"person_add"}),!1!==options.refreshMetadata&&filterItemsByMethod(this,items,"canRefreshMetadata",user,1).length&&(needsDivider=!0,commands.push({name:_globalize.default.translate("HeaderRefreshMetadata"),id:"refresh",icon:"refresh"})),!1!==options.refreshMetadata&&filterItemsByMethod(this,items,"canScanLibraryFiles",user,1).length)switch(itemType){case"Playlist":case"Genre":case"MusicGenre":case"GameGenre":case"Channel":case"MusicArtist":break;default:needsDivider=!0,commands.push({name:_globalize.default.translate("HeaderScanLibraryFiles"),id:"scan",icon:"refresh"})}return needsDivider=needsDivider&&!(commands[commands.length-1].dividerAfter=!0),!1!==options.removeFromPlaylist&&filterItemsByMethod(this,items,"canRemoveFromPlaylist",user,1).length&&commands.push({name:_globalize.default.translate("HeaderRemoveFromPlaylist"),id:"removefromplaylist",icon:"remove_circle_outline",primaryCommand:!0,horizontalDragSection:"right"}),filterItemsByMethod(this,items,"canRemoveFromCollection",user,1).length&&commands.push({name:_globalize.default.translate("HeaderRemoveFromCollection"),id:"removefromcollection",icon:"remove_circle_outline",primaryCommand:!0,horizontalDragSection:"right"}),user&&(!1!==options.deleteItem&&filterItemsByMethod(this,items,"canDelete",user,1).length&&"VirtualFolder"===itemType&&commands.push({name:_globalize.default.translate("Remove"),id:"delete",icon:"remove_circle_outline"}),"VirtualFolder"===itemType)&&user.Policy.IsAdministrator&&"boxsets"!==item.CollectionType&&1===items.length&&commands.push({name:_globalize.default.translate("Rename"),id:"renamelibrary",icon:"edit"}),1===items.length&&(options.removeFromNextUp&&commands.push({name:_globalize.default.translate("HeaderRemoveFromContinueWatching"),id:"removefromnextup",icon:"remove_circle_outline"}),options.removeFromResume)&&commands.push({name:"Audio"===item.MediaType?_globalize.default.translate("HeaderRemoveFromContinueListening"):_globalize.default.translate("HeaderRemoveFromContinueWatching"),id:"removefromresume",icon:"remove_circle_outline"}),1===items.length&&(filterItemsByMethod(this,items,"canMoveUp",user,1).length&&commands.push({name:_globalize.default.translate("HeaderMoveUpInOrder"),id:"moveupinorder",icon:"&#xe5d8;"}),filterItemsByMethod(this,items,"canMoveDown",user,1).length&&commands.push({name:_globalize.default.translate("HeaderDownUpInOrder"),id:"movedowninorder",icon:"&#xe5db;"}),"ItemImage"===itemType&&(item.ImageTag||commands.push({name:_globalize.default.translate("HeaderAddImageFromUrl"),id:"addimagefromurl",icon:"link"}),("Backdrop"!==item.ImageType||null!=apiClient&&apiClient.isMinServerVersion("4.9.0.13"))&&(item.Providers.length&&(canPlay=item.ImageTag?_globalize.default.translate("HeaderSearchNewImage"):_globalize.default.translate("HeaderSearchForAnImage"),commands.push({name:canPlay,id:"searchimageproviders",icon:"search"})),_servicelocator.appHost.supports("fileinput"))&&commands.push({name:_globalize.default.translate("HeaderSelectImageFile"),id:"addimage",icon:"add_circle_outline"}),item.ImageTag)&&commands.push({name:_globalize.default.translate("HeaderSetImageFromUrl"),id:"addimagefromurl",icon:"link"}),"Plugin"===itemType&&user.Policy.IsAdministrator&&item.ConfigPageUrl&&commands.push({name:_globalize.default.translate("Settings"),id:"open",icon:"settings"}),!1!==options.share&&this.canShare(item,user)&&commands.push({name:_globalize.default.translate("Share"),id:"share",icon:"share"}),"Recording"===itemType)&&"InProgress"===item.Status&&user.Policy.EnableLiveTvManagement&&!1!==options.cancelTimer&&commands.push({name:_globalize.default.translate("HeaderStopRecording"),id:"canceltimer",icon:"&#xe061;"}),"Plugin"===itemType&&filterItemsByMethod(this,items,"canDelete",user,1).length&&commands.push({name:_globalize.default.translate("Uninstall"),id:"delete",icon:"delete",primaryCommand:!0,horizontalDragSection:"right"}),1===items.length&&("Audio"===itemType&&function(item){if(item=item.MediaSources)return(item=item[0])&&0<(item.MediaStreams||[]).filter(function(s){return"Subtitle"===s.Type}).length}(item)&&commands.push({name:_globalize.default.translate("HeaderViewLyrics"),id:"lyrics",icon:"lyrics"}),"Server"===itemType&&commands.push({name:_globalize.default.translate("HeaderViewServerInfo"),id:"serverinfo",icon:"&#xe63E;"}),"Server"===itemType&&apiClient&&apiClient.supportsWakeOnLan()&&commands.push({name:_globalize.default.translate("HeaderWakeServer"),id:"wakeserver",icon:"&#xe63E;",primaryCommand:!0}),"Series"===itemType&&null!=apiClient&&apiClient.isMinServerVersion("4.8.0.59")&&commands.push({name:_globalize.default.translate("HeaderViewMissingEpisodes"),id:"showmissingepisodes",icon:"format_list_bulleted"}),"Season"===itemType)&&null!=apiClient&&apiClient.isMinServerVersion("4.8.0.60")&&commands.push({name:_globalize.default.translate("HeaderViewMissingEpisodes"),id:"showmissingepisodes",icon:"format_list_bulleted"}),commands},BaseItemController.prototype.isDeletePrimaryCommand=function(itemType){return"Plugin"===itemType},BaseItemController.prototype.scanLibraryFiles=function(items,options){var apiClient=_connectionmanager.default.getApiClient(items[0]),instance=this;return apiClient.getCurrentUser().then(function(user){return(items=filterItemsByMethod(instance,items,"canScanLibraryFiles",user)).length?apiClient.refreshItems(items,{Recursive:!0,ImageRefreshMode:"Default",MetadataRefreshMode:"Default",ReplaceAllImages:!1,ReplaceAllMetadata:!1}).then(function(){return showToast(_globalize.default.translate("ScanningLibraryFilesDots"))}):rejectNoItems()})},BaseItemController.prototype.refreshMetadata=function(items,options){var apiClient=_connectionmanager.default.getApiClient(items[0]),instance=this;return apiClient.getCurrentUser().then(function(user){return(items=filterItemsByMethod(instance,items,"canRefreshMetadata",user)).length?Emby.importModule("./modules/refreshdialog/refreshdialog.js").then(function(RefreshDialog){return new RefreshDialog({items:items}).show()}):rejectNoItems()})},BaseItemController.prototype.addToPlaylist=function(items,options){var apiClient=_connectionmanager.default.getApiClient(items[0]),instance=this;return apiClient.getCurrentUser().then(function(user){return(items=filterItemsByMethod(instance,items,"canAddToPlaylist",user)).length?addToList(items,"Playlist"):rejectNoItems()})},BaseItemController.prototype.addToCollection=function(items,options){var apiClient=_connectionmanager.default.getApiClient(items[0]),instance=this;return apiClient.getCurrentUser().then(function(user){return(items=filterItemsByMethod(instance,items,"canAddToCollection",user)).length?addToList(items,"Collection"):rejectNoItems()})},BaseItemController.prototype.groupVersions=function(items,options){var apiClient=_connectionmanager.default.getApiClient(items[0]),instance=this;return apiClient.getCurrentUser().then(function(user){return(items=filterItemsByMethod(instance,items,"canManageMultiVersionGrouping",user)).length?items.length<2?showAlertAndReject(_globalize.default.translate("PleaseSelectTwoItems")):(_loading.default.show(),apiClient.mergeVersions(items).then(function(response){return _loading.default.hide(),Promise.resolve(response)},function(response){return _loading.default.hide(),Promise.reject(response)})):rejectNoItems()})},BaseItemController.prototype.getAvailableFields=function(options){var _getSeriesSortOption,_this$getNameSortOpti,_getDateLastActiveSor2,_getNumberSortOption,_getOriginalTitleSort,_this$getNameSortOpti3,_getFileSortOption,_getArtistSortOption,_getAlbumSortOption,_getCommunityRatingSo,_getCriticRatingSortO,_getParentalRatingSor,_getReleaseDateSortOp,_getRuntimeSortOption,_getContainerSortOpti,_getResolutionSortOpt,_getBitrateSortOption,_getSizeSortOption,_getDatePlayedSortOpt,_getPlayCountSortOpti,_options$parentItem,_getDateAddedSortOpti,_getProductionYearSor,defaultVisible,_getDateLastActiveSor,fields=[],itemType=options.itemType||"",apiClient=options.apiClient;switch("User"===itemType&&fields.push({id:"IsAdministrator",name:_globalize.default.translate("Admin"),gridDisplayName:'<i title="'+_globalize.default.translate("Admin")+'" class="md-icon dataGridItemCell-icon">&#xef3d;</i>',size:getColumnSize("Icon"),sortBy:null,gridColumnType:"icon",viewTypes:"datagrid",defaultVisible:"datagrid"}),itemType){case"":case"Episode":fields.push({id:"SeriesName",name:_globalize.default.translate("Series"),size:getColumnSize("SeriesName"),sortBy:null==(_getSeriesSortOption=getSeriesSortOption(itemType))?void 0:_getSeriesSortOption.value,viewTypes:"datagrid",defaultVisible:"datagrid"}),fields.push({id:"EpisodeNumber",name:_globalize.default.translate("Number"),size:getColumnSize("EpisodeNumber"),sortBy:null,viewTypes:"datagrid",defaultVisible:"datagrid"})}switch(itemType){case"Photo":case"PhotoAlbum":fields.push({id:"Name",name:_globalize.default.translate("Title"),size:getColumnSize("Name"),sortBy:null==(_this$getNameSortOpti=this.getNameSortOption(itemType,apiClient))?void 0:_this$getNameSortOpti.value,defaultVisible:"datagrid"});break;case"ApiKey":break;default:fields.push({id:"Name",name:_globalize.default.translate("Title"),size:getColumnSize("Name"),sortBy:null==(_this$getNameSortOpti=this.getNameSortOption(itemType,apiClient))?void 0:_this$getNameSortOpti.value,defaultVisible:"*"})}switch("User"===itemType&&fields.push({id:"ConnectUserName",name:"Emby Connect",size:getColumnSize("Email"),sortBy:null}),"ApiKey"===itemType&&fields.push({id:"AppName",name:_globalize.default.translate("AppName"),size:getColumnSize("Name"),sortBy:null,defaultVisible:"*"}),"Device"===itemType&&fields.push({id:"AppNameVersion",name:_globalize.default.translate("AppName"),size:getColumnSize("Name"),sortBy:null,defaultVisible:"*"}),"ApiKey"===itemType&&fields.push({id:"AccessToken",name:_globalize.default.translate("HeaderApiKey"),size:getColumnSize("Name"),sortBy:null,defaultVisible:"*"}),"User"===itemType&&fields.push({id:"LastActivityDateRelative",name:_globalize.default.translate("DateLastActive"),size:getColumnSize("Name"),sortBy:null==(_getDateLastActiveSor=getDateLastActiveSortOption(itemType,apiClient))?void 0:_getDateLastActiveSor.value,viewTypes:"cards",defaultVisible:"cards,list"}),itemType){case"Device":case"User":fields.push({id:"LastActivityDate",name:_globalize.default.translate("DateLastActive"),size:getColumnSize("DateTime"),sortBy:null==(_getDateLastActiveSor2=getDateLastActiveSortOption(itemType,apiClient))?void 0:_getDateLastActiveSor2.value,viewTypes:"datagrid",defaultVisible:"datagrid"})}switch("Device"===itemType&&fields.push({id:"LastUser",name:_globalize.default.translate("User"),size:getColumnSize("Name"),sortBy:null,viewTypes:"datagrid",defaultVisible:"datagrid"}),itemType){case"":case"Audio":case"TvChannel":fields.push({id:"Number",name:_globalize.default.translate("Number"),size:getColumnSize("Number"),sortBy:null==(_getNumberSortOption=getNumberSortOption(itemType))?void 0:_getNumberSortOption.value,viewTypes:"datagrid"})}switch("Program"===itemType&&fields.push({id:"StartDate",name:_globalize.default.translate("AirDate"),size:getColumnSize("StartDate"),sortBy:null==(_getDateLastActiveSor=getStartDateSortOption(itemType))?void 0:_getDateLastActiveSor.value,viewTypes:"datagrid",defaultVisible:"datagrid"}),itemType){case"":case"Movie":case"Video":case"Trailer":case"MusicVideo":case"Series":case"Game":fields.push({id:"OriginalTitle",name:_globalize.default.translate("OriginalTitle"),size:getColumnSize("OriginalTitle"),sortBy:null===(_getOriginalTitleSort={name:_globalize.default.translate("OriginalTitle"),value:"OriginalTitle,SortName",defaultSortOrder:"Descending"})?void 0:_getOriginalTitleSort.value,viewTypes:"datagrid"})}switch(itemType){case"":case"Folder":case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicGenre":case"MusicVideo":case"Playlist":case"Video":case"Game":case"Book":case"Genre":case"GameGenre":case"Person":case"GameSystem":case"Photo":case"PhotoAlbum":case"TvChannel":case"Studio":case"Channel":case"UserView":case"Tag":fields.push({id:"SortName",name:_globalize.default.translate("SortName"),size:getColumnSize("SortName"),sortBy:null==(_this$getNameSortOpti3=this.getNameSortOption(itemType,apiClient))?void 0:_this$getNameSortOpti3.value,viewTypes:"datagrid"})}switch(itemType){case"":case"Movie":case"Episode":case"Trailer":case"Audio":case"MusicVideo":case"Video":case"Game":case"Photo":case"Book":case"Playlist":fields.push({id:"Filename",name:_globalize.default.translate("FileName"),size:getColumnSize("Filename"),sortBy:null==(_getFileSortOption=getFileSortOption())?void 0:_getFileSortOption.value}),fields.push({id:"Path",name:_globalize.default.translate("Path"),size:getColumnSize("Path"),sortBy:null==(_getFileSortOption=getFileSortOption())?void 0:_getFileSortOption.value,viewTypes:"datagrid"})}switch(itemType){case"":case"Audio":case"MusicAlbum":case"MusicVideo":fields.push({id:"Artist",name:_globalize.default.translate("Artist"),size:getColumnSize("Artist"),sortBy:null==(_getArtistSortOption=getArtistSortOption())?void 0:_getArtistSortOption.value,viewTypes:"datagrid",defaultVisible:"datagrid"}),fields.push({id:"AlbumArtist",name:_globalize.default.translate("AlbumArtist"),size:getColumnSize("AlbumArtist"),sortBy:null==(_getArtistSortOption=getAlbumArtistSortOption())?void 0:_getArtistSortOption.value,viewTypes:"datagrid",defaultVisible:"datagrid"}),fields.push({id:"Composer",name:_globalize.default.translate("Composer"),size:getColumnSize("Composer"),sortBy:null==(_getArtistSortOption=getComposerSortOption())?void 0:_getArtistSortOption.value,viewTypes:"datagrid",defaultVisible:"datagrid"})}switch(itemType){case"":case"Audio":fields.push({id:"Album",name:_globalize.default.translate("Album"),size:getColumnSize("Album"),sortBy:null==(_getAlbumSortOption=getAlbumSortOption())?void 0:_getAlbumSortOption.value,viewTypes:"datagrid",defaultVisible:"datagrid"})}switch(itemType){case"":case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"Audio":case"MusicAlbum":case"MusicVideo":case"Video":case"Game":case"Book":case"Photo":case"Program":case"TvChannel":fields.push({id:"CommunityRating",name:getCommunityRatingOptionName(itemType),size:getColumnSize("CommunityRating"),sortBy:null==(_getCommunityRatingSo=getCommunityRatingSortOption(itemType))?void 0:_getCommunityRatingSo.value,defaultVisible:"datagrid"})}switch(itemType){case"":case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"MusicAlbum":case"MusicVideo":case"Video":case"Game":case"Book":case"Photo":case"Program":case"TvChannel":fields.push({id:"CriticRating",name:_globalize.default.translate("CriticRating"),size:getColumnSize("CriticRating"),sortBy:null==(_getCriticRatingSortO=getCriticRatingSortOption())?void 0:_getCriticRatingSortO.value,defaultVisible:"datagrid"})}switch(itemType){case"":case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"Audio":case"MusicAlbum":case"MusicVideo":case"Playlist":case"Video":case"Game":case"Book":case"Photo":case"Program":case"TvChannel":fields.push({id:"OfficialRating",name:_globalize.default.translate("ParentalRating"),size:getColumnSize("OfficialRating"),sortBy:null==(_getParentalRatingSor=getParentalRatingSortOption())?void 0:_getParentalRatingSor.value,defaultVisible:"datagrid"})}switch(itemType){case"":case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"Audio":case"MusicAlbum":case"MusicVideo":case"Video":case"Game":case"Book":case"Person":case"Photo":case"Program":switch(itemType){case"Season":case"Episode":case"Audio":case"MusicAlbum":case"MusicVideo":case"Video":case"Game":case"Book":case"Person":case"Photo":defaultVisible="datagrid";break;case"BoxSet":case"Playlist":break;default:defaultVisible="*"}fields.push({id:"ProductionYear",name:_globalize.default.translate("Year"),size:getColumnSize("ProductionYear"),sortBy:null==(_getProductionYearSor=getProductionYearSortOption())?void 0:_getProductionYearSor.value,defaultVisible:defaultVisible})}switch(itemType){case"":case"Movie":case"Series":case"Season":case"Episode":case"Trailer":case"Audio":case"MusicAlbum":case"MusicVideo":case"Video":case"Game":case"Book":case"Person":case"Photo":case"Program":fields.push({id:"PremiereDate",name:_globalize.default.translate("ReleaseDate"),size:getColumnSize("Date"),sortBy:null==(_getReleaseDateSortOp=getReleaseDateSortOption())?void 0:_getReleaseDateSortOp.value,viewTypes:"datagrid",defaultVisible:"datagrid"})}switch(itemType){case"":case"Movie":case"Episode":case"Trailer":case"MusicVideo":case"Video":case"Audio":case"MusicAlbum":case"Playlist":case"Series":case"Season":fields.push({id:"Runtime",name:_globalize.default.translate("Runtime"),size:getColumnSize("Runtime"),sortBy:null==(_getRuntimeSortOption=getRuntimeSortOption())?void 0:_getRuntimeSortOption.value,defaultVisible:"datagrid"})}switch(itemType){case"":case"Folder":case"Movie":case"Series":case"Season":case"Episode":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicVideo":case"Playlist":case"Video":case"Game":case"Book":case"Person":case"GameSystem":case"Photo":case"Program":fields.push({id:"Genres",name:_globalize.default.translate("Genres"),size:getColumnSize("Genres"),sortBy:null})}switch(itemType){case"":case"Folder":case"Movie":case"Series":case"Season":case"Episode":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicVideo":case"Playlist":case"Video":case"Game":case"Book":case"Person":case"GameSystem":case"Photo":case"Program":case"TvChannel":fields.push({id:"Tags",name:_globalize.default.translate("Tags"),size:getColumnSize("Tags"),sortBy:null}),fields.push({id:"Studios",name:_globalize.default.translate("Studios"),size:getColumnSize("Studios"),sortBy:null})}switch(itemType){case"":case"Movie":case"Trailer":case"Series":case"MusicVideo":case"Video":fields.push({id:"Tagline",name:_globalize.default.translate("Tagline"),size:getColumnSize("Path"),sortBy:null})}switch(itemType){case"":case"Folder":case"Movie":case"Series":case"Season":case"Episode":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicVideo":case"Playlist":case"Video":case"Game":case"Book":case"Person":case"GameSystem":case"Photo":case"Program":fields.push({id:"Overview",name:_globalize.default.translate("Overview"),size:getColumnSize("Path"),sortBy:null})}switch(itemType){case"":case"Movie":case"Episode":case"Trailer":case"Audio":case"MusicVideo":case"Video":case"Game":case"Photo":case"Book":fields.push({id:"Container",name:_globalize.default.translate("Container"),size:getColumnSize("Container"),sortBy:null==(_getContainerSortOpti=getContainerSortOption())?void 0:_getContainerSortOpti.value})}switch(itemType){case"":case"Movie":case"Episode":case"Trailer":case"MusicVideo":case"Video":case"TvChannel":case"Program":case"Photo":fields.push({id:"Resolution",name:_globalize.default.translate("Resolution"),size:getColumnSize("Resolution"),sortBy:null==(_getResolutionSortOpt=getResolutionSortOption())?void 0:_getResolutionSortOpt.value})}switch(itemType){case"":case"Movie":case"Episode":case"Trailer":case"Audio":case"MusicVideo":case"Video":fields.push({id:"Bitrate",name:_globalize.default.translate("Bitrate"),size:getColumnSize("Bitrate"),sortBy:null==(_getBitrateSortOption=getBitrateSortOption())?void 0:_getBitrateSortOption.value})}switch(itemType){case"":case"Movie":case"Episode":case"Trailer":case"Audio":case"MusicVideo":case"Video":case"Game":case"Photo":case"Book":fields.push({id:"Size",name:_globalize.default.translate("Size"),size:getColumnSize("Size"),sortBy:null==(_getSizeSortOption=getSizeSortOption(itemType))?void 0:_getSizeSortOption.value})}switch(itemType){case"":case"Movie":case"Episode":case"Trailer":case"MusicVideo":case"Video":fields.push({id:"Video3DFormat",name:"3D",size:getColumnSize("Video3DFormat"),sortBy:null,viewTypes:"datagrid"})}switch(itemType){case"":case"Movie":case"Episode":case"Trailer":case"Audio":case"MusicVideo":case"Video":case"Game":case"Book":case"TvChannel":case"Series":fields.push({id:"DatePlayed",name:_globalize.default.translate("DatePlayed"),size:getColumnSize("Date"),sortBy:null==(_getDatePlayedSortOpt=getDatePlayedSortOption(itemType))?void 0:_getDatePlayedSortOpt.value,viewTypes:"datagrid"})}switch(itemType){case"":case"Movie":case"Episode":case"Trailer":case"Audio":case"MusicVideo":case"Video":case"Game":case"Book":case"TvChannel":fields.push({id:"PlayCount",name:_globalize.default.translate("Plays"),size:getColumnSize("PlayCount"),sortBy:null==(_getPlayCountSortOpti=getPlayCountSortOption())?void 0:_getPlayCountSortOpti.value,viewTypes:"datagrid"})}switch(itemType){case"":case"Movie":case"Series":case"Season":case"Episode":case"Trailer":case"Audio":case"MusicVideo":case"Video":case"Game":case"Book":case"TvChannel":case"MusicAlbum":"MusicAlbum"===itemType&&"audiobooks"!==(null==(_options$parentItem=options.parentItem)?void 0:_options$parentItem.CollectionType)||fields.push({id:"Played",name:_globalize.default.translate("Played"),gridDisplayName:'<i title="'+_globalize.default.translate("Played")+'" class="md-icon dataGridItemCell-icon">&#xe86c;</i>',size:getColumnSize("Icon"),sortBy:null,gridColumnType:"button",viewTypes:"datagrid",defaultVisible:"datagrid",center:!0})}switch(itemType){case"":case"Folder":case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicVideo":case"Playlist":case"Video":case"Game":case"Book":case"Person":case"Photo":case"TvChannel":fields.push({id:"IsFavorite",name:_globalize.default.translate("Favorite"),gridDisplayName:'<i title="'+_globalize.default.translate("Favorite")+'" class="md-icon dataGridItemCell-icon autortl">&#xe87d;</i>',size:getColumnSize("Icon"),sortBy:null,gridColumnType:"button",viewTypes:"datagrid",defaultVisible:"datagrid",center:!0})}switch("User"===itemType&&fields.push({id:"HasPassword",name:_globalize.default.translate("Password"),size:getColumnSize("Icon"),sortBy:null,gridColumnType:"button",viewTypes:"datagrid",defaultVisible:"datagrid"}),null!=apiClient&&apiClient.isMinServerVersion("4.8.0.50")&&"User"===itemType&&fields.push({id:"HasProfilePin",name:_globalize.default.translate("TitleProfilePin"),size:getColumnSize("Icon"),sortBy:null,gridColumnType:"button",viewTypes:"datagrid",defaultVisible:"datagrid"}),"User"===itemType&&fields.push({id:"EnableRemoteAccess",name:_globalize.default.translate("RemoteAccess"),size:getColumnSize("Icon"),sortBy:null,gridColumnType:"icon",viewTypes:"datagrid",defaultVisible:"datagrid"}),"User"===itemType&&fields.push({id:"IsDisabled",name:_globalize.default.translate("Disabled"),size:getColumnSize("Icon"),sortBy:null,gridColumnType:"icon",viewTypes:"datagrid",defaultVisible:"datagrid"}),itemType){case"":case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicVideo":case"Video":case"Game":case"Book":case"Person":case"Photo":case"TvChannel":case"Playlist":case"User":fields.push({id:"DateCreated",name:_globalize.default.translate("DateAdded"),size:getColumnSize("Date"),sortBy:null==(_getDateAddedSortOpti=getDateAddedSortOption(itemType,apiClient))?void 0:_getDateAddedSortOpti.value,viewTypes:"datagrid"});break;case"ApiKey":fields.push({id:"DateCreated",name:_globalize.default.translate("DateAdded"),size:getColumnSize("Date"),sortBy:null==(_getDateAddedSortOpti=getDateAddedSortOption(itemType,apiClient))?void 0:_getDateAddedSortOpti.value,defaultVisible:"*"})}"Device"===itemType&&null!=apiClient&&apiClient.isMinServerVersion("4.8.0.47")&&fields.push({id:"IpAddress",name:_globalize.default.translate("IpAddress"),size:getColumnSize("IpAddress"),sortBy:null==(_getDateLastActiveSor=getIpAddressSortOption(itemType,apiClient))?void 0:_getDateLastActiveSor.value,defaultVisible:"datagrid"}),"Log"===itemType&&fields.push({id:"DateModified",name:_globalize.default.translate("DateModified"),size:getColumnSize("DateTime"),sortBy:null,defaultVisible:"*"}),"Log"===itemType&&fields.push({id:"Size",name:_globalize.default.translate("Size"),size:getColumnSize("Size"),sortBy:null==(_getDateLastActiveSor=getSizeSortOption(itemType))?void 0:_getDateLastActiveSor.value,defaultVisible:"datagrid"}),"Plugin"===itemType&&fields.push({id:"Version",name:_globalize.default.translate("Version"),size:getColumnSize("Version"),sortBy:null,defaultVisible:"*"});for(var i=0,length=fields.length;i<length;i++){var field=fields[i];field.gridDisplayName||field.name&&field.size&&field.name.length>field.size&&(field.size=Math.max(field.name.length,field.size))}return fields},BaseItemController.prototype.getNameSortOption=function(itemType,apiClient){switch(itemType){case"ApiKey":case"Log":case"Plugin":case"ActivityLogEntry":return null;case"Device":return null!=apiClient&&apiClient.isMinServerVersion("4.8.0.47")?{name:_globalize.default.translate("Title"),value:"SortName,DateLastActivity",defaultSortOrder:"Ascending"}:null;case"User":return null!=apiClient&&apiClient.isMinServerVersion("4.8.0.47")?{name:_globalize.default.translate("Title"),value:"SortName",defaultSortOrder:"Ascending"}:null;default:return{name:_globalize.default.translate("Title"),value:"SortName",defaultSortOrder:"Ascending"}}},BaseItemController.prototype.getDefaultSorting=function(options){var field,itemType=options.itemType||"",apiClient=options.apiClient;switch(itemType){case"Episode":field=getSeriesSortOption(itemType);break;case"Program":field=getStartDateSortOption(itemType);break;case"Device":field=getDateLastActiveSortOption(itemType,apiClient)}return(field=field||this.getNameSortOption(itemType,apiClient))?{sortBy:field.value,sortOrder:field.defaultSortOrder}:null},BaseItemController.prototype.getSortMenuOptions=function(options){var sortBy=[],itemType=options.itemType||"",apiClient=options.apiClient,options=options.availableFieldIds;switch(itemType){case"PlaylistItem":return getPlaylistOrCollectionSortMenuOptions("Playlist");case"BoxSetItem":return apiClient.isMinServerVersion("4.8.0.16")?getPlaylistOrCollectionSortMenuOptions("BoxSet"):[]}(options.Name||options.SortName)&&(option=this.getNameSortOption(itemType,apiClient))&&sortBy.push(option),options.Album&&(option=getAlbumSortOption())&&sortBy.push(option),options.AlbumArtist&&(option=getAlbumArtistSortOption())&&sortBy.push(option),options.Artist&&(option=getArtistSortOption())&&sortBy.push(option),options.StartDate&&(option=getStartDateSortOption(itemType))&&sortBy.push(option),(options.Filename||options.Path)&&(option=getFileSortOption())&&sortBy.push(option),options.Bitrate&&(option=getBitrateSortOption())&&sortBy.push(option),options.CommunityRating&&(option=getCommunityRatingSortOption(itemType))&&sortBy.push(option),options.Composer&&(option=getComposerSortOption())&&sortBy.push(option),options.Container&&(option=getContainerSortOption())&&sortBy.push(option),options.CriticRating&&(option=getCriticRatingSortOption())&&sortBy.push(option),options.DateCreated&&(option=getDateAddedSortOption(itemType,apiClient))&&sortBy.push(option),(options.LastActivityDate||options.LastActivityDateRelative)&&(option=getDateLastActiveSortOption(itemType,apiClient))&&sortBy.push(option),options.IpAddress&&(option=getIpAddressSortOption(itemType,apiClient))&&sortBy.push(option);var _option14,option=function(itemType){return"Series"!==itemType?null:{name:_globalize.default.translate("LastEpisodeDateAdded"),value:"DateLastContentAdded,SortName",defaultSortOrder:"Descending"}}(itemType);return option&&sortBy.push(option),(option=function(itemType,apiClient){return!apiClient.isMinServerVersion("4.9.0.17")||"Series"!==itemType?null:{name:_globalize.default.translate("LastEpisodeDateAired"),value:"LastContentPremiereDate,SortName",defaultSortOrder:"Descending"}}(itemType,apiClient))&&sortBy.push(option),options.DatePlayed&&(_option14=getDatePlayedSortOption(itemType))&&sortBy.push(_option14),(option=function(itemType){return"TvChannel"!==itemType?null:{name:_globalize.default.translate("Favorites"),value:"IsFavorite,DatePlayed,ChannelNumber,SortName",defaultSortOrder:"Ascending",sortOrderAscending:"Ascending,Descending,Ascending",sortOrderDescending:"Descending,Ascending,Ascending"}}(itemType))&&sortBy.push(option),options.OfficialRating&&(_option14=getParentalRatingSortOption())&&sortBy.push(_option14),options.PlayCount&&(_option14=getPlayCountSortOption())&&sortBy.push(_option14),options.ProductionYear&&(_option14=getProductionYearSortOption())&&sortBy.push(_option14),options.PremiereDate&&(_option14=getReleaseDateSortOption())&&sortBy.push(_option14),options.Resolution&&(_option14=getResolutionSortOption())&&sortBy.push(_option14),options.Runtime&&(_option14=getRuntimeSortOption())&&sortBy.push(_option14),options.SeriesName&&(_option14=getSeriesSortOption(itemType))&&sortBy.push(_option14),options.Size&&(_option14=getSizeSortOption(itemType))&&sortBy.push(_option14),options.Number&&(_option14=getNumberSortOption(itemType))&&sortBy.push(_option14),(option=function(itemType,apiClient){switch(itemType){case"Movie":case"Series":case"Episode":case"Audio":case"MusicAlbum":case"MusicArtist":case"Photo":case"Video":case"MusicVideo":case"Trailer":break;default:return null}return apiClient&&apiClient.isMinServerVersion("4.8.0.11")?{name:_globalize.default.translate("Random"),value:"Random",defaultSortOrder:"Ascending"}:null}(itemType,apiClient))&&sortBy.push(option),sortBy.sort(compareByName),sortBy},BaseItemController.prototype.createListHelper=function(apiClient,type,name,itemIds){return _loading.default.show(),apiClient.createList(apiClient.getCurrentUserId(),type,name,itemIds).then(function(result){_loading.default.hide();var newListName=result.Name||name;return onAddedToList(type,result.Id),notifyAddedToList(newListName,type,result.ItemAddedCount),Promise.resolve()})},BaseItemController.prototype.addToListHelper=function(list,itemIds){var apiClient=_connectionmanager.default.getApiClient(list.ServerId),userId=apiClient.getCurrentUserId();return function(apiClient,userId,type,id,addIds){return"Playlist"!==type?Promise.resolve():apiClient.getAddToPlaylistInfo(userId,id,addIds).then(function(result){return result.ContainsDuplicates?((result={text:1<result.ItemCount?_globalize.default.translate("ItemsAlreadyInPlaylist"):_globalize.default.translate("ItemAlreadyInPlaylist"),buttons:[]}).buttons.push({name:_globalize.default.translate("HeaderAddAgain"),id:"add",type:"submit"}),result.buttons.push({name:_globalize.default.translate("Skip"),id:"skip"}),result.buttons.push({name:_globalize.default.translate("Cancel"),id:"cancel",type:"cancel"}),showDialog(result).then(function(result){return"add"===result||"skip"===result?Promise.resolve(result):Promise.reject(result)})):Promise.resolve()})}(apiClient,userId,list.Type,list.Id,itemIds).then(function(result){return _loading.default.show(),apiClient.addToList(userId,list.Type,list.Id,itemIds,"skip"===result).then(function(result){_loading.default.hide();var type="BoxSet"===list.Type?"Collection":"Playlist";onAddedToList(type,list.Id),result.ItemAddedCount&&notifyAddedToList(list.Name,type,result.ItemAddedCount)})})},BaseItemController.prototype.executeCommand=rejectNoSupportedCommands;_exports.default=BaseItemController});