#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hackage-security
version:              0.6.2.6
visibility:           public
id:                   hackage-security-0.6.2.6-FL14q84FMEZFXfATXwmNBa
key:                  hackage-security-0.6.2.6-FL14q84FMEZFXfATXwmNBa
license:              BSD-3-Clause
copyright:            Copyright 2015-2022 Well-Typed LLP
maintainer:           cabal-devel@haskell.org
author:               Edsko de Vries
homepage:             https://github.com/haskell/hackage-security
synopsis:             Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<https://hackage.haskell.org/>).  It is based on The Update
    Framework (<https://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).

    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.

    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).

category:             Distribution
abi:                  d3c873d87bc5f0b659d3ef3bc31e27c6
exposed:              True
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.TUF.FileMap Hackage.Security.Trusted
    Hackage.Security.Util.Checked Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical

hidden-modules:
    Hackage.Security.Key Hackage.Security.Trusted.TCB
    Hackage.Security.TUF Hackage.Security.TUF.Common
    Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
    Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
    Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
    Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
    Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
    Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
    Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
    Hackage.Security.Util.Exit Hackage.Security.Util.IO
    Hackage.Security.Util.JSON Hackage.Security.Util.Lens
    Hackage.Security.Util.Stack Hackage.Security.Util.TypedEmbedded

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hackage-security-0.6.2.6
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hackage-security-0.6.2.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hackage-security
hs-libraries:         HShackage-security-0.6.2.6-FL14q84FMEZFXfATXwmNBa
depends:
    Cabal-3.6.3.0 base-4.16.4.0
    base16-bytestring-1.0.2.0-BfU7bG0tjnC37zYxX4slQA
    base64-bytestring-1.2.1.0-IROdBrGh8de3SyeGv4rKYj
    bytestring-0.11.4.0 containers-0.6.5.1
    cryptohash-sha256-0.11.102.1-IJPkgr8yXYZ3pOUoxE9WNg
    directory-1.3.6.2 ed25519-0.0.5.0-J1hYKylECALHDf0AVFqTV7
    filepath-1.4.2.2 ghc-prim-0.8.0
    lukko-0.1.1.3-6qPKE1k7OmfFGueWz7YEKR mtl-2.2.2
    network-3.1.4.0-1av7pSyu1s1AG52DPIhcGs
    network-uri-2.6.4.2-74JpbzeSIdyJoqu3FQVNpR parsec-3.1.15.0
    pretty-1.1.3.6 tar-0.5.1.1-1rgifZLONNXAvaA6Ili3sa
    template-haskell-2.18.0.0 time-1.11.1.1 transformers-0.5.6.2
    zlib-0.6.3.0-CuOO7n4zc2g8TBZxjplZPM

haddock-interfaces:
    /usr/share/doc/haskell-hackage-security/html/hackage-security.haddock

haddock-html:         /usr/share/doc/haskell-hackage-security/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

