#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 json-ast
version:              0.3.2
visibility:           public
id:                   json-ast-0.3.2-C9JklmFKEvWE0ZmAfBAwgL
key:                  json-ast-0.3.2-C9JklmFKEvWE0ZmAfBAwgL
license:              MIT
copyright:            (c) 2016, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/json-ast 
synopsis:             Universal JSON AST datastructure
description:
    This library provides only a data-type representing the JSON value tree.
    It is intended to be used as a shared data-type by all kinds of JSON libraries.
    Same as we have the \"xml-types\" package for libraries dealing with XML.

    Now, since the \"aeson\" @Value@ has been serving this purpose for years,
    we'\''ve intentionally made this type representationally identical to it,
    making it possible to convert between them at 0 runtime cost.
    This means that we can use those types interchangeably,
    making it possible to gradually migrate.

    ===Why displace the \"aeson\" @Value@?

    1. To boost the competition between JSON libraries.
    Instead of nudging the community to implement its ideas by patching \"aeson\".
    After all, competition is the driving force of evolution and hence progress.

    2. Due to so much patching already happening to \"aeson\",
    its loss of focus, some questionable design and
    strive for backwards compatibility, it'\''s becoming bloated.
    IOW, it'\''s trying to be "everything JSON" but with no careful design or plan and
    it'\''s tied by its past.
    With these restrictions it'\''s impossible for \"aeson\" to ever become a polished
    library.

abi:                  a6b8aeffa0dd25e6cfb52ce97f4b36f8
exposed:              True
exposed-modules:      JSONAST
import-dirs:          /usr/lib/ghc-9.2.8/site-local/json-ast-0.3.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/json-ast-0.3.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-json-ast
hs-libraries:         HSjson-ast-0.3.2-C9JklmFKEvWE0ZmAfBAwgL
depends:
    base-4.16.4.0 scientific-0.3.7.0-8ausramh0PCAAyDmAQtWkI
    text-1.2.5.0 unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN

haddock-interfaces:   /usr/share/doc/haskell-json-ast/html/json-ast.haddock
haddock-html:         /usr/share/doc/haskell-json-ast/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

