#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-types
version:              1.4.0.1
visibility:           public
id:                   lsp-types-1.4.0.1-8fq24p7hfveKkgUEYsAszh
key:                  lsp-types-1.4.0.1-8fq24p7hfveKkgUEYsAszh
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:
    Haskell library for the Microsoft Language Server Protocol, data types

description:
    An implementation of the types to allow language implementors to
    support the Language Server Protocol for their specific language.

category:             Development
abi:                  d93894a1e77487db1ff58940555c869e
exposed:              True
exposed-modules:
    Data.IxMap Language.LSP.Types Language.LSP.Types.Capabilities
    Language.LSP.Types.Lens Language.LSP.Types.SMethodMap
    Language.LSP.VFS

hidden-modules:
    Language.LSP.Types.CallHierarchy Language.LSP.Types.Cancellation
    Language.LSP.Types.ClientCapabilities Language.LSP.Types.CodeAction
    Language.LSP.Types.CodeLens Language.LSP.Types.Command
    Language.LSP.Types.Common Language.LSP.Types.Completion
    Language.LSP.Types.Configuration Language.LSP.Types.Declaration
    Language.LSP.Types.Definition Language.LSP.Types.Diagnostic
    Language.LSP.Types.DocumentColor Language.LSP.Types.DocumentFilter
    Language.LSP.Types.DocumentHighlight
    Language.LSP.Types.DocumentLink Language.LSP.Types.DocumentSymbol
    Language.LSP.Types.FoldingRange Language.LSP.Types.Formatting
    Language.LSP.Types.Hover Language.LSP.Types.Implementation
    Language.LSP.Types.Initialize Language.LSP.Types.Location
    Language.LSP.Types.LspId Language.LSP.Types.MarkupContent
    Language.LSP.Types.Method Language.LSP.Types.Message
    Language.LSP.Types.Parsing Language.LSP.Types.Progress
    Language.LSP.Types.Registration Language.LSP.Types.References
    Language.LSP.Types.Rename Language.LSP.Types.SelectionRange
    Language.LSP.Types.ServerCapabilities
    Language.LSP.Types.SemanticTokens Language.LSP.Types.SignatureHelp
    Language.LSP.Types.StaticRegistrationOptions
    Language.LSP.Types.TextDocument Language.LSP.Types.TypeDefinition
    Language.LSP.Types.Uri Language.LSP.Types.Utils
    Language.LSP.Types.Window Language.LSP.Types.WatchedFiles
    Language.LSP.Types.WorkspaceEdit
    Language.LSP.Types.WorkspaceFolders
    Language.LSP.Types.WorkspaceSymbol

import-dirs:          /usr/lib/ghc-9.2.8/site-local/lsp-types-1.4.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lsp-types-1.4.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-types1.4
hs-libraries:         HSlsp-types-1.4.0.1-8fq24p7hfveKkgUEYsAszh
depends:
    Diff-0.4.1-7DJ54PO7amxJCKVFCJguu4
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9 base-4.16.4.0 binary-0.8.9.0
    bytestring-0.11.4.0 containers-0.6.5.1
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS deepseq-1.4.6.1
    directory-1.3.6.2 dlist-1.0-HCxoMn9TirQDgPCFxho7O filepath-1.4.2.2
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    hslogger-1.3.1.1-AaFqNA3CZ3wF1V1MzkMbBe
    lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7 mod-0.2.0.1-4iKHZQ6mJT75YNSqnA67PE
    mtl-2.2.2 network-uri-2.6.4.2-74JpbzeSIdyJoqu3FQVNpR
    rope-utf16-splay-0.3.2.0-BXliMwvtXJ6BGydO65dsrx
    scientific-0.3.7.0-8ausramh0PCAAyDmAQtWkI
    some-1.0.5-L5glA67mR8RJufLDsA2lRz template-haskell-2.18.0.0
    temporary-1.3-6g6bzMzGEBECPR8ySppZs6 text-1.2.5.0
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF

haddock-interfaces:   /usr/share/doc/haskell-lsp-types1.4/html/lsp-types.haddock
haddock-html:         /usr/share/doc/haskell-lsp-types1.4/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

