#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ral
version:              0.2.1
visibility:           public
id:                   ral-0.2.1-5Xddkh8Og9D13LoF68DQhY
key:                  ral-0.2.1-5Xddkh8Og9D13LoF68DQhY
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  0294622869a7ea3d9310dfdb1d0c4788
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.2.8/site-local/ral-0.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/ral-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.1-5Xddkh8Og9D13LoF68DQhY
depends:
    QuickCheck-2.14.3-8QSIOMYs5brCg5V5nmVdY2
    adjunctions-4.4.2-B52pzpq8i1pGYrTd6BpDX0 base-4.16.4.0
    bin-0.1.3-2Z3SDFUkaRA6MdMV9PTyfB boring-0.2.1-Icfsg6aSH6SpFFKOquZU
    deepseq-1.4.6.1 distributive-0.6.2.1-4X1MYYG6NTsBbO6uVT9gPy
    fin-0.3-9oQOjzcNh5Y3MdD5lRdENL
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    indexed-traversable-0.1.4-6hGnPWNuqXlFS0NzZXy7sq
    semigroupoids-5.3.7-Aol4v1yb5Zg1lc2q2bwPkl

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

