#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 text-ansi
version:              0.2.1.1
visibility:           public
id:                   text-ansi-0.2.1.1-Gd4StowABUXC4X4V2zCfve
key:                  text-ansi-0.2.1.1-Gd4StowABUXC4X4V2zCfve
license:              BSD-3-Clause
copyright:            (c) 2018-2023, Mitchell Rosen
maintainer:           Mitchell Rosen <mitchellwrosen@gmail.com>
author:               Mitchell Rosen
homepage:             https://github.com/mitchellwrosen/text-ansi
synopsis:             Text styling for ANSI terminals.
description:
    Text styling for ANSI terminals using SGR codes, as defined by the
    <https://www.ecma-international.org/publications/files/ECMA-ST/Ecma-048.pdf ECMA-48>
    standard.

    Supports foreground\/background color, bold\/faint intensity, italic,
    single\/double underline, strikethrough, frame, encircle, and overline escape
    sequences. Some styles may not work on your terminal.

    Also features terminal detection, so redirecting styled output to a file will
    automatically strip the ANSI escape sequences.

category:             Data
abi:                  30dcdf789bea8707ed5eddbb252b310c
exposed:              True
exposed-modules:
    String.ANSI Text.ANSI Text.Builder.ANSI Text.Lazy.Builder.ANSI

import-dirs:          /usr/lib/ghc-9.2.8/site-local/text-ansi-0.2.1.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/text-ansi-0.2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-text-ansi
hs-libraries:         HStext-ansi-0.2.1.1-Gd4StowABUXC4X4V2zCfve
depends:
    base-4.16.4.0 text-1.2.5.0
    text-builder-0.6.7-JGHqkY3W2LuBWogrMXdnTv

haddock-interfaces:   /usr/share/doc/haskell-text-ansi/html/text-ansi.haddock
haddock-html:         /usr/share/doc/haskell-text-ansi/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

