#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tls
version:              1.8.0
visibility:           public
id:                   tls-1.8.0-2IAnq24nPDgHWAd4R673hS
key:                  tls-1.8.0-2IAnq24nPDgHWAd4R673hS
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/haskell-tls/hs-tls
synopsis:             TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.

    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.

    Currently implement the TLS1.0, TLS1.1, TLS1.2 and TLS 1.3 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.

    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.

category:             Network
abi:                  e27d1c86b67f4833bde959390b57bb83
exposed:              True
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Extra Network.TLS.Extra.Cipher Network.TLS.Extra.FFDHE
    Network.TLS.Internal Network.TLS.QUIC

hidden-modules:
    Network.TLS.Cap Network.TLS.Struct Network.TLS.Struct13
    Network.TLS.Core Network.TLS.Context Network.TLS.Context.Internal
    Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
    Network.TLS.Crypto.DH Network.TLS.Crypto.IES
    Network.TLS.Crypto.Types Network.TLS.ErrT Network.TLS.Extension
    Network.TLS.Handshake Network.TLS.Handshake.Certificate
    Network.TLS.Handshake.Client Network.TLS.Handshake.Common
    Network.TLS.Handshake.Common13 Network.TLS.Handshake.Control
    Network.TLS.Handshake.Key Network.TLS.Handshake.Process
    Network.TLS.Handshake.Random Network.TLS.Handshake.Server
    Network.TLS.Handshake.Signature Network.TLS.Handshake.State
    Network.TLS.Handshake.State13 Network.TLS.Hooks Network.TLS.IO
    Network.TLS.Imports Network.TLS.KeySchedule Network.TLS.MAC
    Network.TLS.Measurement Network.TLS.Packet Network.TLS.Packet13
    Network.TLS.Parameters Network.TLS.PostHandshake Network.TLS.Record
    Network.TLS.Record.Disengage Network.TLS.Record.Engage
    Network.TLS.Record.Layer Network.TLS.Record.Reading
    Network.TLS.Record.Writing Network.TLS.Record.State
    Network.TLS.Record.Types Network.TLS.RNG Network.TLS.State
    Network.TLS.Session Network.TLS.Sending Network.TLS.Receiving
    Network.TLS.Util Network.TLS.Util.ASN1
    Network.TLS.Util.Serialization Network.TLS.Types Network.TLS.Wire
    Network.TLS.X509

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tls-1.8.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tls-1.8.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tls
hs-libraries:         HStls-1.8.0-2IAnq24nPDgHWAd4R673hS
depends:
    asn1-encoding-0.9.6-GAq2QlCqcbdGlIErejW67k
    asn1-types-0.3.4-JGSPng6oak4BPhV2NPikd8
    async-2.2.5-A9yY3sStrUyIJcfOkNbDOv base-4.16.4.0
    bytestring-0.11.4.0 cereal-0.5.8.3-9zcITCTkqXtHoa6jbeSF22
    crypton-0.34-1VPpUG8ba8hJMOLvG5BIhn
    crypton-x509-1.7.6-LSkyIc38YxHAG9yDNc2EDR
    crypton-x509-store-1.6.9-ELwjJy9ZesW67wlTMK8831
    crypton-x509-validation-1.6.12-747uYQjEoywAC4KFDpD3uW
    data-default-class-0.1.2.0-Kt3ErptCt5hHHi8l61h1Gp
    memory-0.18.0-Hvum6HaH78UJG59LYyNLK1 mtl-2.2.2
    network-3.1.4.0-1av7pSyu1s1AG52DPIhcGs transformers-0.5.6.2
    unix-time-0.4.14-F818kS1pKtW28WqAlouDGc

haddock-interfaces:   /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html:         /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

