#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-FFUpiNtW8Yk6dkAQVGyIwp
key:                  hledger-web-1.32.1-FFUpiNtW8Yk6dkAQVGyIwp
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  29ffd4f37fa738a26b9178627232b996
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-FFUpiNtW8Yk6dkAQVGyIwp
depends:
    Decimal-0.5.2-IyyiL7sGU7tBzBWwGViQxZ
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9 base-4.16.4.0
    base64-0.4.2.4-jAS9VwwSCp9A4H8dyAbfD
    blaze-html-0.9.2.0-C4ZBPt0ygub3tdDLZwenWL
    blaze-markup-0.8.3.0-F62q6tKjBbGDf7FwMvopea bytestring-0.11.4.0
    case-insensitive-1.2.1.0-3YsL0BQanAbLHEhUwcLo8j
    clientsession-0.9.2.0-9wjmI6si7DkCPXyGCBPDAZ
    cmdargs-0.10.22-JQ4ivQZzeRmKKTWVSPDfjg
    conduit-1.3.6-6olN0R4zhzQGfJxY5P1sQG
    conduit-extra-1.3.6-DNMogv3hOWO1ZuiF0M3PeA containers-0.6.5.1
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS directory-1.3.6.2
    extra-1.7.16-HmT1ExbMa8s7Fr43bhn74d filepath-1.4.2.2
    hjsmin-0.2.0.4-14UGI2bd1QpF3DRj6K6kYw
    hledger-1.32.1-LhvEDQYH60vOC85PodvNX
    hledger-lib-1.32.1-FKHO6y01CcdHwuIswe95zc
    hspec-2.10.9-8EHAZD5WgY7w8NSfyDurV
    http-client-0.7.17-2Oi6aYWRkvSIlsipbaKPwU
    http-conduit-2.3.9.1-9MtEZt4ARFdLbv43mFT48g
    http-types-0.12.4-6kOruwBLItLEcotK7uAwKL
    megaparsec-9.6.1-xFWwysPvLWIMfIZXM34tr mtl-2.2.2
    network-3.1.4.0-1av7pSyu1s1AG52DPIhcGs
    safe-0.3.21-41ZPWazUMNgR08x0DBIts
    shakespeare-2.1.0.1-Aep3bGsUDar9PKhkk50ZWW
    template-haskell-2.18.0.0 text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2 unix-compat-0.7.2-IqISP17ENORAfbSsgoGqIp
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI
    wai-3.2.4-4FGE67nPXB9CBfEQ1pErUn
    wai-cors-0.2.7-1UqjOTtIEcf83shFLWCNbq
    wai-extra-3.1.15-9O7PIOa3wBMJgbrFOYIJlE
    wai-handler-launch-3.0.3.1-6WTgcG5WeWX6G8qknIJHCM
    warp-3.3.30-KmDHwdvNkGg1Qpns2AuMxx
    yaml-0.11.11.2-FsesGw9U9gbF319C8E5TNI
    yesod-1.6.2.1-4DDykoiqys336dme286Su9
    yesod-core-1.6.26.0-G6fIH1cUcrDDUXDmjcfsb9
    yesod-form-1.7.6-BHQVpBlEj6b3fukwucFNqG
    yesod-static-1.6.1.0-4eAGPTCeRgaGntcZ6PoEbn
    yesod-test-1.6.16-21U3lLrGPII2gJBDVDMsGd

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

