/*******************************************************************************
* Copyright 2023 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

//@HEADER
// ***************************************************
//
// HPCG: High Performance Conjugate Gradient Benchmark
//
// Contact:
// Michael A. Heroux ( maherou@sandia.gov)
// Jack Dongarra     (dongarra@eecs.utk.edu)
// Piotr Luszczek    (luszczek@eecs.utk.edu)
//
// ***************************************************
//@HEADER


#include "CustomKernels.hpp"

#include "kernels/mv_kernels.hpp"

namespace custom {

    // select between kernel modes for trmv
    // y <- y + (L + B) * x -- uplo::lower_update
    //
    // y  = r - (U + B) * x -- uplo::upper_nonloc
    // y1 =      U      * x -- uplo::upper_nonloc
    sycl::event SpTRMV(sycl::queue &queue, sparseMatrix *matA, uplo mode, const double *x, const double *r, double *y, double *y1, const std::vector<sycl::event>& dependencies)
    {
        assert(matA->block_size == 16);

        switch (mode) {
        case uplo::lower_update:
            {
                return sparse_esb4_lbmv_update_esimd<16>(
                    queue, matA->nrows, matA->nBlocks,
                    matA->esbblockptr, matA->esblastLower, matA->esbfirstNonloc, matA->esbblockptr+1,
                    matA->esbcolind, matA->esbvalues, x, y, matA->trmv_l_reorder, matA->applyL3CacheTRMVLReorder, dependencies);
            } break;
        case uplo::upper_nonlocal:
            {
                return sparse_esb4_ubmv_esimd<16>(
                    queue, matA->nrows, matA->nBlocks,
                    matA->esbfirstUpper, matA->esbblockptr+1, matA->esbcolind, matA->esbvalues,
                    x, r, y, y1, matA->trmv_u_reorder, matA->applyL3CacheTRMVUReorder, dependencies);
            } break;
        default:
            {
                throw std::runtime_error("unsupported uplo parameter called in SpTRMV");
            }
        }

        return sycl::event();
    }

} // namespace custom
