/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher;

import java.util.Map;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.asyncquery.model.QueryState;
import org.opensearch.sql.spark.client.EMRServerlessClient;
import org.opensearch.sql.spark.dispatcher.BatchQueryHandler;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryResponse;
import org.opensearch.sql.spark.dispatcher.model.JobType;
import org.opensearch.sql.spark.flint.FlintIndexMetadata;
import org.opensearch.sql.spark.flint.FlintIndexMetadataService;
import org.opensearch.sql.spark.flint.operation.FlintIndexOpCancel;
import org.opensearch.sql.spark.flint.operation.FlintIndexOpFactory;
import org.opensearch.sql.spark.leasemanager.LeaseManager;
import org.opensearch.sql.spark.leasemanager.model.LeaseRequest;
import org.opensearch.sql.spark.metrics.MetricsService;
import org.opensearch.sql.spark.parameter.SparkSubmitParametersBuilderProvider;
import org.opensearch.sql.spark.response.JobExecutionResponseReader;

public class RefreshQueryHandler
extends BatchQueryHandler {
    private final FlintIndexMetadataService flintIndexMetadataService;
    private final FlintIndexOpFactory flintIndexOpFactory;

    public RefreshQueryHandler(EMRServerlessClient emrServerlessClient, JobExecutionResponseReader jobExecutionResponseReader, FlintIndexMetadataService flintIndexMetadataService, LeaseManager leaseManager, FlintIndexOpFactory flintIndexOpFactory, MetricsService metricsService, SparkSubmitParametersBuilderProvider sparkSubmitParametersBuilderProvider) {
        super(emrServerlessClient, jobExecutionResponseReader, leaseManager, metricsService, sparkSubmitParametersBuilderProvider);
        this.flintIndexMetadataService = flintIndexMetadataService;
        this.flintIndexOpFactory = flintIndexOpFactory;
    }

    @Override
    public String cancelJob(AsyncQueryJobMetadata asyncQueryJobMetadata, AsyncQueryRequestContext asyncQueryRequestContext) {
        String datasourceName = asyncQueryJobMetadata.getDatasourceName();
        Map<String, FlintIndexMetadata> indexMetadataMap = this.flintIndexMetadataService.getFlintIndexMetadata(asyncQueryJobMetadata.getIndexName(), asyncQueryRequestContext);
        if (!indexMetadataMap.containsKey(asyncQueryJobMetadata.getIndexName())) {
            throw new IllegalStateException(String.format("Couldn't fetch flint index: %s details", asyncQueryJobMetadata.getIndexName()));
        }
        FlintIndexMetadata indexMetadata = indexMetadataMap.get(asyncQueryJobMetadata.getIndexName());
        FlintIndexOpCancel jobCancelOp = this.flintIndexOpFactory.getCancel(datasourceName);
        jobCancelOp.apply(indexMetadata, asyncQueryRequestContext);
        return asyncQueryJobMetadata.getQueryId();
    }

    @Override
    public DispatchQueryResponse submit(DispatchQueryRequest dispatchQueryRequest, DispatchQueryContext context) {
        this.leaseManager.borrow(new LeaseRequest(JobType.REFRESH, dispatchQueryRequest.getDatasource()));
        DispatchQueryResponse resp = super.submit(dispatchQueryRequest, context);
        DataSourceMetadata dataSourceMetadata = context.getDataSourceMetadata();
        return DispatchQueryResponse.builder().queryId(resp.getQueryId()).jobId(resp.getJobId()).resultIndex(resp.getResultIndex()).sessionId(resp.getSessionId()).datasourceName(dataSourceMetadata.getName()).jobType(JobType.REFRESH).indexName(context.getIndexQueryDetails().openSearchIndexName()).status(QueryState.WAITING).build();
    }
}

