/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.parameter;

import com.amazonaws.arn.Arn;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasources.auth.AuthenticationType;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigClusterSetting;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigClusterSettingLoader;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.parameter.DataSourceSparkParameterComposer;
import org.opensearch.sql.spark.parameter.SparkSubmitParameters;

public class S3GlueDataSourceSparkParameterComposer
implements DataSourceSparkParameterComposer {
    public static final String FLINT_BASIC_AUTH = "basic";
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    private final SparkExecutionEngineConfigClusterSettingLoader settingLoader;

    public void compose(DataSourceMetadata metadata, SparkSubmitParameters params, DispatchQueryRequest dispatchQueryRequest, AsyncQueryRequestContext context) {
        Optional<SparkExecutionEngineConfigClusterSetting> maybeClusterSettings = this.settingLoader.load();
        if (!maybeClusterSettings.isPresent()) {
            throw new RuntimeException("No cluster settings present");
        }
        SparkExecutionEngineConfigClusterSetting clusterSetting = maybeClusterSettings.get();
        String region = clusterSetting.getRegion();
        String roleArn = (String)metadata.getProperties().get("glue.auth.role_arn");
        String accountId = Arn.fromString((String)roleArn).getAccountId();
        params.setConfigItem("spark.emr-serverless.driverEnv.ASSUME_ROLE_CREDENTIALS_ROLE_ARN", roleArn);
        params.setConfigItem("spark.executorEnv.ASSUME_ROLE_CREDENTIALS_ROLE_ARN", roleArn);
        params.setConfigItem("spark.hive.metastore.glue.role.arn", roleArn);
        params.setConfigItem("spark.sql.catalog." + metadata.getName(), "org.opensearch.sql.FlintDelegatingSessionCatalog");
        params.setConfigItem("spark.flint.datasource.name", metadata.getName());
        boolean icebergEnabled = BooleanUtils.toBoolean((String)((String)metadata.getProperties().get("glue.iceberg.enabled")));
        if (icebergEnabled) {
            params.setConfigItem("spark.jars.packages", params.getConfigItem("spark.jars.packages") + ",org.apache.iceberg:iceberg-spark-runtime-3.3_2.12:1.5.0,software.amazon.awssdk:bundle:2.26.30");
            params.setConfigItem("spark.sql.catalog.spark_catalog", "org.apache.iceberg.spark.SparkSessionCatalog");
            params.setConfigItem("spark.sql.catalog.spark_catalog.catalog-impl", "org.apache.iceberg.aws.glue.GlueCatalog");
            params.setConfigItem("spark.sql.extensions", "org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions,org.opensearch.flint.spark.FlintSparkExtensions,org.opensearch.flint.spark.FlintPPLSparkExtensions");
            params.setConfigItem("spark.sql.catalog.spark_catalog.client.region", region);
            params.setConfigItem("spark.sql.catalog.spark_catalog.glue.account-id", accountId);
            params.setConfigItem("spark.sql.catalog.spark_catalog.client.assume-role.arn", roleArn);
            params.setConfigItem("spark.sql.catalog.spark_catalog.client.assume-role.region", region);
            params.setConfigItem("spark.sql.iceberg.handle-timestamp-without-timezone", TRUE);
            boolean lakeFormationEnabled = BooleanUtils.toBoolean((String)((String)metadata.getProperties().get("glue.lakeformation.enabled")));
            if (lakeFormationEnabled) {
                String sessionTag = (String)metadata.getProperties().get("glue.lakeformation.session_tag");
                if (StringUtils.isBlank((CharSequence)sessionTag)) {
                    throw new IllegalArgumentException("glue.lakeformation.session_tag is required");
                }
                params.setConfigItem("spark.flint.optimizer.covering.enabled", FALSE);
                params.setConfigItem("spark.sql.catalog.spark_catalog.glue.lakeformation-enabled", TRUE);
                params.setConfigItem("spark.sql.catalog.spark_catalog.client.factory", "org.apache.iceberg.aws.lakeformation.LakeFormationAwsClientFactory");
                params.setConfigItem("spark.sql.catalog.spark_catalog.client.assume-role.tags.LakeFormationAuthorizedCaller", sessionTag);
            } else {
                params.setConfigItem("spark.sql.catalog.spark_catalog.client.factory", "org.apache.iceberg.aws.AssumeRoleAwsClientFactory");
            }
        }
        this.setFlintIndexStoreHost(params, this.parseUri((String)metadata.getProperties().get("glue.indexstore.opensearch.uri"), metadata.getName()));
        this.setFlintIndexStoreAuthProperties(params, (String)metadata.getProperties().get("glue.indexstore.opensearch.auth"), () -> (String)metadata.getProperties().get("glue.indexstore.opensearch.auth.username"), () -> (String)metadata.getProperties().get("glue.indexstore.opensearch.auth.password"), () -> (String)metadata.getProperties().get("glue.indexstore.opensearch.region"));
        params.setConfigItem("spark.flint.datasource.name", metadata.getName());
    }

    private void setFlintIndexStoreHost(SparkSubmitParameters params, URI uri) {
        params.setConfigItem("spark.datasource.flint.host", uri.getHost());
        params.setConfigItem("spark.datasource.flint.port", String.valueOf(uri.getPort()));
        params.setConfigItem("spark.datasource.flint.scheme", uri.getScheme());
    }

    private void setFlintIndexStoreAuthProperties(SparkSubmitParameters params, String authType, Supplier<String> userName, Supplier<String> password, Supplier<String> region) {
        if (AuthenticationType.get((String)authType).equals((Object)AuthenticationType.BASICAUTH)) {
            params.setConfigItem("spark.datasource.flint.auth", FLINT_BASIC_AUTH);
            params.setConfigItem("spark.datasource.flint.auth.username", userName.get());
            params.setConfigItem("spark.datasource.flint.auth.password", password.get());
        } else if (AuthenticationType.get((String)authType).equals((Object)AuthenticationType.AWSSIGV4AUTH)) {
            params.setConfigItem("spark.datasource.flint.auth", "sigv4");
            params.setConfigItem("spark.datasource.flint.region", region.get());
        } else {
            params.setConfigItem("spark.datasource.flint.auth", authType);
        }
    }

    private URI parseUri(String opensearchUri, String datasourceName) {
        try {
            return new URI(opensearchUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Bad URI in indexstore configuration of the : %s datasoure.", datasourceName));
        }
    }

    @Generated
    public S3GlueDataSourceSparkParameterComposer(SparkExecutionEngineConfigClusterSettingLoader settingLoader) {
        this.settingLoader = settingLoader;
    }
}

