/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.visitor;

import com.google.common.collect.Sets;
import java.util.Set;
import org.opensearch.sql.legacy.antlr.parser.OpenSearchLegacySqlParser;
import org.opensearch.sql.legacy.exception.SqlFeatureNotImplementedException;
import org.opensearch.sql.legacy.utils.StringUtils;

public class UnsupportedSemanticVerifier {
    private static final Set<String> mathConstants = Sets.newHashSet((Object[])new String[]{"e", "pi"});
    private static final Set<String> supportedNestedFunctions = Sets.newHashSet((Object[])new String[]{"nested", "reverse_nested", "score", "match_query", "matchquery"});
    private static final Set<String> unsupportedFunctions = Sets.newHashSet((Object[])new String[]{"adddate", "addtime", "datetime", "greatest", "least"});
    private static final Set<String> unsupportedOperators = Sets.newHashSet((Object[])new String[]{"div"});

    public static void verify(OpenSearchLegacySqlParser.ScalarFunctionCallContext ctx) {
        String funcName = StringUtils.toLower(ctx.scalarFunctionName().getText());
        if (ctx.parent.parent instanceof OpenSearchLegacySqlParser.FunctionAsAggregatorFunctionContext && !supportedNestedFunctions.contains(StringUtils.toLower(funcName))) {
            throw new SqlFeatureNotImplementedException(StringUtils.format("Aggregation calls with function aggregator like [%s] are not supported yet", ctx.parent.parent.getText()));
        }
        if (ctx.parent.parent instanceof OpenSearchLegacySqlParser.NestedFunctionArgsContext && !mathConstants.contains(funcName) && !supportedNestedFunctions.contains(funcName)) {
            throw new SqlFeatureNotImplementedException(StringUtils.format("Nested function calls like [%s] are not supported yet", ctx.parent.parent.parent.getText()));
        }
        if (unsupportedFunctions.contains(funcName)) {
            throw new SqlFeatureNotImplementedException(StringUtils.format("Function [%s] is not supported yet", funcName));
        }
    }

    public static void verify(OpenSearchLegacySqlParser.MathOperatorContext ctx) {
        if (unsupportedOperators.contains(StringUtils.toLower(ctx.getText()))) {
            throw new SqlFeatureNotImplementedException(StringUtils.format("Operator [%s] is not supported yet", ctx.getText()));
        }
    }

    public static void verify(OpenSearchLegacySqlParser.RegexpPredicateContext ctx) {
        throw new SqlFeatureNotImplementedException("Regexp predicate is not supported yet");
    }
}

