/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.SearchModule;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.OpenSearchStorageEngine;

public class OpenSearchQueryRequest
implements OpenSearchRequest {
    private final OpenSearchRequest.IndexName indexName;
    private SearchSourceBuilder sourceBuilder;
    private final OpenSearchExprValueFactory exprValueFactory;
    private final List<String> includes;
    private boolean needClean = true;
    private boolean searchDone = false;
    private String pitId;
    private TimeValue cursorKeepAlive;
    private Object[] searchAfter;
    private SearchResponse searchResponse = null;

    public OpenSearchQueryRequest(String indexName, int size, OpenSearchExprValueFactory factory, List<String> includes) {
        this(new OpenSearchRequest.IndexName(indexName), size, factory, includes);
    }

    public OpenSearchQueryRequest(OpenSearchRequest.IndexName indexName, int size, OpenSearchExprValueFactory factory, List<String> includes) {
        this.indexName = indexName;
        this.sourceBuilder = new SearchSourceBuilder();
        this.sourceBuilder.from(0);
        this.sourceBuilder.size(size);
        this.sourceBuilder.timeout(DEFAULT_QUERY_TIMEOUT);
        this.exprValueFactory = factory;
        this.includes = includes;
    }

    public OpenSearchQueryRequest(OpenSearchRequest.IndexName indexName, SearchSourceBuilder sourceBuilder, OpenSearchExprValueFactory factory, List<String> includes) {
        this.indexName = indexName;
        this.sourceBuilder = sourceBuilder;
        this.exprValueFactory = factory;
        this.includes = includes;
    }

    public OpenSearchQueryRequest(OpenSearchRequest.IndexName indexName, SearchSourceBuilder sourceBuilder, OpenSearchExprValueFactory factory, List<String> includes, TimeValue cursorKeepAlive, String pitId) {
        this.indexName = indexName;
        this.sourceBuilder = sourceBuilder;
        this.exprValueFactory = factory;
        this.includes = includes;
        this.cursorKeepAlive = cursorKeepAlive;
        this.pitId = pitId;
    }

    public OpenSearchQueryRequest(StreamInput in, OpenSearchStorageEngine engine) throws IOException {
        String sourceBuilderString = in.readString();
        NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(new SearchModule(Settings.EMPTY, Collections.emptyList()).getNamedXContents());
        XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, DeprecationHandler.IGNORE_DEPRECATIONS, sourceBuilderString);
        this.sourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
        this.cursorKeepAlive = in.readTimeValue();
        this.pitId = in.readString();
        this.includes = in.readStringList();
        this.indexName = new OpenSearchRequest.IndexName(in);
        int length = in.readVInt();
        this.searchAfter = new Object[length];
        for (int i = 0; i < length; ++i) {
            this.searchAfter[i] = in.readGenericValue();
        }
        OpenSearchIndex index = (OpenSearchIndex)engine.getTable(null, this.indexName.toString());
        this.exprValueFactory = new OpenSearchExprValueFactory(index.getFieldOpenSearchTypes());
    }

    @Override
    public OpenSearchResponse search(Function<SearchRequest, SearchResponse> searchAction, Function<SearchScrollRequest, SearchResponse> scrollAction) {
        if (this.pitId == null) {
            if (this.searchDone) {
                return new OpenSearchResponse(SearchHits.empty(), this.exprValueFactory, this.includes);
            }
            this.searchDone = true;
            return new OpenSearchResponse(searchAction.apply(new SearchRequest().indices(this.indexName.getIndexNames()).source(this.sourceBuilder)), this.exprValueFactory, this.includes);
        }
        return this.searchWithPIT(searchAction);
    }

    public OpenSearchResponse searchWithPIT(Function<SearchRequest, SearchResponse> searchAction) {
        OpenSearchResponse openSearchResponse;
        if (this.searchDone) {
            openSearchResponse = new OpenSearchResponse(SearchHits.empty(), this.exprValueFactory, this.includes);
        } else {
            this.sourceBuilder.pointInTimeBuilder(new PointInTimeBuilder(this.pitId));
            this.sourceBuilder.timeout(this.cursorKeepAlive);
            if (this.searchAfter != null) {
                this.sourceBuilder.searchAfter(this.searchAfter);
            }
            if (this.sourceBuilder.sorts() == null) {
                this.sourceBuilder.sort("_doc", SortOrder.ASC);
            }
            SearchRequest searchRequest = new SearchRequest().source(this.sourceBuilder);
            this.searchResponse = searchAction.apply(searchRequest);
            openSearchResponse = new OpenSearchResponse(this.searchResponse, this.exprValueFactory, this.includes);
            this.needClean = openSearchResponse.isEmpty();
            this.searchDone = openSearchResponse.isEmpty();
            SearchHit[] searchHits = this.searchResponse.getHits().getHits();
            if (searchHits != null && searchHits.length > 0) {
                this.searchAfter = searchHits[searchHits.length - 1].getSortValues();
                this.sourceBuilder.searchAfter(this.searchAfter);
            }
        }
        return openSearchResponse;
    }

    @Override
    public void clean(Consumer<String> cleanAction) {
        try {
            if (this.pitId != null && this.needClean) {
                cleanAction.accept(this.pitId);
                this.searchDone = true;
            }
        }
        finally {
            this.pitId = null;
        }
    }

    @Override
    public boolean hasAnotherBatch() {
        if (this.pitId != null) {
            return !this.needClean;
        }
        return false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.pitId != null) {
            out.writeString(this.sourceBuilder.toString());
            out.writeTimeValue(this.sourceBuilder.timeout());
            out.writeString(this.sourceBuilder.pointInTimeBuilder().getId());
            out.writeStringCollection(this.includes);
            this.indexName.writeTo(out);
            if (this.searchAfter != null) {
                out.writeVInt(this.searchAfter.length);
                for (Object obj : this.searchAfter) {
                    out.writeGenericValue(obj);
                }
            }
        } else {
            throw new UnsupportedOperationException("OpenSearchQueryRequest serialization is not implemented.");
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchQueryRequest)) {
            return false;
        }
        OpenSearchQueryRequest other = (OpenSearchQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSearchDone() != other.isSearchDone()) {
            return false;
        }
        OpenSearchRequest.IndexName this$indexName = this.getIndexName();
        OpenSearchRequest.IndexName other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !((Object)this$indexName).equals(other$indexName)) {
            return false;
        }
        SearchSourceBuilder this$sourceBuilder = this.getSourceBuilder();
        SearchSourceBuilder other$sourceBuilder = other.getSourceBuilder();
        if (this$sourceBuilder == null ? other$sourceBuilder != null : !this$sourceBuilder.equals(other$sourceBuilder)) {
            return false;
        }
        String this$pitId = this.getPitId();
        String other$pitId = other.getPitId();
        if (this$pitId == null ? other$pitId != null : !this$pitId.equals(other$pitId)) {
            return false;
        }
        TimeValue this$cursorKeepAlive = this.getCursorKeepAlive();
        TimeValue other$cursorKeepAlive = other.getCursorKeepAlive();
        if (this$cursorKeepAlive == null ? other$cursorKeepAlive != null : !this$cursorKeepAlive.equals(other$cursorKeepAlive)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSearchAfter(), other.getSearchAfter())) {
            return false;
        }
        SearchResponse this$searchResponse = this.getSearchResponse();
        SearchResponse other$searchResponse = other.getSearchResponse();
        return !(this$searchResponse == null ? other$searchResponse != null : !this$searchResponse.equals(other$searchResponse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchQueryRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSearchDone() ? 79 : 97);
        OpenSearchRequest.IndexName $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : ((Object)$indexName).hashCode());
        SearchSourceBuilder $sourceBuilder = this.getSourceBuilder();
        result = result * 59 + ($sourceBuilder == null ? 43 : $sourceBuilder.hashCode());
        String $pitId = this.getPitId();
        result = result * 59 + ($pitId == null ? 43 : $pitId.hashCode());
        TimeValue $cursorKeepAlive = this.getCursorKeepAlive();
        result = result * 59 + ($cursorKeepAlive == null ? 43 : $cursorKeepAlive.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSearchAfter());
        SearchResponse $searchResponse = this.getSearchResponse();
        result = result * 59 + ($searchResponse == null ? 43 : $searchResponse.hashCode());
        return result;
    }

    @Generated
    public OpenSearchRequest.IndexName getIndexName() {
        return this.indexName;
    }

    @Generated
    public SearchSourceBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    @Override
    @Generated
    public OpenSearchExprValueFactory getExprValueFactory() {
        return this.exprValueFactory;
    }

    @Generated
    public List<String> getIncludes() {
        return this.includes;
    }

    @Generated
    public boolean isNeedClean() {
        return this.needClean;
    }

    @Generated
    public boolean isSearchDone() {
        return this.searchDone;
    }

    @Generated
    public String getPitId() {
        return this.pitId;
    }

    @Generated
    public TimeValue getCursorKeepAlive() {
        return this.cursorKeepAlive;
    }

    @Generated
    public Object[] getSearchAfter() {
        return this.searchAfter;
    }

    @Generated
    public SearchResponse getSearchResponse() {
        return this.searchResponse;
    }

    @Generated
    public String toString() {
        return "OpenSearchQueryRequest(indexName=" + this.getIndexName() + ", sourceBuilder=" + this.getSourceBuilder() + ", needClean=" + this.isNeedClean() + ", searchDone=" + this.isSearchDone() + ", pitId=" + this.getPitId() + ", cursorKeepAlive=" + this.getCursorKeepAlive() + ", searchAfter=" + Arrays.deepToString(this.getSearchAfter()) + ", searchResponse=" + this.getSearchResponse() + ")";
    }
}

