/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.client;

import java.util.List;
import java.util.Map;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.Nullable;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLConfig;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.ToolMetadata;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentResponse;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorResponse;
import org.opensearch.ml.common.transport.deploy.MLDeployModelResponse;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskResponse;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupResponse;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.transport.register.MLRegisterModelResponse;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsResponse;

public interface MachineLearningClient {
    default public ActionFuture<MLOutput> predict(String modelId, MLInput mlInput) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.predict(modelId, mlInput, (ActionListener<MLOutput>)actionFuture);
        return actionFuture;
    }

    public void predict(String var1, MLInput var2, ActionListener<MLOutput> var3);

    default public ActionFuture<MLOutput> trainAndPredict(MLInput mlInput) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.trainAndPredict(mlInput, (ActionListener<MLOutput>)actionFuture);
        return actionFuture;
    }

    public void trainAndPredict(MLInput var1, ActionListener<MLOutput> var2);

    default public ActionFuture<MLOutput> train(MLInput mlInput, boolean asyncTask) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.train(mlInput, asyncTask, (ActionListener<MLOutput>)actionFuture);
        return actionFuture;
    }

    public void train(MLInput var1, boolean var2, ActionListener<MLOutput> var3);

    default public ActionFuture<MLOutput> run(MLInput mlInput, Map<String, Object> args) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.run(mlInput, args, (ActionListener<MLOutput>)actionFuture);
        return actionFuture;
    }

    public void run(MLInput var1, Map<String, Object> var2, ActionListener<MLOutput> var3);

    default public ActionFuture<MLModel> getModel(String modelId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.getModel(modelId, (ActionListener<MLModel>)actionFuture);
        return actionFuture;
    }

    public void getModel(String var1, ActionListener<MLModel> var2);

    default public ActionFuture<MLTask> getTask(String taskId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.getTask(taskId, (ActionListener<MLTask>)actionFuture);
        return actionFuture;
    }

    public void getTask(String var1, ActionListener<MLTask> var2);

    default public ActionFuture<DeleteResponse> deleteModel(String modelId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.deleteModel(modelId, (ActionListener<DeleteResponse>)actionFuture);
        return actionFuture;
    }

    public void deleteModel(String var1, ActionListener<DeleteResponse> var2);

    default public ActionFuture<DeleteResponse> deleteTask(String taskId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.deleteModel(taskId, (ActionListener<DeleteResponse>)actionFuture);
        return actionFuture;
    }

    public void deleteTask(String var1, ActionListener<DeleteResponse> var2);

    default public ActionFuture<SearchResponse> searchModel(SearchRequest searchRequest) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.searchModel(searchRequest, (ActionListener<SearchResponse>)actionFuture);
        return actionFuture;
    }

    public void searchModel(SearchRequest var1, ActionListener<SearchResponse> var2);

    default public ActionFuture<SearchResponse> searchTask(SearchRequest searchRequest) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.searchTask(searchRequest, (ActionListener<SearchResponse>)actionFuture);
        return actionFuture;
    }

    public void searchTask(SearchRequest var1, ActionListener<SearchResponse> var2);

    default public ActionFuture<MLRegisterModelResponse> register(MLRegisterModelInput mlInput) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.register(mlInput, (ActionListener<MLRegisterModelResponse>)actionFuture);
        return actionFuture;
    }

    public void register(MLRegisterModelInput var1, ActionListener<MLRegisterModelResponse> var2);

    default public ActionFuture<MLDeployModelResponse> deploy(String modelId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.deploy(modelId, (ActionListener<MLDeployModelResponse>)actionFuture);
        return actionFuture;
    }

    public void deploy(String var1, ActionListener<MLDeployModelResponse> var2);

    default public ActionFuture<MLUndeployModelsResponse> undeploy(String[] modelIds, @Nullable String[] nodeIds) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.undeploy(modelIds, nodeIds, (ActionListener<MLUndeployModelsResponse>)actionFuture);
        return actionFuture;
    }

    public void undeploy(String[] var1, String[] var2, ActionListener<MLUndeployModelsResponse> var3);

    default public ActionFuture<MLCreateConnectorResponse> createConnector(MLCreateConnectorInput mlCreateConnectorInput) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.createConnector(mlCreateConnectorInput, (ActionListener<MLCreateConnectorResponse>)actionFuture);
        return actionFuture;
    }

    public void createConnector(MLCreateConnectorInput var1, ActionListener<MLCreateConnectorResponse> var2);

    default public ActionFuture<DeleteResponse> deleteConnector(String connectorId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.deleteConnector(connectorId, (ActionListener<DeleteResponse>)actionFuture);
        return actionFuture;
    }

    public void deleteConnector(String var1, ActionListener<DeleteResponse> var2);

    default public ActionFuture<MLRegisterModelGroupResponse> registerModelGroup(MLRegisterModelGroupInput mlRegisterModelGroupInput) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.registerModelGroup(mlRegisterModelGroupInput, (ActionListener<MLRegisterModelGroupResponse>)actionFuture);
        return actionFuture;
    }

    public void registerModelGroup(MLRegisterModelGroupInput var1, ActionListener<MLRegisterModelGroupResponse> var2);

    default public ActionFuture<MLExecuteTaskResponse> execute(FunctionName name, Input input) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.execute(name, input, (ActionListener<MLExecuteTaskResponse>)actionFuture);
        return actionFuture;
    }

    public void execute(FunctionName var1, Input var2, ActionListener<MLExecuteTaskResponse> var3);

    default public ActionFuture<MLRegisterAgentResponse> registerAgent(MLAgent mlAgent) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.registerAgent(mlAgent, (ActionListener<MLRegisterAgentResponse>)actionFuture);
        return actionFuture;
    }

    public void registerAgent(MLAgent var1, ActionListener<MLRegisterAgentResponse> var2);

    default public ActionFuture<DeleteResponse> deleteAgent(String agentId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.deleteAgent(agentId, (ActionListener<DeleteResponse>)actionFuture);
        return actionFuture;
    }

    public void deleteAgent(String var1, ActionListener<DeleteResponse> var2);

    default public ActionFuture<List<ToolMetadata>> listTools() {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.listTools((ActionListener<List<ToolMetadata>>)actionFuture);
        return actionFuture;
    }

    public void listTools(ActionListener<List<ToolMetadata>> var1);

    default public ActionFuture<ToolMetadata> getTool(String toolName) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.getTool(toolName, (ActionListener<ToolMetadata>)actionFuture);
        return actionFuture;
    }

    public void getTool(String var1, ActionListener<ToolMetadata> var2);

    default public ActionFuture<MLConfig> getConfig(String configId) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.getConfig(configId, (ActionListener<MLConfig>)actionFuture);
        return actionFuture;
    }

    public void getConfig(String var1, ActionListener<MLConfig> var2);
}

