/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreateElementFull2
extends SingleLineCommand2<ClassDiagram> {
    private final Mode mode;

    public CommandCreateElementFull2(Mode mode) {
        super(CommandCreateElementFull2.getRegexConcat(mode));
        this.mode = mode;
    }

    private static RegexConcat getRegexConcat(Mode mode) {
        String regex = "(state|person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|action|process|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout)";
        if (mode == Mode.WITH_MIX_PREFIX) {
            return RegexConcat.build(CommandCreateElementFull2.class.getName() + (Object)((Object)mode), RegexLeaf.start(), new RegexLeaf("mix_"), new RegexLeaf("SYMBOL", regex), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexLeaf("CODE1", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%g].+?[%g])"), new RegexConcat(new RegexLeaf("DISPLAY2", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), StereotypePattern.optional("STEREOTYPE2"), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREOTYPE"), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.end());
        }
        return RegexConcat.build(CommandCreateElementFull2.class.getName() + (Object)((Object)mode), RegexLeaf.start(), new RegexLeaf("SYMBOL", regex), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexLeaf("CODE1", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%g].+?[%g])"), new RegexConcat(new RegexLeaf("DISPLAY2", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), StereotypePattern.optional("STEREOTYPE2"), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREOTYPE"), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.end());
    }

    @Override
    protected final boolean isForbidden(CharSequence line) {
        return line.toString().matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String s2;
        USymbol usymbol;
        LeafType type;
        String symbol;
        if (this.mode == Mode.NORMAL_KEYWORD && !diagram.isAllowMixing()) {
            return CommandExecutionResult.error("Use 'allowmixing' if you want to mix classes and other UML elements.");
        }
        String codeRaw = arg.getLazzy("CODE", 0);
        String displayRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.getLazzy("DISPLAY", 0));
        char codeChar = this.getCharEncoding(codeRaw);
        char codeDisplay = this.getCharEncoding(displayRaw);
        if (codeRaw.startsWith("()")) {
            symbol = "interface";
            codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(codeRaw.substring(2)));
        } else {
            symbol = codeChar == '(' || codeDisplay == '(' ? "usecase" : (codeChar == ':' || codeDisplay == ':' ? "actor" : (codeChar == '[' || codeDisplay == '[' ? "component" : arg.get("SYMBOL", 0)));
        }
        if (symbol == null) {
            type = LeafType.DESCRIPTION;
            usymbol = diagram.getSkinParam().actorStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("port")) {
            type = LeafType.PORTIN;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("portin")) {
            type = LeafType.PORTIN;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("portout")) {
            type = LeafType.PORTOUT;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase/")) {
            type = LeafType.USECASE_BUSINESS;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("state")) {
            type = LeafType.STATE;
            usymbol = null;
        } else {
            type = LeafType.DESCRIPTION;
            usymbol = USymbols.fromString(symbol, diagram.getSkinParam());
            if (usymbol == null) {
                throw new IllegalStateException();
            }
        }
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeRaw);
        Display display = Display.getWithNewlines(displayRaw == null ? idShort : displayRaw);
        Quark<Entity> quark = diagram.quarkInContext(true, idShort);
        Entity entity = quark.getData();
        if (entity == null) {
            entity = diagram.reallyCreateLeaf(quark, display, type, usymbol);
        }
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        entity.setDisplay(display);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        CommandCreateClassMultilines.addTags(entity, arg.getLazzy("TAGS", 0));
        String urlString = arg.get("URL", 0);
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s2 = arg.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s2));
        return CommandExecutionResult.ok();
    }

    private char getCharEncoding(String codeRaw) {
        return codeRaw != null && codeRaw.length() > 2 ? codeRaw.charAt(0) : (char)'\u0000';
    }

    public static enum Mode {
        NORMAL_KEYWORD,
        WITH_MIX_PREFIX;

    }
}

