/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.svek.extremity.Extremity;

public class ExtremityArrow
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final ULine line;
    private final XPoint2D contact;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    public ExtremityArrow(XPoint2D p1, double angle, XPoint2D center) {
        angle = this.manageround(angle);
        int xContact = this.buildPolygon();
        this.polygon.rotate(angle + 1.5707963267948966);
        this.polygon = this.polygon.translate(p1.getX(), p1.getY());
        this.contact = new XPoint2D(p1.getX() - (double)xContact * Math.cos(angle + 1.5707963267948966), p1.getY() - (double)xContact * Math.sin(angle + 1.5707963267948966));
        this.line = new ULine(center.getX() - this.contact.getX(), center.getY() - this.contact.getY());
    }

    public ExtremityArrow(XPoint2D p0, double angle) {
        this.line = null;
        angle = this.manageround(angle);
        this.buildPolygon();
        this.polygon.rotate(angle);
        this.polygon = this.polygon.translate(p0.getX(), p0.getY());
        this.contact = p0;
    }

    private int buildPolygon() {
        this.polygon.addPoint(0.0, 0.0);
        int xWing = 9;
        int yAperture = 4;
        this.polygon.addPoint(-9.0, -4.0);
        int xContact = 5;
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        return 5;
    }

    @Override
    public double getDecorationLength() {
        return 6.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor color = ug.getParam().getColor();
        ug = color == null ? ug.apply(HColors.none().bg()) : ug.apply(color.bg());
        ug.draw(this.polygon);
        if (this.line != null && this.line.getLength() > 2.0) {
            ug.apply(UTranslate.point(this.contact)).draw(this.line);
        }
    }

    public void drawLineIfTransparent(UGraphic ug) {
        XPoint2D pt1 = this.polygon.getPoint(0);
        XPoint2D pt2 = this.polygon.getPoint(2);
        ULine line = ULine.create(pt1, pt2);
        ug.apply(UTranslate.point(pt1)).draw(line);
    }
}

