/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class JsonKeyExists
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%json_key_exists", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 2;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        String keyname;
        JsonObject object;
        TValue arg0 = values.get(0);
        if (!arg0.isJson()) {
            return TValue.fromBoolean(false);
        }
        JsonValue json = arg0.toJson();
        if (!json.isObject()) {
            return TValue.fromBoolean(false);
        }
        TValue arg1 = values.get(1);
        if ((arg1.isString() || arg1.isJson() && arg1.toJson().isString()) && (object = (JsonObject)json).contains(keyname = arg1.toString())) {
            return TValue.fromBoolean(true);
        }
        return TValue.fromBoolean(false);
    }
}

