/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class JsonSet
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%json_set", 3);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 2 || nbArg == 3;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        TValue data = values.get(0);
        if (!data.isJson()) {
            throw new EaterException("Not JSON data", location);
        }
        JsonValue json = data.toJson().cloneMe();
        if (!json.isArray() && !json.isObject()) {
            return data;
        }
        switch (values.size()) {
            case 2: {
                if (json.isObject()) {
                    JsonValue value = values.get(1).toJsonValue();
                    if (value.isObject()) {
                        json.asObject().deepMerge(value.asObject());
                    }
                    return TValue.fromJson(json);
                }
            }
            case 3: {
                if (json.isArray()) {
                    if (values.get(1).isNumber()) {
                        Integer index = values.get(1).toInt();
                        JsonValue value = values.get(2).toJsonValue();
                        if (0 <= index && index < json.asArray().size()) {
                            json.asArray().set((int)index, value);
                        }
                    }
                    return TValue.fromJson(json);
                }
                if (!json.isObject()) break;
                String name = values.get(1).toString();
                JsonValue value = values.get(2).toJsonValue();
                json.asObject().set(name, value);
                return TValue.fromJson(json);
            }
        }
        assert (false);
        throw new EaterException("Error on json_set: Too many arguments", location);
    }
}

